/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTS;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.Delegate;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTS.GlobalTID;
import com.ibm.ws.Transaction.JTS.TaskIdPropagationData;
import com.ibm.ws.Transaction.JTS.TaskIdPropagationDataHelper;
import com.ibm.ws.Transaction.JTS.WSCascadedPropagationDataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.BOSSObjectKey;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import org.omg.CORBA.Any;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.TransIdentityHelper;
import org.omg.CosTransactions.otid_t;
import org.omg.PortableInterceptor.ClientRequestInfo;

public final class TxInterceptorHelper {
    private static final TraceComponent tc = Tr.register(TxInterceptorHelper.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final int OMG_TRANSACTION_SERVICE_ID = 0;
    public static final int IMPLEMENTATION_SPECIFIC_CONTEXT = 0;
    public static final int DEFERRED_BEGIN_CONTEXT = 1;
    public static final int INTEROP_CONTEXT = 2;
    public static final int NON_INTEROP_CONTEXT = 3;
    public static final int RRS_CASCADED_CONTEXT = 4;
    public static final int FORMATID_WASC = 1463898947;
    public static final int FORMATID_CB390 = -1010695802;
    public static final int FORMATID_RRS = -640035614;
    private static HashSet _nonTransactionalOperations;
    private static Class _WLMNotifierClass;
    private static final String wlmNotifierImplKey = "com.ibm.ws.transaction.WLMNotifier";

    public static final PropagationContext demarshalContext(byte[] byArray, ORB oRB) {
        PropagationContext propagationContext;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "demarshalContext", Util.toHexString(byArray));
            }
            CDRInputStream cDRInputStream = ORB.createCDRInputStream((ORB)oRB, (byte[])byArray, (int)byArray.length);
            cDRInputStream.consumeEndian();
            propagationContext = new PropagationContext();
            propagationContext.timeout = cDRInputStream.read_ulong();
            propagationContext.current = TransIdentityHelper.read((InputStream)cDRInputStream);
            int n = cDRInputStream.read_long();
            propagationContext.parents = new TransIdentity[n];
            for (int i = 0; i < propagationContext.parents.length; ++i) {
                propagationContext.parents[i] = TransIdentityHelper.read((InputStream)cDRInputStream);
            }
            try {
                propagationContext.implementation_specific_data = cDRInputStream.read_any();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                FFDCFilter.processException(outOfMemoryError, "com.ibm.ws.Transaction.JTS.TxInterceptorHelper.demarshalContext", "105");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                Tr.event(tc, "Exception processing prop context any", outOfMemoryError);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "demarshalContext", propagationContext);
        }
        return propagationContext;
    }

    public static final byte[] marshalContext(PropagationContext propagationContext, ORB oRB) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshalContext");
        }
        byte[] byArray = null;
        CDROutputStream cDROutputStream = ORB.createCDROutputStream((ORB)oRB);
        cDROutputStream.putEndian();
        PropagationContextHelper.write((OutputStream)cDROutputStream, propagationContext);
        byArray = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshalContext", byArray);
        }
        return byArray;
    }

    public static int determineContextType(PropagationContext propagationContext) {
        Any any;
        Any any2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "determineContextType", propagationContext);
        }
        if (propagationContext.current == null || propagationContext.current.otid.formatID == -1) {
            Tr.warning(tc, "WTRN0007_CANT_IMPORT_NULL_CONTEXT");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "determineContextType", "context has null transaction identifier");
            }
            throw new TRANSACTION_REQUIRED();
        }
        if (propagationContext.parents.length > 0) {
            Tr.warning(tc, "WTRN0008_CANT_IMPORT_NESTED_TRAN", new GlobalTID(propagationContext.current.otid));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "determineContextType", "INVALID_TRANSACTION");
            }
            throw new INVALID_TRANSACTION();
        }
        int n = propagationContext.current.coord == null ? (propagationContext.current.otid.formatID == 1463898947 || propagationContext.current.otid.formatID == -1010695802 ? 1 : (propagationContext.current.otid.formatID == -640035614 ? ((any2 = propagationContext.implementation_specific_data) != null && any2.type().equal(WSCascadedPropagationDataHelper.type()) ? 4 : 3) : ((any = propagationContext.implementation_specific_data) != null && any.type().kind() != TCKind.tk_boolean ? 0 : 3))) : 2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "determineContextType", n == 1 ? "DEFERRED_BEGIN_CONTEXT" : (n == 3 ? "NON_INTEROP_CONTEXT" : (n == 0 ? "IMPLEMENTATION_SPECIFIC_CONTEXT" : "INTEROP_CONTEXT")));
        }
        return n;
    }

    public static boolean isTransactional(ClientRequestInfo clientRequestInfo) {
        boolean bl;
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "isTransactional", clientRequestInfo);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "One-way operation: " + clientRequestInfo.response_expected());
            }
            boolean bl2 = bl = TxInterceptorHelper.isTransactional(clientRequestInfo.operation()) && clientRequestInfo.response_expected();
            if (bl && PlatformHelperFactory.getPlatformHelper().isZOS()) {
                ObjectImpl objectImpl = null;
                try {
                    BOSSObjectKey bOSSObjectKey;
                    Delegate delegate;
                    IOR iOR;
                    Profile profile;
                    ObjectKey objectKey;
                    objectImpl = (ObjectImpl)clientRequestInfo.effective_target();
                    if (objectImpl != null && (objectKey = (profile = (iOR = (delegate = (Delegate)objectImpl._get_delegate()).locatedIOR()).getProfile()).getObjectKeyObject()) != null && objectKey.getMagic() == -690371886 && (bOSSObjectKey = (BOSSObjectKey)objectKey).getFlag(Integer.MIN_VALUE)) {
                        bl = false;
                    }
                }
                catch (Throwable throwable) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Object key manipulation falied", new Object[]{objectImpl, throwable});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isTransactional", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isTransactional(String string) {
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isTransactional", string);
        }
        if (_nonTransactionalOperations == null) {
            String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("com.ibm.ejs.jts.jts.knownNonTransactional");
                    if (string == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "com.ibm.ejs.jts.jts.knownNonTransactional not set: using default value");
                        }
                        string = "_is_a:_get_handle";
                    }
                    return string;
                }
            });
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "knownNonTransactional: ", string2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            HashSet<String> hashSet = new HashSet<String>();
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "nonTransactionalOperation: " + string3);
                }
                hashSet.add(string3);
            }
            _nonTransactionalOperations = hashSet;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Set of non-transactional operations: " + _nonTransactionalOperations);
            }
        }
        boolean bl2 = bl = !_nonTransactionalOperations.contains(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isTransactional", new Boolean(bl));
        }
        return bl;
    }

    static otid_t createOtidFromTransaction(TransactionImpl transactionImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createOtidFromTransaction", transactionImpl);
        }
        GlobalTID globalTID = new GlobalTID(transactionImpl.getXid());
        otid_t otid_t2 = globalTID.getRealTID();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createOtidFromTransaction", otid_t2);
        }
        return otid_t2;
    }

    static otid_t createJTA2OtidFromTransaction(TransactionImpl transactionImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createJTA2OtidFromTransaction", transactionImpl);
        }
        Xid xid = transactionImpl.getXid();
        otid_t otid_t2 = new otid_t(xid.getFormatId(), 0, xid.getGlobalTransactionId());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createJTA2OtidFromTransaction", otid_t2);
        }
        return otid_t2;
    }

    public static int calculateSubordinateTimeout(TransactionImpl transactionImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateSubordinateTimeout", transactionImpl);
        }
        int n = 0;
        long l = transactionImpl.getExpirationTime();
        if (transactionImpl.getExpirationTime() != 0L) {
            long l2 = (l - System.currentTimeMillis() + 999L) / 1000L + 10L;
            int n2 = n = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            if (n <= 0) {
                block8: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Timeout for subordinate <= 0. Marking rollback only");
                    }
                    try {
                        transactionImpl.setRollbackOnly();
                    }
                    catch (IllegalStateException illegalStateException) {
                        FFDCFilter.processException(illegalStateException, "com.ibm.ws.Transaction.JTS.TxInterceptorHelper.calculateSubordinateTimeout.", "242");
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block8;
                        Tr.event(tc, "IllegalStateException setting tx rollback only");
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "calculateSubordinateTimeout");
                }
                throw new TRANSACTION_ROLLEDBACK();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateSubordinateTimeout", new Integer(n));
        }
        return n;
    }

    static String getTaskId(PropagationContext propagationContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTaskId", propagationContext);
        }
        String string = null;
        TypeCode typeCode = propagationContext.implementation_specific_data.type();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ISD type", typeCode);
        }
        if (typeCode.equal(TaskIdPropagationDataHelper.type())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Extracting taskId from TaskIdPropagationData");
            }
            TaskIdPropagationData taskIdPropagationData = TaskIdPropagationDataHelper.extract(propagationContext.implementation_specific_data);
            string = taskIdPropagationData.taskId;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTaskId", string);
        }
        return string;
    }

    static void notifyWLM(TransactionImpl transactionImpl) {
        if (_WLMNotifierClass != null) {
            TxInterceptorHelper.notifyWLM(transactionImpl, transactionImpl.getXid().getGlobalTransactionId());
        }
    }

    static void notifyWLM(TransactionImpl transactionImpl, byte[] byArray) {
        if (_WLMNotifierClass != null) {
            block5: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "notifyWLM", new Object[]{_WLMNotifierClass, transactionImpl});
                }
                try {
                    Method method2 = _WLMNotifierClass.getMethod("init", Transaction.class, [B.class);
                    method2.invoke(_WLMNotifierClass.newInstance(), transactionImpl, byArray);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTS.TxInterceptorHelper.notifyWLM", "390");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Failed to notify WLM", throwable);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "notifyWLM");
            }
        }
    }

    static {
        try {
            _WLMNotifierClass = ImplFactory.loadClassFromKey(wlmNotifierImplKey);
        }
        catch (Throwable throwable) {
            if (throwable instanceof NoClassDefFoundError) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WLMNotifier class definition not found by ImplFactory - assume key not defined");
                }
            } else {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTS.TxInterceptorHelper.<clinit>", "108");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to load WLMNotifier class", throwable);
                }
            }
            _WLMNotifierClass = null;
        }
    }
}

