/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.EnvironmentType;
import com.ibm.ws.util.ImplFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class TransactionManagerFactory {
    private static final TraceComponent tc = Tr.register(TransactionManagerFactory.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static WebSphereTransactionManager _tranManager;
    private static LocalTransactionCurrent _localTranCurrent;
    private static UOWCurrent _uowCurrent;
    private static String _tmSetKey;
    private static String _ltcKey;
    private static String _class;
    private static boolean _implsLoaded;

    private TransactionManagerFactory() {
    }

    public static WebSphereTransactionManager getTransactionManager() {
        if (_tranManager == null) {
            if (!_implsLoaded) {
                TransactionManagerFactory.loadImplementations();
            }
            if (_tranManager == null) {
                throw new NoClassDefFoundError(_class);
            }
        }
        return _tranManager;
    }

    public static LocalTransactionCurrent getLocalTransactionCurrent() {
        if (!_implsLoaded) {
            TransactionManagerFactory.loadImplementations();
        }
        return _localTranCurrent;
    }

    public static UOWCurrent getUOWCurrent() {
        if (_uowCurrent == null) {
            if (!_implsLoaded) {
                TransactionManagerFactory.loadImplementations();
            }
            if (_uowCurrent == null) {
                throw new NoClassDefFoundError(_class);
            }
        }
        return _uowCurrent;
    }

    private static void loadImplementations() {
        block5: {
            int n = EnvironmentType.getEnvironmentType();
            if (n == 0) {
                _tmSetKey = "com.ibm.ws.transaction.WSTxManager";
                _ltcKey = "com.ibm.ws.transaction.LocalTranCurrent";
            } else if (n == 1) {
                _tmSetKey = "com.ibm.ws.transaction.NonRecovWSTxManager";
                _ltcKey = null;
            }
            try {
                TransactionManagerFactory.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        block7: {
                            Class clazz = null;
                            try {
                                Method method2;
                                if (_tmSetKey != null) {
                                    clazz = ImplFactory.loadClassFromKey(_tmSetKey);
                                    method2 = clazz.getMethod("instance", null);
                                    _tranManager = (WebSphereTransactionManager)method2.invoke(null, null);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                        Tr.event(tc, "Transaction manager initialized");
                                    }
                                    _uowCurrent = (UOWCurrent)((Object)_tranManager);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                        Tr.event(tc, "UOW Current initialized");
                                    }
                                }
                                if (_ltcKey != null) {
                                    clazz = ImplFactory.loadClassFromKey(_ltcKey);
                                    method2 = clazz.getMethod("instance", null);
                                    _localTranCurrent = (LocalTransactionCurrent)method2.invoke(null, null);
                                }
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.TransactionManagerFactry.loadImplementations", "158");
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Error encountered loading implementations", throwable);
                                }
                                if (!(throwable instanceof NoClassDefFoundError)) break block7;
                                _class = throwable.getMessage();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException(privilegedActionException, "com.ibm.ws.Transaction.TransactionManagerFactory.loadImplementations", "169");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                Tr.event(tc, "PrivilegedActionException loading and initializing impls", privilegedActionException);
            }
        }
        _implsLoaded = true;
    }

    public static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            try {
                return privilegedExceptionAction.run();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new PrivilegedActionException(exception);
            }
        }
        return AccessController.doPrivileged(privilegedExceptionAction);
    }

    static {
        _tmSetKey = null;
        _ltcKey = null;
        _class = null;
    }
}

