/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.client;

import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTS.TaskIdPropagationData;
import com.ibm.ws.Transaction.JTS.TaskIdPropagationDataHelper;
import com.ibm.ws.Transaction.JTS.TxInterceptorHelper;
import com.ibm.ws.Transaction.client.NonRecoverableTranManagerSet;
import com.ibm.ws.Transaction.client.NonRecoverableTransactionImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.WSThreadLocal;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.otid_t;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;

public final class NonRecoverableClientInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final TraceComponent tc = Tr.register(NonRecoverableClientInterceptor.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static WSThreadLocal _contextTable = new WSThreadLocal();
    private static final NonRecoverableClientInterceptor _instance = new NonRecoverableClientInterceptor();
    private static final PlatformHelper ph = PlatformHelperFactory.getPlatformHelper();
    private static otid_t _deferredBeginOtid = new otid_t(1463898947, 0, new byte[0]);

    private NonRecoverableClientInterceptor() {
    }

    public static NonRecoverableClientInterceptor instance() {
        return _instance;
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive_exception", clientRequestInfo);
        }
        NonRecoverableClientInterceptor.getContextTable().set((Object)null);
        this.receive_reply(clientRequestInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_exception");
        }
    }

    public static byte[] send_request(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send_request", string);
        }
        ORB oRB = ph.getGlobalORB();
        byte[] byArray = _instance.send_request(string, oRB);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send_request", byArray);
        }
        return byArray;
    }

    public void send_request(ClientRequestInfo clientRequestInfo) {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send_request", clientRequestInfo);
        }
        if ((byArray = this.send_request(clientRequestInfo.operation(), (ORB)((LocalObject)clientRequestInfo)._orb())) != null) {
            ServiceContext serviceContext = new ServiceContext(0, byArray);
            clientRequestInfo.add_request_service_context(serviceContext, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send_request");
        }
    }

    private byte[] send_request(String string, ORB oRB) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send_request", new Object[]{string, oRB});
        }
        byte[] byArray = null;
        if (TxInterceptorHelper.isTransactional(string)) {
            NonRecoverableTransactionImpl nonRecoverableTransactionImpl = null;
            try {
                nonRecoverableTransactionImpl = (NonRecoverableTransactionImpl)NonRecoverableTranManagerSet.instance().getTransaction();
                if (nonRecoverableTransactionImpl != null) {
                    int n = nonRecoverableTransactionImpl.getStatus();
                    if (n == 3 || n == 4) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "send_request");
                        }
                        throw new TRANSACTION_REQUIRED();
                    }
                    if (n == 1) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "send_request");
                        }
                        throw new TRANSACTION_ROLLEDBACK();
                    }
                    PropagationContext propagationContext = (PropagationContext)NonRecoverableClientInterceptor.getContextTable().get();
                    if (propagationContext == null) {
                        long l = nonRecoverableTransactionImpl.getExpirationTime();
                        int n2 = 0;
                        if (l > 0L && (n2 = (int)((l - System.currentTimeMillis()) / 1000L)) <= 0) {
                            nonRecoverableTransactionImpl.setRollbackOnly();
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "send_request");
                            }
                            throw new TRANSACTION_ROLLEDBACK();
                        }
                        TransIdentity transIdentity = null;
                        Any any = oRB.create_any();
                        Terminator terminator = nonRecoverableTransactionImpl.getTerminator();
                        if (terminator == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "First remote request. Sending deferred begin context");
                            }
                            transIdentity = new TransIdentity(null, null, _deferredBeginOtid);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Transaction has already gone remote. Sending interop context");
                            }
                            transIdentity = new TransIdentity(nonRecoverableTransactionImpl.getCoordinator(), terminator, nonRecoverableTransactionImpl.getOtid());
                        }
                        String string2 = nonRecoverableTransactionImpl.getTaskId();
                        if (string2 != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Non-null taskId. Propagating in ISD", string2);
                            }
                            TaskIdPropagationData taskIdPropagationData = new TaskIdPropagationData(string2);
                            TaskIdPropagationDataHelper.insert(any, taskIdPropagationData);
                        }
                        propagationContext = new PropagationContext(n2, transIdentity, new TransIdentity[0], any);
                    }
                    _contextTable.set(propagationContext);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Marshalling transaction context", propagationContext);
                    }
                    byArray = TxInterceptorHelper.marshalContext(propagationContext, oRB);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No transaction active on thread.");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.client.NonRecoverableClientInterceptor.send_request", "238", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception encountered marshaling context and adding it to the request", exception);
                }
                if (nonRecoverableTransactionImpl != null) {
                    nonRecoverableTransactionImpl.setRollbackOnly();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "send_request");
                }
                throw new TRANSACTION_ROLLEDBACK();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send_request", byArray);
        }
        return byArray;
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
    }

    public static void receive_reply(String string, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive_reply", new Object[]{string, byArray});
        }
        ORB oRB = ph.getGlobalORB();
        _instance.receive_reply(string, byArray, oRB);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_reply");
        }
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive_reply", clientRequestInfo);
        }
        ServiceContext serviceContext = null;
        serviceContext = ((ExtendedClientRequestInfo)clientRequestInfo).getReplyServiceContext(0);
        byte[] byArray = null;
        if (serviceContext != null) {
            byArray = serviceContext.context_data;
        }
        this.receive_reply(clientRequestInfo.operation(), byArray, (ORB)((LocalObject)clientRequestInfo)._orb());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_reply");
        }
    }

    private void receive_reply(String string, byte[] byArray, ORB oRB) {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "receive_reply", new Object[]{string, byArray, oRB});
            }
            NonRecoverableTransactionImpl nonRecoverableTransactionImpl = null;
            if (TxInterceptorHelper.isTransactional(string)) {
                try {
                    nonRecoverableTransactionImpl = (NonRecoverableTransactionImpl)NonRecoverableTranManagerSet.instance().getTransaction();
                    if (nonRecoverableTransactionImpl == null) break block11;
                    if (byArray != null) {
                        _contextTable.set((Object)null);
                        if (nonRecoverableTransactionImpl.getTerminator() == null) {
                            PropagationContext propagationContext = TxInterceptorHelper.demarshalContext(byArray, oRB);
                            nonRecoverableTransactionImpl.setTerminator(propagationContext.current.term);
                            nonRecoverableTransactionImpl.setCoordinator(propagationContext.current.coord);
                            nonRecoverableTransactionImpl.setOtid(propagationContext.current.otid);
                        }
                        break block11;
                    }
                    nonRecoverableTransactionImpl.setRollbackOnly();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "receive_reply");
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.client.NonRecoverableClientInterceptor.receive_reply", "351", (Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception encountered processing reply", exception);
                    }
                    if (nonRecoverableTransactionImpl != null) {
                        nonRecoverableTransactionImpl.setRollbackOnly();
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "receive_reply");
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_reply");
        }
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) {
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void destroy() {
    }

    private static final WSThreadLocal getContextTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextTable");
        }
        if (_contextTable == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null context table. Creating");
            }
            _contextTable = new WSThreadLocal();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextTable", _contextTable);
        }
        return _contextTable;
    }
}

