/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.client.NonRecoverableTranManagerSet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.uow.UOWScope;
import java.util.ArrayList;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.otid_t;

public final class NonRecoverableTransactionImpl
implements Transaction,
UOWCoordinator,
UOWScope {
    private int _status = 0;
    private static final TraceComponent tc = Tr.register(NonRecoverableTransactionImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private int _timeout;
    private static boolean _reportHeuristics;
    private boolean _rollbackOnly;
    private long _expirationTime;
    private Terminator _terminator;
    private Coordinator _coordinator;
    private otid_t _otid;
    private Xid _xid;
    private ArrayList _syncs;
    private String _taskId;

    public NonRecoverableTransactionImpl(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NonRecoverableTransactionImpl", new Integer(n));
        }
        this._timeout = n;
        if (this._timeout > 0) {
            this._expirationTime = System.currentTimeMillis() + (long)this._timeout * 1000L;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NonRecoverableTransactionImpl");
        }
    }

    public long getExpirationTime() {
        return this._expirationTime;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, SecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        this.beforeCompletion();
        NonRecoverableTranManagerSet.instance().suspend();
        if (this._terminator != null) {
            try {
                if (this._rollbackOnly) {
                    if (this._terminator != null) {
                        this._terminator.rollback();
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
                if (this._terminator != null) {
                    this._terminator.commit(_reportHeuristics);
                }
                this._status = 3;
            }
            catch (HeuristicHazard heuristicHazard) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "HeuristicHazard on transaction commit", (Object)heuristicHazard);
                }
                throw new HeuristicMixedException();
            }
            catch (HeuristicMixed heuristicMixed) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "HeuristicMixed on transaction commit", (Object)heuristicMixed);
                }
                throw new HeuristicRollbackException();
            }
            catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "TRANSACTION_ROLLEDBACK on transaction commit", (Object)tRANSACTION_ROLLEDBACK);
                }
                this._status = 4;
                throw new RollbackException();
            }
            catch (NO_PERMISSION nO_PERMISSION) {
                FFDCFilter.processException((Throwable)nO_PERMISSION, "com.ibm.ws.Transaction.JTA.client.NonRecoverableTransaction.commit", "86", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "NO_PERMISSION on transaction commit", (Object)nO_PERMISSION);
                }
                throw new SecurityException();
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "OBJECT_NOT_EXIST on transaction commit", (Object)oBJECT_NOT_EXIST);
                }
                this._status = 4;
                throw new RollbackException();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.client.NonRecoverableTransaction.commit", "93", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected Throwable on transaction commit", throwable);
                }
                throw new SystemException();
            }
            finally {
                this.afterCompletion(this._status);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "commit");
                }
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Transaction has not gone remote. Trivial commit");
            }
            if (this._rollbackOnly) {
                this._status = 4;
                this.afterCompletion(this._status);
                throw new RollbackException();
            }
            this._status = 3;
            this.afterCompletion(this._status);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback() throws SecurityException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback");
        }
        NonRecoverableTranManagerSet.instance().suspend();
        if (this._terminator != null) {
            try {
                this._terminator.rollback();
                this._status = 4;
                return;
            }
            catch (NO_PERMISSION nO_PERMISSION) {
                FFDCFilter.processException((Throwable)nO_PERMISSION, "com.ibm.ws.Transaction.JTA.client.NonRecoverableTransaction.rollback", "115", this);
                if (!tc.isEventEnabled()) throw new SecurityException();
                Tr.event(tc, "NO_PERMISSION on transaction rollback", (Object)nO_PERMISSION);
                throw new SecurityException();
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                if (!tc.isEventEnabled()) return;
                Tr.event(tc, "OBJECT_NOT_EXIST on transaction rollback", (Object)oBJECT_NOT_EXIST);
                return;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.JTA.client.NonRecoverableTransaction.rollback", "122", this);
                if (!tc.isEventEnabled()) throw new SystemException();
                Tr.event(tc, "Unexpected Throwable on transaction rollback", throwable);
                throw new SystemException();
            }
            finally {
                this.afterCompletion(this._status);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "rollback");
                }
            }
        } else {
            this._status = 4;
            this.afterCompletion(this._status);
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "Transaction has not gone remote. Trivial rollback");
        }
    }

    public void setRollbackOnly() {
        this._rollbackOnly = true;
    }

    public void setTransactionTimeout(int n) {
        this._timeout = n;
    }

    public int getStatus() {
        if (this._rollbackOnly && this._status == 0) {
            return 1;
        }
        return this._status;
    }

    public Terminator getTerminator() {
        return this._terminator;
    }

    public void setTerminator(Terminator terminator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTerminator", terminator);
        }
        this._terminator = terminator;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTerminator");
        }
    }

    public Coordinator getCoordinator() {
        return this._coordinator;
    }

    public void setCoordinator(Coordinator coordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCoordinator", coordinator);
        }
        this._coordinator = coordinator;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCoordinator");
        }
    }

    public otid_t getOtid() {
        return this._otid;
    }

    public void setOtid(otid_t otid_t2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setOtid", otid_t2);
        }
        this._otid = otid_t2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setOtid");
        }
    }

    public boolean delistResource(XAResource xAResource, int n) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delistResource", new Object[]{xAResource, new Integer(n)});
        }
        SystemException systemException = new SystemException("Enlisting and delisting resources is not supported in a client environment");
        FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.client.NonRecoverableTransactionImpl", "201", this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delistResource", (Object)systemException);
        }
        throw systemException;
    }

    public boolean enlistResource(XAResource xAResource) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "enlistResource", new Object[]{xAResource});
        }
        SystemException systemException = new SystemException("Enlisting and delisting resources is not supported in a client environment");
        FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.Transaction.JTA.client.NonRecoverableTransactionImpl", "214", this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "enlistResource", (Object)systemException);
        }
        throw systemException;
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSynchronization", synchronization);
        }
        switch (this._status) {
            case 0: {
                if (!this._rollbackOnly) break;
            }
            case 4: 
            case 9: {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "The transaction was rolled back. Throwing RollbackException");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerSynchronization (SPI)");
                }
                throw new RollbackException();
            }
            default: {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "The transaction is inactive or prepared. Throwing IllegalStateException");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerSynchronization (SPI)");
                }
                throw new IllegalStateException();
            }
        }
        if (this._syncs == null) {
            this._syncs = new ArrayList();
        }
        this._syncs.add(synchronization);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSynchronization", synchronization);
        }
    }

    private void beforeCompletion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeCompletion");
        }
        if (this._syncs != null && this._status == 0 && !this._rollbackOnly) {
            for (int i = 0; i < this._syncs.size(); ++i) {
                try {
                    ((Synchronization)this._syncs.get(i)).beforeCompletion();
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "WTRN0074_SYNCHRONIZATION_EXCEPTION", new Object[]{"before_completion", throwable});
                    this._rollbackOnly = true;
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeCompletion");
        }
    }

    private void afterCompletion(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterCompletion " + n);
        }
        if (this._syncs != null) {
            for (int i = 0; i < this._syncs.size(); ++i) {
                try {
                    ((Synchronization)this._syncs.get(i)).afterCompletion(n);
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "WTRN0074_SYNCHRONIZATION_EXCEPTION", new Object[]{"after_completion", throwable});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterCompletion");
        }
    }

    public int getTxType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTxType");
            Tr.exit(tc, "getTxType", "Interop global");
        }
        return 1;
    }

    public boolean isGlobal() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGlobal");
            Tr.exit(tc, "isGlobal", "true");
        }
        return true;
    }

    public boolean getRollbackOnly() {
        return this._rollbackOnly;
    }

    public byte[] getTID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTID");
        }
        byte[] byArray = null;
        if (this._otid != null) {
            byArray = this._otid.tid;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTID", byArray);
        }
        return byArray;
    }

    public Xid getXid() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXid");
        }
        if (this._xid == null && this._otid != null) {
            this._xid = new XidImpl(this._otid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXid", this._xid);
        }
        return this._xid;
    }

    public void setTaskId(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTaskId", new Object[]{string, this});
        }
        this._taskId = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTaskId");
        }
    }

    public String getTaskId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTaskId", this);
            Tr.exit(tc, "getTaskId", this._taskId);
        }
        return this._taskId;
    }

    private class XidImpl
    implements Xid {
        private int _formatId;
        private byte[] _globalTxId;
        private byte[] _branchQualifier;

        public XidImpl(otid_t otid_t2) {
            this._formatId = otid_t2.formatID;
            this._branchQualifier = new byte[otid_t2.bqual_length];
            this._globalTxId = new byte[otid_t2.tid.length - this._branchQualifier.length];
            System.arraycopy(otid_t2.tid, 0, this._globalTxId, 0, this._globalTxId.length);
            System.arraycopy(otid_t2.tid, this._globalTxId.length, this._branchQualifier, 0, this._branchQualifier.length);
        }

        public int getFormatId() {
            return this._formatId;
        }

        public byte[] getGlobalTransactionId() {
            return this._globalTxId;
        }

        public byte[] getBranchQualifier() {
            return this._branchQualifier;
        }

        public String toString() {
            return Integer.toHexString(this._formatId) + "-" + Util.toHexString(this._globalTxId) + "-" + Util.toHexString(this._branchQualifier);
        }
    }
}

