/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.ffdc.FFDCFilter;

public class Semaphore {
    private static final TraceComponent tc = Tr.register(Semaphore.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private int _count;
    private TransactionImpl _txImpl;

    public Semaphore(TransactionImpl transactionImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Semaphore", transactionImpl);
        }
        this._txImpl = transactionImpl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Semaphore", this);
        }
    }

    public TransactionImpl getTransaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransaction", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransaction", this._txImpl);
        }
        return this._txImpl;
    }

    public synchronized void increment() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "increment", this);
        }
        ++this._count;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_count = " + this._count);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "increment");
        }
    }

    public synchronized void decrement() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decrement", this);
        }
        --this._count;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_count = " + this._count);
        }
        if (this._count <= 0) {
            this.notify();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decrement");
        }
    }

    public synchronized void force() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "force", this);
        }
        this.notify();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "force");
        }
    }

    public synchronized void externalWait(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "externalWait", new Object[]{new Long(l), this});
        }
        if (this._count > 0) {
            boolean bl = false;
            long l2 = System.currentTimeMillis();
            while (!bl) {
                try {
                    this.wait(l);
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.Transaction.wstx.Semaphore.externalWait", "102", this);
                    long l3 = System.currentTimeMillis() - l2;
                    if (l3 < l) {
                        l -= l3;
                        continue;
                    }
                    bl = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "externalWait");
        }
    }

    public synchronized void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset", this);
        }
        this._count = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public synchronized int getCount() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCount", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCount", new Integer(this._count));
        }
        return this._count;
    }
}

