/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.wstx.JTAAsyncSynchronizationBase;
import com.ibm.ws.Transaction.wstx.ParticipantPortSoapBindingStub;
import com.ibm.ws.Transaction.wstx.ParticipantPortType;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATServices;
import com.ibm.ws.Transaction.wstx.WSTXConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wscoor.ProtocolSecurityHelper;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.net.URL;

public final class Volatile2PCAsyncSynchronization
extends JTAAsyncSynchronizationBase {
    private static final TraceComponent tc = Tr.register(Volatile2PCAsyncSynchronization.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final String _txIdentifier;
    protected final EndpointReference _resource;
    protected final EndpointReference _coordinator;

    Volatile2PCAsyncSynchronization(EndpointReference endpointReference, EndpointReference endpointReference2, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Volatile2PCAsyncSynchronization", new Object[]{endpointReference, endpointReference2, string});
        }
        this._txIdentifier = string;
        this._resource = endpointReference;
        this._coordinator = endpointReference2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Volatile2PCAsyncSynchronization", this);
        }
    }

    public void sendAsyncAfterCompletion(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendAsyncAfterCompletion", new Object[]{new Integer(n), this});
        }
        try {
            EndpointReference endpointReference = WSATControlSet.createEPR(WSATServices.getWSATFaultURI());
            ServiceHelper.setAffinity(endpointReference, null);
            endpointReference.setReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME, this.getWSATTxIdentifier());
            endpointReference.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, this.getWSATParticipantIdentifier());
            ProtocolSecurityHelper.makeEPRSecure(this._coordinator.getAddress().getURI().getHost(), endpointReference);
            ParticipantPortType participantPortType = WSATServices.getWSATService().getParticipant(new URL(this.getWSATParticipantIdentifier()));
            ParticipantPortSoapBindingStub participantPortSoapBindingStub = (ParticipantPortSoapBindingStub)participantPortType;
            participantPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.replyToEPR", this._coordinator);
            participantPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.faultToEPR", endpointReference);
            participantPortSoapBindingStub._setProperty("com.ibm.websphere.wsaddressing.destinationEPR", this._resource);
            switch (n) {
                case 3: 
                case 5: {
                    participantPortSoapBindingStub.commitOperation(null);
                    break;
                }
                case 4: {
                    participantPortSoapBindingStub.rollbackOperation(null);
                    break;
                }
            }
            this._semaphore.increment();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.wstx.Volatile2PCAsyncSynchronization.sendAsyncAfterCompletion", "120", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "afterCompletion caught Exception", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sendAsyncAfterCompletion", "RuntimeException");
            }
            throw new RuntimeException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendAsyncAfterCompletion");
        }
    }

    public void sendAsyncBeforeCompletion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendAsyncBeforeCompletion", this);
        }
        try {
            EndpointReference endpointReference = WSATControlSet.createEPR(WSATServices.getWSATFaultURI());
            ServiceHelper.setAffinity(endpointReference, null);
            endpointReference.setReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME, this.getWSATTxIdentifier());
            endpointReference.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, this.getWSATParticipantIdentifier());
            ParticipantPortType participantPortType = WSATServices.getWSATService().getParticipant(new URL(this.getWSATParticipantIdentifier()));
            ParticipantPortSoapBindingStub participantPortSoapBindingStub = (ParticipantPortSoapBindingStub)participantPortType;
            participantPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.replyToEPR", this._coordinator);
            participantPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.faultToEPR", endpointReference);
            participantPortSoapBindingStub._setProperty("com.ibm.websphere.wsaddressing.destinationEPR", this._resource);
            participantPortSoapBindingStub.prepareOperation(null);
            this._semaphore.increment();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.wstx.Volatile2PCAsyncSynchronization.sendAsyncBeforeCompletion", "166", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beforeCompletion caught Exception", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sendAsyncBeforeCompletion", "RuntimeException");
            }
            throw new RuntimeException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendAsyncBeforeCompletion");
        }
    }

    public void beforeCompletion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeCompletion", this);
        }
        this._stateProcessed = true;
        switch (this._asyncState) {
            case 0: {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeCompletion", "IllegalStateException");
                }
                throw new IllegalStateException();
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeCompletion", "IllegalStateException");
                }
                throw new IllegalStateException();
            }
            case 4: {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Committed when processing beforeCompletion");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeCompletion", "IllegalStateException");
                }
                throw new IllegalStateException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeCompletion");
        }
    }

    public void afterCompletion(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterCompletion", new Object[]{new Integer(n), this});
        }
        this._stateProcessed = true;
        switch (this._asyncState) {
            case 0: {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterCompletion", "IllegalStateException");
                }
                throw new IllegalStateException();
            }
            case 1: {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterCompletion", "IllegalStateException");
                }
                throw new IllegalStateException();
            }
            case 2: {
                break;
            }
            case 3: {
                if (n == 4) break;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterCompletion", "IllegalStateException");
                }
                throw new IllegalStateException();
            }
            case 4: {
                if (n == 3 || n == 5) break;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterCompletion", "IllegalStateException");
                }
                throw new IllegalStateException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterCompletion");
        }
    }

    String getWSATParticipantIdentifier() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSATParticipantIdentifier", this);
        }
        String string = null;
        if (this._resource != null) {
            string = this._resource.getAddress().getURI().toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSATParticipantIdentifier", string);
        }
        return string;
    }

    String getWSATTxIdentifier() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSATTxIdentifier", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSATTxIdentifier", this._txIdentifier);
        }
        return this._txIdentifier;
    }

    public String getKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey", this);
        }
        String string = this.getWSATTxIdentifier() + this.getWSATParticipantIdentifier();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey", string);
        }
        return string;
    }
}

