/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.Transaction.wstx.Notification;
import com.ibm.ws.Transaction.wstx.ParticipantPortSoapBindingStub;
import com.ibm.ws.Transaction.wstx.ParticipantPortType;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATServices;
import com.ibm.ws.Transaction.wstx.WSTXConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.TxServiceImpl;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.wscoor.ProtocolSecurityHelper;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.NamespaceNotSupportedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.transaction.SystemException;
import javax.xml.rpc.ServiceException;

public final class WSATAsyncResource
implements Serializable {
    private static final long serialVersionUID = 4621016428916961077L;
    private static final transient TraceComponent tc = Tr.register(WSATAsyncResource.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final transient boolean _isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    private final String _txIdentifier;
    protected final EndpointReference _resource;
    protected final EndpointReference _coordinator;
    private final String _branchID;

    public WSATAsyncResource(EndpointReference endpointReference, EndpointReference endpointReference2, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSATAsyncResource", new Object[]{endpointReference, endpointReference2, string});
        }
        this._txIdentifier = string;
        this._resource = endpointReference;
        this._coordinator = endpointReference2;
        this._branchID = string2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSATAsyncResource", this);
        }
    }

    String getWSATTxIdentifier() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getWSATTxIdentifier", this._txIdentifier);
        }
        return this._txIdentifier;
    }

    String getWSATParticipantIdentifier() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSATParticipantIdentifier", this);
        }
        String string = null;
        if (this._resource != null) {
            string = this._resource.getAddress().getURI().toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSATParticipantIdentifier", string);
        }
        return string;
    }

    public String getWSATBranchId() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getWSATBranchId", this._branchID);
        }
        return this._branchID;
    }

    EndpointReference getParticipantEPR() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getParticipantEPR", this._resource);
        }
        return this._resource;
    }

    EndpointReference getCoordinatorEPR() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCoordinatorEPR", this._coordinator);
        }
        return this._coordinator;
    }

    public void prepareOperation(Notification notification) throws RemoteException, ServiceException, MalformedURLException, ReferenceParameterCreationException, NamespaceNotSupportedException, EndpointReferenceCreationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareOperation", new Object[]{notification, this});
        }
        EndpointReference endpointReference = WSATControlSet.createEPR(WSATServices.getWSATFaultURI());
        ServiceHelper.setAffinity(endpointReference, null);
        endpointReference.setReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME, this.getWSATTxIdentifier());
        endpointReference.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, this.getWSATParticipantIdentifier());
        if (_isZOS) {
            endpointReference.setReferenceParameter(WSTXConstants.BRANCH_ELEMENT_QNAME, this.getWSATBranchId());
        }
        if (WSATControlSet.isHeuristicsSupported()) {
            this._coordinator.setReferenceParameter(WSTXConstants.SUPPORT_HEURISTIC_QNAME, String.valueOf(true));
        }
        ProtocolSecurityHelper.makeEPRSecure(this._coordinator.getAddress().getURI().getHost(), endpointReference);
        ParticipantPortType participantPortType = WSATServices.getWSATService().getParticipant(new URL(this.getWSATParticipantIdentifier()));
        final ParticipantPortSoapBindingStub participantPortSoapBindingStub = (ParticipantPortSoapBindingStub)participantPortType;
        participantPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.faultToEPR", endpointReference);
        participantPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.replyToEPR", this._coordinator);
        participantPortSoapBindingStub._setProperty("com.ibm.websphere.wsaddressing.destinationEPR", this._resource);
        participantPortSoapBindingStub._setProperty("com.ibm.ws.wsaddressing.UCFCallback.disable", "true");
        try {
            final Notification notification2 = notification;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws RemoteException, ServiceException, MalformedURLException, ReferenceParameterCreationException, NamespaceNotSupportedException, EndpointReferenceCreationException {
                    participantPortSoapBindingStub.prepareOperation(notification2);
                    return null;
                }
            };
            TxServiceImpl.runAsSystem(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof RemoteException) {
                throw (RemoteException)throwable;
            }
            if (throwable instanceof ServiceException) {
                throw (ServiceException)throwable;
            }
            if (throwable instanceof MalformedURLException) {
                throw (MalformedURLException)throwable;
            }
            if (throwable instanceof ReferenceParameterCreationException) {
                throw (ReferenceParameterCreationException)throwable;
            }
            if (throwable instanceof NamespaceNotSupportedException) {
                throw (NamespaceNotSupportedException)throwable;
            }
            if (throwable instanceof EndpointReferenceCreationException) {
                throw (EndpointReferenceCreationException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareOperation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitOperation(Notification notification) throws RemoteException, ServiceException, MalformedURLException, ReferenceParameterCreationException, NamespaceNotSupportedException, EndpointReferenceCreationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commitOperation", new Object[]{notification, this});
        }
        try {
            EndpointReference endpointReference = WSATControlSet.createEPR(WSATServices.getWSATFaultURI());
            ServiceHelper.setAffinity(endpointReference, null);
            endpointReference.setReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME, this.getWSATTxIdentifier());
            endpointReference.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, this.getWSATParticipantIdentifier());
            if (_isZOS) {
                endpointReference.setReferenceParameter(WSTXConstants.BRANCH_ELEMENT_QNAME, this.getWSATBranchId());
            }
            ProtocolSecurityHelper.makeEPRSecure(this._coordinator.getAddress().getURI().getHost(), endpointReference);
            ParticipantPortType participantPortType = WSATServices.getWSATService().getParticipant(new URL(this.getWSATParticipantIdentifier()));
            final ParticipantPortSoapBindingStub participantPortSoapBindingStub = (ParticipantPortSoapBindingStub)participantPortType;
            participantPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.replyToEPR", this._coordinator);
            participantPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.faultToEPR", endpointReference);
            participantPortSoapBindingStub._setProperty("com.ibm.websphere.wsaddressing.destinationEPR", this._resource);
            participantPortSoapBindingStub._setProperty("com.ibm.ws.wsaddressing.UCFCallback.disable", "true");
            try {
                final Notification notification2 = notification;
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() throws RemoteException, ServiceException, MalformedURLException, ReferenceParameterCreationException, NamespaceNotSupportedException, EndpointReferenceCreationException {
                        participantPortSoapBindingStub.commitOperation(notification2);
                        return null;
                    }
                };
                TxServiceImpl.runAsSystem(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof RemoteException) {
                    throw (RemoteException)throwable;
                }
                if (throwable instanceof ServiceException) {
                    throw (ServiceException)throwable;
                }
                if (throwable instanceof MalformedURLException) {
                    throw (MalformedURLException)throwable;
                }
                if (throwable instanceof ReferenceParameterCreationException) {
                    throw (ReferenceParameterCreationException)throwable;
                }
                if (throwable instanceof NamespaceNotSupportedException) {
                    throw (NamespaceNotSupportedException)throwable;
                }
                if (throwable instanceof EndpointReferenceCreationException) {
                    throw (EndpointReferenceCreationException)throwable;
                }
                throw new RuntimeException(throwable);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commitOperation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackOperation(Notification notification) throws RemoteException, ServiceException, MalformedURLException, ReferenceParameterCreationException, NamespaceNotSupportedException, EndpointReferenceCreationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackOperation", new Object[]{notification, this});
        }
        try {
            EndpointReference endpointReference = WSATControlSet.createEPR(WSATServices.getWSATFaultURI());
            ServiceHelper.setAffinity(endpointReference, null);
            endpointReference.setReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME, this.getWSATTxIdentifier());
            endpointReference.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, this.getWSATParticipantIdentifier());
            if (_isZOS) {
                endpointReference.setReferenceParameter(WSTXConstants.BRANCH_ELEMENT_QNAME, this.getWSATBranchId());
            }
            if (WSATControlSet.isHeuristicsSupported()) {
                this._coordinator.setReferenceParameter(WSTXConstants.SUPPORT_HEURISTIC_QNAME, String.valueOf(true));
            }
            ProtocolSecurityHelper.makeEPRSecure(this._coordinator.getAddress().getURI().getHost(), endpointReference);
            ParticipantPortType participantPortType = WSATServices.getWSATService().getParticipant(new URL(this.getWSATParticipantIdentifier()));
            final ParticipantPortSoapBindingStub participantPortSoapBindingStub = (ParticipantPortSoapBindingStub)participantPortType;
            participantPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.replyToEPR", this._coordinator);
            participantPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.faultToEPR", endpointReference);
            participantPortSoapBindingStub._setProperty("com.ibm.websphere.wsaddressing.destinationEPR", this._resource);
            participantPortSoapBindingStub._setProperty("com.ibm.ws.wsaddressing.UCFCallback.disable", "true");
            try {
                final Notification notification2 = notification;
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() throws RemoteException, ServiceException, MalformedURLException, ReferenceParameterCreationException, NamespaceNotSupportedException, EndpointReferenceCreationException {
                        participantPortSoapBindingStub.rollbackOperation(notification2);
                        return null;
                    }
                };
                TxServiceImpl.runAsSystem(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof RemoteException) {
                    throw (RemoteException)throwable;
                }
                if (throwable instanceof ServiceException) {
                    throw (ServiceException)throwable;
                }
                if (throwable instanceof MalformedURLException) {
                    throw (MalformedURLException)throwable;
                }
                if (throwable instanceof ReferenceParameterCreationException) {
                    throw (ReferenceParameterCreationException)throwable;
                }
                if (throwable instanceof NamespaceNotSupportedException) {
                    throw (NamespaceNotSupportedException)throwable;
                }
                if (throwable instanceof EndpointReferenceCreationException) {
                    throw (EndpointReferenceCreationException)throwable;
                }
                throw new RuntimeException(throwable);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollbackOperation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetOperation(Notification notification) throws RemoteException, ServiceException, MalformedURLException, ReferenceParameterCreationException, NamespaceNotSupportedException, EndpointReferenceCreationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "forgetOperation", new Object[]{notification, this});
        }
        try {
            EndpointReference endpointReference = WSATControlSet.createEPR(WSATServices.getWSATFaultURI());
            ServiceHelper.setAffinity(endpointReference, null);
            endpointReference.setReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME, this.getWSATTxIdentifier());
            endpointReference.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, this.getWSATParticipantIdentifier());
            if (_isZOS) {
                endpointReference.setReferenceParameter(WSTXConstants.BRANCH_ELEMENT_QNAME, this.getWSATBranchId());
            }
            ProtocolSecurityHelper.makeEPRSecure(this._coordinator.getAddress().getURI().getHost(), endpointReference);
            ParticipantPortType participantPortType = WSATServices.getWSATService().getParticipant(new URL(this.getWSATParticipantIdentifier()));
            final ParticipantPortSoapBindingStub participantPortSoapBindingStub = (ParticipantPortSoapBindingStub)participantPortType;
            participantPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.faultToEPR", endpointReference);
            participantPortSoapBindingStub._setProperty("com.ibm.websphere.wsaddressing.destinationEPR", this._resource);
            participantPortSoapBindingStub._setProperty("com.ibm.ws.wsaddressing.UCFCallback.disable", "true");
            try {
                final Notification notification2 = notification;
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() throws RemoteException, ServiceException, MalformedURLException, ReferenceParameterCreationException, NamespaceNotSupportedException, EndpointReferenceCreationException {
                        participantPortSoapBindingStub.forgetOperation(notification2);
                        return null;
                    }
                };
                TxServiceImpl.runAsSystem(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof RemoteException) {
                    throw (RemoteException)throwable;
                }
                if (throwable instanceof ServiceException) {
                    throw (ServiceException)throwable;
                }
                if (throwable instanceof MalformedURLException) {
                    throw (MalformedURLException)throwable;
                }
                if (throwable instanceof ReferenceParameterCreationException) {
                    throw (ReferenceParameterCreationException)throwable;
                }
                if (throwable instanceof NamespaceNotSupportedException) {
                    throw (NamespaceNotSupportedException)throwable;
                }
                if (throwable instanceof EndpointReferenceCreationException) {
                    throw (EndpointReferenceCreationException)throwable;
                }
                throw new RuntimeException(throwable);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "forgetOperation");
            }
        }
    }

    byte[] toLogData() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toLogData", this);
        }
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.wstx.WSATAsyncResource.toLogData", "279", this);
            SystemException systemException = new SystemException();
            systemException.initCause((Throwable)exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "toLogData", (Object)systemException);
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toLogData", byArray);
        }
        return byArray;
    }

    static WSATAsyncResource fromLogData(byte[] byArray) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fromLogData", byArray);
        }
        WSATAsyncResource wSATAsyncResource = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            wSATAsyncResource = (WSATAsyncResource)object;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.Transaction.wstx.WSATAsyncResource.fromLogData", "307");
            SystemException systemException = new SystemException();
            systemException.initCause((Throwable)exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fromLogData", (Object)systemException);
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fromLogData", wSATAsyncResource);
        }
        return wSATAsyncResource;
    }

    String describe() {
        return "WSAT resource: " + this.getWSATParticipantIdentifier();
    }
}

