/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.LocalTransaction.LocalTranCurrentSet;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.CoordinatorImpl;
import com.ibm.ws.Transaction.JTS.ResourceCallback;
import com.ibm.ws.Transaction.JTS.TransactionWrapper;
import com.ibm.ws.Transaction.JTS.TxInterceptorHelper;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.wstx.RegisterAlarm;
import com.ibm.ws.Transaction.wstx.RegisterResponseCorrelationData;
import com.ibm.ws.Transaction.wstx.RegisterResponseOperationHandlerImpl;
import com.ibm.ws.Transaction.wstx.WSATFaultPort;
import com.ibm.ws.Transaction.wstx.WSATFaultPortSoapBindingStub;
import com.ibm.ws.Transaction.wstx.WSATHandlerHelper;
import com.ibm.ws.Transaction.wstx.WSATRecoveryCoordinator;
import com.ibm.ws.Transaction.wstx.WSATResourceCallback;
import com.ibm.ws.Transaction.wstx.WSATServices;
import com.ibm.ws.Transaction.wstx.WSTXConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.wsaddressing.HAResource;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws.wscoor.ProtocolSecurityHelper;
import com.ibm.ws.wscoor.RegisterResponseOperationHandler;
import com.ibm.ws.wscoor.RegisterType;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.ws.wscoor.WSCoorHelper;
import com.ibm.ws.wscoor.WSCoorServices;
import com.ibm.ws390.tx.WSATCRControlSet;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.exitpoint.systemcontext.SystemContext;
import com.ibm.wsspi.soapchannel.monitor.SOAPRequestController;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.webservices.sysapp.SystemEndpointContext;
import com.ibm.wsspi.wsaddressing.AttributedType;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.NamespaceNotSupportedException;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.Text;

public final class WSATControlSet {
    private static final TraceComponent tc = Tr.register(WSATControlSet.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final TranManagerSet _TMSet = TranManagerSet.instance();
    private static final LocalTranCurrentSet _LTCSet = LocalTranCurrentSet.instance();
    private static final boolean _isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    private static final Hashtable _contexts = new Hashtable();
    private static final Hashtable _JTATran2ID = new Hashtable();
    private static final Hashtable _transactionWrappers = new Hashtable();
    private static final Hashtable _HAHashtables = new Hashtable();
    private static final WSThreadLocal _threadUOWCoord = new WSThreadLocal();
    private static final WSThreadLocal _threadSuspendedTran = new WSThreadLocal();
    private static final WSThreadLocal _threadImportedTran = new WSThreadLocal();
    private static final WSThreadLocal _needToRegister = new WSThreadLocal();
    private static ClusterService _clusterService;
    private static RecoveryDirector _recoveryDirector;
    private static String _IdentityString;
    private static String _NonNullIdentityString;
    private static Name _clusterIdName;
    private static boolean _HAEnabled;
    private static boolean _deferredRegistrationEnabled;
    private static boolean _heuristicsSupported;
    private static final String CONTEXT_KEY_SEPARATOR = " ";
    public static final String UNAUTHORIZED = "unauthorized";
    private static final AttributedURI WSAT_FAULT_ACTION;
    private static boolean _initialised;

    private static synchronized void initialise() {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "initialise");
            }
            if (_initialised) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initialise", "Already initialized");
                }
                return;
            }
            try {
                _recoveryDirector = RecoveryDirectorFactory.recoveryDirector();
                _HAEnabled = _recoveryDirector.isHAEnabled();
                if (_HAEnabled) {
                    FailureScope failureScope = _recoveryDirector.currentFailureScope();
                    Identity identity = _recoveryDirector.clusterIdentity(failureScope);
                    _clusterService = ClusterServiceFactory.getClusterService();
                    _IdentityString = _clusterService.identityToString(identity);
                }
                _NonNullIdentityString = _recoveryDirector.getNonNullCurrentFailureScopeIDString();
                _initialised = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.Transaction.wstx.WSATControlSet.<clinit>", "213");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "initialise caught exception ", exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialise", new Object[]{_recoveryDirector, new Boolean(_HAEnabled), _clusterService, _IdentityString, new Boolean(_initialised)});
        }
    }

    static void clearTransactionAssociation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clearTransactionAssociation");
        }
        _threadSuspendedTran.set((Object)null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clearTransactionAssociation");
        }
    }

    static TransactionImpl resumeSuspendedTransactionAssociation() {
        TransactionImpl transactionImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeSuspendedTransactionAssociation");
        }
        if ((transactionImpl = (TransactionImpl)_threadSuspendedTran.get()) != null) {
            try {
                transactionImpl.resumeAssociation();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.wstx.WSATControlSet.resumeSuspendedTransactionAssociation", "350");
            }
            _threadSuspendedTran.set((Object)null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeSuspendedTransactionAssociation", transactionImpl);
        }
        return transactionImpl;
    }

    static void resumeSuspendedTransactionAssociationMarkRollback() {
        TransactionImpl transactionImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeSuspendedTransactionAssociationMarkRollback");
        }
        if ((transactionImpl = WSATControlSet.resumeSuspendedTransactionAssociation()) != null) {
            try {
                transactionImpl.setRollbackOnly();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.wstx.WSATControlSet.resumeSuspendedTransactionAssociationMarkRollback", "346");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeSuspendedTransactionAssociationMarkRollback");
        }
    }

    static TransactionImpl suspendCurrentTransactionAssociation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "suspendCurrentTransactionAssociation");
        }
        TransactionImpl transactionImpl = _TMSet.getTransactionImpl();
        _threadSuspendedTran.set(transactionImpl);
        if (transactionImpl != null) {
            transactionImpl.suspendAssociation();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "suspendCurrentTransactionAssociation", transactionImpl);
        }
        return transactionImpl;
    }

    static void completedTransactionBranch(RegisterResponseCorrelationData registerResponseCorrelationData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "completedTransactionBranch", registerResponseCorrelationData);
        }
        String string = registerResponseCorrelationData.getIdentifier();
        int n = registerResponseCorrelationData.getBranchIndex();
        if (_isZOS) {
            WSATCRControlSet.instance().failImportWSATContext(string, n);
            SOAPRequestController sOAPRequestController = registerResponseCorrelationData.getSOAPRequestController();
            sOAPRequestController.sendError();
        } else {
            String string2 = WSATControlSet.createContextKey(string, n);
            _contexts.remove(string2);
            _transactionWrappers.remove(string2);
            TransactionImpl transactionImpl = registerResponseCorrelationData.getTransactionImpl();
            _JTATran2ID.remove(transactionImpl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "completedTransactionBranch");
        }
    }

    static void completedTransactionBranch(String string, int n, String string2, TransactionImpl transactionImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "completedTransactionBranch", new Object[]{string, new Integer(n), string2, transactionImpl});
        }
        String string3 = WSATControlSet.createContextKey(string, n);
        _contexts.remove(string3);
        if (string2 == null || string2.equals(WSATControlSet.getNonNullIdentityString())) {
            _transactionWrappers.remove(string3);
        } else {
            Hashtable hashtable = (Hashtable)_HAHashtables.get(string2);
            if (hashtable != null) {
                hashtable.remove(string3);
            }
        }
        _JTATran2ID.remove(transactionImpl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "completedTransactionBranch");
        }
    }

    public static CoordinationContext getCoordinationContextForCurrentTx(SystemContext systemContext, boolean bl) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCoordinationContextForCurrentTx", new Object[]{systemContext, bl});
        }
        CoordinationContext coordinationContext = null;
        try {
            TransactionImpl transactionImpl = _TMSet.getTransactionImpl();
            if (transactionImpl == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCoordinationContextForCurrentTx", null);
                }
                return null;
            }
            int n = transactionImpl.getStatus();
            if (n == 3 || n == 4) {
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "The transaction has already completed and cannot be exported.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getCoordinationContextForCurrentTx", "TransactionRequiredException");
                    }
                }
                throw new TransactionRequiredException();
            }
            if (transactionImpl.isTimedOut()) {
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "The transaction has timed out.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getCoordinationContextForCurrentTx", "TransactionRolledbackException");
                    }
                }
                throw new TransactionRolledbackException();
            }
            if (systemContext != null && systemContext.isOneWay()) {
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "The request is one way.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getCoordinationContextForCurrentTx", "Exception");
                    }
                }
                throw new Exception("Illegal attempt to flow context on a one-way message");
            }
            String string = (String)_JTATran2ID.get(transactionImpl);
            int n2 = 0;
            if (_isZOS) {
                n2 = transactionImpl.getXidImpl().getBqualBranchIndex();
            }
            if (string == null) {
                string = transactionImpl.getGlobalGlobalID();
                _JTATran2ID.put(transactionImpl, string);
                coordinationContext = WSATControlSet.createCoordinationContext(string, WSTXConstants.WSAT_COORDINATION_TYPE, n2, bl, TxInterceptorHelper.calculateSubordinateTimeout(transactionImpl) * 1000);
                WSATResourceCallback wSATResourceCallback = new WSATResourceCallback(string, WSATControlSet.getIdentityString(), n2, transactionImpl);
                TransactionWrapper transactionWrapper = new TransactionWrapper(transactionImpl);
                transactionWrapper.setResourceCallback(wSATResourceCallback);
                WSATControlSet.putTransactionWrapper(WSATControlSet.createContextKey(string, n2), transactionWrapper);
                transactionImpl.promoteToDistributedTx(string);
            } else {
                coordinationContext = (CoordinationContext)_contexts.get(WSATControlSet.createContextKey(string, n2));
            }
        }
        catch (TransactionRolledbackException transactionRolledbackException) {
            FFDCFilter.processException(transactionRolledbackException, "com.ibm.ws.Transaction.wstx.WSATControlSet.getCoordinationContextForCurrentTx", "539");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getCoordinationContextForCurrentTx", (Object)transactionRolledbackException);
            }
            throw transactionRolledbackException;
        }
        catch (TransactionRequiredException transactionRequiredException) {
            FFDCFilter.processException(transactionRequiredException, "com.ibm.ws.Transaction.wstx.WSATControlSet.getCoordinationContextForCurrentTx", "548");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getCoordinationContextForCurrentTx", (Object)transactionRequiredException);
            }
            throw transactionRequiredException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.wstx.WSATControlSet.getCoordinationContextForCurrentTx", "557");
            Exception exception = new Exception(throwable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getCoordinationContextForCurrentTx", exception);
            }
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCoordinationContextForCurrentTx", coordinationContext);
        }
        return coordinationContext;
    }

    static void establishCoordinationContext(CoordinationContext coordinationContext) throws Exception {
        if (!_isZOS && !_TMSet.isReplayComplete()) {
            throw new Exception("Transaction service not ready to process new transactions");
        }
        WSATControlSet.establishCoordinationContext(coordinationContext, (byte[])null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void establishCoordinationContext(CoordinationContext coordinationContext, byte[] byArray, int n) throws Exception {
        block39: {
            if (TraceComponent.isAnyTracingEnabled()) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "establishCoordinationContext", new Object[]{coordinationContext, byArray, new Integer(n)});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Identifier - " + coordinationContext.getIdentifier());
                    Tr.debug(tc, "CoordinationType - " + coordinationContext.getCoordinationType());
                    Tr.debug(tc, "Expires - " + coordinationContext.getExpires());
                    Tr.debug(tc, "RegistrationService Address - " + coordinationContext.getRegistrationService().getAddress());
                    if (byArray != null) {
                        Tr.debug(tc, "Native Xid - ", Util.toHexString(byArray));
                    }
                }
            }
            boolean bl = WSATControlSet.isRegistrationDeferable(coordinationContext.getRegistrationService());
            try {
                String string;
                AttributedType attributedType;
                UOWCoordinator uOWCoordinator = _TMSet.getUOWCoord();
                _threadUOWCoord.set(uOWCoordinator);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "uowCurrent", uOWCoordinator);
                }
                String string2 = coordinationContext.getIdentifier().getURI().toString();
                if (uOWCoordinator != null && uOWCoordinator.isGlobal()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.debug(tc, "The Web Service request is a local invocation");
                    }
                    ((TransactionImpl)uOWCoordinator).resumeAssociation();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "establishCoordinationContext");
                    }
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug(tc, "The Web Service request is a remote invocation");
                }
                if (!coordinationContext.getCoordinationType().toString().equals("http://schemas.xmlsoap.org/ws/2004/10/wsat")) break block39;
                LocalTransactionCoordinator localTransactionCoordinator = _LTCSet.suspend();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Suspended LTC", localTransactionCoordinator);
                }
                boolean bl2 = false;
                String string3 = WSATControlSet.createContextKey(string2, n);
                Object object = _contexts;
                synchronized (object) {
                    attributedType = (CoordinationContext)_contexts.get(string3);
                    if (attributedType == null) {
                        if (!_isZOS && _TMSet.isQuiesced()) {
                            throw new Exception("Server is Quiescing, transaction will not be imported");
                        }
                        bl2 = true;
                        string = coordinationContext.getExpires();
                        WSATControlSet.createCoordinationContext(string2, WSTXConstants.WSAT_COORDINATION_TYPE, n, true, WSATControlSet.convertExpires(string));
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got Coordination Context");
                    }
                }
                if (bl2) {
                    try {
                        Object object2;
                        _needToRegister.set(Boolean.TRUE);
                        object = WSATControlSet.createEPR(WSATServices.getWSATParticipantURI());
                        WSATControlSet.pinEPRToServer((EndpointReference)object);
                        attributedType = coordinationContext.getRegistrationService();
                        string = attributedType.getAddress().getURI().toString();
                        String string4 = attributedType.getReferenceParameter(WSTXConstants.SUPPORT_HEURISTIC_QNAME);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "nevheur = " + string4);
                        }
                        object.setReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME, string2);
                        if (_isZOS) {
                            object.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, new Integer(n).toString());
                        } else {
                            object.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, string);
                        }
                        RegisterType registerType = new RegisterType((EndpointReference)object, URI.create("http://schemas.xmlsoap.org/ws/2004/10/wsat/Durable2PC"));
                        String string5 = coordinationContext.getExpires();
                        TransactionImpl transactionImpl = new TransactionImpl((int)(WSATControlSet.convertExpires(string5) / 1000L), string2, byArray);
                        WSATResourceCallback wSATResourceCallback = new WSATResourceCallback(string2, WSATControlSet.getIdentityString(), n, transactionImpl);
                        transactionImpl.setWSATRecoveryCoordinator(new WSATRecoveryCoordinator(string2, (EndpointReference)object, bl));
                        CoordinatorImpl coordinatorImpl = new CoordinatorImpl(transactionImpl);
                        try {
                            if (!_isZOS) {
                                WSATControlSet.importTran(transactionImpl);
                            }
                            object2 = new TransactionWrapper(transactionImpl);
                            ((TransactionWrapper)object2).setResourceCallback(wSATResourceCallback);
                            WSATControlSet.putTransactionWrapper(string3, (TransactionWrapper)object2);
                            _JTATran2ID.put(transactionImpl, string2);
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.wstx.WSATControlSet.establishCoordinationContext", "617");
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "establishCoordinationContext", throwable);
                            }
                            coordinatorImpl.rollback_only();
                        }
                        if (!bl && !_isZOS) {
                            object2 = new RegisterAlarm();
                            RegisterResponseCorrelationData registerResponseCorrelationData = new RegisterResponseCorrelationData(null, (EndpointReference)object, (RegisterAlarm)object2, string2, string, n, transactionImpl);
                            RegisterResponseOperationHandlerImpl.addRegisterResponseTarget(string2 + string, registerResponseCorrelationData);
                            ((RegisterAlarm)object2).start(Configuration.getAsyncResponseTimeout(), registerResponseCorrelationData);
                            WSCoorHelper.doAsyncRegister(registerType, (EndpointReference)attributedType, string2 + string, (RegisterResponseOperationHandler)new RegisterResponseOperationHandlerImpl(), WSATServices.getWSATFaultURI());
                        }
                        break block39;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.wstx.WSATControlSet.establishCoordinationContext", "586");
                        _contexts.remove(WSATControlSet.createContextKey(string2, n));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "establishCoordinationContext", throwable);
                        }
                        throw new TransactionRolledbackException();
                    }
                }
                if (_isZOS && byArray == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "z/OS second call of method");
                    }
                } else {
                    _needToRegister.set(Boolean.FALSE);
                }
                if ((object = WSATControlSet.getTransactionForID(string3)) == null) {
                    throw new Exception("Transaction for known identifier not found. Id: " + string2);
                }
                WSATControlSet.importTran((TransactionImpl)object);
            }
            catch (TransactionRolledbackException transactionRolledbackException) {
                FFDCFilter.processException(transactionRolledbackException, "com.ibm.ws.Transaction.wstx.WSATControlSet.establishCoordinationContext", "269");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "establishCoordinationContext", (Object)transactionRolledbackException);
                }
                throw transactionRolledbackException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.wstx.WSATControlSet.establishCoordinationContext", "270");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "establishCoordinationContext", throwable);
                }
                throw new Exception(throwable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "establishCoordinationContext");
        }
    }

    public static void establishCoordinationContext(CoordinationContext coordinationContext, SOAPRequestController sOAPRequestController, byte[] byArray) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "establishCoordinationContext", new Object[]{coordinationContext, sOAPRequestController, byArray});
        }
        if (coordinationContext == null) {
            if (byArray != null) {
                WSATCRControlSet.instance().importWSATContext(null, false, null, byArray, sOAPRequestController, null, 0);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "establishCoordinationContext");
            }
            return;
        }
        if (coordinationContext.getCoordinationType().toString().equals("http://schemas.xmlsoap.org/ws/2004/10/wsat")) {
            boolean bl = WSATControlSet.isRegistrationDeferable(coordinationContext.getRegistrationService());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "deferRegistration", new Boolean(bl));
            }
            try {
                AttributedURI attributedURI = coordinationContext.getIdentifier();
                String string = attributedURI.getURI().toString();
                byte[] byArray2 = WSATHandlerHelper.toLogData(coordinationContext);
                String string2 = coordinationContext.getExpires();
                int n = (int)(WSATControlSet.convertExpires(string2) / 1000L);
                int n2 = WSATCRControlSet.instance().importWSATContext(string, bl, byArray2, byArray, sOAPRequestController, null, n);
                if (!bl && n2 > 0) {
                    EndpointReference endpointReference = WSATControlSet.createEPR(WSATServices.getWSATParticipantURI());
                    WSATControlSet.pinEPRToServer(endpointReference);
                    EndpointReference endpointReference2 = coordinationContext.getRegistrationService();
                    String string3 = endpointReference2.getAddress().getURI().toString();
                    endpointReference.setReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME, string);
                    endpointReference.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, String.valueOf(n2));
                    endpointReference.setReferenceParameter(WSTXConstants.BRANCH_ELEMENT_QNAME, String.valueOf(n2));
                    RegisterType registerType = new RegisterType(endpointReference, URI.create("http://schemas.xmlsoap.org/ws/2004/10/wsat/Durable2PC"));
                    RegisterAlarm registerAlarm = new RegisterAlarm();
                    RegisterResponseCorrelationData registerResponseCorrelationData = new RegisterResponseCorrelationData(sOAPRequestController, endpointReference, registerAlarm, string, string3, n2, byArray2, byArray, n);
                    RegisterResponseOperationHandlerImpl.addRegisterResponseTarget(string + string3, registerResponseCorrelationData);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Suspending SOAP request", sOAPRequestController);
                    }
                    sOAPRequestController.suspend();
                    registerAlarm.start(Configuration.getAsyncResponseTimeout(), registerResponseCorrelationData);
                    WSCoorHelper.doAsyncRegister(registerType, endpointReference2, string + string3, (RegisterResponseOperationHandler)new RegisterResponseOperationHandlerImpl(), WSATServices.getWSATFaultURI());
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.wstx.WSATControlSet.establishCoordinationContext", "270");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "establishCoordinationContext", throwable);
                }
                throw new Exception(throwable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "establishCoordinationContext");
        }
    }

    public static boolean isRegistrationDeferable(EndpointReference endpointReference) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isRegistrationDeferable", endpointReference);
        }
        String string = endpointReference.getReferenceParameter(WSTXConstants.DEFERABLE_ELEMENT_QNAME);
        Boolean bl = Boolean.valueOf(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isRegistrationDeferable", bl);
        }
        return bl;
    }

    public static boolean isHeuristicsSupported() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isHeuristicsSupported", _heuristicsSupported);
        }
        return _heuristicsSupported;
    }

    public static void setHeuristicsSupport(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setHeuristicsSupport", bl);
        }
        _heuristicsSupported = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setHeuristicsSupport", _heuristicsSupported);
        }
    }

    static CoordinationContext createCoordinationContext(String string, URI uRI, int n, boolean bl, long l) throws SystemException {
        EndpointReference endpointReference;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createCoordinationContext", new Object[]{string, uRI, new Integer(n), bl, new Long(l)});
        }
        try {
            endpointReference = WSATControlSet.createEPR(WSCoorServices.getRegistrationCoordinatorURI());
            ServiceHelper.setAffinity(endpointReference, null);
            endpointReference.setReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME, string);
            endpointReference.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, string);
            if (_isZOS) {
                endpointReference.setReferenceParameter(WSTXConstants.BRANCH_ELEMENT_QNAME, String.valueOf(n));
            }
            endpointReference.setReferenceParameter(WSTXConstants.DEFERABLE_ELEMENT_QNAME, String.valueOf(bl));
            if (WSATControlSet.isHeuristicsSupported()) {
                endpointReference.setReferenceParameter(WSTXConstants.SUPPORT_HEURISTIC_QNAME, String.valueOf(true));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.Transaction.wstx.WSATControlSet.createCoordinationContext", "690");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Exception creating CoordinationContext", exception);
            }
            SystemException systemException = new SystemException();
            systemException.initCause((Throwable)exception);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createCoordinationContext", (Object)systemException);
            }
            throw systemException;
        }
        CoordinationContext coordinationContext = new CoordinationContext(WSAddressingFactory.createAttributedURI(URI.create(string)), uRI, endpointReference, String.valueOf(l), null);
        _contexts.put(WSATControlSet.createContextKey(string, n), coordinationContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createCoordinationContext", coordinationContext);
        }
        return coordinationContext;
    }

    static TransactionImpl cleanupThreadContext() throws InvalidTransactionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupThreadContext");
        }
        TransactionImpl transactionImpl = WSATControlSet.unImportTran();
        UOWCoordinator uOWCoordinator = (UOWCoordinator)_threadUOWCoord.get();
        if (uOWCoordinator != null && !uOWCoordinator.isGlobal()) {
            LocalTransactionCoordinator localTransactionCoordinator = (LocalTransactionCoordinator)((Object)uOWCoordinator);
            _LTCSet.resume(localTransactionCoordinator);
        }
        _threadUOWCoord.set((Object)null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupThreadContext", transactionImpl);
        }
        return transactionImpl;
    }

    static TransactionImpl getTransactionForID(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransactionForID", string);
        }
        TransactionImpl transactionImpl = null;
        TransactionWrapper transactionWrapper = (TransactionWrapper)_transactionWrappers.get(string);
        transactionImpl = transactionWrapper != null ? transactionWrapper.getTransaction() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransactionForID", transactionImpl);
        }
        return transactionImpl;
    }

    public static void reconstruct(TransactionImpl transactionImpl, WSATRecoveryCoordinator wSATRecoveryCoordinator, FailureScopeController failureScopeController) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reconstruct", new Object[]{transactionImpl, wSATRecoveryCoordinator, failureScopeController});
        }
        String string = wSATRecoveryCoordinator.getIdentifier();
        WSATControlSet.reconstruct(transactionImpl, string, failureScopeController);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reconstruct");
        }
    }

    public static void reconstruct(TransactionImpl transactionImpl, String string, FailureScopeController failureScopeController) throws SystemException {
        Object object;
        Hashtable hashtable;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reconstruct", new Object[]{transactionImpl, string, failureScopeController});
        }
        if (!_initialised) {
            WSATControlSet.initialise();
        }
        _JTATran2ID.put(transactionImpl, string);
        TransactionWrapper transactionWrapper = new TransactionWrapper(transactionImpl);
        int n = 0;
        if (_isZOS) {
            n = transactionImpl.getXidImpl().getBqualBranchIndex();
        }
        WSATControlSet.createCoordinationContext(string, WSTXConstants.WSAT_COORDINATION_TYPE, n, true, 0L);
        String string2 = null;
        if (WSATControlSet.isHAEnabled() && (hashtable = _recoveryDirector.clusterIdentity((FailureScope)(object = failureScopeController.failureScope()))) != null) {
            string2 = _clusterService.identityToString((Identity)((Object)hashtable));
        }
        object = new WSATResourceCallback(string, string2, n, transactionImpl);
        transactionWrapper.setResourceCallback((ResourceCallback)object);
        if (string2 == null || string2.equals(WSATControlSet.getNonNullIdentityString())) {
            WSATControlSet.putTransactionWrapper(string, transactionWrapper);
        } else {
            hashtable = (Hashtable)_HAHashtables.get(string2);
            if (hashtable == null) {
                hashtable = new Hashtable();
                _HAHashtables.put(string2, hashtable);
            }
            hashtable.put(string, transactionWrapper);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reconstruct");
        }
    }

    public static HashMap getSOAPHeaderElements(SystemEndpointContext systemEndpointContext) throws SOAPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSOAPHeaderElements", systemEndpointContext);
        }
        SOAPHeader sOAPHeader = ((SOAPMessageContext)systemEndpointContext.getMessageContext()).getMessage().getSOAPPart().getEnvelope().getHeader();
        Iterator iterator = sOAPHeader.getChildElements();
        HashMap<Name, String> hashMap = new HashMap<Name, String>();
        while (iterator.hasNext()) {
            javax.xml.soap.SOAPElement sOAPElement = WSATControlSet.getSOAPElementForObject(iterator.next());
            if (sOAPElement == null) continue;
            hashMap.put(sOAPElement.getElementName(), sOAPElement.getValue());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSOAPHeaderElements", hashMap);
        }
        return hashMap;
    }

    static Name getClusterIdName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getClusterIdName", _clusterIdName);
        }
        return _clusterIdName;
    }

    static void pinEPRToServer(EndpointReference endpointReference) throws EndpointReferenceCreationException {
        if (!_initialised) {
            WSATControlSet.initialise();
        }
        if (_HAEnabled) {
            if (!ServiceHelper.setAffinity(endpointReference, (HAResource)((Object)_recoveryDirector))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "makeEPRHighlyAvailable failed");
                }
                throw new EndpointReferenceCreationException("Failed to set EPR affinity");
            }
        } else {
            ServiceHelper.setAffinity(endpointReference, null);
        }
    }

    private static void putTransactionWrapper(String string, TransactionWrapper transactionWrapper) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putTransactionWrapper", new Object[]{string, transactionWrapper});
        }
        _transactionWrappers.put(string, transactionWrapper);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "putTransactionWrapper");
        }
    }

    static TransactionWrapper getTransactionWrapper(String string, String string2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransactionWrapper", new Object[]{string, string2});
        }
        TransactionWrapper transactionWrapper = null;
        if (string2 == null || string2.equals(WSATControlSet.getNonNullIdentityString())) {
            transactionWrapper = (TransactionWrapper)_transactionWrappers.get(string);
        } else {
            Hashtable hashtable = (Hashtable)_HAHashtables.get(string2);
            if (hashtable != null) {
                transactionWrapper = (TransactionWrapper)hashtable.get(string);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransactionWrapper", transactionWrapper);
        }
        return transactionWrapper;
    }

    static boolean isHAEnabled() {
        if (!_initialised) {
            WSATControlSet.initialise();
        }
        return _HAEnabled;
    }

    static String getIdentityString() {
        if (!_initialised) {
            WSATControlSet.initialise();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getIdentityString", _IdentityString);
        }
        return _IdentityString;
    }

    static String getNonNullIdentityString() {
        if (!_initialised) {
            WSATControlSet.initialise();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getNonNullIdentityString", _NonNullIdentityString);
        }
        return _NonNullIdentityString;
    }

    static UOWCoordinator getinitialUOW() {
        UOWCoordinator uOWCoordinator = (UOWCoordinator)_threadUOWCoord.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getinitialUOW", uOWCoordinator);
        }
        return uOWCoordinator;
    }

    static boolean needToRegister() {
        Boolean bl = (Boolean)_needToRegister.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "needToRegister", bl);
        }
        return bl;
    }

    public static String createContextKey(String string, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createContextKey", new Object[]{string, new Integer(n)});
        }
        if (!_isZOS) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createContextKey", string);
            }
            return string;
        }
        String string2 = string + CONTEXT_KEY_SEPARATOR + n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createContextKey", string2);
        }
        return string2;
    }

    protected static javax.xml.soap.SOAPElement getSOAPElementForObject(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry(tc, "getSOAPElementForObject", object);
        }
        javax.xml.soap.SOAPElement sOAPElement = null;
        if (object instanceof javax.xml.soap.SOAPElement) {
            sOAPElement = (javax.xml.soap.SOAPElement)object;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String string = sOAPElement.getLocalName();
                String string2 = sOAPElement.getNamespaceURI();
                String string3 = sOAPElement.getPrefix();
                Tr.info(tc, "Found SOAPElement ref param/prop  Local name:" + string + " prefix: " + string3 + " uri: " + string2, object);
            }
        } else if (object instanceof Text) {
            Text text = (Text)object;
            sOAPElement = WSATControlSet.getSOAPElementFromTextElement(text);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.error(tc, "Ref property/param was not of type text or SOAPElement", object);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSOAPElementForObject", sOAPElement);
        }
        return sOAPElement;
    }

    protected static javax.xml.soap.SOAPElement getSOAPElementFromTextElement(Text text) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSOAPElementFromTextElement", text);
        }
        javax.xml.soap.SOAPElement sOAPElement = null;
        try {
            String string = text.getLocalName();
            String string2 = text.getPrefix();
            String string3 = text.getNamespaceURI();
            if (string2 == null && string3 == null && string == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.info(tc, "Text object just contained whitespace");
                }
                sOAPElement = null;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.info(tc, "Found TextObject and converted to SOAPElement ref param/prop  Local name:" + string + " prefix: " + string2 + " uri: " + string3);
                }
                sOAPElement = string2 != null && string3 != null ? SOAPFactory.newInstance().createElement(string, string2, string3) : SOAPFactory.newInstance().createElement(string);
                sOAPElement.setValue(text.getValue());
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.Transaction.wstx.WSATControlSet", "1245", new Object[]{sOAPElement, text});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSOAPElementFromTextElement", sOAPElement);
        }
        return sOAPElement;
    }

    public static EndpointReference createEPR(URI uRI) throws NamespaceNotSupportedException, EndpointReferenceCreationException {
        EndpointReference endpointReference = WSCoorHelper.createEPR(uRI);
        return endpointReference;
    }

    static void sendInvalidState(SystemEndpointContext systemEndpointContext, EndpointReference endpointReference, String string, String string2, String string3) throws MalformedURLException, ServiceException, SOAPException, RemoteException, ReferenceParameterCreationException, NamespaceNotSupportedException, EndpointReferenceCreationException {
        WSATControlSet.sendFault(systemEndpointContext, endpointReference, null, WSTXConstants.INVALID_STATE, string, string2, string3);
    }

    public static void sendInvalidState(SystemEndpointContext systemEndpointContext, EndpointReference endpointReference, String string, String string2) throws MalformedURLException, ServiceException, SOAPException, RemoteException, ReferenceParameterCreationException, NamespaceNotSupportedException, EndpointReferenceCreationException {
        WSATControlSet.sendFault(systemEndpointContext, endpointReference, null, WSTXConstants.INVALID_STATE, string, string2, null);
    }

    static void sendInvalidProtocol(SystemEndpointContext systemEndpointContext, EndpointReference endpointReference, String string, String string2) throws MalformedURLException, ServiceException, SOAPException, RemoteException, ReferenceParameterCreationException, NamespaceNotSupportedException, EndpointReferenceCreationException {
        WSATControlSet.sendFault(systemEndpointContext, endpointReference, null, WSTXConstants.INVALID_PROTOCOL, string, string2, null);
    }

    public static void sendInconsistentInternalState(SystemEndpointContext systemEndpointContext, EndpointReference endpointReference, String string, String string2) throws MalformedURLException, ServiceException, SOAPException, RemoteException, ReferenceParameterCreationException, NamespaceNotSupportedException, EndpointReferenceCreationException {
        WSATControlSet.sendFault(systemEndpointContext, endpointReference, WSAT_FAULT_ACTION, WSTXConstants.INCONSISTENT_INTERNAL_STATE, string, string2, null);
    }

    private static void sendFault(SystemEndpointContext systemEndpointContext, EndpointReference endpointReference, AttributedURI attributedURI, Name name2, String string, String string2, String string3) throws ReferenceParameterCreationException, MalformedURLException, ServiceException, SOAPException, RemoteException, NamespaceNotSupportedException, EndpointReferenceCreationException {
        WSATFaultPortSoapBindingStub wSATFaultPortSoapBindingStub;
        EndpointReference endpointReference2;
        MessageContext messageContext;
        EndpointReference endpointReference3;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendFault", new Object[]{systemEndpointContext, endpointReference, attributedURI, name2, string, string2, string3});
        }
        if ((endpointReference3 = (EndpointReference)(messageContext = systemEndpointContext.getMessageContext()).getProperty("com.ibm.wsspi.wsaddressing.inbound.FaultToEPR")) == null) {
            endpointReference3 = endpointReference;
        }
        if (endpointReference3 == null) {
            endpointReference3 = (EndpointReference)messageContext.getProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR");
        }
        if (endpointReference3 != null) {
            endpointReference2 = WSATControlSet.createEPR(WSATServices.getWSATParticipantURI());
            endpointReference2.setReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME, string);
            endpointReference2.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, string2);
            WSATControlSet.pinEPRToServer(endpointReference2);
            ProtocolSecurityHelper.makeEPRSecure(endpointReference3.getAddress().getURI().getHost(), endpointReference2);
            if (_isZOS && string3 != null) {
                endpointReference2.setReferenceParameter(WSTXConstants.BRANCH_ELEMENT_QNAME, string3);
            }
            WSATFaultPort wSATFaultPort = WSATServices.getWSATFaultService().getWSATFaultPort(new URL(endpointReference3.getAddress().getURI().toString()));
            wSATFaultPortSoapBindingStub = (WSATFaultPortSoapBindingStub)wSATFaultPort;
            if (attributedURI != null) {
                wSATFaultPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.action", attributedURI);
            }
        } else {
            MalformedURLException malformedURLException = new MalformedURLException("Null FaultTo EPR");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "sendFault", malformedURLException);
            }
            throw malformedURLException;
        }
        wSATFaultPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.fromEPR", endpointReference2);
        wSATFaultPortSoapBindingStub._setProperty("com.ibm.websphere.wsaddressing.destinationEPR", endpointReference3);
        wSATFaultPortSoapBindingStub._setProperty("com.ibm.ws.wsaddressing.UCFCallback.disable", "true");
        SOAPFault sOAPFault = WSATControlSet.getSOAPFactory(systemEndpointContext).createSOAPFault();
        sOAPFault.setFaultCode(name2);
        wSATFaultPortSoapBindingStub.fault(sOAPFault);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendFault");
        }
    }

    private static SOAPFactory getSOAPFactory(SystemEndpointContext systemEndpointContext) throws SOAPException {
        SOAPFactory sOAPFactory;
        Serializable serializable;
        com.ibm.ws.webservices.engine.MessageContext messageContext;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSOAPFactory", systemEndpointContext);
        }
        if ((messageContext = (com.ibm.ws.webservices.engine.MessageContext)systemEndpointContext.getMessageContext()) != null && (serializable = (SOAPElement)messageContext.getMessage().getSOAPHeader()) != null && (sOAPFactory = ((SOAPElement)serializable).getSOAPFactory()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getSOAPFactory", sOAPFactory);
            }
            return sOAPFactory;
        }
        serializable = new SOAPFactory();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSOAPFactory", serializable);
        }
        return serializable;
    }

    public static boolean isDeferredRegistrationEnabled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isDeferredRegistrationEnabled", _deferredRegistrationEnabled);
        }
        return _deferredRegistrationEnabled;
    }

    public static void disableDeferredRegistration() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "disableDeferredRegistration");
        }
        _deferredRegistrationEnabled = false;
    }

    static void received_WSAT_request(byte[] byArray, byte[] byArray2) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "received_WSAT_request", new Object[]{byArray, byArray2});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "XID", byArray);
            }
        }
        if (_TMSet.getUOWCoord() != null) {
            SystemException systemException = new SystemException("Transaction already on thread");
            if (TraceComponent.isAnyTracingEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "uowCurrent", _TMSet.getUOWCoord());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "received_WSAT_request", (Object)systemException);
                }
            }
            throw systemException;
        }
        if (byArray2 == null) {
            SystemException systemException = new SystemException("No coordination context for WSAT transaction");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "received_WSAT_request", (Object)systemException);
            }
            throw systemException;
        }
        XidImpl xidImpl = new XidImpl(byArray);
        TransactionImpl transactionImpl = TransactionImpl.findInPrimaryKeyMap(xidImpl.getPrimaryKey());
        if (transactionImpl == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Received first method in this tx", xidImpl);
            }
            CoordinationContext coordinationContext = WSATHandlerHelper.fromLogData(byArray2);
            try {
                WSATControlSet.establishCoordinationContext(coordinationContext, byArray, xidImpl.getBqualBranchIndex());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.Transaction.wstx.WSATControlSet.received_WSAT_request", "1473");
                SystemException systemException = new SystemException();
                systemException.initCause((Throwable)exception);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "received_WSAT_request", (Object)systemException);
                }
                throw systemException;
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Received subsequent method in this tx and no tran on thread", xidImpl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "received_WSAT_request");
        }
    }

    private static void importTran(TransactionImpl transactionImpl) throws InvalidTransactionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "importTran", transactionImpl);
        }
        WSATControlSet.setImportedTran(transactionImpl);
        transactionImpl.addAssociation();
        _TMSet.resume(transactionImpl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "importTran");
        }
    }

    private static TransactionImpl unImportTran() throws InvalidTransactionException {
        TransactionImpl transactionImpl;
        block7: {
            Transaction transaction;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "unImportTran");
            }
            if ((transactionImpl = WSATControlSet.getImportedTran()) != null && !transactionImpl.equals(transaction = _TMSet.suspend())) {
                InvalidTransactionException invalidTransactionException = new InvalidTransactionException();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "unImportTran", (Object)invalidTransactionException);
                }
                throw invalidTransactionException;
            }
            WSATControlSet.setImportedTran(null);
            if (transactionImpl != null) {
                transactionImpl.removeAssociation();
                try {
                    transactionImpl.decrementWSATCount();
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.Transaction.wstx.WSATControlSet.unImportTran", "936");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                    Tr.event(tc, "cleanupThreadContext Exception caught trying to decrementWSATCount: ", exception);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unImportTran", transactionImpl);
        }
        return transactionImpl;
    }

    static void setImportedTran(TransactionImpl transactionImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setImportedTran", transactionImpl);
        }
        _threadImportedTran.set(transactionImpl);
    }

    private static TransactionImpl getImportedTran() {
        Object object = _threadImportedTran.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getImportedTran", object);
        }
        return (TransactionImpl)object;
    }

    public static long convertExpires(String string) {
        long l;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "convertExpires", string);
            }
            l = 0L;
            if (string != null) {
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "convertExpires", "NumberFormatException: " + string);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "convertExpires", new Long(l));
        }
        return l;
    }

    static {
        _deferredRegistrationEnabled = true;
        _heuristicsSupported = false;
        WSAT_FAULT_ACTION = WSAddressingFactory.createAttributedURI(URI.create("http://schemas.xmlsoap.org/ws/2004/10/wsat/fault"));
    }
}

