/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATFaultPort;
import com.ibm.ws.Transaction.wstx.WSATPortSoapBindingBase;
import com.ibm.ws.Transaction.wstx.WSTXConstants;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.wscoor.ProtocolSecurityHelper;
import com.ibm.ws390.tx.WSATCRControlSet;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class WSATFaultPortSoapBindingImpl
extends WSATPortSoapBindingBase
implements WSATFaultPort {
    private static final TraceComponent tc = Tr.register(WSATFaultPortSoapBindingImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final boolean _isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();

    public void fault(SOAPElement sOAPElement) throws RemoteException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fault", sOAPElement);
        }
        MessageContext messageContext = this._context.getMessageContext();
        EndpointReference endpointReference = (EndpointReference)messageContext.getProperty("com.ibm.wsspi.wsaddressing.inbound.FromEPR");
        ProtocolSecurityHelper.checkAuthorization(endpointReference);
        HashMap hashMap = null;
        try {
            hashMap = WSATControlSet.getSOAPHeaderElements(this._context);
        }
        catch (SOAPException sOAPException) {
            RemoteException remoteException = new RemoteException(null, sOAPException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fault", remoteException);
            }
            throw remoteException;
        }
        String string = (String)hashMap.get(WSTXConstants.TXID_ELEMENT_NAME);
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Identifier in fault is " + string);
        }
        String string2 = (String)hashMap.get(WSTXConstants.BRANCH_ELEMENT_NAME);
        boolean bl = true;
        if (_isZOS) {
            if (string == null || !WSATCRControlSet.instance().setFault(string, string2)) {
                bl = false;
            }
        } else if (string == null || (object = WSATControlSet.getTransactionForID(string)) == null) {
            bl = false;
        } else {
            switch (((TransactionImpl)object).getStatus()) {
                case 0: 
                case 7: {
                    ((TransactionImpl)object).setRollbackOnly();
                    break;
                }
                default: {
                    ((TransactionImpl)object).fault();
                }
            }
        }
        if (!bl) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Invalid ID received in fault", string);
            }
            object = new RemoteException();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fault", object);
            }
            throw object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fault");
        }
    }
}

