/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.wstx.CoordinatorPortSoapBindingStub;
import com.ibm.ws.Transaction.wstx.CoordinatorPortType;
import com.ibm.ws.Transaction.wstx.NotificationImpl;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATServices;
import com.ibm.ws.Transaction.wstx.WSTXConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wscoor.ProtocolSecurityHelper;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import javax.transaction.SystemException;
import org.omg.CosTransactions.Status;

public final class WSATRecoveryCoordinator
implements Serializable {
    private static final long serialVersionUID = 5500037426315245114L;
    private static final transient TraceComponent tc = Tr.register(WSATRecoveryCoordinator.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private EndpointReference _superiorCoordinatorEPR;
    private final String _identifier;
    private final EndpointReference _participantEPR;
    private final transient boolean _deferRegistration;
    private transient boolean _registerSent;

    public static WSATRecoveryCoordinator fromLogData(byte[] byArray) throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "fromLogData", byArray);
        }
        WSATRecoveryCoordinator wSATRecoveryCoordinator = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            wSATRecoveryCoordinator = (WSATRecoveryCoordinator)object;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.wstx.WSATRecoveryCoordinator.fromLogData", "67");
            Throwable throwable2 = new SystemException().initCause(throwable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "fromLogData", throwable2);
            }
            throw (SystemException)throwable2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "fromLogData", wSATRecoveryCoordinator);
        }
        return wSATRecoveryCoordinator;
    }

    public WSATRecoveryCoordinator(String string, EndpointReference endpointReference, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "WSATRecoveryCoordinator", new Object[]{string, endpointReference});
        }
        this._identifier = string;
        this._participantEPR = endpointReference;
        this._deferRegistration = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "WSATRecoveryCoordinator", this);
        }
    }

    public String getIdentifier() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getIdentifier", this._identifier);
        }
        return this._identifier;
    }

    public byte[] toLogData() throws SystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "toLogData", this);
        }
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.wstx.WSATRecoveryCoordinator.toLogData", "118", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Exception caught in toLogData " + exception);
            }
            Throwable throwable = new SystemException().initCause((Throwable)exception);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "toLogData", throwable);
            }
            throw (SystemException)throwable;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "toLogData", byArray);
            }
        }
        return byArray;
    }

    private CoordinatorPortType coord() {
        CoordinatorPortSoapBindingStub coordinatorPortSoapBindingStub;
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "coord", this);
            }
            coordinatorPortSoapBindingStub = null;
            try {
                EndpointReference endpointReference = WSATControlSet.createEPR(WSATServices.getWSATFaultURI());
                ServiceHelper.setAffinity(endpointReference, null);
                endpointReference.setReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME, this._identifier);
                endpointReference.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, this._identifier);
                ProtocolSecurityHelper.makeEPRSecure(this._participantEPR.getAddress().getURI().getHost(), this._participantEPR);
                coordinatorPortSoapBindingStub = (CoordinatorPortSoapBindingStub)WSATServices.getWSATService().getCoordinator(new URL(this._superiorCoordinatorEPR.getAddress().getURI().toString()));
                coordinatorPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.fromEPR", this._participantEPR);
                coordinatorPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.replyToEPR", this._participantEPR);
                coordinatorPortSoapBindingStub._setProperty("com.ibm.wsspi.wsaddressing.faultToEPR", endpointReference);
                coordinatorPortSoapBindingStub._setProperty("com.ibm.websphere.wsaddressing.destinationEPR", this._superiorCoordinatorEPR);
                coordinatorPortSoapBindingStub._setProperty("com.ibm.ws.wsaddressing.UCFCallback.disable", "true");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.wstx.WSATRecoveryCoordinator.coord", "202", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "coord", exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "coord", coordinatorPortSoapBindingStub);
        }
        return coordinatorPortSoapBindingStub;
    }

    public Status replay_completion() {
        Status status;
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "replay_completion", this);
            }
            status = Status.StatusUnknown;
            try {
                this.coord().replayOperation(NotificationImpl.anInstance());
            }
            catch (RemoteException remoteException) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.Transaction.wstx.WSATRecoveryCoordinator.replay_completion", "225", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "replay_completion", remoteException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "replay_completion", status);
        }
        return status;
    }

    public void resendPrepared() {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "resendPrepared", this);
            }
            try {
                this.coord().preparedOperation(NotificationImpl.anInstance());
            }
            catch (RemoteException remoteException) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.Transaction.wstx.WSATRecoveryCoordinator.resendPrepared", "239", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "resendPrepared", remoteException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resendPrepared");
        }
    }

    EndpointReference getParticipantEPR() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getParticipantEPR", this._participantEPR);
        }
        return this._participantEPR;
    }

    public void setSuperiorCoordinatorEPR(EndpointReference endpointReference) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setSuperiorCoordinatorEPR", new Object[]{endpointReference, this});
        }
        if (this._superiorCoordinatorEPR == null) {
            this._superiorCoordinatorEPR = endpointReference;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setSuperiorCoordinatorEPR", this._superiorCoordinatorEPR);
        }
    }

    EndpointReference getSuperiorCoordinator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getSuperiorCoordinator", this._superiorCoordinatorEPR);
        }
        return this._superiorCoordinatorEPR;
    }

    boolean isDeferRegistration() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isDeferRegistration", new Boolean(this._deferRegistration));
        }
        return this._deferRegistration;
    }

    public boolean isRegisterSent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isRegisterSent", new Boolean(this._registerSent));
        }
        return this._registerSent;
    }

    public void setRegisterSent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setRegisterSent");
        }
        this._registerSent = true;
    }
}

