/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.wstx.JTAAsyncResponseHelper;
import com.ibm.ws.Transaction.wstx.WSATAsyncResource;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATCoordinatorPortDistImpl;
import com.ibm.ws.Transaction.wstx.WSATHandlerHelper;
import com.ibm.ws.Transaction.wstx.WSATParticipantWrapper;
import com.ibm.ws.Transaction.wstx.WSATServices;
import com.ibm.ws.Transaction.wstx.WSTXConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.EnvironmentType;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.ws.wscoor.WSCoorHelper;
import com.ibm.wsspi.webservices.rpc.handler.GenericHandler;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.EndpointReferenceManager;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Node;

public class WSATSOAPClientHandler
extends GenericHandler {
    private static final TraceComponent tc = Tr.register(WSATSOAPClientHandler.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int envType;
    private static final Integer nonPersistentDeliveryMode;
    private static WSThreadLocal _txEstablishedBySystemContextHandler;
    private static final boolean _isZOS;
    public static final Object NO_TX_ESTABLISHED;
    public static URI _coordinatorURI;
    public static final boolean _disabled;
    private static final String DEFERRED_REGISTRATION_ELEMENT_LOCALNAME;

    public boolean handleRequest(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest", new Object[]{messageContext, this});
        }
        if (_disabled) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handleRequest", Boolean.TRUE);
            }
            return true;
        }
        WSATControlSet.clearTransactionAssociation();
        if (envType == 0 && WSATHandlerHelper.isSendWSAT()) {
            Object object;
            Object object2 = WSATSOAPClientHandler.getTxEstablishedBySystemContextHandler();
            if (object2 != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "SystemContextHandler driven prior to global handler");
                }
                if (object2 instanceof TransactionImpl) {
                    object = (TransactionImpl)object2;
                    if (!((TransactionImpl)object).equals(TranManagerSet.instance().getTransactionImpl())) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Tx established by SystemContextHandler is no longer on the thread");
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "handleRequest", "JAXRPCException");
                        }
                        throw new JAXRPCException();
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "SystemContextHandler was invoked and did not import a transaction.");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleRequest", Boolean.TRUE);
                    }
                    return true;
                }
            }
            try {
                object = WSATControlSet.getCoordinationContextForCurrentTx(null, WSATControlSet.isDeferredRegistrationEnabled());
                if (object != null) {
                    com.ibm.ws.webservices.engine.MessageContext messageContext2 = (com.ibm.ws.webservices.engine.MessageContext)messageContext;
                    if (messageContext2.isOneWay()) {
                        throw new JAXRPCException("Can't add coordination context to one way message");
                    }
                    if (ServiceHelper.getInitFailed()) {
                        throw new JAXRPCException("WSAT Initialisation has failed, cannot process request");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding CoordinationContext to SOAPHeader");
                    }
                    ((CoordinationContext)object).insertIntoSOAPHeader(messageContext2);
                    HashMap hashMap = new HashMap();
                    WSCoorHelper.addAffinityToMap(((CoordinationContext)object).getIdentifier().toString(), hashMap);
                    WSCoorHelper.setWLMContextMap(messageContext2, hashMap);
                    messageContext.setProperty("deliveryMode", (Object)nonPersistentDeliveryMode);
                    WSATControlSet.suspendCurrentTransactionAssociation();
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No CoordinationContext found");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.wstx.WSATSOAPClientHandler.handleRequest", "105", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "WSATSOAPClientHandler", exception);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleRequest", "JAXRPCException");
                }
                throw new JAXRPCException((Throwable)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest", Boolean.TRUE);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleResponse", new Object[]{messageContext, this});
        }
        if (_disabled) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handleResponse", Boolean.TRUE);
            }
            return true;
        }
        TransactionImpl transactionImpl = WSATControlSet.resumeSuspendedTransactionAssociation();
        if (transactionImpl == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handleResponse", Boolean.TRUE);
            }
            return true;
        }
        this.processResponse(messageContext, transactionImpl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResponse", Boolean.TRUE);
        }
        return true;
    }

    private void processResponse(MessageContext messageContext, TransactionImpl transactionImpl) {
        SOAPHeader sOAPHeader;
        SOAPEnvelope sOAPEnvelope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processResponse", new Object[]{messageContext, transactionImpl});
        }
        SOAPMessage sOAPMessage = ((com.ibm.ws.webservices.engine.MessageContext)messageContext).getMessage();
        SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
        try {
            sOAPEnvelope = sOAPPart.getEnvelope();
            sOAPHeader = sOAPEnvelope.getHeader();
        }
        catch (SOAPException sOAPException) {
            JAXRPCException jAXRPCException = new JAXRPCException((Throwable)sOAPException);
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.Transaction.wstx.WSATSOAPClientHandler.processResponse", "275", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "processResponse", (Object)jAXRPCException);
            }
            throw jAXRPCException;
        }
        if (sOAPHeader == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "processResponse");
            }
            return;
        }
        try {
            Object object;
            Object object2;
            sOAPEnvelope = null;
            Iterator iterator = sOAPHeader.getChildElements();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (!(object2 instanceof SOAPHeaderElement) || !DEFERRED_REGISTRATION_ELEMENT_LOCALNAME.equals((object = (SOAPHeaderElement)object2).getLocalName())) continue;
                sOAPEnvelope = object;
                break;
            }
            if (sOAPEnvelope == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "processResponse");
                }
                return;
            }
            object2 = null;
            try {
                object2 = EndpointReferenceManager.createEndpointReference((SOAPElement)sOAPEnvelope);
            }
            catch (EndpointReferenceCreationException endpointReferenceCreationException) {
                JAXRPCException jAXRPCException = new JAXRPCException((Throwable)endpointReferenceCreationException);
                throw jAXRPCException;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "participantEPR", object2);
            }
            sOAPHeader.removeChild((Node)sOAPEnvelope);
            object = object2.getReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME);
            if (object == null) {
                JAXRPCException jAXRPCException = new JAXRPCException();
                throw jAXRPCException;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "txID", object);
            }
            EndpointReference endpointReference = WSATControlSet.createEPR(_coordinatorURI);
            endpointReference.setReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME, (String)object);
            endpointReference.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, object2.getAddress().getURI().toString());
            String string = null;
            if (_isZOS) {
                string = "" + transactionImpl.getXidImpl().getBqualBranchIndex();
                endpointReference.setReferenceParameter(WSTXConstants.BRANCH_ELEMENT_QNAME, string);
            }
            WSATControlSet.pinEPRToServer(endpointReference);
            WSATAsyncResource wSATAsyncResource = new WSATAsyncResource((EndpointReference)object2, endpointReference, (String)object, string);
            WSATParticipantWrapper wSATParticipantWrapper = new WSATParticipantWrapper(wSATAsyncResource);
            transactionImpl.enlistAsyncResource(wSATParticipantWrapper);
            if (!_isZOS) {
                JTAAsyncResponseHelper jTAAsyncResponseHelper = WSATCoordinatorPortDistImpl.getJTAAsyncResponseHelper();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "AsyncResponseHelper", jTAAsyncResponseHelper);
                }
                jTAAsyncResponseHelper.addResponseTarget(wSATParticipantWrapper);
            }
        }
        catch (JAXRPCException jAXRPCException) {
            FFDCFilter.processException((Throwable)jAXRPCException, "com.ibm.ws.Transaction.wstx.WSATSOAPClientHandler.processResponse", "355", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "processResponse", (Object)jAXRPCException);
            }
            throw jAXRPCException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.wstx.WSATSOAPClientHandler.processResponse", "359", this);
            JAXRPCException jAXRPCException = new JAXRPCException((Throwable)exception);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "processResponse", (Object)jAXRPCException);
            }
            throw jAXRPCException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processResponse");
        }
    }

    public boolean handleFault(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault", new Object[]{messageContext, this});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            WSATHandlerHelper.traceFault(messageContext);
        }
        this.handleResponse(messageContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleFault", Boolean.TRUE);
        }
        return true;
    }

    public void handleClosure(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "handleClosure", messageContext);
        }
    }

    protected static void setTxEstablishedBySystemContextHandler(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setTxEstablishedBySystemContextHandler", object);
        }
        _txEstablishedBySystemContextHandler.set(object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setTxEstablishedBySystemContextHandler");
        }
    }

    protected static Object getTxEstablishedBySystemContextHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTxEstablishedBySystemContextHandler");
        }
        Object object = _txEstablishedBySystemContextHandler.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTxEstablishedBySystemContextHandler", object);
        }
        return object;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<clinit>");
        }
        envType = EnvironmentType.getEnvironmentType();
        nonPersistentDeliveryMode = new Integer(1);
        _txEstablishedBySystemContextHandler = new WSThreadLocal();
        _isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
        NO_TX_ESTABLISHED = new Object();
        if (envType == 0) {
            _coordinatorURI = WSATServices.getWSATCoordinatorURI();
        }
        _disabled = Boolean.valueOf(System.getProperty("com.ibm.ws.wsaddressingAndDependentsDisabled"));
        DEFERRED_REGISTRATION_ELEMENT_LOCALNAME = WSTXConstants.PARTICIPANT_REGISTRATION_ELEMENT_NAME.getLocalName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<clinit>", _disabled);
        }
    }
}

