/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATHandlerHelper;
import com.ibm.ws.Transaction.wstx.WSATRecoveryCoordinator;
import com.ibm.ws.Transaction.wstx.WSTXConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.ws390.tx.TransactionManagerMessage;
import com.ibm.ws390.tx.WSATJMSSystemContextHandler;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.webservices.rpc.handler.GenericHandler;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.InvalidTransactionException;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public final class WSATSOAPServerHandler
extends GenericHandler {
    private static final TraceComponent tc = Tr.register(WSATSOAPServerHandler.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final boolean isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    public static final boolean _disabled = Boolean.valueOf(System.getProperty("com.ibm.ws.wsaddressingAndDependentsDisabled"));

    public boolean handleRequest(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest", new Object[]{messageContext, _disabled});
        }
        if (_disabled) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handleRequest", Boolean.TRUE);
            }
            return true;
        }
        try {
            WSATControlSet.setImportedTran(null);
            CoordinationContext coordinationContext = WSATHandlerHelper.getCoordinationContext((SOAPMessageContext)messageContext);
            if (coordinationContext != null) {
                int n = 0;
                if (isZOS) {
                    Object object;
                    String string = null;
                    if (messageContext instanceof RPCContext) {
                        object = (RPCContext)messageContext;
                        string = object.getTransportName();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Request from transport " + string);
                        }
                    }
                    if ("http".equals(string)) {
                        Object object2;
                        Object object3;
                        object = null;
                        if ("http".equals(string) && (object = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)) == null) {
                            throw new JAXRPCException("No servlet request with xid data, cannot process request");
                        }
                        String string2 = object.getHeader(HttpConstants.HDR_ZOS_TRAN_XID.getName());
                        if (string2 != null) {
                            object3 = new TransactionManagerMessage(Util.byteArray(string2));
                            object2 = ((TransactionManagerMessage)object3).getXid();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got transaction xid from message context", object2);
                            }
                        } else {
                            throw new JAXRPCException("No xid data in servlet request, cannot process request");
                        }
                        n = ((XidImpl)object2).getBqualBranchIndex();
                        object3 = TranManagerSet.instance();
                        object2 = ((TranManagerSet)object3).getTransactionImpl();
                        if (object2 != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got transaction on thread", object2);
                            }
                            throw new JAXRPCException("Transaction already on thread");
                        }
                    } else if ("jms".equals(string)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got messsage from JMS so need xid from sys ctx handler");
                        }
                        if ((n = WSATJMSSystemContextHandler.getBranchIndex()) < 0) {
                            throw new JAXRPCException("No xid data in jms system context, cannot process request");
                        }
                        object = TranManagerSet.instance();
                        TransactionImpl transactionImpl = ((TranManagerSet)object).getTransactionImpl();
                        if (transactionImpl != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got transaction on thread", transactionImpl);
                            }
                            throw new JAXRPCException("Transaction already on thread");
                        }
                    }
                }
                if (WSATHandlerHelper.isSupportsWSAT(messageContext)) {
                    if (ServiceHelper.getInitFailed()) {
                        throw new JAXRPCException("WSAT Initialisation has failed, cannot process request");
                    }
                    WSATControlSet.establishCoordinationContext(coordinationContext, null, n);
                }
            }
        }
        catch (JAXRPCException jAXRPCException) {
            FFDCFilter.processException((Throwable)jAXRPCException, "com.ibm.ws.Transaction.wstx.WSATSOAPServerHandler.handleRequest", "83", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handleRequest", (Object)jAXRPCException);
            }
            throw jAXRPCException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.wstx.WSATSOAPServerHandler.handleRequest", "78", this);
            JAXRPCException jAXRPCException = new JAXRPCException(throwable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handleRequest", (Object)jAXRPCException);
            }
            throw jAXRPCException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest", Boolean.TRUE);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleResponse", messageContext);
        }
        if (_disabled) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handleResponse", Boolean.TRUE);
            }
            return true;
        }
        if (isZOS || WSATHandlerHelper.isSupportsWSAT(messageContext)) {
            UOWCoordinator uOWCoordinator = WSATControlSet.getinitialUOW();
            if (uOWCoordinator != null && uOWCoordinator.isGlobal()) {
                TranManagerSet tranManagerSet;
                TransactionImpl transactionImpl;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got the global tran ctx stored earlier; proceeding with local invocation handler behaviour");
                }
                if ((transactionImpl = (tranManagerSet = TranManagerSet.instance()).getTransactionImpl()) != null) {
                    transactionImpl.suspendAssociation();
                }
            } else {
                TransactionImpl transactionImpl;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got the local tran ctx stored earlier; proceeding with remote invocation handler behaviour");
                }
                try {
                    transactionImpl = WSATControlSet.cleanupThreadContext();
                }
                catch (InvalidTransactionException invalidTransactionException) {
                    JAXRPCException jAXRPCException = new JAXRPCException("No WSATRecoveryCoordinator");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleResponse", (Object)jAXRPCException);
                    }
                    throw jAXRPCException;
                }
                if (transactionImpl == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleResponse", "No transaction returned from cleanupThreadContext()");
                    }
                    return true;
                }
                WSATRecoveryCoordinator wSATRecoveryCoordinator = transactionImpl.getWSATRecoveryCoordinator();
                if (wSATRecoveryCoordinator == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleResponse", "No WSATRecoveryCoordinator as the transaction was not imported");
                    }
                    return true;
                }
                boolean bl = wSATRecoveryCoordinator.isDeferRegistration();
                if (!bl && !isZOS) {
                    int n = Configuration.getAsyncResponseTimeout() / 1000;
                    while (wSATRecoveryCoordinator.getSuperiorCoordinator() == null && n-- > 0) {
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Waiting for register response");
                            }
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Sleep was interrupted", interruptedException);
                        }
                    }
                }
                if (transactionImpl.getWSATRecoveryCoordinator().isRegisterSent()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleResponse", "Already sent registration EPR");
                    }
                    return true;
                }
                if (!bl) {
                    if (!isZOS && wSATRecoveryCoordinator.getSuperiorCoordinator() == null) {
                        JAXRPCException jAXRPCException = new JAXRPCException("No WSATRecoveryCoordinator");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "handleResponse", (Object)jAXRPCException);
                        }
                        throw jAXRPCException;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleResponse", "Got superior coordinator on another thread");
                    }
                    return true;
                }
                if (WSATControlSet.needToRegister()) {
                    EndpointReference endpointReference = wSATRecoveryCoordinator.getParticipantEPR();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "participantEPR", endpointReference);
                    }
                    SOAPMessage sOAPMessage = ((SOAPMessageContext)messageContext).getMessage();
                    SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
                    try {
                        SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
                        sOAPEnvelope.addNamespaceDeclaration("wscoor", "http://schemas.xmlsoap.org/ws/2004/10/wscoor");
                        SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
                        if (sOAPHeader == null) {
                            sOAPHeader = sOAPEnvelope.addHeader();
                        }
                        SOAPHeaderElement sOAPHeaderElement = sOAPHeader.addHeaderElement(WSTXConstants.PARTICIPANT_REGISTRATION_ELEMENT_NAME);
                        endpointReference.getSOAPElement((SOAPElement)sOAPHeaderElement);
                    }
                    catch (SOAPException sOAPException) {
                        FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.Transaction.wstx.WSATSOAPServerHandler.handleResponse", "249", this);
                        JAXRPCException jAXRPCException = new JAXRPCException((Throwable)sOAPException);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "handleResponse", (Object)jAXRPCException);
                        }
                        throw jAXRPCException;
                    }
                    transactionImpl.getWSATRecoveryCoordinator().setRegisterSent();
                } else {
                    Tr.debug(tc, "No need to register");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResponse", Boolean.TRUE);
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault", new Object[]{messageContext, this});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            WSATHandlerHelper.traceFault(messageContext);
        }
        boolean bl = this.handleResponse(messageContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleFault", bl);
        }
        return bl;
    }

    public void handleClosure(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "handleClosure", messageContext);
        }
    }
}

