/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.wstx.RegisterOperationHandlerImpl;
import com.ibm.ws.Transaction.wstx.WSATFaultService;
import com.ibm.ws.Transaction.wstx.WSATService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.wscoor.RegistrationCoordinatorSoapBindingImpl;
import com.ibm.ws.wscoor.ServiceHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedAction;
import javax.transaction.SystemException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;

public final class WSATServices {
    private static final TraceComponent tc;
    private static WSATService _wsatService;
    private static WSATFaultService _wsatFaultService;
    private static URI _WSATParticipantURI;
    private static URI _WSATCoordinatorURI;
    private static URI _WSATFaultURI;
    private static boolean _initialized;
    static /* synthetic */ Class class$com$ibm$ws$Transaction$wstx$WSATService;
    static /* synthetic */ Class class$com$ibm$ws$Transaction$wstx$WSATFaultService;

    static WSATService getWSATService() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getWSATService", _wsatService);
        }
        return _wsatService;
    }

    static WSATFaultService getWSATFaultService() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getWSATFaultService", _wsatFaultService);
        }
        return _wsatFaultService;
    }

    public static URI getWSATCoordinatorURI() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSATCoordinatorURI");
        }
        if (!_initialized) {
            WSATServices.initialize();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSATCoordinatorURI", _WSATCoordinatorURI);
        }
        return _WSATCoordinatorURI;
    }

    public static URI getWSATParticipantURI() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSATParticipantURI");
        }
        if (!_initialized) {
            WSATServices.initialize();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSATParticipantURI", _WSATParticipantURI);
        }
        return _WSATParticipantURI;
    }

    static URI getWSATFaultURI() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSATFaultURI");
        }
        if (!_initialized) {
            WSATServices.initialize();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSATFaultURI", _WSATFaultURI);
        }
        return _WSATFaultURI;
    }

    private static synchronized void initialize() {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize");
            }
            if (_initialized) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initialize", "Already initialized");
                }
                return;
            }
            try {
                _WSATCoordinatorURI = ServiceHelper.getAddressedURI(_wsatService.getCoordinatorAddress());
                _WSATParticipantURI = ServiceHelper.getAddressedURI(_wsatService.getParticipantAddress());
                _WSATFaultURI = ServiceHelper.getAddressedURI(_wsatFaultService.getWSATFaultPortAddress());
                _initialized = true;
            }
            catch (SystemException systemException) {
                FFDCFilter.processException(systemException, "com.ibm.ws.Transaction.wstx.WSATServices.initialize", "120");
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "initialize", (Object)systemException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", new Object[]{_WSATCoordinatorURI, _WSATParticipantURI, _WSATFaultURI});
        }
    }

    static {
        block4: {
            tc = Tr.register(WSATServices.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<clinit>");
            }
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    block4: {
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "run", this);
                        }
                        try {
                            ServiceFactory serviceFactory = ServiceFactory.newInstance();
                            ((com.ibm.wsspi.webservices.rpc.ServiceFactory)serviceFactory).useGlobalHandlers("SYSTEM_ENGINE");
                            _wsatService = (WSATService)serviceFactory.loadService(class$com$ibm$ws$Transaction$wstx$WSATService == null ? (class$com$ibm$ws$Transaction$wstx$WSATService = WSATServices.class$("com.ibm.ws.Transaction.wstx.WSATService")) : class$com$ibm$ws$Transaction$wstx$WSATService);
                            _wsatFaultService = (WSATFaultService)serviceFactory.loadService(class$com$ibm$ws$Transaction$wstx$WSATFaultService == null ? (class$com$ibm$ws$Transaction$wstx$WSATFaultService = WSATServices.class$("com.ibm.ws.Transaction.wstx.WSATFaultService")) : class$com$ibm$ws$Transaction$wstx$WSATFaultService);
                        }
                        catch (ServiceException serviceException) {
                            FFDCFilter.processException((Throwable)serviceException, "com.ibm.ws.Transaction.wstx.WSATServices.run", "81", this);
                            if (!tc.isEventEnabled()) break block4;
                            Tr.event(tc, "ERROR loading WSCOOR/WSAT Services", (Object)serviceException);
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "run", null);
                    }
                    return null;
                }
            });
            try {
                RegisterOperationHandlerImpl registerOperationHandlerImpl = new RegisterOperationHandlerImpl();
                RegistrationCoordinatorSoapBindingImpl.addRegisterOperationHandler(new URI("http://schemas.xmlsoap.org/ws/2004/10/wsat/Durable2PC"), registerOperationHandlerImpl);
                RegistrationCoordinatorSoapBindingImpl.addRegisterOperationHandler(new URI("http://schemas.xmlsoap.org/ws/2004/10/wsat/Volatile2PC"), registerOperationHandlerImpl);
                RegistrationCoordinatorSoapBindingImpl.addRegisterOperationHandler(new URI("http://schemas.xmlsoap.org/ws/2004/10/wsat/Completion"), registerOperationHandlerImpl);
            }
            catch (URISyntaxException uRISyntaxException) {
                FFDCFilter.processException(uRISyntaxException, "com.ibm.ws.Transaction.wstx.WSATServices.<clinit>", "106");
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "<clinit>", uRISyntaxException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<clinit>", new Object[]{_wsatService, _wsatFaultService});
        }
    }
}

