/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.wstx.WSATAsyncResource;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATCoordinatorPortDistImpl;
import com.ibm.ws.Transaction.wstx.WSATHandlerHelper;
import com.ibm.ws.Transaction.wstx.WSATParticipantWrapper;
import com.ibm.ws.Transaction.wstx.WSATRecoveryCoordinator;
import com.ibm.ws.Transaction.wstx.WSATSOAPClientHandler;
import com.ibm.ws.Transaction.wstx.WSATServices;
import com.ibm.ws.Transaction.wstx.WSTXConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws390.tx.WSATCRControlSet;
import com.ibm.ws390.tx.WSATJMSSystemContextHandler;
import com.ibm.wsspi.exitpoint.systemcontext.SystemContext;
import com.ibm.wsspi.exitpoint.systemcontext.SystemContextHandler;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.io.IOException;
import java.util.Map;
import javax.transaction.InvalidTransactionException;

public final class WSATSystemContextHandler
implements SystemContextHandler {
    private static final TraceComponent tc = Tr.register(WSATSystemContextHandler.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final boolean _isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    public static final String CONTEXT_KEY = "com.ibm.websphere.transaction.wstx";
    private static final String PARTICIPANT_KEY = "com.ibm.websphere.transaction.wstx.participant";

    public boolean extractContext(SystemContext systemContext, Map map) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractContext", new Object[]{systemContext, map});
        }
        try {
            map.put(CONTEXT_KEY, systemContext.getSystemContextItem(CONTEXT_KEY));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.wstx.WSATSystemContextHandler.extractContext", "80", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "extractContext", throwable);
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "extractContext", Boolean.TRUE);
        }
        return true;
    }

    public boolean establishContext(Map map) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "establishContext", map);
        }
        Object object = WSATSOAPClientHandler.NO_TX_ESTABLISHED;
        int n = 0;
        if (_isZOS) {
            try {
                n = WSATJMSSystemContextHandler.establishWSATContext(map);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws390.tx.WSATJMSSystemContextHandler.estabishContext", "189");
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception raised from establishWSATContext", exception);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "establishContext", Boolean.FALSE);
                    }
                }
                return false;
            }
        }
        if (WSATHandlerHelper.isSupportsWSAT()) {
            try {
                CoordinationContext coordinationContext = (CoordinationContext)map.get(CONTEXT_KEY);
                if (coordinationContext != null) {
                    WSATControlSet.establishCoordinationContext(coordinationContext, null, n);
                    TransactionImpl transactionImpl = TranManagerSet.instance().getTransactionImpl();
                    if (transactionImpl != null) {
                        object = transactionImpl;
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.wstx.WSATSystemContextHandler.establishContext", "116", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "establishContext", Boolean.FALSE);
                }
                return false;
            }
        }
        WSATSOAPClientHandler.setTxEstablishedBySystemContextHandler(object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "establishContext", Boolean.TRUE);
        }
        return true;
    }

    public boolean insertRequestContext(SystemContext systemContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertRequestContext", systemContext);
        }
        WSATControlSet.clearTransactionAssociation();
        if (WSATHandlerHelper.isSendWSAT()) {
            try {
                CoordinationContext coordinationContext = WSATControlSet.getCoordinationContextForCurrentTx(systemContext, WSATControlSet.isDeferredRegistrationEnabled());
                if (coordinationContext != null) {
                    systemContext.putSystemContextItem(CONTEXT_KEY, coordinationContext);
                    WSATControlSet.suspendCurrentTransactionAssociation();
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No CoordinationContext added");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.Transaction.wstx.WSATSystemContextHandler.insertRequestContext", "82", this);
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception caught inserting context into message", throwable);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "insertRequestContext", Boolean.FALSE);
                    }
                }
                return false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertRequestContext", Boolean.TRUE);
        }
        return true;
    }

    public void insertRequestContextFailed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertRequestContextFailed");
        }
        this.requestFailed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertRequestContextFailed");
        }
    }

    public void requestFailed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "requestFailed");
        }
        if (WSATHandlerHelper.isSendWSAT()) {
            WSATControlSet.resumeSuspendedTransactionAssociationMarkRollback();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "requestFailed");
        }
    }

    public void requestSucceeded(SystemContext systemContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "requestSucceeded", systemContext);
        }
        if (WSATHandlerHelper.isSendWSAT()) {
            EndpointReference endpointReference;
            block15: {
                endpointReference = null;
                try {
                    endpointReference = (EndpointReference)systemContext.getSystemContextItem(PARTICIPANT_KEY);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "participantEPR", endpointReference);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.Transaction.wstx.WSATSystemContextHandler.requestSucceeded", "146", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "requestSucceeded", illegalArgumentException);
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.Transaction.wstx.WSATSystemContextHandler.requestSucceeded", "151", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "requestSucceeded", iOException);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.Transaction.wstx.WSATSystemContextHandler.requestSucceeded", "156", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                    Tr.debug(tc, "requestSucceeded", classNotFoundException);
                }
            }
            if (endpointReference == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "requestSucceeded", "Nothing to register");
                }
                return;
            }
            TransactionImpl transactionImpl = WSATControlSet.resumeSuspendedTransactionAssociation();
            if (transactionImpl != null) {
                String string = transactionImpl.getGlobalGlobalID();
                try {
                    EndpointReference endpointReference2 = WSATControlSet.createEPR(WSATServices.getWSATCoordinatorURI());
                    endpointReference2.setReferenceParameter(WSTXConstants.TXID_ELEMENT_QNAME, string);
                    endpointReference2.setReferenceParameter(WSTXConstants.INSTANCEID_ELEMENT_QNAME, endpointReference.getAddress().getURI().toString());
                    WSATControlSet.pinEPRToServer(endpointReference2);
                    WSATAsyncResource wSATAsyncResource = new WSATAsyncResource(endpointReference, endpointReference2, string, null);
                    WSATParticipantWrapper wSATParticipantWrapper = new WSATParticipantWrapper(wSATAsyncResource);
                    transactionImpl.enlistAsyncResource(wSATParticipantWrapper);
                    WSATCoordinatorPortDistImpl.getJTAAsyncResponseHelper().addResponseTarget(wSATParticipantWrapper);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.Transaction.wstx.WSATSystemContextHandler.requestSucceeded", "199", this);
                    transactionImpl.setRollbackOnly();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "requestSucceeded");
        }
    }

    public void requestSucceeded() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "requestSucceeded");
            Tr.exit(tc, "requestSucceeded");
        }
    }

    public void establishContextFailed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "establishContextFailed");
        }
        if (WSATHandlerHelper.isSupportsWSAT()) {
            TransactionImpl transactionImpl;
            block6: {
                transactionImpl = null;
                try {
                    transactionImpl = WSATControlSet.cleanupThreadContext();
                }
                catch (InvalidTransactionException invalidTransactionException) {
                    FFDCFilter.processException((Throwable)invalidTransactionException, "com.ibm.ws.Transaction.wstx.WSATSystemContextHandler.establishContextFailed", "323", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "establishContextFailed", (Object)invalidTransactionException);
                }
            }
            if (transactionImpl != null) {
                transactionImpl.setRollbackOnly();
            }
        }
        WSATSOAPClientHandler.setTxEstablishedBySystemContextHandler(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "establishContextFailed");
        }
    }

    public void removeEstablishedContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEstablishedContext");
        }
        if (WSATHandlerHelper.isSupportsWSAT()) {
            WSATSOAPClientHandler.setTxEstablishedBySystemContextHandler(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEstablishedContext");
        }
    }

    public boolean insertResponseContext(SystemContext systemContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertResponseContext", systemContext);
        }
        if (WSATHandlerHelper.isSupportsWSAT()) {
            TransactionImpl transactionImpl;
            block19: {
                Object object = WSATSOAPClientHandler.getTxEstablishedBySystemContextHandler();
                if (!(object instanceof TransactionImpl)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "insertResponseContext", "No tx established by system context handler");
                    }
                    return true;
                }
                transactionImpl = null;
                try {
                    transactionImpl = WSATControlSet.cleanupThreadContext();
                }
                catch (InvalidTransactionException invalidTransactionException) {
                    FFDCFilter.processException((Throwable)invalidTransactionException, "com.ibm.ws.Transaction.wstx.WSATSystemContextHandler.insertResponseContext", "366", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block19;
                    Tr.debug(tc, "insertResponseContext", (Object)invalidTransactionException);
                }
            }
            if (transactionImpl == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "insertResponseContext", "No transaction returned from cleanupThreadContext()");
                }
                return true;
            }
            WSATRecoveryCoordinator wSATRecoveryCoordinator = transactionImpl.getWSATRecoveryCoordinator();
            if (wSATRecoveryCoordinator == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "insertResponseContext", "No WSATRecoveryCoordinator as the transaction was not imported");
                }
                return true;
            }
            if (transactionImpl.getWSATRecoveryCoordinator().isRegisterSent()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "insertResponseContext", "Already sent registration EPR");
                }
                return true;
            }
            if (WSATControlSet.needToRegister()) {
                EndpointReference endpointReference = wSATRecoveryCoordinator.getParticipantEPR();
                try {
                    systemContext.putSystemContextItem(PARTICIPANT_KEY, endpointReference);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.Transaction.wstx.WSATSystemContextHandler.insertResponseContext", "305", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "insertResponseContext", Boolean.FALSE);
                    }
                    return false;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.Transaction.wstx.WSATSystemContextHandler.insertResponseContext", "311", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "insertResponseContext", Boolean.FALSE);
                    }
                    return false;
                }
                transactionImpl.getWSATRecoveryCoordinator().setRegisterSent();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertResponseContext", Boolean.TRUE);
        }
        return true;
    }

    public void insertResponseContextFailed() {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertResponseContextFailed");
        }
        if (WSATHandlerHelper.isSupportsWSAT() && (object = WSATSOAPClientHandler.getTxEstablishedBySystemContextHandler()) instanceof TransactionImpl) {
            TransactionImpl transactionImpl;
            block6: {
                transactionImpl = null;
                try {
                    transactionImpl = WSATControlSet.cleanupThreadContext();
                }
                catch (InvalidTransactionException invalidTransactionException) {
                    FFDCFilter.processException((Throwable)invalidTransactionException, "com.ibm.ws.Transaction.wstx.WSATSystemContextHandler.insertResponseContextFailed", "427", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "insertResponseContextFailed", (Object)invalidTransactionException);
                }
            }
            if (transactionImpl != null) {
                transactionImpl.setRollbackOnly();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertResponseContextFailed");
        }
    }

    public boolean peekContext(Map map) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "peekContext", map);
        }
        boolean bl = false;
        if (_isZOS) {
            bl = WSATCRControlSet.instance().peekWSATContext(map);
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isDebugEnabled() && bl) {
                Tr.debug(tc, "Updated contextMap", map);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "peekContext", bl);
            }
        }
        return bl;
    }

    public void extractContextFailed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractContextFailed", this);
            Tr.exit(tc, "extractContextFailed");
        }
    }
}

