/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityTokenImpl;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.ServerUserActivityImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityManager;
import com.ibm.ws.javax.activity.ActivityToken;
import com.ibm.ws.javax.activity.GlobalId;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.javax.activity.InvalidParentContextException;
import com.ibm.ws.javax.activity.ServiceNotRegisteredException;
import com.ibm.ws.javax.activity.SystemException;

public class ActivityManagerImpl
extends ServerUserActivityImpl
implements ActivityManager {
    private static final TraceComponent tc = Tr.register(ActivityManagerImpl.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");

    protected ActivityManagerImpl() {
    }

    public ActivityToken suspend() throws SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend", this);
        }
        ActivityTokenImpl activityTokenImpl = null;
        if (!this._serviceRegistered) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No service registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspend", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup(), this._hlsInfo.getServiceName());
        if (localActivityContext != null) {
            try {
                activityTokenImpl = localActivityContext.suspend();
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.ActivityManagerImpl.suspend", "87", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "SystemException caught suspending current activity. Rethrowing.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "suspend", systemException);
                }
                throw systemException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.ActivityManagerImpl.suspend", "94", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexcepted exception caught suspending current activity. Throwing SystemException.");
                }
                Object[] objectArray = new Object[]{"suspend", "com.ibm.ws.activity.ActivityManagerImpl", exception};
                Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "suspend", "SystemException");
                }
                throw new SystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend", activityTokenImpl);
        }
        return activityTokenImpl;
    }

    public void resume(ActivityToken activityToken) throws InvalidActivityException, InvalidParentContextException, SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume", new Object[]{activityToken, this});
        }
        if (!this._serviceRegistered) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No service registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resume", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        if (activityToken != null) {
            if (!(activityToken instanceof ActivityTokenImpl)) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Foreign activity token. Throwing InvalidActivityException");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resume", "InvalidActivityException");
                }
                throw new InvalidActivityException();
            }
            ActivityTokenImpl activityTokenImpl = (ActivityTokenImpl)activityToken;
            LocalActivityContext localActivityContext = activityTokenImpl.getContext();
            if (localActivityContext != null) {
                if (!localActivityContext.isResumable()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Activity is not resumable. Throwing InvalidParentContextException.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resume", "InvalidParentContextException");
                    }
                    throw new InvalidParentContextException();
                }
                try {
                    localActivityContext.resume(activityTokenImpl);
                }
                catch (InvalidActivityException invalidActivityException) {
                    FFDCFilter.processException((Throwable)invalidActivityException, "com.ibm.ws.activity.ActivityManagerImpl.resume", "175", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "InvalidActivityException caught resuming token. Rethrowing.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resume", (Object)invalidActivityException);
                    }
                    throw invalidActivityException;
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.ActivityManagerImpl.resume", "181", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "SystemException caught resuming token. Rethrowing.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resume", systemException);
                    }
                    throw systemException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.ActivityManagerImpl.resume", "187", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unexpected Exception caught resuming token. Throwing SystemException.", exception);
                    }
                    Object[] objectArray = new Object[]{"resume", "com.ibm.ws.activity.ActivityManagerImpl", exception};
                    Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resume", "SystemException");
                    }
                    throw new SystemException();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    public ActivityToken suspendGroup() throws SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspendGroup", this);
        }
        ActivityTokenImpl activityTokenImpl = null;
        if (!this._serviceRegistered) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No service registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspendGroup", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getTopContext(this._hlsInfo.getContextGroup());
        if (localActivityContext != null) {
            try {
                activityTokenImpl = localActivityContext.suspend();
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.ActivityManagerImpl.suspendGroup", "250", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "SystemException caught suspending top context. Rethrowing.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "suspendGroup", systemException);
                }
                throw systemException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.ActivityManagerImpl.suspendGroup", "257", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected exception caught. Throwing SystemException", exception);
                }
                Object[] objectArray = new Object[]{"suspendGroup", "com.ibm.ws.activity.ActivityManagerImpl", exception};
                Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "suspendGroup", "SystemException");
                }
                throw new SystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspendGroup", activityTokenImpl);
        }
        return activityTokenImpl;
    }

    public void resumeGroup(ActivityToken activityToken) throws InvalidActivityException, InvalidParentContextException, SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeGroup", new Object[]{activityToken, this});
        }
        if (!this._serviceRegistered) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No service registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resumeGroup", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        if (activityToken != null) {
            if (!(activityToken instanceof ActivityTokenImpl)) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Foreign activity token. Throwing InvalidActivityException");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resumeGroup", "InvalidActivityException");
                }
                throw new InvalidActivityException();
            }
            if (_threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup()) != null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Contexts in group already on thread. Throwing InvalidParentContextException.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resumeGroup", "InvalidParentContextException");
                }
                throw new InvalidParentContextException();
            }
            ActivityTokenImpl activityTokenImpl = (ActivityTokenImpl)activityToken;
            LocalActivityContext localActivityContext = activityTokenImpl.getContext();
            if (localActivityContext != null) {
                if (localActivityContext.getParentContext() != null) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Context has a parent - throwing InvalidActivityException");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resumeGroup", "InvalidActivityException");
                    }
                    throw new InvalidActivityException();
                }
                try {
                    localActivityContext.resume(activityTokenImpl);
                }
                catch (InvalidActivityException invalidActivityException) {
                    FFDCFilter.processException((Throwable)invalidActivityException, "com.ibm.ws.activity.ActivityManagerImpl.resumeGroup", "348", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "InvalidActivityException caught. Rethrowing.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resumeGroup", (Object)invalidActivityException);
                    }
                    throw invalidActivityException;
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.ActivityManagerImpl.resumeGroup", "354", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "SystemException caught from resume. Rethrowing.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resumeGroup", systemException);
                    }
                    throw systemException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.ActivityManagerImpl.resumeGroup", "360", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unexpected exception caught. Throwing SystemException", exception);
                    }
                    Object[] objectArray = new Object[]{"resumeGroup", "com.ibm.ws.activity.ActivityManagerImpl", exception};
                    Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resumeGroup", "SystemException");
                    }
                    throw new SystemException();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeGroup");
        }
    }

    public ActivityToken suspendAll() throws SystemException, ServiceNotRegisteredException {
        ActivityTokenImpl activityTokenImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspendAll", this);
        }
        if (!this._serviceRegistered) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No service registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspendAll", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        try {
            activityTokenImpl = _threadContextManager.suspendAllContexts();
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.ActivityManagerImpl.suspendAll", "408", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "SystemException caught suspending all contexts. Rethrowing.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspendAll", systemException);
            }
            throw systemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.ActivityManagerImpl.suspendAll", "414", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught. Throwing SystemException", exception);
            }
            Object[] objectArray = new Object[]{"suspendAll", "com.ibm.ws.activity.ActivityManagerImpl", exception};
            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspendAll", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspendAll", activityTokenImpl);
        }
        return activityTokenImpl;
    }

    public void resumeAll(ActivityToken activityToken) throws InvalidActivityException, InvalidParentContextException, SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeAll", new Object[]{activityToken, this});
        }
        if (!this._serviceRegistered) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No service registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resumeAll", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        if (activityToken != null) {
            if (!(activityToken instanceof ActivityTokenImpl)) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Foreign activity token. Throwing InvalidActivityException");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resumeAll", "InvalidActivityException");
                }
                throw new InvalidActivityException();
            }
            if (_threadContextManager.anyCurrentContext()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Contexts already on thread. Throwing InvalidParentContextException.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resumeAll", "InvalidParentContextException");
                }
                throw new InvalidParentContextException();
            }
            ActivityTokenImpl activityTokenImpl = (ActivityTokenImpl)activityToken;
            LocalActivityContext localActivityContext = activityTokenImpl.getContext();
            if (localActivityContext != null) {
                if (localActivityContext.getParentContext() != null) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Context has a parent - throwing InvalidActivityException");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resumeAll", "InvalidActivityException");
                    }
                    throw new InvalidActivityException();
                }
                try {
                    localActivityContext.resume(activityTokenImpl);
                }
                catch (InvalidActivityException invalidActivityException) {
                    FFDCFilter.processException((Throwable)invalidActivityException, "com.ibm.ws.activity.ActivityManagerImpl.resumeAll", "500", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "InvalidActivityException caught. Rethrowing");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resumeAll", (Object)invalidActivityException);
                    }
                    throw invalidActivityException;
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.ActivityManagerImpl.resumeAll", "507", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "SystemException caught from resume. Rethrowing.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resumeAll", systemException);
                    }
                    throw systemException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.ActivityManagerImpl.resumeAll", "514", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unexpected exception caught. Throwing SystemException", exception);
                    }
                    Object[] objectArray = new Object[]{"resumeAll", "com.ibm.ws.activity.ActivityManagerImpl", exception};
                    Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resumeAll", "SystemException");
                    }
                    throw new SystemException();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeAll");
        }
    }

    public GlobalId hibernate() {
        throw new UnsupportedOperationException();
    }

    public void reactivate(GlobalId globalId) {
        throw new UnsupportedOperationException();
    }
}

