/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityCoordinatorImpl;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.activity.ActivityTokenImpl;
import com.ibm.ws.activity.GlobalIdImpl;
import com.ibm.ws.activity.HLSInformation;
import com.ibm.ws.activity.PropertyGroupInfo;
import com.ibm.ws.activity.ThreadContextManager;
import com.ibm.ws.activity.remote.CoordinatorProxy;
import com.ibm.ws.activity.remote.DistributedActivityContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityNotProcessedException;
import com.ibm.ws.javax.activity.ActivityPendingException;
import com.ibm.ws.javax.activity.ContextPendingException;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.javax.activity.InvalidStateException;
import com.ibm.ws.javax.activity.NoActivityException;
import com.ibm.ws.javax.activity.NotOriginatorException;
import com.ibm.ws.javax.activity.Outcome;
import com.ibm.ws.javax.activity.SignalSetUnknownException;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.javax.activity.coordination.ServiceManager;
import com.ibm.ws.javax.activity.propertygroup.PropertyGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class LocalActivityContext {
    private static final TraceComponent tc = Tr.register(LocalActivityContext.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    protected GlobalIdImpl _globalId = null;
    protected int _type = 0;
    private int _status = 0;
    private boolean _completedWithChildren = false;
    protected int _completionStatus = 1;
    protected HashMap _propertyGroups = new HashMap();
    protected HashMap _propertyGroupManagers = new HashMap();
    protected String _serviceName = "";
    protected ServiceManager _serviceManager = null;
    private int _version = 2;
    protected ActivityCoordinatorImpl _localCoordinator = null;
    protected boolean _clientProcess = true;
    protected static ThreadContextManager _threadContextManager = ThreadContextManager.instance();
    protected int _timeout = -1;
    protected Vector _associations = new Vector();
    protected LocalActivityContext _parentContext = null;
    protected Hashtable _activeChildren = new Hashtable();
    protected List _children = new ArrayList();
    protected String _contextGroup = "default";
    protected HLSInformation _hlsInformation = null;
    protected String _contextId = null;
    private DistributedActivityContext _distributedContext;
    private int _importedAssociations = 0;

    public LocalActivityContext(HLSInformation hLSInformation, int n) throws SystemException {
        this(hLSInformation, n, null);
    }

    public LocalActivityContext(HLSInformation hLSInformation, int n, GlobalIdImpl globalIdImpl) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LocalActivityContext", new Object[]{hLSInformation, new Integer(n), globalIdImpl});
        }
        this._type = 1244808517;
        if (globalIdImpl == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating a GlobalId object to represent a new activity context");
            }
            this._globalId = new GlobalIdImpl();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using existing GlobalId object to represent a recovered activity context");
            }
            this._globalId = globalIdImpl;
        }
        this.incrementAssociationCount();
        _threadContextManager.registerContextByGlobalId(this._globalId, this);
        this._propertyGroupManagers = hLSInformation.getPropertyGroupManagers();
        this._serviceName = hLSInformation.getServiceName();
        this._contextGroup = hLSInformation.getContextGroup();
        this._serviceManager = hLSInformation.getServiceManager();
        this._timeout = n;
        this._completionStatus = 1;
        this._hlsInformation = hLSInformation;
        if (ActivityService.instance().isServerProcess()) {
            this._clientProcess = false;
        }
        if (this._timeout > -1 && this._hlsInformation != null) {
            this.getCoordinator();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LocalActivityContext", this);
        }
    }

    public LocalActivityContext(DistributedActivityContext distributedActivityContext, String string, String string2, int n, int n2, GlobalIdImpl globalIdImpl, HLSInformation hLSInformation) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LocalActivityContext", new Object[]{distributedActivityContext, string, string2, new Integer(n), new Integer(n2), globalIdImpl, hLSInformation});
        }
        this._distributedContext = distributedActivityContext;
        this._serviceName = string;
        this._contextGroup = string2;
        this._clientProcess = false;
        this._type = n;
        this._globalId = globalIdImpl;
        _threadContextManager.registerContextByGlobalId(this._globalId, this);
        this._timeout = n2;
        this._hlsInformation = hLSInformation;
        if (this._hlsInformation != null) {
            this._contextGroup = this._hlsInformation.getContextGroup();
            this._serviceManager = this._hlsInformation.getServiceManager();
            this._propertyGroupManagers = this._hlsInformation.getPropertyGroupManagers();
            if (this._timeout > -1) {
                this.getCoordinator();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LocalActivityContext", this);
        }
    }

    public void driveChildBegin() throws SystemException {
        ActivityCoordinatorImpl activityCoordinatorImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "driveChildBegin", this);
        }
        if (this._parentContext != null && this._parentContext._hlsInformation.signalChildBegin() && (activityCoordinatorImpl = this.getParentCoordinator()) != null) {
            try {
                Outcome outcome = activityCoordinatorImpl.processSignalSetInternal("org.omg.CosActivity.ChildLifetime", this._completionStatus);
                if (outcome != null && outcome.getName().equals("org.omg.CosActivity.ActionError")) {
                    this._completionStatus = 2;
                }
            }
            catch (ActivityNotProcessedException activityNotProcessedException) {
                FFDCFilter.processException((Throwable)activityNotProcessedException, "com.ibm.ws.activity.LocalActivityContext.driveChildBegin", "729", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Convert ActivityNotProcessedException to SystemException - unable to process child lifetime signalset" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "driveChildBegin", "SystemException");
                }
                throw new SystemException();
            }
            catch (SignalSetUnknownException signalSetUnknownException) {
                FFDCFilter.processException((Throwable)signalSetUnknownException, "com.ibm.ws.activity.LocalActivityContext.driveChildBegin", "738", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Convert SignalSetUnknownException to SystemException - unable to create child lifetime signalset" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "driveChildBegin", "SystemException");
                }
                throw new SystemException();
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.LocalActivityContext.driveChildBegin", "746", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Rethrow SystemException - unexpected error occured processing the child lifetime signalset" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "driveChildBegin", "SystemException");
                }
                throw new SystemException();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.driveChildBegin", "755", this);
                Object[] objectArray = new Object[]{"driveChildBegin", "com.ibm.ws.activity.LocalActivityContext", exception};
                Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Convert Exception to SystemException - unexpected error occured processing the child lifetime signalset" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "driveChildBegin", "SystemException");
                }
                throw new SystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "driveChildBegin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityTokenImpl completionPreinvoke() throws SystemException, ActivityPendingException, ContextPendingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completionPreinvoke", this);
        }
        ActivityTokenImpl activityTokenImpl = null;
        LocalActivityContext localActivityContext = this;
        synchronized (localActivityContext) {
            if (this.getStatus() != 0) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Throw SystemException - context not in active state" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "completionPreinvoke", "SystemException");
                }
                throw new SystemException();
            }
            if (this.countAssociations() != 1L) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Throw ActivityPendingException - context active in process" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "completionPreinvoke", "ActivityPendingException");
                }
                throw new ActivityPendingException();
            }
            if (this._children.size() > 0 && this._completionStatus == 0) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Throw ContextPendingException - context has active children" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "completionPreinvoke", "ContextPendingException");
                }
                throw new ContextPendingException();
            }
        }
        if (this._children.size() > 0) {
            this.markChildrenFailed();
            localActivityContext = this.getActiveChild();
            if (localActivityContext != null) {
                try {
                    activityTokenImpl = localActivityContext.suspend();
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.LocalActivityContext.completionPreinvoke", "502", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Rethrow SystemException - unable to suspend active child" + this._contextId);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "completionPreinvoke", systemException);
                    }
                    throw systemException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.completionPreinvoke", "510", this);
                    Object[] objectArray = new Object[]{"completionPreinvoke", "com.ibm.ws.activity.LocalActivityContext", exception};
                    Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Convert Exception to SystemException - unable to suspend active child" + this._contextId);
                    }
                    SystemException systemException = new SystemException();
                    systemException.initCause(exception);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "completionPreinvoke", systemException);
                    }
                    throw systemException;
                }
            }
            this.removeFromChain();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completionPreinvoke", activityTokenImpl);
        }
        return activityTokenImpl;
    }

    public Outcome complete(ActivityTokenImpl activityTokenImpl) throws ContextPendingException, NotOriginatorException, ActivityPendingException, SystemException, ActivityNotProcessedException, NoActivityException {
        Outcome outcome;
        block42: {
            Object object;
            block39: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "complete", new Object[]{activityTokenImpl, this});
                }
                outcome = null;
                try {
                    object = this._serviceManager.getCompletionSignalSetName();
                    if (object != null && !this._hlsInformation.noForceCoordinator()) {
                        this.getCoordinator();
                    }
                    if (this._localCoordinator != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Passing control of completion to local coordinator");
                        }
                        try {
                            outcome = this._localCoordinator.completeActivityInternal((String)object, this._completionStatus);
                            break block39;
                        }
                        catch (ContextPendingException contextPendingException) {
                            FFDCFilter.processException((Throwable)contextPendingException, "com.ibm.ws.activity.LocalActivityContext.complete", "934", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "!!!Exception: Rethrow ContextPendingException - failure driving local coordinator to complete activity");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "complete", contextPendingException);
                            }
                            throw contextPendingException;
                        }
                        catch (SystemException systemException) {
                            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.LocalActivityContext.complete", "942", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "!!!Exception: Rethrow SystemException - failure driving local coordinator to complete activity");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "complete", systemException);
                            }
                            throw systemException;
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.complete", "949", this);
                            Object[] objectArray = new Object[]{"complete", "com.ibm.ws.activity.LocalActivityContext", exception};
                            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "!!!Exception: Convert Exception to SystemException - failure driving local coordinator to complete activity");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "complete", "SystemException");
                            }
                            throw new SystemException();
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Driving simple, local completion (no coordinator)");
                    }
                    try {
                        this.completeLocal();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.complete", "1042", this);
                        Object[] objectArray = new Object[]{"complete", "com.ibm.ws.activity.LocalActivityContext", exception};
                        Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "!!!Exception: Convert Exception to SystemException - unexpected error occured whilst attempting local completion");
                        }
                        throw new SystemException();
                    }
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.LocalActivityContext.complete", "1054", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Rethrow SystemException" + this._contextId);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "complete", systemException);
                    }
                    throw systemException;
                }
                catch (ContextPendingException contextPendingException) {
                    block41: {
                        block40: {
                            FFDCFilter.processException((Throwable)contextPendingException, "com.ibm.ws.activity.LocalActivityContext.complete", "1060", this);
                            try {
                                this.setStatus(0);
                            }
                            catch (InvalidStateException invalidStateException) {
                                FFDCFilter.processException((Throwable)invalidStateException, "com.ibm.ws.activity.LocalActivityContext.complete", "1067", this);
                                if (tc.isEventEnabled()) {
                                    Tr.event(tc, "Absorb InvalidStateException - unable to switch to active state" + this._contextId);
                                }
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.complete", "1073", this);
                                Object[] objectArray = new Object[]{"complete", "com.ibm.ws.activity.LocalActivityContext", contextPendingException};
                                Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                                if (!tc.isEventEnabled()) break block40;
                                Tr.event(tc, "Absorb Exception - unable to switch to active state" + this._contextId);
                            }
                        }
                        if (activityTokenImpl != null) {
                            LocalActivityContext localActivityContext = activityTokenImpl.getContext();
                            try {
                                localActivityContext.resume(activityTokenImpl);
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.complete", "1092", this);
                                Object[] objectArray = new Object[]{"complete", "com.ibm.ws.activity.LocalActivityContext", contextPendingException};
                                Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                                if (!tc.isEventEnabled()) break block41;
                                Tr.event(tc, "Absorb Exception - exception when resuming suspended child" + this._contextId);
                            }
                        }
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Rethrow ContextPendingException" + this._contextId);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "complete", contextPendingException);
                    }
                    throw contextPendingException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.complete", "1153", this);
                    Object[] objectArray = new Object[]{"complete", "com.ibm.ws.activity.LocalActivityContext", exception};
                    Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Convert Exception to SystemException" + this._contextId);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "complete", "SystemException");
                    }
                    throw new SystemException();
                }
            }
            if (activityTokenImpl != null) {
                object = activityTokenImpl.getContext();
                try {
                    ((LocalActivityContext)object).resume(activityTokenImpl);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.complete", "1173", this);
                    Object[] objectArray = new Object[]{"complete", "com.ibm.ws.activity.LocalActivityContext", exception};
                    Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                    if (!tc.isDebugEnabled()) break block42;
                    Tr.debug(tc, "!!!Exception: Absorb Exception - exception when resuming suspended child" + this._contextId);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "complete", outcome);
        }
        return outcome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outcome heuristicComplete() throws ContextPendingException, ActivityPendingException, SystemException, ActivityNotProcessedException {
        Outcome outcome;
        block45: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "heuristicComplete", this);
            }
            outcome = null;
            ActivityTokenImpl activityTokenImpl = null;
            Object object = this;
            synchronized (object) {
                if (this.getStatus() != 0) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Throw SystemException - context not in active state" + this._contextId);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "heuristicComplete", "SystemException");
                    }
                    throw new SystemException();
                }
                if (this.countAssociations() != 1L) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Throw ActivityPendingException - context active in process" + this._contextId);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "heuristicComplete", "ActivityPendingException");
                    }
                    throw new ActivityPendingException();
                }
                if (this._children.size() > 0 && this._completionStatus == 0) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Throw ContextPendingException - context has active children" + this._contextId);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "heuristicComplete", "ContextPendingException");
                    }
                    throw new ContextPendingException();
                }
            }
            if (this._children.size() > 0) {
                this.markChildrenFailed();
                object = this.getActiveChild();
                if (object != null) {
                    try {
                        activityTokenImpl = ((LocalActivityContext)object).suspend();
                    }
                    catch (SystemException systemException) {
                        FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.LocalActivityContext.heuristicComplete", "1531", this);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Rethrow SystemException - unable to suspend active child" + this._contextId);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "heuristicComplete", systemException);
                        }
                        throw systemException;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.heuristicComplete", "1538", this);
                        Object[] objectArray = new Object[]{"heuristicComplete", "com.ibm.ws.activity.LocalActivityContext", exception};
                        Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Convert Exception to SystemException - unable to suspend active child" + this._contextId);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "heuristicComplete", "SystemException");
                        }
                        throw new SystemException();
                    }
                }
                this.removeFromChain();
            }
            try {
                object = this._serviceManager.getCompletionSignalSetName();
                outcome = this._localCoordinator.completeActivityInternal((String)object, this._completionStatus);
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.LocalActivityContext.heuristicComplete", "1574", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Rethrow SystemException" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "heuristicComplete", systemException);
                }
                throw systemException;
            }
            catch (ContextPendingException contextPendingException) {
                block44: {
                    block43: {
                        FFDCFilter.processException((Throwable)contextPendingException, "com.ibm.ws.activity.LocalActivityContext.heuristicComplete", "1580", this);
                        try {
                            this.setStatus(0);
                        }
                        catch (InvalidStateException invalidStateException) {
                            FFDCFilter.processException((Throwable)invalidStateException, "com.ibm.ws.activity.LocalActivityContext.heuristicComplete", "1587", this);
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Absorb InvalidStateException - unable to switch to active state" + this._contextId);
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.heuristicComplete", "1593", this);
                            Object[] objectArray = new Object[]{"heuristicComplete", "com.ibm.ws.activity.LocalActivityContext", contextPendingException};
                            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                            if (!tc.isEventEnabled()) break block43;
                            Tr.event(tc, "Absorb Exception - unable to switch to active state" + this._contextId);
                        }
                    }
                    if (activityTokenImpl != null) {
                        LocalActivityContext localActivityContext = activityTokenImpl.getContext();
                        try {
                            localActivityContext.resume(activityTokenImpl);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.heuristicComplete", "1612", this);
                            Object[] objectArray = new Object[]{"heuristicComplete", "com.ibm.ws.activity.LocalActivityContext", contextPendingException};
                            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                            if (!tc.isEventEnabled()) break block44;
                            Tr.event(tc, "Absorb Exception - exception when resuming suspended child" + this._contextId);
                        }
                    }
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Rethrow ContextPendingException" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "heuristicComplete", contextPendingException);
                }
                throw contextPendingException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.heuristicComplete", "1673", this);
                Object[] objectArray = new Object[]{"heuristicComplete", "com.ibm.ws.activity.LocalActivityContext", exception};
                Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Convert Exception to SystemException" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "heuristicComplete", "SystemException");
                }
                throw new SystemException();
            }
            if (activityTokenImpl != null) {
                object = activityTokenImpl.getContext();
                try {
                    ((LocalActivityContext)object).resume(activityTokenImpl);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.heuristicComplete", "1693", this);
                    Object[] objectArray = new Object[]{"heuristicComplete", "com.ibm.ws.activity.LocalActivityContext", exception};
                    Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                    if (!tc.isDebugEnabled()) break block45;
                    Tr.debug(tc, "heuristicComplete", "!!!Exception: Absorb Exception - exception when resuming suspended child" + this._contextId);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "heuristicComplete", outcome);
        }
        return outcome;
    }

    protected boolean completedWithChildren() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completedWithChildren", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completedWithChildren", this._completedWithChildren);
        }
        return this._completedWithChildren;
    }

    public void incrementAssociationCount() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "incrementAssociationCount");
        }
        ++this._importedAssociations;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "incrementAssociationCount", new Integer(this._importedAssociations));
        }
    }

    public void decrementAssociationCount() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decrementAssociationCount");
        }
        --this._importedAssociations;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decrementAssociationCount", new Integer(this._importedAssociations));
        }
    }

    public void completeLocal() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeLocal", this);
        }
        boolean bl = this.hasChild();
        this.suspendNoToken();
        if (!bl) {
            this.removeContextFromParent();
        }
        this.driveCompletedOnPGs();
        this._status = 2;
        if (!bl) {
            _threadContextManager.unregisterContextByGlobalId(this._globalId);
        }
        this._completedWithChildren = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeLocal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeImported() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeImported", this);
        }
        if (this._localCoordinator == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no local coordinator so end the activity");
            }
            this.removeContextFromParent();
            ThreadContextManager threadContextManager = ThreadContextManager.instance();
            synchronized (threadContextManager) {
                if (this._importedAssociations <= 0) {
                    this.driveCompletedOnPGs();
                    this._status = 2;
                    _threadContextManager.unregisterContextByGlobalId(this._globalId);
                }
            }
        } else {
            LocalActivityContext localActivityContext;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "activity has local coordinator so cleanup parent ref if needed");
            }
            if ((localActivityContext = this.getParentContext()) != null && localActivityContext.getCoordinatorRef() == null) {
                this.removeContextFromParent();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeImported");
        }
    }

    public void setCompletionStatus(int n) throws InvalidStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCompletionStatus", new Object[]{new Integer(n), this});
        }
        if (this._completionStatus == 2 && n != 2) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Throw InvalidStateException - CompletionStatus already FailOnly" + this._contextId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setCompletionStatus", "InvalidStateException");
            }
            throw new InvalidStateException();
        }
        this._completionStatus = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCompletionStatus");
        }
    }

    public int getCompletionStatus() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompletionStatus", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompletionStatus", new Integer(this._completionStatus));
        }
        return this._completionStatus;
    }

    public ActivityTokenImpl suspend() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend", this);
        }
        ActivityTokenImpl activityTokenImpl = null;
        LocalActivityContext localActivityContext = this.getActiveChild();
        try {
            activityTokenImpl = localActivityContext != null ? new ActivityTokenImpl(this, localActivityContext.suspend()) : new ActivityTokenImpl(this, null);
            this.deactivateFromThread();
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.LocalActivityContext.suspend", "1437", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Rethrow SystemException - unexpected error occured whilst suspending context" + this._contextId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspend", systemException);
            }
            throw systemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.suspend", "1444", this);
            Object[] objectArray = new Object[]{"suspend", "com.ibm.ws.activity.LocalActivityContext", exception};
            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Convert Exception to SystemException - unexpected error occured whilst suspending context" + this._contextId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspend", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend", activityTokenImpl);
        }
        return activityTokenImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(ActivityTokenImpl activityTokenImpl) throws InvalidActivityException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume", new Object[]{activityTokenImpl, this});
        }
        Object object = this;
        synchronized (object) {
            if (this.getStatus() == 2) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Attempting to resume a completed activity - no-op");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resume");
                }
                return;
            }
            if (this.getStatus() != 0 && this.getStatus() != 1 && this.getStatus() != 6) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Throw InvalidActivityException - Attempted to resume activity with non active status" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resume", "InvalidActivityException");
                }
                throw new InvalidActivityException();
            }
            try {
                this.activateOnThread();
                this.driveResumedOnPGs();
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.LocalActivityContext.resume", "1504", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Rethrow SystemException - error occured whilst resuming context" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resume", systemException);
                }
                throw systemException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.resume", "1511", this);
                Object[] objectArray = new Object[]{"resume", "com.ibm.ws.activity.LocalActivityContext", exception};
                Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Convert Exception to SystemException - unexpected error occured whilst resuming context" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resume", "SystemException");
                }
                throw new SystemException();
            }
        }
        try {
            object = activityTokenImpl.getChildToken();
            if (object != null) {
                LocalActivityContext localActivityContext = ((ActivityTokenImpl)object).getContext();
                localActivityContext.resume((ActivityTokenImpl)object);
            }
        }
        catch (InvalidActivityException invalidActivityException) {
            FFDCFilter.processException((Throwable)invalidActivityException, "com.ibm.ws.activity.LocalActivityContext.resume", "1533", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "caught InvalidActivityException from child resume; suspend before rethrowing");
            }
            this.suspendNoToken();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resume", (Object)invalidActivityException);
            }
            throw invalidActivityException;
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.LocalActivityContext.resume", "1547", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Rethrow SystemException - error occured whilst resuming child token" + this._contextId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resume", systemException);
            }
            throw systemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.resume", "1554", this);
            Object[] objectArray = new Object[]{"resume", "com.ibm.ws.activity.LocalActivityContext", exception};
            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Convert Exception to SystemException - unexpected error occured whilst resuming child token" + this._contextId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resume", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    protected void markFailed() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markFailed", this);
        }
        this._completionStatus = 2;
        this.driveCompletedOnPGs();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markFailed");
        }
    }

    public PropertyGroup getPropertyGroup(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyGroup", new Object[]{string, this});
        }
        PropertyGroup propertyGroup = (PropertyGroup)this._propertyGroups.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyGroup", propertyGroup);
        }
        return propertyGroup;
    }

    public GlobalIdImpl getGlobalId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGlobalId", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGlobalId", this._globalId);
        }
        return this._globalId;
    }

    public void setGlobalId(GlobalIdImpl globalIdImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setGlobalId", new Object[]{globalIdImpl, this});
        }
        this._globalId = globalIdImpl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setGlobalId");
        }
    }

    public int getVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVersion", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVersion", new Integer(this._version));
        }
        return this._version;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getName", this);
        }
        String string = this._globalId.print();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getName", string);
        }
        return string;
    }

    public ServiceManager getServiceManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceManager", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceManager", this._serviceManager);
        }
        return this._serviceManager;
    }

    public LocalActivityContext getCurrentContext(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentContext", new Object[]{string, this});
        }
        LocalActivityContext localActivityContext = null;
        LocalActivityContext localActivityContext2 = this;
        while (localActivityContext == null && localActivityContext2 != null) {
            if (localActivityContext2._serviceName.equals(string)) {
                localActivityContext = localActivityContext2;
                continue;
            }
            localActivityContext2 = localActivityContext2.getParentContext();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentContext", localActivityContext);
        }
        return localActivityContext;
    }

    public synchronized ActivityCoordinatorImpl getCoordinator() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCoordinator", this);
        }
        if (this._localCoordinator == null && !this._clientProcess) {
            try {
                CoordinatorProxy coordinatorProxy = this._distributedContext != null ? this._distributedContext.getSuperiorCoordinatorProxy() : null;
                this._localCoordinator = new ActivityCoordinatorImpl(coordinatorProxy, this, this._hlsInformation);
            }
            catch (SignalSetUnknownException signalSetUnknownException) {
                FFDCFilter.processException((Throwable)signalSetUnknownException, "com.ibm.ws.activity.LocalActivityContext.getCoordinator", "2345", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Convert SignalSetUnknownException to SystemException - Superior registration failed" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCoordinator", "SystemException");
                }
                throw new SystemException();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.getCoordinator", "2352", this);
                Object[] objectArray = new Object[]{"getCoordinator", "com.ibm.ws.activity.LocalActivityContext", exception};
                Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Convert Exception to SystemException - unexpected error occured attempting to register with superior" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCoordinator", "SystemException");
                }
                throw new SystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCoordinator", this._localCoordinator);
        }
        return this._localCoordinator;
    }

    public ActivityCoordinatorImpl getCoordinatorRef() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCoordinatorRef", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCoordinatorRef", this._localCoordinator);
        }
        return this._localCoordinator;
    }

    public ActivityCoordinatorImpl getParentCoordinator() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentCoordinator", this);
        }
        ActivityCoordinatorImpl activityCoordinatorImpl = null;
        if (this._parentContext != null) {
            LocalActivityContext localActivityContext = this._parentContext;
            try {
                activityCoordinatorImpl = localActivityContext.getCoordinator();
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.LocalActivityContext.getParentCoordinator", "2418", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Rethrow SystemException - unexpected error occured getting parent's coordinator" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getParentCoordinator", systemException);
                }
                throw systemException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.getParentCoordinator", "2425", this);
                Object[] objectArray = new Object[]{"getParentCoordinator", "com.ibm.ws.activity.LocalActivityContext", exception};
                Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Convert Exception to SystemException - unexpected error occured getting parent's coordinator" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getParentCoordinator", "SystemException");
                }
                throw new SystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentCoordinator", activityCoordinatorImpl);
        }
        return activityCoordinatorImpl;
    }

    public int getParentStatus() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentStatus", this);
        }
        int n = this._status;
        if (this._parentContext != null) {
            LocalActivityContext localActivityContext = this._parentContext;
            n = localActivityContext.getStatus();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentStatus", new Integer(n));
        }
        return n;
    }

    public Outcome broadcast(String string) throws SignalSetUnknownException, InvalidActivityException, SystemException, ActivityNotProcessedException, NoActivityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "broadcast", new Object[]{string, this});
        }
        Outcome outcome = null;
        if (string.equals("org.omg.CosActivity.Synchronization") || string.equals("org.omg.CosActivity.ChildLifetime")) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Throw InvalidActivityException - unable to broadcast internal signalset" + this._contextId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "broadcast", "InvalidActivityException");
            }
            throw new InvalidActivityException();
        }
        if (this.getStatus() != 0) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Throw InvalidActivityException - unable to broadcast during completion" + this._contextId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "broadcast", "InvalidActivityException");
            }
            throw new InvalidActivityException();
        }
        ActivityCoordinatorImpl activityCoordinatorImpl = this.getCoordinator();
        if (activityCoordinatorImpl != null) {
            try {
                outcome = this._localCoordinator.processSignalSetInternal(string, this._completionStatus);
            }
            catch (SignalSetUnknownException signalSetUnknownException) {
                FFDCFilter.processException((Throwable)signalSetUnknownException, "com.ibm.ws.activity.LocalActivityContext.broadcast", "2566", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Rethrow SignalSetUnknownException " + this._contextId + " " + string);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "broadcast", signalSetUnknownException);
                }
                throw signalSetUnknownException;
            }
            catch (ActivityNotProcessedException activityNotProcessedException) {
                FFDCFilter.processException((Throwable)activityNotProcessedException, "com.ibm.ws.activity.LocalActivityContext.broadcast", "2572", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Rethrow ActivityNotProcessedException " + this._contextId + " " + string);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "broadcast", activityNotProcessedException);
                }
                throw activityNotProcessedException;
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.LocalActivityContext.broadcast", "2580", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Rethrow SystemException - error occured attempting to process signal set" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "broadcast", systemException);
                }
                throw systemException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "broadcast", outcome);
        }
        return outcome;
    }

    public void driveSuspendedOnPGs() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "driveSuspendedOnPGs", this);
            }
            try {
                Iterator iterator = this._propertyGroups.values().iterator();
                while (iterator.hasNext()) {
                    PropertyGroup propertyGroup = (PropertyGroup)iterator.next();
                    propertyGroup.suspended();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.driveSuspendedOnPGs", "3285", this);
                Object[] objectArray = new Object[]{"suspend", "com.ibm.ws.activity.LocalActivityContext", exception};
                Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Exception caught from PG suspend");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "driveSuspendedOnPGs");
        }
    }

    public void driveResumedOnPGs() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "driveResumedOnPGs", this);
            }
            try {
                Iterator iterator = this._propertyGroups.values().iterator();
                while (iterator.hasNext()) {
                    PropertyGroup propertyGroup = (PropertyGroup)iterator.next();
                    propertyGroup.resumed();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.driveResumedOnPGs", "3321", this);
                Object[] objectArray = new Object[]{"resume", "com.ibm.ws.activity.LocalActivityContext", exception};
                Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Exception caught from PG resume");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "driveResumedOnPGs");
        }
    }

    public void driveCompletedOnPGs() {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "driveCompletedOnPGs", this);
            }
            try {
                Iterator iterator = this._propertyGroups.values().iterator();
                while (iterator.hasNext()) {
                    PropertyGroup propertyGroup = (PropertyGroup)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "completing PG:" + propertyGroup);
                    }
                    propertyGroup.completed();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.driveCompletedOnPGs", "3358", this);
                Object[] objectArray = new Object[]{"complete", "com.ibm.ws.activity.LocalActivityContext", exception};
                Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
                if (!tc.isEventEnabled()) break block6;
                Tr.event(tc, "Exception caught from PG complete");
            }
        }
        this._propertyGroups.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "driveCompletedOnPGs");
        }
    }

    public void createPGs(LocalActivityContext localActivityContext) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPGs", new Object[]{localActivityContext, this});
        }
        Iterator iterator = this._propertyGroupManagers.values().iterator();
        while (iterator.hasNext()) {
            PropertyGroup propertyGroup;
            PropertyGroupInfo propertyGroupInfo = (PropertyGroupInfo)iterator.next();
            PropertyGroup propertyGroup2 = null;
            if (localActivityContext != null) {
                propertyGroup2 = localActivityContext.getPropertyGroup(propertyGroupInfo._name);
            }
            if ((propertyGroup = propertyGroupInfo._manager.create(propertyGroup2, this._globalId)) == null) {
                Object[] objectArray = new Object[]{propertyGroupInfo._name, this._serviceName};
                Tr.error(tc, "ERR_NULL_PG", objectArray);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Throw SystemException - propery group manager: " + propertyGroupInfo._name + " supplied null property group on create" + this._contextId);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createPGs", "SystemException");
                }
                throw new SystemException();
            }
            this._propertyGroups.put(propertyGroupInfo._name, propertyGroup);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPGs");
        }
    }

    public void recreatePGs(LocalActivityContext localActivityContext) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recreatePGs", new Object[]{localActivityContext, this});
        }
        Iterator iterator = this._propertyGroupManagers.values().iterator();
        while (iterator.hasNext()) {
            PropertyGroup propertyGroup;
            PropertyGroupInfo propertyGroupInfo = (PropertyGroupInfo)iterator.next();
            PropertyGroup propertyGroup2 = null;
            if (localActivityContext != null) {
                propertyGroup2 = localActivityContext.getPropertyGroup(propertyGroupInfo._name);
            }
            if ((propertyGroup = propertyGroupInfo._manager.recoverPropertyGroup(propertyGroup2, this._globalId)) != null) {
                this._propertyGroups.put(propertyGroupInfo._name, propertyGroup);
                continue;
            }
            Tr.error(tc, "ERR_NULL_RECREATE_PG", new Object[]{propertyGroupInfo._name, this._serviceName});
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Throw SystemException - propery group manager: " + propertyGroupInfo._name + " supplied null property group on recreate" + this._contextId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recreatePGs", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recreatePGs");
        }
    }

    public synchronized int getStatus() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatus", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatus", new Integer(this._status));
        }
        return this._status;
    }

    public synchronized void setStatus(int n) throws InvalidStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStatus", new Object[]{new Integer(n), this});
        }
        if (n == 3 || n == 4) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Throw InvalidStateException - Requested state is invalid: " + n + " from " + this._status + this._contextId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setStatus", "InvalidStateException");
            }
            throw new InvalidStateException();
        }
        this._status = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStatus");
        }
    }

    public boolean isResumable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isResumable", this);
        }
        boolean bl = false;
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._contextGroup);
        if (localActivityContext == this._parentContext) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isResumable", bl);
        }
        return bl;
    }

    public LocalActivityContext resumeHierarchy() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeHierarchy", this);
        }
        LocalActivityContext localActivityContext = this;
        try {
            if (this._parentContext != null && !this._parentContext.isActiveOnThread()) {
                localActivityContext = this._parentContext.resumeHierarchy();
            }
            this.activateOnThread();
            this.driveResumedOnPGs();
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.LocalActivityContext.resumeHierarchy", "2110", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Rethrow SystemException - unable to activate comtext on thread" + this._contextId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resumeHierarchy", systemException);
            }
            throw systemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.LocalActivityContext.resumeHierarchy", "2118", this);
            Object[] objectArray = new Object[]{"resumeHierarchy", "com.ibm.ws.activity.LocalActivityContext", exception};
            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught during resume processing.", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resumeHierarchy", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeHierarchy", localActivityContext);
        }
        return localActivityContext;
    }

    public boolean notifyImported() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyImported", this);
        }
        boolean bl = false;
        if (this._hlsInformation != null) {
            bl = this._hlsInformation.notifyImported();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyImported", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivateFromThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deactivateFromThread", this);
        }
        this.driveSuspendedOnPGs();
        if (this._parentContext != null) {
            this._parentContext.childDeActivatingFromThread(this);
        }
        this._associations.removeElement(Thread.currentThread());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Deactivated. Thread associations of " + this, this._associations);
        }
        if (this._associations.isEmpty()) {
            Vector vector = this._associations;
            synchronized (vector) {
                this._associations.notify();
            }
        }
        _threadContextManager.removeContextFromThread(this._contextGroup);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deactivateFromThread");
        }
    }

    public void cleanFromThread() {
        LocalActivityContext localActivityContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanFromThread", this);
        }
        if ((localActivityContext = this.getActiveChild()) != null) {
            DistributedActivityContext distributedActivityContext = localActivityContext.getDistributedContext();
            if (distributedActivityContext != null) {
                distributedActivityContext.cleanFromThread();
            } else {
                localActivityContext.cleanFromThread();
            }
        }
        this.suspendNoToken();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanFromThread");
        }
    }

    protected long countAssociations() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "countAssociations", this);
        }
        long l = this._associations.size();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "countAssociations", new Long(l));
        }
        return l;
    }

    public LocalActivityContext getParentContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentContext", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentContext", this._parentContext);
        }
        return this._parentContext;
    }

    public LocalActivityContext getTopContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTopContext", this);
        }
        LocalActivityContext localActivityContext = this;
        for (LocalActivityContext localActivityContext2 = localActivityContext.getParentContext(); localActivityContext2 != null; localActivityContext2 = localActivityContext2.getParentContext()) {
            localActivityContext = localActivityContext2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTopContext", localActivityContext);
        }
        return localActivityContext;
    }

    public ActivityTokenImpl getContextInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextInfo", this);
        }
        ActivityTokenImpl activityTokenImpl = null;
        LocalActivityContext localActivityContext = this.getActiveChild();
        activityTokenImpl = localActivityContext == null ? new ActivityTokenImpl(this, null) : new ActivityTokenImpl(this, localActivityContext.getContextInfo());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextInfo", activityTokenImpl);
        }
        return activityTokenImpl;
    }

    public int getTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimeout", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimeout", new Integer(this._timeout));
        }
        return this._timeout;
    }

    public LocalActivityContext getActiveChild() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveChild", this);
        }
        LocalActivityContext localActivityContext = (LocalActivityContext)this._activeChildren.get(Thread.currentThread());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveChild", localActivityContext);
        }
        return localActivityContext;
    }

    protected void markChildrenFailed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markChildrenFailed", this);
        }
        if (this._hlsInformation.markChildrenFailed()) {
            Iterator iterator = this._children.iterator();
            while (iterator.hasNext()) {
                LocalActivityContext localActivityContext = (LocalActivityContext)iterator.next();
                localActivityContext.markChildrenFailed();
                try {
                    localActivityContext.markFailed();
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.LocalActivityContext.markChildrenFailed", "469", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markChildrenFailed");
        }
    }

    protected void removeFromChain() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFromChain", this);
        }
        if (this._parentContext != null) {
            this._parentContext._children.remove(this);
        }
        Iterator iterator = this._children.iterator();
        while (iterator.hasNext()) {
            LocalActivityContext localActivityContext = (LocalActivityContext)iterator.next();
            if (this._parentContext != null) {
                this._parentContext._children.add(localActivityContext);
            }
            localActivityContext._parentContext = this._parentContext;
        }
        if (this._parentContext != null && this._parentContext._activeChildren.get(Thread.currentThread()) == this) {
            this._parentContext._activeChildren.remove(Thread.currentThread());
            if (this._activeChildren.get(Thread.currentThread()) != null) {
                this._parentContext._activeChildren.put(Thread.currentThread(), this._activeChildren.get(Thread.currentThread()));
            }
        }
        this._children.clear();
        this._activeChildren.remove(Thread.currentThread());
        this._parentContext = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFromChain");
        }
    }

    public void addContextToParent(LocalActivityContext localActivityContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addContextToParent", new Object[]{localActivityContext, this});
        }
        if (this._parentContext == null) {
            this._parentContext = localActivityContext;
            if (localActivityContext != null) {
                localActivityContext.addNewChild(this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addContextToParent");
        }
    }

    private void addNewChild(LocalActivityContext localActivityContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNewChild", new Object[]{localActivityContext, this});
        }
        if (!this._children.contains(localActivityContext)) {
            this._children.add(localActivityContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNewChild");
        }
    }

    protected void removeContextFromParent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeContextFromParent", this);
        }
        if (this._parentContext != null) {
            this._parentContext.removeExistingChild(this);
            this._parentContext = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeContextFromParent");
        }
    }

    private void removeExistingChild(LocalActivityContext localActivityContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeExistingChild", new Object[]{localActivityContext, this});
        }
        boolean bl = this._children.remove(localActivityContext);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Child removed", Boolean.toString(bl));
        }
        if (!this.hasChild() && this._completedWithChildren) {
            this.removeContextFromParent();
            _threadContextManager.unregisterContextByGlobalId(this._globalId);
            this._localCoordinator.cleanup();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeExistingChild");
        }
    }

    public void activateOnThread() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activateOnThread", this);
        }
        if (this._associations.contains(Thread.currentThread())) {
            this.removeContextFromParent();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Throw SystemException - context already active on thread" + this._contextId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "activateOnThread", "SystemException");
            }
            throw new SystemException();
        }
        if (this._parentContext != null) {
            this._parentContext.childActivatingOnThread(this);
        }
        this._associations.addElement(Thread.currentThread());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Activated. Thread associations of " + this, this._associations);
        }
        _threadContextManager.addContextToThread(this._contextGroup, this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "activateOnThread");
        }
    }

    private void childActivatingOnThread(LocalActivityContext localActivityContext) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childActivatingOnThread", new Object[]{localActivityContext, this});
        }
        if (!this._children.contains(localActivityContext)) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Throw SystemException - child not known to target context" + this._contextId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "childActivatingOnThread", "SystemException");
            }
            throw new SystemException();
        }
        if (this._activeChildren.containsKey(Thread.currentThread())) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Throw SystemException - context already active on current thread" + this._contextId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "childActivatingOnThread", "SystemException");
            }
            throw new SystemException();
        }
        this._activeChildren.put(Thread.currentThread(), localActivityContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childActivatingOnThread");
        }
    }

    private void childDeActivatingFromThread(LocalActivityContext localActivityContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childDeActivatingFromThread", new Object[]{localActivityContext, this});
        }
        LocalActivityContext localActivityContext2 = (LocalActivityContext)this._activeChildren.remove(Thread.currentThread());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed context: " + localActivityContext2);
        }
    }

    public boolean isActiveOnThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isActiveOnThread", this);
        }
        boolean bl = this._associations.contains(Thread.currentThread());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isActiveOnThread", bl);
        }
        return bl;
    }

    public boolean hasChild() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasChild", this);
        }
        boolean bl = false;
        if (this._children.size() > 0) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasChild", bl);
        }
        return bl;
    }

    public String toString() {
        return "LocalActivityContext[" + this._globalId + "]";
    }

    public void suspendNoToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspendNoToken", this);
        }
        if (this._associations.contains(Thread.currentThread())) {
            LocalActivityContext localActivityContext;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "context on thread so suspend");
            }
            if ((localActivityContext = this.getActiveChild()) != null) {
                localActivityContext.suspendNoToken();
            }
            this.deactivateFromThread();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspendNoToken");
        }
    }

    public int getType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType", new Integer(this._type));
        }
        return this._type;
    }

    public PropertyGroupInfo getPropertyGroupInfo(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyGroupInfo", new Object[]{string, this});
        }
        PropertyGroupInfo propertyGroupInfo = (PropertyGroupInfo)this._propertyGroupManagers.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyGroupInfo", propertyGroupInfo);
        }
        return propertyGroupInfo;
    }

    public String getServiceName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceName", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceName", this._serviceName);
        }
        return this._serviceName;
    }

    public String getContextGroup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextGroup", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextGroup", this._contextGroup);
        }
        return this._contextGroup;
    }

    public Iterator getPropertyGroupNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyGroupNames", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyGroupNames");
        }
        return this._propertyGroups.keySet().iterator();
    }

    public Iterator getPropertyGroupManagerNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyGroupManagerNames", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyGroupManagerNames");
        }
        return this._propertyGroupManagers.keySet().iterator();
    }

    public PropertyGroupInfo getPropertyGroupManager(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyGroupManager", new Object[]{string, this});
        }
        PropertyGroupInfo propertyGroupInfo = (PropertyGroupInfo)this._propertyGroupManagers.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyGroupManager", propertyGroupInfo);
        }
        return propertyGroupInfo;
    }

    public void updatePropertyGroup(String string, PropertyGroup propertyGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updatePropertyGroup", new Object[]{string, propertyGroup, this});
        }
        this._propertyGroups.put(string, propertyGroup);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updatePropertyGroup");
        }
    }

    public HashMap getPropertyGroups() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyGroups", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyGroups", this._propertyGroups);
        }
        return this._propertyGroups;
    }

    public void setPropertyGroups(HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPropertyGroups", new Object[]{hashMap, this});
        }
        this._propertyGroups = hashMap;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPropertyGroups");
        }
    }

    public List getChildren() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildren", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildren", this._children);
        }
        return this._children;
    }

    public DistributedActivityContext getDistributedContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDistributedContext", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDistributedContext", this._distributedContext);
        }
        return this._distributedContext;
    }

    public void setDistributedContext(DistributedActivityContext distributedActivityContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDistributedContext", new Object[]{distributedActivityContext, this});
        }
        this._distributedContext = distributedActivityContext;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDistributedContext");
        }
    }

    public HLSInformation getHLSInformation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHLSInformation", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHLSInformation", this._hlsInformation);
        }
        return this._hlsInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilNotAssociatedWithAnyThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitUntilNotAssociatedWithAnyThread", this);
        }
        Vector vector = this._associations;
        synchronized (vector) {
            if (!this._associations.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Context is associated with one or more threads. Waiting");
                }
                try {
                    this._associations.wait();
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.activity.LocalActivityContext.waitUntilNotAssociatedWithAnyThread", "2927", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitUntilNotAssociatedWithAnyThread");
        }
    }
}

