/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityCoordinatorImpl;
import com.ibm.ws.activity.GlobalIdImpl;
import com.ibm.ws.activity.HLSInformation;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.ThreadContextManager;
import com.ibm.ws.activity.remote.DistributedActivityContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityCompletedException;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;

public class LocalActivityContextFactory {
    private static final TraceComponent tc = Tr.register(LocalActivityContextFactory.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    private static ThreadContextManager _threadContextManager = ThreadContextManager.instance();

    public static LocalActivityContext create(HLSInformation hLSInformation, LocalActivityContext localActivityContext, int n, boolean bl) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create", new Object[]{hLSInformation, localActivityContext, new Integer(n), bl});
        }
        LocalActivityContext localActivityContext2 = null;
        LocalActivityContext localActivityContext3 = null;
        try {
            localActivityContext2 = new LocalActivityContext(hLSInformation, n);
            localActivityContext3 = _threadContextManager.getCurrentContext(localActivityContext2._contextGroup, localActivityContext2._serviceName);
            if (localActivityContext != null) {
                localActivityContext2.addContextToParent(localActivityContext);
            }
            if (bl) {
                localActivityContext2.activateOnThread();
            }
            localActivityContext2.createPGs(localActivityContext3);
            if (!localActivityContext2._clientProcess) {
                localActivityContext2.driveChildBegin();
            }
        }
        catch (SystemException systemException) {
            FFDCFilter.processException(systemException, "com.ibm.ws.activity.LocalActivityContextFactory.create", "71");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Rethrow SystemException - an unexpected error occured creating the context");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "create", systemException);
            }
            throw systemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.activity.LocalActivityContextFactory.create", "78");
            Object[] objectArray = new Object[]{"create", "com.ibm.ws.activity.LocalActivityContext", exception};
            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Convert Exception to SystemException - an unexpected error occured activating the context");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "create", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create", localActivityContext2);
        }
        return localActivityContext2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalActivityContext create(DistributedActivityContext distributedActivityContext, String string, String string2, int n, int n2, GlobalIdImpl globalIdImpl, HLSInformation hLSInformation, LocalActivityContext localActivityContext) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create", new Object[]{distributedActivityContext, string, string2, new Integer(n), new Integer(n2), globalIdImpl, hLSInformation, localActivityContext});
        }
        LocalActivityContext localActivityContext2 = new LocalActivityContext(distributedActivityContext, string, string2, n, n2, globalIdImpl, hLSInformation);
        localActivityContext2.addContextToParent(_threadContextManager.getCurrentContext(localActivityContext2.getContextGroup()));
        try {
            localActivityContext2.activateOnThread();
            localActivityContext2.driveResumedOnPGs();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "create", localActivityContext2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create", localActivityContext2);
        }
        return localActivityContext2;
    }

    public static LocalActivityContext recreate(HLSInformation hLSInformation, LocalActivityContext localActivityContext, int n, boolean bl, GlobalIdImpl globalIdImpl, RecoverableUnit recoverableUnit) throws ActivityCompletedException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recreate", new Object[]{hLSInformation, localActivityContext, new Integer(n), bl, globalIdImpl, recoverableUnit});
        }
        LocalActivityContext localActivityContext2 = null;
        LocalActivityContext localActivityContext3 = null;
        try {
            localActivityContext2 = new LocalActivityContext(hLSInformation, n, globalIdImpl);
            if (recoverableUnit != null) {
                new DistributedActivityContext(localActivityContext2);
            }
            if (bl) {
                localActivityContext3 = _threadContextManager.getCurrentContext(localActivityContext2._contextGroup, localActivityContext2._serviceName);
            } else if (localActivityContext != null) {
                localActivityContext3 = localActivityContext.getCurrentContext(localActivityContext2._serviceName);
            }
            if (localActivityContext != null) {
                localActivityContext2.addContextToParent(localActivityContext);
            }
            if (bl) {
                localActivityContext2.activateOnThread();
            }
            localActivityContext2._localCoordinator = new ActivityCoordinatorImpl(recoverableUnit, localActivityContext2._serviceManager, localActivityContext2, hLSInformation.getRecoveryLog(), hLSInformation);
            localActivityContext2.recreatePGs(localActivityContext3);
        }
        catch (ActivityCompletedException activityCompletedException) {
            FFDCFilter.processException(activityCompletedException, "com.ibm.ws.activity.LocalActivityContextFactory.recreate", "213");
            try {
                localActivityContext2.completeLocal();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.activity.LocalActivityContextFactory.recreate", "225");
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Rethrow ActivityCompleted");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recreate", (Object)activityCompletedException);
            }
            throw activityCompletedException;
        }
        catch (SystemException systemException) {
            FFDCFilter.processException(systemException, "com.ibm.ws.activity.LocalActivityContextFactory.recreate", "234");
            try {
                localActivityContext2.completeLocal();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.activity.LocalActivityContextFactory.recreate", "246");
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Rethrow SystemException - an unexpected error occured creating the context");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recreate", systemException);
            }
            throw systemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.activity.LocalActivityContextFactory.recreate", "255");
            try {
                localActivityContext2.completeLocal();
            }
            catch (Exception exception2) {
                FFDCFilter.processException(exception2, "com.ibm.ws.activity.LocalActivityContextFactory.recreate", "266");
            }
            Object[] objectArray = new Object[]{"recreate", "com.ibm.ws.activity.LocalActivityContext", exception};
            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Convert Exception to SystemException - an unexpected error occured activating the context");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recreate", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recreate", localActivityContext2);
        }
        return localActivityContext2;
    }
}

