/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.coordination.Action;
import java.util.ArrayList;
import java.util.List;

public class Semaphore {
    private static final TraceComponent tc = Tr.register(Semaphore.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    private int _count;
    private List _actions = new ArrayList();

    public synchronized void increment() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "increment", this);
        }
        ++this._count;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_count = " + this._count);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "increment");
        }
    }

    public synchronized void decrement() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decrement", this);
        }
        --this._count;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_count = " + this._count);
        }
        if (this._count <= 0) {
            this.notify();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decrement");
        }
    }

    public synchronized void force() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "force", this);
        }
        this.notify();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "force");
        }
    }

    public synchronized void externalWait(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "externalWait", new Object[]{new Long(l), this});
        }
        if (this._count > 0) {
            boolean bl = false;
            long l2 = System.currentTimeMillis();
            while (!bl) {
                try {
                    this.wait(l);
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.activity.Semaphore.externalWait", "86", this);
                    long l3 = System.currentTimeMillis() - l2;
                    if (l3 < l) {
                        l -= l3;
                        continue;
                    }
                    bl = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "externalWait");
        }
    }

    public synchronized void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset", this);
        }
        this._count = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public synchronized int getCount() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCount", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCount", new Integer(this._count));
        }
        return this._count;
    }

    protected void addAction(Action action) {
        this._actions.add(action);
    }

    protected List getActions() {
        return this._actions;
    }
}

