/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityCoordinator;
import com.ibm.ws.javax.activity.ActivityInformation;
import com.ibm.ws.javax.activity.CoordinationInformation;
import com.ibm.ws.javax.activity.GlobalId;
import com.ibm.ws.javax.activity.Outcome;
import com.ibm.ws.javax.activity.Signal;
import com.ibm.ws.javax.activity.SignalSetActiveException;
import com.ibm.ws.javax.activity.SignalSetInactiveException;
import com.ibm.ws.javax.activity.coordination.SubordinateSignalSet;
import org.omg.CORBA.Any;

public class SynchronizationSignalSet
implements SubordinateSignalSet {
    private static final TraceComponent tc = Tr.register(SynchronizationSignalSet.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    public static final String _name = "org.omg.CosActivity.Synchronization";
    public static final String _preCompSignal = "preCompletion";
    public static final String _postCompSignal = "postCompletion";
    private int _completionStatus;
    private boolean _subordinateFlag;
    private boolean _outcomeSuccess;
    private GlobalId _globalId;
    private Outcome _finalOutcome;
    private Any _defaultAny = null;
    private int _thisStage;
    private final int _stageNull = 0;
    private final int _stageBegin = 1;
    private final int _stagePreCompletion = 2;
    private final int _stagePostCompletion = 3;

    public SynchronizationSignalSet(GlobalId globalId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SynchronizationSignalSet", globalId);
        }
        this._thisStage = 0;
        this._globalId = globalId;
        this._completionStatus = -1;
        this._subordinateFlag = false;
        this._outcomeSuccess = true;
        this._defaultAny = ActivityService.getORB().create_any();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SynchronizationSignalSet");
        }
    }

    public String getSignalSetName() {
        return _name;
    }

    public Signal getSignal() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignal", this);
        }
        String string = null;
        Signal signal = null;
        if (this._subordinateFlag) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getSignal() called by subordinate coordinator");
            }
            signal = null;
        } else {
            switch (this._thisStage) {
                case 1: {
                    this._thisStage = 2;
                    string = _preCompSignal;
                    signal = new Signal(string, _name, new ActivityInformation(this._globalId, this._completionStatus));
                    break;
                }
                case 2: {
                    this._thisStage = 3;
                    string = _postCompSignal;
                    signal = new Signal(string, _name, new ActivityInformation(this._globalId, this._completionStatus, this._finalOutcome));
                    break;
                }
                default: {
                    signal = null;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignal", signal);
        }
        return signal;
    }

    public void setSignal(Signal signal) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignal", new Object[]{signal, this});
        }
        try {
            ActivityInformation activityInformation = (ActivityInformation)signal.getExtendedValue();
            this._completionStatus = activityInformation.getCompletionStatus();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.SynchronizationSignalSet.setSignal", "191", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Exception caught: " + exception.toString());
            }
            Object[] objectArray = new Object[]{"setSignal", "com.ibm.ws.activity.SynchronizationSignalSet", exception};
            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
        }
        this._subordinateFlag = true;
        this._thisStage = 1;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignal");
        }
    }

    public CoordinationInformation setResponse(Outcome outcome) throws SignalSetInactiveException {
        boolean bl;
        boolean bl2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setResponse", new Object[]{outcome, this});
        }
        if (this._thisStage == 0) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "SignalSetInactiveException thrown");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setResponse", "SignalSetInactiveException");
            }
            throw new SignalSetInactiveException();
        }
        String string = outcome.getName();
        if (string.equals("preCompletionSuccess") || string.equals("org.omg.CosActivity.preCompletionSuccess") || string.equals("org.omg.preCompletionSuccess")) {
            bl2 = true;
            bl = false;
        } else if (string.equals("preCompletionFailed") || string.equals("org.omg.CosActivity.preCompletionFailed") || string.equals("org.omg.preCompletionFailed")) {
            bl2 = true;
            bl = true;
            this._completionStatus = 2;
            this._outcomeSuccess = false;
        } else {
            bl2 = true;
            bl = true;
            this._completionStatus = 2;
        }
        CoordinationInformation coordinationInformation = new CoordinationInformation(bl2, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setResponse", coordinationInformation);
        }
        return coordinationInformation;
    }

    public Outcome getOutcome() throws SignalSetActiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutcome", this);
        }
        if (this._thisStage == 0) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "SignalSetActiveException thrown");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOutcome", "SignalSetActiveException");
            }
            throw new SignalSetActiveException();
        }
        Outcome outcome = this._outcomeSuccess ? new Outcome("preCompletionSuccess", this._defaultAny) : new Outcome("preCompletionFailed", this._defaultAny);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutcome", outcome);
        }
        return outcome;
    }

    public Outcome getCurrentOutcome() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentOutcome", this);
        }
        Outcome outcome = this._outcomeSuccess ? new Outcome("preCompletionSuccess", this._defaultAny) : new Outcome("preCompletionFailed", this._defaultAny);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentOutcome", outcome);
        }
        return outcome;
    }

    public void setCompletionStatus(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCompletionStatus", new Object[]{new Integer(n), new Integer(n2), this});
        }
        if (this._thisStage == 0) {
            this._completionStatus = n;
            this._thisStage = this._completionStatus == 0 ? 1 : 2;
        } else if (this._completionStatus != 2) {
            this._completionStatus = n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCompletionStatus");
        }
    }

    public int getCompletionStatus() throws SignalSetActiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompletionStatus", this);
        }
        if (this._thisStage < 2) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "SignalSetActiveException thrown");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCompletionStatus", "SignalSetActiveException");
            }
            throw new SignalSetActiveException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompletionStatus", new Integer(this._completionStatus));
        }
        return this._completionStatus;
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy", this);
        }
        this._globalId = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void setFinalOutcome(Outcome outcome) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFinalOutcome", new Object[]{outcome, this});
        }
        this._finalOutcome = outcome;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFinalOutcome");
        }
    }

    public void setActivityCoordinator(ActivityCoordinator activityCoordinator) throws SignalSetActiveException {
    }
}

