/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityTokenImpl;
import com.ibm.ws.activity.GlobalIdImpl;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.GlobalId;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.util.WSThreadLocal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public class ThreadContextManager {
    private static final TraceComponent tc = Tr.register(ThreadContextManager.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    private WSThreadLocal _threadContextMap = new WSThreadLocal();
    private HashMap _contextGroupMap = new HashMap();
    private Hashtable globalIdContextMap = new Hashtable();
    private WSThreadLocal threadActivityTokenMap = new WSThreadLocal();
    private HashMap _foreignIdToGlobaIdMap = new HashMap();
    private HashMap _globalIdToForeignIdMap = new HashMap();
    private static ThreadContextManager _instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadContextManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ThreadContextManager");
        }
        HashMap hashMap = this._contextGroupMap;
        synchronized (hashMap) {
            this._contextGroupMap.put(new String("default"), this._threadContextMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ThreadContextManager");
        }
    }

    public static synchronized ThreadContextManager instance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "instance");
        }
        if (_instance == null) {
            _instance = new ThreadContextManager();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "instance", _instance);
        }
        return _instance;
    }

    public LocalActivityContext getCurrentContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentContext", this);
        }
        LocalActivityContext localActivityContext = (LocalActivityContext)this._threadContextMap.get();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentContext", localActivityContext);
        }
        return localActivityContext;
    }

    public LocalActivityContext getTopContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTopContext", this);
        }
        LocalActivityContext localActivityContext = null;
        LocalActivityContext localActivityContext2 = this.getCurrentContext();
        if (localActivityContext2 != null) {
            localActivityContext = localActivityContext2.getTopContext();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTopContext", localActivityContext);
        }
        return localActivityContext;
    }

    public void addContextToThread(LocalActivityContext localActivityContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addContextToThread", new Object[]{localActivityContext, this});
        }
        this._threadContextMap.set(localActivityContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addContextToThread");
        }
    }

    public void removeContextFromThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeContextFromThread", this);
        }
        LocalActivityContext localActivityContext = (LocalActivityContext)this._threadContextMap.get();
        LocalActivityContext localActivityContext2 = null;
        if (localActivityContext != null) {
            localActivityContext2 = localActivityContext.getParentContext();
        }
        this._threadContextMap.set(localActivityContext2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeContextFromThread");
        }
    }

    public LocalActivityContext getCurrentContext(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentContext", new Object[]{string, this});
        }
        LocalActivityContext localActivityContext = null;
        WSThreadLocal wSThreadLocal = (WSThreadLocal)this._contextGroupMap.get(string);
        if (wSThreadLocal != null) {
            localActivityContext = (LocalActivityContext)wSThreadLocal.get();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentContext", localActivityContext);
        }
        return localActivityContext;
    }

    public LocalActivityContext getCurrentContext(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentContext", new Object[]{string, string2, this});
        }
        LocalActivityContext localActivityContext = this.getCurrentContext(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentContext", localActivityContext);
        }
        return localActivityContext;
    }

    public LocalActivityContext getTopContext(String string) {
        LocalActivityContext localActivityContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTopContext", new Object[]{string, this});
        }
        LocalActivityContext localActivityContext2 = null;
        WSThreadLocal wSThreadLocal = (WSThreadLocal)this._contextGroupMap.get(string);
        if (wSThreadLocal != null && (localActivityContext = (LocalActivityContext)wSThreadLocal.get()) != null) {
            localActivityContext2 = localActivityContext.getTopContext();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTopContext", localActivityContext2);
        }
        return localActivityContext2;
    }

    public synchronized void addContextToThread(String string, LocalActivityContext localActivityContext) {
        WSThreadLocal wSThreadLocal;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addContextToThread", new Object[]{string, localActivityContext, this});
        }
        if ((wSThreadLocal = (WSThreadLocal)this._contextGroupMap.get(string)) == null) {
            wSThreadLocal = new WSThreadLocal();
            this._contextGroupMap.put(string, wSThreadLocal);
        }
        wSThreadLocal.set(localActivityContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addContextToThread");
        }
    }

    public void removeContextFromThread(String string) {
        WSThreadLocal wSThreadLocal;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeContextFromThread", new Object[]{string, this});
        }
        if ((wSThreadLocal = (WSThreadLocal)this._contextGroupMap.get(string)) != null) {
            LocalActivityContext localActivityContext = (LocalActivityContext)wSThreadLocal.get();
            LocalActivityContext localActivityContext2 = null;
            if (localActivityContext != null) {
                localActivityContext2 = localActivityContext.getParentContext();
            }
            wSThreadLocal.set(localActivityContext2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeContextFromThread");
        }
    }

    public ActivityTokenImpl getRootActivityToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRootActivityToken", this);
        }
        ActivityTokenImpl activityTokenImpl = null;
        ActivityTokenImpl activityTokenImpl2 = null;
        Iterator iterator = this._contextGroupMap.values().iterator();
        while (iterator.hasNext()) {
            WSThreadLocal wSThreadLocal = (WSThreadLocal)iterator.next();
            LocalActivityContext localActivityContext = (LocalActivityContext)wSThreadLocal.get();
            if (localActivityContext == null) continue;
            LocalActivityContext localActivityContext2 = localActivityContext.getTopContext();
            activityTokenImpl2 = localActivityContext2.getContextInfo();
            if (activityTokenImpl != null) {
                activityTokenImpl.link(activityTokenImpl2);
                continue;
            }
            activityTokenImpl = activityTokenImpl2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRootActivityToken", activityTokenImpl);
        }
        return activityTokenImpl;
    }

    public ActivityTokenImpl suspendAllContexts() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspendAllContexts", this);
        }
        ActivityTokenImpl activityTokenImpl = null;
        ActivityTokenImpl activityTokenImpl2 = null;
        Iterator iterator = this._contextGroupMap.values().iterator();
        while (iterator.hasNext()) {
            WSThreadLocal wSThreadLocal = (WSThreadLocal)iterator.next();
            LocalActivityContext localActivityContext = (LocalActivityContext)wSThreadLocal.get();
            if (localActivityContext == null) continue;
            LocalActivityContext localActivityContext2 = localActivityContext.getTopContext();
            try {
                activityTokenImpl2 = localActivityContext2.suspend();
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.ThreadContextManager.suspendAllContexts", "593", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "SystemException caught suspending top context. Rethrowing.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "suspendAllContexts", systemException);
                }
                throw systemException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.ThreadContextManager.suspendAllContexts", "599", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected exception caught suspending top context. Throwing SystemException. ", exception);
                }
                SystemException systemException = new SystemException();
                systemException.initCause(exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "suspendAllContexts", systemException);
                }
                throw systemException;
            }
            if (activityTokenImpl != null) {
                activityTokenImpl.link(activityTokenImpl2);
                continue;
            }
            activityTokenImpl = activityTokenImpl2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspendAllContexts", activityTokenImpl);
        }
        return activityTokenImpl;
    }

    public boolean anyCurrentContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "anyCurrentContext", this);
        }
        boolean bl = false;
        LocalActivityContext localActivityContext = null;
        Iterator iterator = this._contextGroupMap.values().iterator();
        while (iterator.hasNext()) {
            WSThreadLocal wSThreadLocal = (WSThreadLocal)iterator.next();
            localActivityContext = (LocalActivityContext)wSThreadLocal.get();
            if (localActivityContext == null) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "anyCurrentContext", bl);
        }
        return bl;
    }

    public int getNumActiveContexts() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNumActiveContexts", this);
        }
        int n = 0;
        Iterator iterator = this._contextGroupMap.values().iterator();
        while (iterator.hasNext()) {
            WSThreadLocal wSThreadLocal = (WSThreadLocal)iterator.next();
            for (LocalActivityContext localActivityContext = (LocalActivityContext)wSThreadLocal.get(); localActivityContext != null; localActivityContext = localActivityContext.getParentContext()) {
                ++n;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNumActiveContexts", new Integer(n));
        }
        return n;
    }

    public void registerContextByGlobalId(GlobalId globalId, LocalActivityContext localActivityContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerContextByGlobalId", new Object[]{globalId, localActivityContext, this});
        }
        this.globalIdContextMap.put(globalId, localActivityContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerContextByGlobalId");
        }
    }

    public void unregisterContextByGlobalId(GlobalId globalId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterContextByGlobalId", new Object[]{globalId, this});
        }
        this.globalIdContextMap.remove(globalId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterContextByGlobalId");
        }
    }

    public LocalActivityContext getContextFromGlobalId(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextFromGlobalId", new Object[]{byArray, this});
        }
        GlobalIdImpl globalIdImpl = new GlobalIdImpl(byArray);
        LocalActivityContext localActivityContext = (LocalActivityContext)this.globalIdContextMap.get(globalIdImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextFromGlobalId", localActivityContext);
        }
        return localActivityContext;
    }

    public LocalActivityContext getContextFromGlobalId(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextFromGlobalId", new Object[]{string, this});
        }
        GlobalIdImpl globalIdImpl = new GlobalIdImpl(string);
        LocalActivityContext localActivityContext = (LocalActivityContext)this.globalIdContextMap.get(globalIdImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextFromGlobalId", localActivityContext);
        }
        return localActivityContext;
    }

    public void addToThreadActivityTokenMap(ActivityTokenImpl activityTokenImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToThreadActivityTokenMap", new Object[]{activityTokenImpl, this});
        }
        this.threadActivityTokenMap.set(activityTokenImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToThreadActivityTokenMap");
        }
    }

    public ActivityTokenImpl removeFromThreadActivityTokenMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFromThreadActivityTokenMap", this);
        }
        ActivityTokenImpl activityTokenImpl = (ActivityTokenImpl)this.threadActivityTokenMap.get();
        this.threadActivityTokenMap.set((Object)null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFromThreadActivityTokenMap", activityTokenImpl);
        }
        return activityTokenImpl;
    }

    public void cleanThread() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanThread", this);
        }
        Iterator iterator = this._contextGroupMap.values().iterator();
        while (iterator.hasNext()) {
            WSThreadLocal wSThreadLocal = (WSThreadLocal)iterator.next();
            LocalActivityContext localActivityContext = (LocalActivityContext)wSThreadLocal.get();
            while (localActivityContext != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cleaning context:" + localActivityContext);
                }
                localActivityContext.cleanFromThread();
                localActivityContext = (LocalActivityContext)wSThreadLocal.get();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanThread");
        }
    }

    public String getForeignIdForGlobalId(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getForeignIdForGlobalId", new Object[]{string, this});
        }
        String string2 = (String)this._globalIdToForeignIdMap.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getForeignIdForGlobalId", string2);
        }
        return string2;
    }

    public String getGlobalIdForForeignId(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGlobalIdForForeignId", new Object[]{string, this});
        }
        String string2 = (String)this._foreignIdToGlobaIdMap.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGlobalIdForForeignId", string2);
        }
        return string2;
    }

    public void addForeignIdMapping(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addForeignIdMapping", new Object[]{string, string2, this});
        }
        this._foreignIdToGlobaIdMap.put(string, string2);
        this._globalIdToForeignIdMap.put(string2, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addForeignIdMapping");
        }
    }

    public void removeForeignIdMapping(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeForeignIdMapping", new Object[]{string, this});
        }
        String string2 = (String)this._globalIdToForeignIdMap.get(string);
        this._foreignIdToGlobaIdMap.remove(string2);
        this._globalIdToForeignIdMap.remove(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeForeignIdMapping");
        }
    }
}

