/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityCoordinatorImpl;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.activity.ActivityTokenImpl;
import com.ibm.ws.activity.GlobalIdImpl;
import com.ibm.ws.activity.HLSInformation;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.LocalActivityContextFactory;
import com.ibm.ws.activity.PropertyGroupInfo;
import com.ibm.ws.activity.ThreadContextManager;
import com.ibm.ws.activity.WebSphereUserActivity;
import com.ibm.ws.activity.remote.DistributedActivityContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityCompletedException;
import com.ibm.ws.javax.activity.ActivityCoordinator;
import com.ibm.ws.javax.activity.ActivityNotProcessedException;
import com.ibm.ws.javax.activity.ActivityPendingException;
import com.ibm.ws.javax.activity.ContextPendingException;
import com.ibm.ws.javax.activity.GlobalId;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.javax.activity.InvalidStateException;
import com.ibm.ws.javax.activity.NoActivityException;
import com.ibm.ws.javax.activity.NoImplementException;
import com.ibm.ws.javax.activity.NotOriginatorException;
import com.ibm.ws.javax.activity.Outcome;
import com.ibm.ws.javax.activity.PropertyGroupUnknownException;
import com.ibm.ws.javax.activity.ServiceAlreadyRegisteredException;
import com.ibm.ws.javax.activity.ServiceInformation;
import com.ibm.ws.javax.activity.ServiceNotRegisteredException;
import com.ibm.ws.javax.activity.SignalSetUnknownException;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.javax.activity.TimeoutRangeException;
import com.ibm.ws.javax.activity.coordination.ServiceManager;
import com.ibm.ws.javax.activity.propertygroup.PropertyGroup;
import java.util.Hashtable;

public abstract class UserActivityImpl
implements WebSphereUserActivity {
    private static final TraceComponent tc = Tr.register(UserActivityImpl.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    protected static final Hashtable registeredHLSInfos = new Hashtable();
    protected static int _defaultActivityServiceTimeout = 600;
    protected static final ThreadContextManager _threadContextManager = ThreadContextManager.instance();
    protected boolean _serviceRegistered;
    protected HLSInformation _hlsInfo;
    protected int _currentServiceTimeout = 0;

    protected UserActivityImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UserActivityImpl");
        }
        this._serviceRegistered = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UserActivityImpl");
        }
    }

    public void begin(int n) throws InvalidStateException, ServiceNotRegisteredException, TimeoutRangeException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "begin", new Object[]{new Integer(n), this});
        }
        if (n < -1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "begin", "TimeoutRangeException");
            }
            throw new TimeoutRangeException();
        }
        if (!this._serviceRegistered) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "begin", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup());
        if (localActivityContext != null && localActivityContext.getCompletionStatus() == 2) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "begin", "InvalidStateException");
            }
            throw new InvalidStateException();
        }
        int n2 = n != 0 ? n : (this._currentServiceTimeout != 0 ? this._currentServiceTimeout : _defaultActivityServiceTimeout);
        try {
            LocalActivityContextFactory.create(this._hlsInfo, localActivityContext, n2, true);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.UserActivityImpl.begin", "190", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "begin", systemException);
            }
            throw systemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.UserActivityImpl.begin", "198", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexcepted exception caught creating LocalActivityContext", exception);
            }
            Tr.error(tc, "ERR_UNEXP_EXCPN", new Object[]{"begin", "com.ibm.ws.activity.UserActivityImpl", exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "begin", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "begin");
        }
    }

    public Outcome complete() throws NoActivityException, ActivityPendingException, ContextPendingException, NotOriginatorException, SystemException, ServiceNotRegisteredException, ActivityNotProcessedException {
        Outcome outcome;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "complete", this);
        }
        if (!this._serviceRegistered) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup(), this._hlsInfo.getServiceName());
        if (localActivityContext == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", "NoActivityException");
            }
            throw new NoActivityException();
        }
        try {
            DistributedActivityContext distributedActivityContext = localActivityContext.getDistributedContext();
            if (distributedActivityContext != null) {
                outcome = distributedActivityContext.complete();
            } else {
                ActivityTokenImpl activityTokenImpl = localActivityContext.completionPreinvoke();
                outcome = localActivityContext.complete(activityTokenImpl);
            }
        }
        catch (ContextPendingException contextPendingException) {
            FFDCFilter.processException((Throwable)contextPendingException, "com.ibm.ws.activity.UserActivityImpl.complete", "295", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", contextPendingException);
            }
            throw contextPendingException;
        }
        catch (ActivityPendingException activityPendingException) {
            FFDCFilter.processException((Throwable)activityPendingException, "com.ibm.ws.activity.UserActivityImpl.complete", "304", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", activityPendingException);
            }
            throw activityPendingException;
        }
        catch (NotOriginatorException notOriginatorException) {
            FFDCFilter.processException((Throwable)notOriginatorException, "com.ibm.ws.activity.UserActivityImpl.complete", "312", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", notOriginatorException);
            }
            throw notOriginatorException;
        }
        catch (ActivityNotProcessedException activityNotProcessedException) {
            FFDCFilter.processException((Throwable)activityNotProcessedException, "com.ibm.ws.activity.UserActivityImpl.complete", "319", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", activityNotProcessedException);
            }
            throw activityNotProcessedException;
        }
        catch (NoActivityException noActivityException) {
            FFDCFilter.processException((Throwable)noActivityException, "com.ibm.ws.activity.UserActivityImpl.complete", "322", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", noActivityException);
            }
            throw noActivityException;
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.UserActivityImpl.complete", "325", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", systemException);
            }
            throw systemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.UserActivityImpl.complete", "333", this);
            Tr.error(tc, "ERR_UNEXP_EXCPN", new Object[]{"complete", "com.ibm.ws.activity.UserActivityImpl", exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "complete", outcome);
        }
        return outcome;
    }

    public Outcome completeWithStatus(int n) throws NoActivityException, ActivityPendingException, ContextPendingException, NotOriginatorException, ActivityNotProcessedException, InvalidStateException, SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeWithStatus", new Object[]{new Integer(n), this});
        }
        if (!this._serviceRegistered) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No ServiceManager registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeWithStatus", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        if (n != 0 && n != 1 && n != 2) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeWithStatus", "InvalidStateException");
            }
            throw new InvalidStateException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup(), this._hlsInfo.getServiceName());
        if (localActivityContext == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeWithStatus", "NoActivityException");
            }
            throw new NoActivityException();
        }
        try {
            localActivityContext.setCompletionStatus(n);
        }
        catch (InvalidStateException invalidStateException) {
            FFDCFilter.processException((Throwable)invalidStateException, "com.ibm.ws.activity.UserActivityImpl.completeWithStatus", "438", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeWithStatus", invalidStateException);
            }
            throw invalidStateException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.UserActivityImpl.completeWithStatus", "444", this);
            Tr.error(tc, "ERR_UNEXP_EXCPN", new Object[]{"complete", "com.ibm.ws.activity.UserActivityImpl", exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeWithStatus", "SystemException");
            }
            throw new SystemException();
        }
        Outcome outcome = null;
        try {
            DistributedActivityContext distributedActivityContext = localActivityContext.getDistributedContext();
            if (distributedActivityContext != null) {
                outcome = distributedActivityContext.complete();
            } else {
                ActivityTokenImpl activityTokenImpl = localActivityContext.completionPreinvoke();
                outcome = localActivityContext.complete(activityTokenImpl);
            }
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.activity.UserActivityImpl.completeWithStatus", "502", this);
            Tr.error(tc, "ERR_UNEXP_EXCPN", new Object[]{"completeWithStatus", "com.ibm.ws.activity.UserActivityImpl", runtimeException});
            SystemException systemException = new SystemException();
            systemException.initCause(runtimeException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeWithStatus", systemException);
            }
            throw systemException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeWithStatus", outcome);
            }
        }
        return outcome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompletionStatus(int n) throws NoActivityException, InvalidStateException, SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCompletionStatus", new Object[]{new Integer(n), this});
        }
        if (!this._serviceRegistered) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setCompletionStatus", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        if (n != 0 && n != 1 && n != 2) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setCompletionStatus", "InvalidStateException");
            }
            throw new InvalidStateException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup(), this._hlsInfo.getServiceName());
        if (localActivityContext == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setCompletionStatus", "NoActivityException");
            }
            throw new NoActivityException();
        }
        try {
            localActivityContext.setCompletionStatus(n);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setCompletionStatus");
            }
        }
    }

    public int getCompletionStatus() throws NoActivityException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompletionStatus", this);
        }
        if (!this._serviceRegistered) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCompletionStatus", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup(), this._hlsInfo.getServiceName());
        if (localActivityContext == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCompletionStatus", "NoActivityException");
            }
            throw new NoActivityException();
        }
        int n = localActivityContext.getCompletionStatus();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompletionStatus", new Integer(n));
        }
        return n;
    }

    public int getStatus() throws ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatus", this);
        }
        if (!this._serviceRegistered) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatus", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup(), this._hlsInfo.getServiceName());
        int n = localActivityContext == null ? 3 : localActivityContext.getStatus();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatus", new Integer(n));
        }
        return n;
    }

    public String getName() throws ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getName", this);
        }
        if (!this._serviceRegistered) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getName", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        String string = null;
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup(), this._hlsInfo.getServiceName());
        if (localActivityContext != null) {
            string = localActivityContext.getName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getName", string);
        }
        return string;
    }

    public void setTimeout(int n) throws TimeoutRangeException, SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTimeout", new Object[]{new Integer(n), this});
        }
        if (!this._serviceRegistered) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setTimeout", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        if (n < -1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setTimeout", "TimeoutRangeException");
            }
            throw new TimeoutRangeException();
        }
        this._currentServiceTimeout = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTimeout");
        }
    }

    public int getTimeout() throws SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimeout", this);
        }
        if (!this._serviceRegistered) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTimeout", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        int n = this._currentServiceTimeout != 0 ? this._currentServiceTimeout : _defaultActivityServiceTimeout;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimeout", new Integer(n));
        }
        return n;
    }

    public GlobalId getGlobalId() throws SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGlobalId", this);
        }
        if (!this._serviceRegistered) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGlobalId", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        GlobalIdImpl globalIdImpl = null;
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup(), this._hlsInfo.getServiceName());
        if (localActivityContext != null) {
            globalIdImpl = localActivityContext.getGlobalId();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGlobalId", globalIdImpl);
        }
        return globalIdImpl;
    }

    public Outcome broadcast(String string) throws NoActivityException, SignalSetUnknownException, InvalidActivityException, SystemException, ServiceNotRegisteredException, ActivityNotProcessedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "broadcast", new Object[]{string, this});
        }
        if (!this._serviceRegistered) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No service manager registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "broadcast", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup(), this._hlsInfo.getServiceName());
        if (localActivityContext == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "broadcast", "NoActivityException");
            }
            throw new NoActivityException();
        }
        Outcome outcome = null;
        try {
            outcome = localActivityContext.broadcast(string);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.activity.UserActivityImpl.broadcast", "831", this);
            SystemException systemException = new SystemException();
            systemException.initCause(runtimeException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "broadcast", systemException);
            }
            throw systemException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "broadcast", outcome);
            }
        }
        return outcome;
    }

    public ActivityCoordinator getCoordinator() throws NoImplementException, SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCoordinator", this);
        }
        if (!this._serviceRegistered) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No service manager registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCoordinator", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        if (!ActivityService.instance().isServerProcess()) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Illegal attempt to access coordinator in client. Throwing NoImplementException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCoordinator", "NoImplementException");
            }
            throw new NoImplementException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup(), this._hlsInfo.getServiceName());
        ActivityCoordinatorImpl activityCoordinatorImpl = null;
        if (localActivityContext != null) {
            activityCoordinatorImpl = localActivityContext.getCoordinator();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCoordinator", activityCoordinatorImpl);
        }
        return activityCoordinatorImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityCoordinator getParentCoordinator() throws NoImplementException, SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentCoordinator", this);
        }
        if (!this._serviceRegistered) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getParentCoordinator", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        if (!ActivityService.instance().isServerProcess()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getParentCoordinator", "NoImplementException");
            }
            throw new NoImplementException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup(), this._hlsInfo.getServiceName());
        ActivityCoordinatorImpl activityCoordinatorImpl = null;
        try {
            if (localActivityContext != null) {
                activityCoordinatorImpl = localActivityContext.getParentCoordinator();
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getParentCoordinator", activityCoordinatorImpl);
            }
        }
        return activityCoordinatorImpl;
    }

    public PropertyGroup getPropertyGroup(String string) throws PropertyGroupUnknownException, NoActivityException, SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyGroup", new Object[]{string, this});
        }
        if (!this._serviceRegistered) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertyGroup", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertyGroup", "PropertyGroupUnknownException");
            }
            throw new PropertyGroupUnknownException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup(), this._hlsInfo.getServiceName());
        if (localActivityContext == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertyGroup", "NoActivityException");
            }
            throw new NoActivityException();
        }
        PropertyGroup propertyGroup = localActivityContext.getPropertyGroup(string);
        if (propertyGroup == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertyGroup", "PropertyGroupUnknownException");
            }
            throw new PropertyGroupUnknownException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyGroup", propertyGroup);
        }
        return propertyGroup;
    }

    public PropertyGroup getPG(String string) throws ServiceNotRegisteredException, PropertyGroupUnknownException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPG", new Object[]{string, this});
        }
        PropertyGroup propertyGroup = null;
        if (!this._serviceRegistered) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No service manager registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPG", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPG", "PropertyGroupUnknownException");
            }
            throw new PropertyGroupUnknownException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup(), this._hlsInfo.getServiceName());
        if (localActivityContext != null && (propertyGroup = localActivityContext.getPropertyGroup(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPG", "PropertyGroupUnknownException");
            }
            throw new PropertyGroupUnknownException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPG", propertyGroup);
        }
        return propertyGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(ServiceManager serviceManager) throws PropertyGroupUnknownException, SystemException, ServiceAlreadyRegisteredException {
        boolean bl;
        String string;
        block38: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerService", new Object[]{serviceManager, this});
            }
            if (this._serviceRegistered) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerService", "ServiceAlreadyRegisteredException");
                }
                throw new ServiceAlreadyRegisteredException();
            }
            if (serviceManager == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerService", "SystemException");
                }
                throw new SystemException();
            }
            ServiceInformation serviceInformation = serviceManager.getServiceInformation();
            if (serviceInformation == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerService", "SystemException");
                }
                throw new SystemException();
            }
            string = serviceInformation.getServiceName();
            if (string == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerService", "SystemException");
                }
                throw new SystemException();
            }
            this._hlsInfo = new HLSInformation();
            try {
                this._hlsInfo.setServiceName(string);
                this._hlsInfo.setContextGroup(serviceInformation.getContextGroup());
                this._hlsInfo.setServiceManager(serviceManager);
                String[] stringArray = serviceManager.getPropertyGroupNames();
                if (stringArray == null) break block38;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (string2 == null) continue;
                    PropertyGroupInfo propertyGroupInfo = this._hlsInfo.getPropertyGroupInfo(string2);
                    if (propertyGroupInfo == null) {
                        try {
                            propertyGroupInfo = new PropertyGroupInfo(stringArray[i], serviceManager.getPropertyGroupManager(stringArray[i]));
                        }
                        catch (PropertyGroupUnknownException propertyGroupUnknownException) {
                            FFDCFilter.processException((Throwable)propertyGroupUnknownException, "com.ibm.ws.activity.UserActivityImpl.registerService", "1232", this);
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "PropertyGroupUnknownException caught. Rethrowing.");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "registerService", propertyGroupUnknownException);
                            }
                            throw propertyGroupUnknownException;
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.UserActivityImpl.registerService", "1239", this);
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Unexpected exception caught. Throwing SystemException.");
                            }
                            Tr.error(tc, "ERR_UNEXP_EXCPN", new Object[]{"registerService", "com.ibm.ws.activity.UserActivityImpl", exception});
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "registerService", "SystemException");
                            }
                            throw new SystemException();
                        }
                    }
                    this._hlsInfo.setPropertyGroupInfo(string2, propertyGroupInfo);
                }
            }
            catch (PropertyGroupUnknownException propertyGroupUnknownException) {
                FFDCFilter.processException((Throwable)propertyGroupUnknownException, "com.ibm.ws.activity.UserActivityImpl.registerService", "1293", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "PropertyGroupUnknownException caught. Rethrowing");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerService", propertyGroupUnknownException);
                }
                throw propertyGroupUnknownException;
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.UserActivityImpl.registerService", "1300", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "SystemException caught. Rethrowing");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerService", systemException);
                }
                throw systemException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.UserActivityImpl.registerService", "1307", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexception exception caught. Throwing SystemException");
                }
                Tr.error(tc, "ERR_UNEXP_EXCPN", new Object[]{"registerService", "com.ibm.ws.activity.UserActivityImpl", exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerService", "SystemException");
                }
                throw new SystemException();
            }
        }
        try {
            bl = this.initializeRecoveryLogForHLS(serviceManager, string);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.UserActivityImpl.registerService", "1423", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "registerService", systemException);
            }
            throw systemException;
        }
        if (!bl) {
            Hashtable hashtable = registeredHLSInfos;
            synchronized (hashtable) {
                if (registeredHLSInfos.get(string) == null) {
                    registeredHLSInfos.put(string, this._hlsInfo);
                }
            }
            if (ActivityService.instance().isServerProcess()) {
                this._hlsInfo.initializeServantManagers(new GlobalId[0]);
            }
        }
        this._serviceRegistered = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerService");
        }
    }

    protected abstract boolean initializeRecoveryLogForHLS(ServiceManager var1, String var2) throws SystemException;

    public ServiceManager getService() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getService", this);
        }
        ServiceManager serviceManager = null;
        if (this._serviceRegistered) {
            serviceManager = this._hlsInfo.getServiceManager();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getService", serviceManager);
        }
        return serviceManager;
    }

    protected static boolean isServiceRegistered(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServiceRegistered", string);
        }
        boolean bl = false;
        if (string != null) {
            bl = registeredHLSInfos.containsKey(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServiceRegistered", bl);
        }
        return bl;
    }

    public static HLSInformation getRegisteredService(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRegisteredService", string);
        }
        HLSInformation hLSInformation = (HLSInformation)registeredHLSInfos.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegisteredService", hLSInformation);
        }
        return hLSInformation;
    }

    public GlobalId[] recover() throws ServiceNotRegisteredException, SystemException {
        GlobalId[] globalIdArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recover", this);
        }
        if (!this._serviceRegistered) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No ServiceManager registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        try {
            globalIdArray = this.performRecovery();
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.UserActivityImpl.recover", "1586", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", systemException);
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recover", globalIdArray);
        }
        return globalIdArray;
    }

    protected abstract GlobalId[] performRecovery() throws SystemException;

    public ActivityCoordinator recreate(GlobalId globalId, GlobalId globalId2, boolean bl) throws ServiceNotRegisteredException, ActivityCompletedException, SystemException, IllegalArgumentException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recreate", new Object[]{globalId, globalId2, bl, this});
        }
        if (!this._serviceRegistered) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No ServiceManager registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recreate", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        if (globalId == null) {
            this.closeRecoveryLog();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recreate", null);
            }
            return null;
        }
        if (globalId2 != null && bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recreate", "IllegalArgumentException");
            }
            throw new IllegalArgumentException("Resume must not be true when a parentGid is provided");
        }
        try {
            this.initializeRecoveredData();
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.UserActivityImpl.recreate", "1644", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recreate", systemException);
            }
            throw systemException;
        }
        LocalActivityContext localActivityContext = _threadContextManager.getContextFromGlobalId(globalId.toBytes());
        LocalActivityContext localActivityContext2 = null;
        if (localActivityContext != null) {
            LocalActivityContext localActivityContext3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "An activity already exists with globalId " + globalId.print());
            }
            if ((object = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup())) != null) {
                if (((LocalActivityContext)object).getGlobalId().equals(localActivityContext.getGlobalId()) && !bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resume parameter does not match the activity's association with the calling thread");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "recreate", "IllegalStateException");
                    }
                    throw new IllegalStateException();
                }
            } else if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resume parameter does not match the activity's association with the calling thread");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "recreate", "IllegalStateException");
                }
                throw new IllegalStateException();
            }
            if ((localActivityContext3 = localActivityContext.getParentContext()) != null) {
                if (!localActivityContext3.getGlobalId().equals(globalId2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The existing activity has a different parent to that specified by parentGid");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "recreate", "IllegalStateException");
                    }
                    throw new IllegalStateException();
                }
            } else if (globalId2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The existing activity does not have a parent but parentGid is not null");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "recreate", "IllegalStateException");
                }
                throw new IllegalStateException();
            }
            localActivityContext2 = localActivityContext;
        } else {
            object = null;
            if (globalId2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No parentGid - parent is context on calling thread");
                }
                object = _threadContextManager.getCurrentContext(this._hlsInfo.getContextGroup());
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ParentGid provided - getting context for given gid");
                }
                if ((object = _threadContextManager.getContextFromGlobalId(globalId2.toBytes())) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The parentGid " + globalId2.print() + " does not identify an existing activity");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "recreate", "IllegalArgumentException");
                    }
                    throw new IllegalArgumentException();
                }
            }
            int n = 0;
            n = this._currentServiceTimeout != 0 ? this._currentServiceTimeout : _defaultActivityServiceTimeout;
            localActivityContext2 = this.recreateActivity((LocalActivityContext)object, n, bl, globalId);
            ActivityCoordinatorImpl activityCoordinatorImpl = localActivityContext2.getCoordinatorRef();
            activityCoordinatorImpl.connect();
            this._hlsInfo.getActionServantManager().forget(globalId);
            this._hlsInfo.getCoordinatorServantManager().forget(globalId);
            this.activityRecreated(globalId);
        }
        object = localActivityContext2.getCoordinatorRef();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recreate", object);
        }
        return object;
    }

    protected abstract void activityRecreated(GlobalId var1);

    protected abstract void initializeRecoveredData() throws SystemException;

    protected abstract void closeRecoveryLog();

    protected abstract LocalActivityContext recreateActivity(LocalActivityContext var1, int var2, boolean var3, GlobalId var4) throws SystemException, ActivityCompletedException;

    protected static Hashtable getRegisteredHLSInfos() {
        return registeredHLSInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outcome complete(GlobalId globalId) throws ServiceNotRegisteredException, NoActivityException, SystemException, ContextPendingException, NotOriginatorException, ActivityNotProcessedException, ActivityPendingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "complete", new Object[]{globalId, this});
        }
        if (!this._serviceRegistered) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No ServiceManager registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getContextFromGlobalId(globalId.toBytes());
        if (localActivityContext == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No activity found for GlobalId " + globalId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", "NoActivityException");
            }
            throw new NoActivityException();
        }
        Outcome outcome = null;
        try {
            outcome = this.completeActivity(localActivityContext);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", outcome);
            }
        }
        return outcome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outcome completeWithStatus(GlobalId globalId, int n) throws ServiceNotRegisteredException, NoActivityException, SystemException, ContextPendingException, NotOriginatorException, ActivityNotProcessedException, ActivityPendingException, InvalidStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeWithStatus", new Object[]{globalId, new Integer(n), this});
        }
        if (!this._serviceRegistered) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No ServiceManager registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeWithStatus", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getContextFromGlobalId(globalId.toBytes());
        if (localActivityContext == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No activity found for GlobalId " + globalId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeWithStatus", "NoActivityException");
            }
            throw new NoActivityException();
        }
        try {
            localActivityContext.setCompletionStatus(n);
        }
        catch (InvalidStateException invalidStateException) {
            FFDCFilter.processException((Throwable)invalidStateException, "com.ibm.ws.activity.UserActivityImpl.completeWithStatus", "2169", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "InvalidStateException caught setting completion status. Rethrowing.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeWithStatus", invalidStateException);
            }
            throw invalidStateException;
        }
        Outcome outcome = null;
        try {
            outcome = this.completeActivity(localActivityContext);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeWithStatus", outcome);
            }
        }
        return outcome;
    }

    private Outcome completeActivity(LocalActivityContext localActivityContext) throws SystemException, ContextPendingException, NotOriginatorException, ActivityNotProcessedException, ActivityPendingException, NoActivityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeActivity", new Object[]{localActivityContext, this});
        }
        Outcome outcome = null;
        ActivityTokenImpl activityTokenImpl = null;
        try {
            DistributedActivityContext distributedActivityContext;
            if (!localActivityContext.isActiveOnThread()) {
                if (_threadContextManager.anyCurrentContext()) {
                    activityTokenImpl = _threadContextManager.suspendAllContexts();
                }
                localActivityContext.resumeHierarchy();
            }
            if ((distributedActivityContext = localActivityContext.getDistributedContext()) != null) {
                outcome = distributedActivityContext.complete();
            } else {
                ActivityTokenImpl activityTokenImpl2 = localActivityContext.completionPreinvoke();
                outcome = localActivityContext.complete(activityTokenImpl2);
            }
        }
        catch (ContextPendingException contextPendingException) {
            FFDCFilter.processException((Throwable)contextPendingException, "com.ibm.ws.activity.UserActivityImpl.completeActivity", "1387", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Activity completion caught ContextPendingException", contextPendingException);
            }
            try {
                this.resumeSuspendedContexts(activityTokenImpl);
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.UserActivityImpl.completeActivity", "2148", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "SystemException caught resuming suspended contexts", systemException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "completeActivity", systemException);
                }
                throw systemException;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeActivity", contextPendingException);
            }
            throw contextPendingException;
        }
        catch (ActivityPendingException activityPendingException) {
            FFDCFilter.processException((Throwable)activityPendingException, "com.ibm.ws.activity.UserActivityImpl.completeActivity", "2161", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Activity completion caught ActivityPendingException", activityPendingException);
            }
            try {
                this.resumeSuspendedContexts(activityTokenImpl);
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.UserActivityImpl.completeActivity", "2170", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "SystemException caught resuming suspended contexts", systemException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "completeActivity", systemException);
                }
                throw systemException;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeActivity", activityPendingException);
            }
            throw activityPendingException;
        }
        catch (NotOriginatorException notOriginatorException) {
            FFDCFilter.processException((Throwable)notOriginatorException, "com.ibm.ws.activity.UserActivityImpl.completeActivity", "2181", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Activity completion caught NotOriginatorException", notOriginatorException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeActivity", notOriginatorException);
            }
            throw notOriginatorException;
        }
        catch (ActivityNotProcessedException activityNotProcessedException) {
            FFDCFilter.processException((Throwable)activityNotProcessedException, "com.ibm.ws.activity.UserActivityImpl.completeActivity", "2188", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Activity completion caught ActivityNotProcessedException", activityNotProcessedException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeActivity", activityNotProcessedException);
            }
            throw activityNotProcessedException;
        }
        catch (NoActivityException noActivityException) {
            FFDCFilter.processException((Throwable)noActivityException, "com.ibm.ws.activity.UserActivityImpl.completeActivity", "2192", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Activity completion caught NoActivityException", noActivityException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeActivity", noActivityException);
            }
            throw noActivityException;
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.UserActivityImpl.completeActivity", "2195", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Activity completion caught SystemException", systemException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeActivity", systemException);
            }
            throw systemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.UserActivityImpl.completeActivity", "2202", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Activity completion caught Exception. Throwing SystemException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeActivity", "SystemException");
            }
            throw new SystemException();
        }
        try {
            this.resumeSuspendedContexts(activityTokenImpl);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.UserActivityImpl.completeActivity", "2214", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SystemException caught resuming suspended contexts", systemException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeActivity", systemException);
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeActivity", outcome);
        }
        return outcome;
    }

    private void resumeSuspendedContexts(ActivityTokenImpl activityTokenImpl) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeSuspendedContexts", new Object[]{activityTokenImpl, this});
        }
        if (activityTokenImpl != null) {
            if (_threadContextManager.anyCurrentContext()) {
                try {
                    _threadContextManager.suspendAllContexts();
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.UserActivityImpl.resumeSuspendedContexts", "2386", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Activity completion caught SystemException. Rethrowing.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resumeSuspendedContexts", systemException);
                    }
                    throw systemException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.UserActivityImpl.resumeSuspendedContexts", "1478", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Activity completion caught Exception. Throwing SystemException.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resumeSuspendedContexts", "SystemException");
                    }
                    throw new SystemException();
                }
            }
            LocalActivityContext localActivityContext = activityTokenImpl.getContext();
            try {
                localActivityContext.resume(activityTokenImpl);
            }
            catch (InvalidActivityException invalidActivityException) {
                FFDCFilter.processException((Throwable)invalidActivityException, "com.ibm.ws.activity.UserActivityImpl.resumeSuspendedContexts", "1494", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Activity completion caught InvalidActivityException. Throwing SystemException.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resumeSuspendedContexts", "SystemException");
                }
                throw new SystemException();
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.UserActivityImpl.resumeSuspendedContexts", "1501", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Activity completion caught SystemException. Rethrowing.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resumeSuspendedContexts", systemException);
                }
                throw systemException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.UserActivityImpl.resumeSuspendedContexts", "1508", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Activity completion caught Exception. Throwing SystemException.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resumeSuspendedContexts", "SystemException");
                }
                throw new SystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeSuspendedContexts");
        }
    }

    public ActivityCoordinator getActivityCoordinator(String string) throws NoActivityException, SystemException, ServiceNotRegisteredException {
        ActivityCoordinator activityCoordinator;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActivityCoordinator", new Object[]{string, this});
        }
        if ((string2 = ThreadContextManager.instance().getGlobalIdForForeignId(string)) != null) {
            activityCoordinator = this.getActivityCoordinator(new GlobalIdImpl(string2));
        } else if (GlobalIdImpl.isValid(string)) {
            activityCoordinator = this.getActivityCoordinator(new GlobalIdImpl(string));
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getActivityCoordinator", "NoActivityException");
            }
            throw new NoActivityException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivityCoordinator", activityCoordinator);
        }
        return activityCoordinator;
    }

    public ActivityCoordinator getActivityCoordinator(GlobalId globalId) throws NoActivityException, ServiceNotRegisteredException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActivityCoordinator", new Object[]{globalId, this});
        }
        if (!this._serviceRegistered) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No ServiceManager registered. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getActivityCoordinator", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        LocalActivityContext localActivityContext = _threadContextManager.getContextFromGlobalId(globalId.toBytes());
        if (localActivityContext == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No activity found for GlobalId " + globalId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getActivityCoordinator", "NoActivityException");
            }
            throw new NoActivityException();
        }
        ActivityCoordinatorImpl activityCoordinatorImpl = null;
        if (localActivityContext != null) {
            try {
                activityCoordinatorImpl = localActivityContext.getCoordinator();
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.UserActivityImpl.getActivityCoordinator", "1531", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Activity completion caught SystemException. Rethrowing.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getActivityCoordinator", systemException);
                }
                throw systemException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivityCoordinator", activityCoordinatorImpl);
        }
        return activityCoordinatorImpl;
    }
}

