/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.PropertyGroupInfo;
import com.ibm.ws.activity.remote.CoordinatorProxy;
import com.ibm.ws.activity.remote.DistributedActivityContext;
import com.ibm.ws.javax.activity.PropertyGroupContext;
import com.ibm.ws.javax.activity.ServiceInformation;
import com.ibm.ws.javax.activity.propertygroup.PropertyGroup;
import com.ibm.ws.javax.activity.propertygroup.PropertyGroupManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ActivityContextDescriptor
implements Serializable {
    private static final TraceComponent tc = Tr.register(ActivityContextDescriptor.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    protected int _timeout = -1;
    protected String _id = null;
    protected List _propertyGroupContexts = null;
    protected String _serviceName = null;
    protected ActivityContextDescriptor _child = null;
    protected Serializable _activitySpecificData = null;
    protected String _contextGroup = null;
    protected int _type = 1;
    protected CoordinatorProxy _coordinator = null;
    protected boolean _custom = false;
    protected boolean _representsAllAncestorNodes = false;
    protected LocalActivityContext _context = null;

    protected ActivityContextDescriptor(String string, int n, String string2, String string3, int n2, CoordinatorProxy coordinatorProxy, List list, Serializable serializable, ActivityContextDescriptor activityContextDescriptor, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ActivityContextDescriptor", new Object[]{string, new Integer(n), string2, string3, new Integer(n2), coordinatorProxy, list, serializable, activityContextDescriptor, bl});
        }
        this._id = string;
        this._timeout = n;
        this._contextGroup = string2;
        this._serviceName = string3;
        this._type = n2;
        this._coordinator = coordinatorProxy;
        this._propertyGroupContexts = list;
        this._activitySpecificData = serializable;
        this._child = activityContextDescriptor;
        this._context = null;
        this._custom = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ActivityContextDescriptor", this);
        }
    }

    protected ActivityContextDescriptor(LocalActivityContext localActivityContext, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ActivityContextDescriptor", new Object[]{localActivityContext, bl, bl2});
        }
        this._context = localActivityContext;
        this._timeout = this._context.getTimeout();
        this._id = this._context.getGlobalId().print();
        this._serviceName = this._context.getServiceName();
        this._type = localActivityContext.getType();
        this._custom = bl;
        this._contextGroup = localActivityContext.getContextGroup();
        DistributedActivityContext distributedActivityContext = localActivityContext.getDistributedContext();
        if (!this._custom) {
            this.updatePropertyGroups(true);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Custom-rendered context; skipping update of property groups");
        }
        if (distributedActivityContext == null) {
            distributedActivityContext = new DistributedActivityContext(localActivityContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ActivityContextDescriptor", this);
        }
    }

    public ActivityContextDescriptor getChild() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChild", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChild", this._child);
        }
        return this._child;
    }

    public LocalActivityContext getContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContext", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContext", this._context);
        }
        return this._context;
    }

    public void setContext(LocalActivityContext localActivityContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setContext", new Object[]{localActivityContext, this});
        }
        this._context = localActivityContext;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setContext");
        }
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getId", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getId", this._id);
        }
        return this._id;
    }

    public String getServiceName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceName", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceName", this._serviceName);
        }
        return this._serviceName;
    }

    public int getTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimeout", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimeout", new Integer(this._timeout));
        }
        return this._timeout;
    }

    public List getPropertyGroups() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyGroups", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyGroups", this._propertyGroupContexts);
        }
        return this._propertyGroupContexts;
    }

    public void setPropertyGroups(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPropertyGroups", new Object[]{list, this});
        }
        this._propertyGroupContexts = list;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPropertyGroups");
        }
    }

    public String getContextGroup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextGroup", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextGroup", this._contextGroup);
        }
        return this._contextGroup;
    }

    public int getType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType", new Integer(this._type));
        }
        return this._type;
    }

    public Serializable getActivitySpecificData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActivitySpecificData", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivitySpecificData", this._activitySpecificData);
        }
        return this._activitySpecificData;
    }

    public void setCoordinator(CoordinatorProxy coordinatorProxy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCoordinator", new Object[]{coordinatorProxy, this});
        }
        this._coordinator = coordinatorProxy;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCoordinator");
        }
    }

    public CoordinatorProxy getCoordinator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCoordinator", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCoordinator", this._coordinator);
        }
        return this._coordinator;
    }

    public String viewDescriptorAsString() {
        return this.viewDescriptorAsString(0);
    }

    private String viewDescriptorAsString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "    ";
        for (int i = 0; i <= n; ++i) {
            string = string + "    ";
        }
        stringBuffer.append("\n");
        stringBuffer.append(string + "Identifier:     " + this.getId() + "\n");
        stringBuffer.append(string + "Timeout:        " + this.getTimeout() + "\n");
        stringBuffer.append(string + "Service Name:   " + this.getServiceName() + "\n");
        if (this._propertyGroupContexts != null) {
            stringBuffer.append(string + "PropertyGroups:   " + "\n");
            Iterator iterator = this._propertyGroupContexts.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(string + "    " + iterator.next());
            }
        }
        if (this._child != null) {
            stringBuffer.append(string + "Child Context:" + this._child.viewDescriptorAsString(n + 1));
        }
        if (n == 0) {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void updatePropertyGroups(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updatePropertyGroups", new Object[]{bl, this});
        }
        Iterator iterator = this._context.getPropertyGroupNames();
        this._propertyGroupContexts = new ArrayList();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PropertyGroup propertyGroup = this._context.getPropertyGroup(string);
            PropertyGroupInfo propertyGroupInfo = this._context.getPropertyGroupInfo(string);
            PropertyGroupManager propertyGroupManager = propertyGroupInfo._manager;
            PropertyGroupContext propertyGroupContext = null;
            if (bl) {
                propertyGroupContext = propertyGroupManager.marshalRequest(propertyGroup);
            } else if (propertyGroupInfo._marshalResponse) {
                propertyGroupContext = propertyGroupManager.marshalResponse(propertyGroup);
            }
            if (propertyGroupContext == null) continue;
            this._propertyGroupContexts.add(propertyGroupContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updatePropertyGroups");
        }
    }

    public static void outputDescriptorHierarchy(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Activity context hierarchy: " + ((ActivityContextDescriptor)iterator.next()).viewDescriptorAsString());
        }
    }

    protected abstract ServiceInformation getServiceInformation();

    public boolean equals(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals", new Object[]{object, this});
        }
        boolean bl = false;
        if (object == this) {
            bl = true;
        } else if (object instanceof ActivityContextDescriptor) {
            ActivityContextDescriptor activityContextDescriptor = (ActivityContextDescriptor)object;
            bl = this._id.equals(activityContextDescriptor._id);
            if (bl) {
                bl = this._child == null ? activityContextDescriptor._child == null : this._child.equals(activityContextDescriptor._child);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals", bl);
        }
        return bl;
    }

    public int hashCode() {
        int n = this._id.hashCode();
        if (this._child != null) {
            n += this._child.hashCode();
        }
        return n;
    }

    public boolean representsAllAncestorNodes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "representsAllAncestorNodes", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "representsAllAncestorNodes", this._representsAllAncestorNodes);
        }
        return this._representsAllAncestorNodes;
    }
}

