/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.activity.ActivityServiceComponentImpl;
import com.ibm.ws.activity.ActivityTokenImpl;
import com.ibm.ws.activity.GlobalIdImpl;
import com.ibm.ws.activity.HLSInformation;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.LocalActivityContextFactory;
import com.ibm.ws.activity.PropertyGroupInfo;
import com.ibm.ws.activity.ThreadContextManager;
import com.ibm.ws.activity.UserActivityImpl;
import com.ibm.ws.activity.remote.ActivityContextDescriptor;
import com.ibm.ws.activity.remote.CoordinatorProxy;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityNotProcessedException;
import com.ibm.ws.javax.activity.ActivityPendingException;
import com.ibm.ws.javax.activity.ContextPendingException;
import com.ibm.ws.javax.activity.GlobalId;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.javax.activity.NoActivityException;
import com.ibm.ws.javax.activity.NotOriginatorException;
import com.ibm.ws.javax.activity.Outcome;
import com.ibm.ws.javax.activity.PropertyGroupContext;
import com.ibm.ws.javax.activity.SignalSetUnknownException;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.javax.activity.propertygroup.PropertyGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.transaction.Transaction;
import org.omg.CosActivity.CosActivityFactory;

public class DistributedActivityContext {
    private static final TraceComponent tc = Tr.register(DistributedActivityContext.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    private LocalActivityContext _localContext;
    private int _activeRequests = 0;
    protected CoordinatorProxy _superiorCoordinatorProxy;
    private boolean _imported = false;
    private ArrayList _loopbackPropertyGroups = null;
    private boolean _registeredHLS = true;
    private List _propertyGroupContexts = null;
    private Serializable _activitySpecificData = null;
    private ActivityContextDescriptor _cachedContext = null;
    private boolean _serverAffinitySet;
    private HashMap _serverAffinities;
    private boolean _cachedContextUpdated = false;
    private boolean _hasUpstreamCoord = false;

    public DistributedActivityContext(String string, String string2, int n, List list, GlobalIdImpl globalIdImpl, int n2, CoordinatorProxy coordinatorProxy, Serializable serializable) throws SystemException, PropertyGroupTooLargeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DistributedActivityContext", new Object[]{string, string2, new Integer(n), list, globalIdImpl, new Integer(n2), coordinatorProxy, serializable});
        }
        this._activitySpecificData = serializable;
        this._superiorCoordinatorProxy = coordinatorProxy;
        this._hasUpstreamCoord = coordinatorProxy != null;
        HLSInformation hLSInformation = UserActivityImpl.getRegisteredService(string);
        if (hLSInformation == null) {
            this._registeredHLS = false;
        }
        LocalActivityContext localActivityContext = ThreadContextManager.instance().getCurrentContext(string2, string);
        try {
            this._localContext = LocalActivityContextFactory.create(this, string, string2, n, n2, globalIdImpl, hLSInformation, localActivityContext);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.remote.DistributedActivityContext.DistributedActivityContext", "127", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DistributedActivityContext", systemException);
            }
            throw systemException;
        }
        this.updatePropertyGroups(list, localActivityContext);
        this._imported = true;
        this._activitySpecificData = serializable;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DistributedActivityContext", this);
        }
    }

    public DistributedActivityContext(LocalActivityContext localActivityContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DistributedActivityContext", localActivityContext);
        }
        this._localContext = localActivityContext;
        this._localContext.setDistributedContext(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DistributedActivityContext", this);
        }
    }

    public Outcome complete() throws ContextPendingException, NotOriginatorException, ActivityPendingException, SystemException, ActivityNotProcessedException, NoActivityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "complete", this);
        }
        Outcome outcome = null;
        if (this._imported) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", "NotOriginatorException");
            }
            throw new NotOriginatorException();
        }
        if (this._activeRequests > 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete", "ActivityPendingException");
            }
            throw new ActivityPendingException();
        }
        ActivityTokenImpl activityTokenImpl = this._localContext.completionPreinvoke();
        if (this._superiorCoordinatorProxy != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Passing control of completion to superior coordinator");
            }
            String string = this._localContext.getServiceManager().getCompletionSignalSetName();
            Transaction transaction = null;
            try {
                transaction = TransactionManagerFactory.getTransactionManager().suspend();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.remote.DistributedActivityContext.complete", "240", this);
            }
            try {
                outcome = this._superiorCoordinatorProxy.completeActivity(string, this._localContext.getCompletionStatus());
            }
            catch (ActivityPendingException activityPendingException) {
                FFDCFilter.processException((Throwable)activityPendingException, "com.ibm.ws.activity.remote.DistributedActivityContext.complete", "256", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ActivityPendingException exception caught from remote coord - rethrowing");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "complete", activityPendingException);
                }
                throw activityPendingException;
            }
            catch (ContextPendingException contextPendingException) {
                FFDCFilter.processException((Throwable)contextPendingException, "com.ibm.ws.activity.remote.DistributedActivityContext.complete", "263", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ContextPendingException exception caught from remote coord - rethrowing");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "complete", contextPendingException);
                }
                throw contextPendingException;
            }
            catch (NoActivityException noActivityException) {
                FFDCFilter.processException((Throwable)noActivityException, "com.ibm.ws.activity.remote.DistributedActivityContext.complete", "270", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NoActivityException exception caught from remote coord - rethrowing");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "complete", noActivityException);
                }
                throw noActivityException;
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.remote.DistributedActivityContext.complete", "277", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SystemException exception caught from remote coord - rethrowing");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "complete", systemException);
                }
                throw systemException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.remote.DistributedActivityContext.complete", "283", this);
                Tr.error(tc, "ERR_UNEXP_EXCPN", new Object[]{"complete", "com.ibm.ws.activity.remote.DistributedActivityContext", exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "complete", "SystemException");
                }
                throw new SystemException();
            }
            finally {
                try {
                    TransactionManagerFactory.getTransactionManager().resume(transaction);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.remote.DistributedActivityContext.complete", "305", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception caught resuming suspended tx", exception);
                    }
                    SystemException systemException = new SystemException();
                    systemException.initCause(exception);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "complete", systemException);
                    }
                    throw systemException;
                }
            }
            try {
                this._localContext.completeLocal();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.remote.DistributedActivityContext.complete", "325", this);
                Tr.error(tc, "ERR_UNEXP_EXCPN", new Object[]{"complete", "com.ibm.ws.activity.remote.DistributedActivityContext", exception});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "!!!Exception: Convert Exception to SystemException - unexpected error occured whilst attempting local completion");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "complete", "SystemException");
                }
                throw new SystemException();
            }
        }
        outcome = this._localContext.complete(activityTokenImpl);
        ThreadContextManager.instance().removeForeignIdMapping(this._localContext.getGlobalId().toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "complete", outcome);
        }
        return outcome;
    }

    public boolean isRequestActive() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRequestActive", this);
        }
        boolean bl2 = bl = this._activeRequests > 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRequestActive", bl);
        }
        return bl;
    }

    public void incRequestCount() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "incRequestCount", this);
        }
        ++this._activeRequests;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "incRequestCount");
        }
    }

    public void decRequestCount() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decRequestCount", this);
        }
        --this._activeRequests;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decRequestCount");
        }
    }

    protected void cleanHierarchyFromThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanHierarchyFromThread", this);
        }
        LocalActivityContext localActivityContext = this._localContext.getTopContext();
        localActivityContext.cleanFromThread();
        DistributedActivityContext distributedActivityContext = localActivityContext.getDistributedContext();
        if (distributedActivityContext != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cleanHierarchyFromThread ... calling root cleanFromThread");
            }
            distributedActivityContext.cleanFromThread();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cleanHierarchyFromThread ... calling cleanFromThread");
            }
            this.cleanFromThread();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanHierarchyFromThread");
        }
    }

    public void cleanFromThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanFromThread", this);
        }
        this._localContext.cleanFromThread();
        if (this._activeRequests > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loopback detected - reset PGs; _activeRequests = " + this._activeRequests);
            }
            HashMap hashMap = this._localContext.getPropertyGroups();
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                PropertyGroup propertyGroup = (PropertyGroup)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completing PG: ", propertyGroup);
                }
                propertyGroup.completed();
            }
            hashMap.clear();
            if (this._loopbackPropertyGroups != null && this._loopbackPropertyGroups.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resetting previous pg hashtable");
                }
                this._localContext.setPropertyGroups((HashMap)this._loopbackPropertyGroups.remove(this._activeRequests - 1));
            }
        } else if (this._imported) {
            this._localContext.completeImported();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanFromThread");
        }
    }

    public boolean isHLSRegistered() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isHLSRegistered", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isHLSRegistered", this._registeredHLS);
        }
        return this._registeredHLS;
    }

    public boolean isImported() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isImported", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isImported", this._imported);
        }
        return this._imported;
    }

    public CoordinatorProxy getSuperiorCoordinatorProxy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSuperiorCoordinatorProxy", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSuperiorCoordinatorProxy", this._superiorCoordinatorProxy);
        }
        return this._superiorCoordinatorProxy;
    }

    public void setSuperiorCoordinatorProxy(CoordinatorProxy coordinatorProxy, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSuperiorCoordinatorProxy", new Object[]{coordinatorProxy, bl, this});
        }
        this._superiorCoordinatorProxy = coordinatorProxy;
        if (bl) {
            this._imported = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSuperiorCoordinatorProxy");
        }
    }

    public Outcome broadcast(String string) throws SignalSetUnknownException, InvalidActivityException, SystemException, ActivityNotProcessedException, NoActivityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "broadcast", new Object[]{string, this});
        }
        Outcome outcome = null;
        if (this._superiorCoordinatorProxy != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling superior process_signal_set.", this._superiorCoordinatorProxy);
            }
            Transaction transaction = null;
            try {
                transaction = TransactionManagerFactory.getTransactionManager().suspend();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.remote.DistributedActivityContext.broadcast", "526", this);
            }
            try {
                outcome = this._superiorCoordinatorProxy.processSignalSet(string, this._localContext.getCompletionStatus());
            }
            catch (ActivityNotProcessedException activityNotProcessedException) {
                FFDCFilter.processException((Throwable)activityNotProcessedException, "com.ibm.ws.activity.remote.DistributedActivityContext.broadcast", "542", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "ActivityNotProcessedException thrown driving superior process_signal_set");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "broadcast", activityNotProcessedException);
                }
                throw activityNotProcessedException;
            }
            catch (SignalSetUnknownException signalSetUnknownException) {
                FFDCFilter.processException((Throwable)signalSetUnknownException, "com.ibm.ws.activity.remote.DistributedActivityContext.broadcast", "549", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "SignalSetUnknownException thrown driving superior process_signal_set");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "broadcast", signalSetUnknownException);
                }
                throw signalSetUnknownException;
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.remote.DistributedActivityContext.broadcast", "556", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "SignalSetUnknownException thrown driving superior process_signal_set");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "broadcast", systemException);
                }
                throw systemException;
            }
            finally {
                try {
                    TransactionManagerFactory.getTransactionManager().resume(transaction);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.remote.DistributedActivityContext.broadcast", "569", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "A failure occured resuming the suspended transaction", exception);
                    }
                    SystemException systemException = new SystemException();
                    systemException.initCause(exception);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "broadcast", systemException);
                    }
                    throw systemException;
                }
            }
        }
        outcome = this._localContext.broadcast(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "broadcast", outcome);
        }
        return outcome;
    }

    public boolean hasNonImportedCoordinatedChild() {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasNonImportedCoordinatedChild", this);
        }
        Iterator iterator = this._localContext.getChildren().iterator();
        while (iterator.hasNext() && !bl) {
            LocalActivityContext localActivityContext = (LocalActivityContext)iterator.next();
            DistributedActivityContext distributedActivityContext = localActivityContext.getDistributedContext();
            if (localActivityContext.getCoordinatorRef() == null || distributedActivityContext == null || distributedActivityContext.isImported()) continue;
            bl = true;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Detected a coordinated activity child that was created in this server");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasNonImportedCoordinatedChild", bl);
        }
        return bl;
    }

    public void checkForLoopback() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForLoopback", this);
        }
        if (this._activeRequests > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "activeRequests show this is a loopback request so stack PGs; _activeRequests=" + this._activeRequests);
            }
            if (this._loopbackPropertyGroups == null) {
                this._loopbackPropertyGroups = new ArrayList();
            }
            this._loopbackPropertyGroups.add(this._activeRequests - 1, this._localContext.getPropertyGroups());
            this._localContext.setPropertyGroups(new HashMap());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForLoopback");
        }
    }

    public void reimport(List list) throws SystemException, PropertyGroupTooLargeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reimport", new Object[]{list, this});
        }
        this.checkForLoopback();
        String string = this._localContext.getContextGroup();
        LocalActivityContext localActivityContext = ThreadContextManager.instance().getCurrentContext(string, this._localContext.getServiceName());
        if (list != null) {
            this.updatePropertyGroups(list, localActivityContext);
        }
        this._localContext.addContextToParent(ThreadContextManager.instance().getCurrentContext(string));
        this._localContext.activateOnThread();
        this._localContext.driveResumedOnPGs();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reimport");
        }
    }

    public void updatePropertyGroups(List list, LocalActivityContext localActivityContext) throws SystemException, PropertyGroupTooLargeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updatePropertyGroups", new Object[]{list, localActivityContext, this});
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            PropertyGroup propertyGroup;
            PropertyGroup propertyGroup2;
            PropertyGroupInfo propertyGroupInfo;
            String string;
            Object object;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (PropertyGroupContext)iterator.next();
                string = ((PropertyGroupContext)object).getPropertyGroupName();
                arrayList.add(string);
                propertyGroupInfo = this._localContext.getPropertyGroupInfo(string);
                if (propertyGroupInfo == null) {
                    if (this._propertyGroupContexts == null) {
                        this._propertyGroupContexts = new ArrayList();
                    }
                    this._propertyGroupContexts.add(object);
                    continue;
                }
                if (propertyGroupInfo._cacheable) {
                    this._localContext.getCoordinator();
                }
                propertyGroup2 = null;
                if (localActivityContext != null) {
                    propertyGroup2 = localActivityContext.getPropertyGroup(string);
                }
                propertyGroup = propertyGroupInfo._manager.unmarshalRequest((PropertyGroupContext)object, this._localContext.getPropertyGroup(string), propertyGroup2, this._localContext.getGlobalId());
                this._localContext.updatePropertyGroup(string, propertyGroup);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "PGM returned property group: " + propertyGroup);
            }
            object = this._localContext.getPropertyGroupManagerNames();
            string = null;
            while (object.hasNext()) {
                string = (String)object.next();
                if (arrayList.contains(string)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating Property Group with no PGCxt for " + string);
                }
                propertyGroupInfo = this._localContext.getPropertyGroupInfo(string);
                if (propertyGroupInfo._cacheable) {
                    this._localContext.getCoordinator();
                }
                propertyGroup2 = null;
                if (localActivityContext != null) {
                    propertyGroup2 = localActivityContext.getPropertyGroup(string);
                }
                propertyGroup = propertyGroupInfo._manager.unmarshalRequest(null, this._localContext.getPropertyGroup(string), propertyGroup2, this._localContext.getGlobalId());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PGM returned property group: " + propertyGroup);
                }
                this._localContext.updatePropertyGroup(propertyGroupInfo._name, propertyGroup);
            }
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.remote.DistributedActivityContext.updatePropertyGroups", "900", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Rethrow SystemException - unexpected error occured");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updatePropertyGroups", systemException);
            }
            throw systemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.remote.DistributedActivityContext.updatePropertyGroups", "908", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Convert Exception to SystemException");
            }
            Object[] objectArray = new Object[]{"updatePropertyGroups", "com.ibm.ws.activity.DistributedActivityContext", exception};
            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
            SystemException systemException = new SystemException();
            systemException.initCause(exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updatePropertyGroups", systemException);
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updatePropertyGroups");
        }
    }

    public LocalActivityContext getLocalContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalContext", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalContext", this._localContext);
        }
        return this._localContext;
    }

    public List getCachedPropertyGroupContexts() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCachedPropertyGroupContexts", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCachedPropertyGroupContexts", this._propertyGroupContexts);
        }
        return this._propertyGroupContexts;
    }

    public Serializable getActivitySpecificData() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActivitySpecificData", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivitySpecificData", this._activitySpecificData);
        }
        return this._activitySpecificData;
    }

    public void setActivitySpecificData(Serializable serializable) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setActivitySpecificData", new Object[]{serializable, this});
        }
        this._activitySpecificData = serializable;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setActivitySpecificData");
        }
    }

    public ActivityContextDescriptor getCachedContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCachedContext", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCachedContext", this._cachedContext);
        }
        return this._cachedContext;
    }

    public void setCachedContext(ActivityContextDescriptor activityContextDescriptor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCachedContext", new Object[]{activityContextDescriptor, this});
        }
        if (this._cachedContext != null) {
            this._cachedContextUpdated = true;
        }
        this._cachedContext = activityContextDescriptor;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCachedContext");
        }
    }

    public boolean isCachedContextUpdated() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCachedContextUpdated", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCachedContextUpdated", this._cachedContextUpdated);
        }
        return this._cachedContextUpdated;
    }

    public boolean hasUpstreamCoord() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasUpstreamCoord", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasUpstreamCoord", this._hasUpstreamCoord);
        }
        return this._hasUpstreamCoord;
    }

    public void setServerAffinity(boolean bl) throws SystemException {
        this.setServerAffinity(this._localContext.getGlobalId(), bl);
    }

    public void setServerAffinity(String string, boolean bl) throws SystemException {
        this.setServerAffinity(new GlobalIdImpl(string), bl);
    }

    public void setServerAffinity(GlobalId globalId, boolean bl) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServerAffinity", new Object[]{globalId, new Boolean(bl), this});
        }
        if (this._serverAffinities == null) {
            this._serverAffinities = new HashMap();
        } else if (this._serverAffinities.containsKey(globalId)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setServerAffinity", "Affinity already set");
            }
            return;
        }
        byte[] byArray = globalId.toBytes();
        CosActivityFactory cosActivityFactory = ActivityServiceComponentImpl.getCosActivityFactory();
        Transaction transaction = ActivityServiceComponentImpl.getProcessArchUtils().beforeCosFactorySuspend();
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling setServerAffinity");
            }
            cosActivityFactory.setServerAffinity(byArray, ActivityServiceComponentImpl.getPlatformHelper().getStoken(), bl);
            this._serverAffinities.put(globalId, byArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.remote.DistributedActivityContext.setServerAffinity", "949", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to establish SR affinity", exception);
            }
            throw new SystemException(exception);
        }
        finally {
            try {
                ActivityServiceComponentImpl.getProcessArchUtils().afterCosFactoryResume(transaction);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.remote.DistributedActivityContext.setServerAffinity", "959", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServerAffinity");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup", this);
        }
        if (this._serverAffinities != null) {
            CosActivityFactory cosActivityFactory = ActivityServiceComponentImpl.getCosActivityFactory();
            Transaction transaction = ActivityServiceComponentImpl.getProcessArchUtils().beforeCosFactorySuspend();
            try {
                Iterator iterator = this._serverAffinities.values().iterator();
                while (iterator.hasNext()) {
                    byte[] byArray = (byte[])iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling cleanup for context", byArray);
                    }
                    cosActivityFactory.cleanup(byArray);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.remote.DistributedActivityContext.cleanup", "1049", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cleanup call threw exception", exception);
                }
            }
            finally {
                try {
                    ActivityServiceComponentImpl.getProcessArchUtils().afterCosFactoryResume(transaction);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.remote.DistributedActivityContext.cleanup", "1059", this);
                }
            }
            this._serverAffinities = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup");
        }
    }

    public void promoteServerAffinities(DistributedActivityContext distributedActivityContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "promoteServerAffinities", distributedActivityContext);
        }
        if (distributedActivityContext != null) {
            if (this._serverAffinities == null) {
                this._serverAffinities = distributedActivityContext._serverAffinities;
            } else if (distributedActivityContext._serverAffinities != null) {
                this._serverAffinities.putAll(distributedActivityContext._serverAffinities);
            }
            distributedActivityContext._serverAffinities = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promoteServerAffinities");
        }
    }
}

