/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.GlobalIdImpl;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.ThreadContextManager;
import com.ibm.ws.activity.remote.ActivityContextDescriptor;
import com.ibm.ws.activity.remote.ActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.ActivityContextDescriptorRenderer;
import com.ibm.ws.activity.remote.DistributedActivityContext;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ServiceInformation;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.util.WSThreadLocal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ServerSideProcessor {
    private static final TraceComponent tc = Tr.register(ServerSideProcessor.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    private static WSThreadLocal _importedContexts = new WSThreadLocal();
    private static final int SUBORDINATE_TIMEOUT_EXTENSION = 30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processRequest(ActivityContextDescriptorFactory activityContextDescriptorFactory, Object object) throws PropertyGroupTooLargeException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRequest", new Object[]{activityContextDescriptorFactory, object});
        }
        List list = activityContextDescriptorFactory.extractDescriptors(object);
        _importedContexts.set(list);
        if (list != null) {
            if (tc.isDebugEnabled()) {
                ActivityContextDescriptor.outputDescriptorHierarchy(list);
            }
            try {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    for (ActivityContextDescriptor activityContextDescriptor = (ActivityContextDescriptor)iterator.next(); activityContextDescriptor != null; activityContextDescriptor = activityContextDescriptor.getChild()) {
                        Serializable serializable;
                        LocalActivityContext localActivityContext = null;
                        boolean bl = false;
                        DistributedActivityContext distributedActivityContext = null;
                        Object object2 = ThreadContextManager.instance();
                        synchronized (object2) {
                            localActivityContext = ThreadContextManager.instance().getContextFromGlobalId(activityContextDescriptor.getId());
                            if (localActivityContext != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Context " + activityContextDescriptor.getId() + " is being reimported.");
                                }
                                bl = true;
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Context " + activityContextDescriptor.getId() + " is being imported.");
                                }
                                serializable = activityContextDescriptor.getPropertyGroups();
                                int n = activityContextDescriptor.getTimeout();
                                if (n > 0) {
                                    n = Math.min(n + 30, 1000000000);
                                }
                                if (!(distributedActivityContext = new DistributedActivityContext(activityContextDescriptor.getServiceName(), activityContextDescriptor.getContextGroup(), activityContextDescriptor.getType(), (List)((Object)serializable), new GlobalIdImpl(activityContextDescriptor.getId()), n, activityContextDescriptor.getCoordinator(), activityContextDescriptor.getActivitySpecificData())).isHLSRegistered()) {
                                    distributedActivityContext.setCachedContext(activityContextDescriptor);
                                }
                                localActivityContext = distributedActivityContext.getLocalContext();
                            }
                            localActivityContext.incrementAssociationCount();
                        }
                        if (!bl) {
                            activityContextDescriptor.setContext(localActivityContext);
                            object2 = distributedActivityContext.getLocalContext().getServiceManager();
                            if (object2 == null || !localActivityContext.notifyImported() || (serializable = activityContextDescriptor.getServiceInformation()) == null) continue;
                            object2.activityImported((ServiceInformation)serializable);
                            continue;
                        }
                        object2 = activityContextDescriptor.getPropertyGroups();
                        if (activityContextDescriptor.representsAllAncestorNodes()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "HLS has indicated that descriptor represents all ancestor nodes");
                            }
                            serializable = new ArrayList();
                            for (LocalActivityContext localActivityContext2 = localActivityContext.getParentContext(); localActivityContext2 != null; localActivityContext2 = localActivityContext2.getParentContext()) {
                                serializable.add(localActivityContext2);
                            }
                            int n = serializable.size();
                            for (int i = n - 1; i >= 0; --i) {
                                ((LocalActivityContext)serializable.get(i)).getDistributedContext().reimport((List)object2);
                            }
                        }
                        localActivityContext.getDistributedContext().reimport((List)object2);
                        activityContextDescriptor.setContext(localActivityContext);
                    }
                }
            }
            catch (SystemException systemException) {
                FFDCFilter.processException(systemException, "com.ibm.ws.activity.remote.ServerSideProcessor.processRequest", "89");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processRequest", systemException);
                }
                throw systemException;
            }
            catch (PropertyGroupTooLargeException propertyGroupTooLargeException) {
                FFDCFilter.processException(propertyGroupTooLargeException, "com.ibm.ws.activity.remote.ServerSideProcessor.processRequest", "95");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processRequest", propertyGroupTooLargeException);
                }
                throw propertyGroupTooLargeException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRequest");
        }
    }

    public static void processReply(ActivityContextDescriptorRenderer activityContextDescriptorRenderer) throws SystemException, PropertyGroupTooLargeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processReply", activityContextDescriptorRenderer);
        }
        ServerSideProcessor.processReply(activityContextDescriptorRenderer, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processReply");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processReply(ActivityContextDescriptorRenderer activityContextDescriptorRenderer, boolean bl) throws SystemException, PropertyGroupTooLargeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processReply", new Object[]{activityContextDescriptorRenderer, bl});
        }
        try {
            List list = (List)_importedContexts.get();
            if (!bl) {
                _importedContexts.set((Object)null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing reply", list);
            }
            if (list != null) {
                if (tc.isDebugEnabled()) {
                    ActivityContextDescriptor.outputDescriptorHierarchy(list);
                }
                if (activityContextDescriptorRenderer.renderingStarting(list)) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Object object;
                        Object object2;
                        ActivityContextDescriptor activityContextDescriptor;
                        for (ActivityContextDescriptor activityContextDescriptor2 = activityContextDescriptor = (ActivityContextDescriptor)iterator.next(); activityContextDescriptor2 != null; activityContextDescriptor2 = activityContextDescriptor2.getChild()) {
                            object2 = ThreadContextManager.instance().getContextFromGlobalId(activityContextDescriptor2.getId());
                            if (object2 != null && ((DistributedActivityContext)(object = ((LocalActivityContext)object2).getDistributedContext())).hasNonImportedCoordinatedChild()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Context has a coordinated child - ensuring that a local coordinator exists");
                                }
                                ((LocalActivityContext)object2).getCoordinator();
                            }
                            activityContextDescriptor2.updatePropertyGroups(false);
                        }
                        activityContextDescriptorRenderer.render(activityContextDescriptor, false);
                        if (bl) continue;
                        object2 = ThreadContextManager.instance();
                        synchronized (object2) {
                            for (object = activityContextDescriptor; object != null; object = ((ActivityContextDescriptor)object).getChild()) {
                                ((ActivityContextDescriptor)object).getContext().decrementAssociationCount();
                            }
                            if (activityContextDescriptor.representsAllAncestorNodes()) {
                                activityContextDescriptor.getContext().getDistributedContext().cleanHierarchyFromThread();
                            } else {
                                activityContextDescriptor.getContext().getDistributedContext().cleanFromThread();
                            }
                        }
                    }
                }
                activityContextDescriptorRenderer.renderingComplete();
            }
        }
        catch (SystemException systemException) {
            FFDCFilter.processException(systemException, "com.ibm.ws.activity.remote.ServerSideProcessor.processReply", "80");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processReply", systemException);
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processReply");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void suspendAllContexts() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspendAllContexts");
        }
        try {
            List list = (List)_importedContexts.get();
            _importedContexts.set((Object)null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Suspending contexts", list);
            }
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ThreadContextManager threadContextManager = ThreadContextManager.instance();
                    synchronized (threadContextManager) {
                        ActivityContextDescriptor activityContextDescriptor;
                        for (ActivityContextDescriptor activityContextDescriptor2 = activityContextDescriptor = (ActivityContextDescriptor)iterator.next(); activityContextDescriptor2 != null; activityContextDescriptor2 = activityContextDescriptor2.getChild()) {
                            LocalActivityContext localActivityContext = ThreadContextManager.instance().getContextFromGlobalId(activityContextDescriptor2.getId());
                            DistributedActivityContext distributedActivityContext = localActivityContext.getDistributedContext();
                            if (distributedActivityContext.hasNonImportedCoordinatedChild()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Context has a coordinated child - ensuring that a local coordinator exists");
                                }
                                localActivityContext.getCoordinator();
                            }
                            localActivityContext.decrementAssociationCount();
                        }
                        activityContextDescriptor.getContext().getDistributedContext().cleanFromThread();
                    }
                }
            }
        }
        catch (SystemException systemException) {
            FFDCFilter.processException(systemException, "com.ibm.ws.activity.remote.ServerSideProcessor.suspendAllContexts", "279");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspendAllContexts", systemException);
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspendAllContexts");
        }
    }
}

