/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote.cos;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.remote.ActivityContextDescriptor;
import com.ibm.ws.activity.remote.ActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.activity.remote.cos.ContextList;
import com.ibm.ws.activity.remote.cos.CosActivityContextDescriptor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.SystemException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.portable.InputStream;
import org.omg.CosActivity.ActivityContext;
import org.omg.CosActivity.ActivityCoordinatorHelper;
import org.omg.CosActivity.ActivityIdentity;
import org.omg.CosActivity.PropertyGroupIdentity;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class CosActivityContextDescriptorFactory
implements ActivityContextDescriptorFactory {
    private static final TraceComponent tc = Tr.register(CosActivityContextDescriptorFactory.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");

    public ActivityContextDescriptor createDescriptor(LocalActivityContext localActivityContext, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDescriptor", new Object[]{localActivityContext, bl, this});
        }
        CosActivityContextDescriptor cosActivityContextDescriptor = new CosActivityContextDescriptor(localActivityContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDescriptor", cosActivityContextDescriptor);
        }
        return cosActivityContextDescriptor;
    }

    public List extractDescriptors(Object object) throws SystemException, PropertyGroupTooLargeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractDescriptors", new Object[]{object, this});
        }
        ServiceContext serviceContext = null;
        ExtendedServerRequestInfo extendedServerRequestInfo = null;
        if (object instanceof ExtendedClientRequestInfo) {
            serviceContext = ((ExtendedClientRequestInfo)object).getReplyServiceContext(16);
        } else {
            extendedServerRequestInfo = (ExtendedServerRequestInfo)object;
            serviceContext = extendedServerRequestInfo.getRequestServiceContext(16);
        }
        ContextList contextList = new ContextList();
        if (serviceContext != null && serviceContext.context_data != null) {
            ActivityContext activityContext;
            HashMap hashMap;
            block9: {
                byte[] byArray = serviceContext.context_data;
                ORB oRB = (ORB)ActivityService.getORB();
                CDRInputStream cDRInputStream = ORB.createCDRInputStream((ORB)oRB, (byte[])byArray, (int)byArray.length);
                cDRInputStream.consumeEndian();
                hashMap = new HashMap();
                activityContext = CosActivityContextDescriptorFactory.readActivityContextFromInputStream((InputStream)cDRInputStream, hashMap);
                try {
                    int n = activityContext.invocation_specific_data.extract_long();
                    contextList.setOptimised();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "extractDescriptors ... found optimised context");
                    }
                }
                catch (BAD_OPERATION bAD_OPERATION) {
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "extractDescriptors ... NO optimised context", (Object)bAD_OPERATION);
                }
            }
            HashMap hashMap2 = new HashMap();
            for (int i = 0; i < activityContext.hierarchy.length; ++i) {
                CosActivityContextDescriptor.create(activityContext.hierarchy[i], hashMap2, contextList, (ServerRequestInfo)extendedServerRequestInfo, hashMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractDescriptors", contextList);
        }
        return contextList;
    }

    protected static ActivityContext readActivityContextFromInputStream(InputStream inputStream, Map map) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readActivityContextFromInputStream", new Object[]{inputStream, map});
        }
        ActivityContext activityContext = new ActivityContext();
        try {
            int n = inputStream.read_long();
            activityContext.hierarchy = new ActivityIdentity[n];
            for (int i = 0; i < activityContext.hierarchy.length; ++i) {
                activityContext.hierarchy[i] = CosActivityContextDescriptorFactory.readActivityIdentityFromInputStream(inputStream, map);
            }
            activityContext.invocation_specific_data = inputStream.read_any();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorFactory.readActivityContextFromInputStream", "81");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught", exception);
            }
            Object[] objectArray = new Object[]{"readActivityContextFromInputStream", "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorFactory", exception};
            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readActivityContextFromInputStream", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readActivityContextFromInputStream", activityContext);
        }
        return activityContext;
    }

    private static ActivityIdentity readActivityIdentityFromInputStream(InputStream inputStream, Map map) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readActivityIdentityFromInputStream", new Object[]{inputStream, map});
        }
        ActivityIdentity activityIdentity = new ActivityIdentity();
        try {
            activityIdentity.type = inputStream.read_ulong();
            activityIdentity.timeout = inputStream.read_long();
            activityIdentity.coord = ActivityCoordinatorHelper.read(inputStream);
            int n = inputStream.read_long();
            activityIdentity.ctxId = new byte[n];
            inputStream.read_octet_array(activityIdentity.ctxId, 0, n);
            int n2 = inputStream.read_long();
            activityIdentity.pgCtx = new PropertyGroupIdentity[n2];
            for (int i = 0; i < activityIdentity.pgCtx.length; ++i) {
                activityIdentity.pgCtx[i] = CosActivityContextDescriptorFactory.readPropertyGroupIdentityFromInputStream(inputStream, map);
            }
            activityIdentity.activity_specific_data = inputStream.read_any();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorFactory.readActivityIdentityFromInputStream", "128");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught", exception);
            }
            Object[] objectArray = new Object[]{"readActivityIdentityFromInputStream", "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorFactory", exception};
            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readActivityIdentityFromInputStream");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readActivityIdentityFromInputStream", activityIdentity);
        }
        return activityIdentity;
    }

    private static PropertyGroupIdentity readPropertyGroupIdentityFromInputStream(InputStream inputStream, Map map) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readPropertyGroupIdentityFromInputStream", new Object[]{inputStream, map});
        }
        PropertyGroupIdentity propertyGroupIdentity = new PropertyGroupIdentity();
        try {
            propertyGroupIdentity.property_group_name = inputStream.read_string();
            int n = inputStream.available();
            propertyGroupIdentity.context_data = inputStream.read_any();
            int n2 = n - inputStream.available();
            if (map != null) {
                map.put(propertyGroupIdentity, new Integer(n2));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorFactory.readPropertyGroupIdentityFromInputStream", "157");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught", exception);
            }
            Object[] objectArray = new Object[]{"readPropertyGroupIdentityFromInputStream", "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorFactory", exception};
            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readPropertyGroupIdentityFromInputStream", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readPropertyGroupIdentityFromInputStream", propertyGroupIdentity);
        }
        return propertyGroupIdentity;
    }
}

