/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote.cos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityCoordinatorImpl;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.activity.ActivityServiceComponentImpl;
import com.ibm.ws.activity.HLSInformation;
import com.ibm.ws.activity.remote.ClientSideProcessor;
import com.ibm.ws.activity.remote.CoordinatorProxy;
import com.ibm.ws.activity.remote.RemoteAction;
import com.ibm.ws.activity.remote.cos.CosActivityActionImpl;
import com.ibm.ws.activity.remote.cos.CosActivityCoordImpl;
import com.ibm.ws.activity.remote.cos.CosActivityRemoteAction;
import com.ibm.ws.activity.remote.cos.CosActivityUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityNotProcessedException;
import com.ibm.ws.javax.activity.ActivityPendingException;
import com.ibm.ws.javax.activity.ContextPendingException;
import com.ibm.ws.javax.activity.NoActivityException;
import com.ibm.ws.javax.activity.Outcome;
import com.ibm.ws.javax.activity.SignalSetUnknownException;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.javax.activity.coordination.Action;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.omg.CORBA.ACTIVITY_COMPLETED;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosActivity.ActionHelper;
import org.omg.CosActivity.ActivityCoordinator;
import org.omg.CosActivity.ActivityCoordinatorHelper;
import org.omg.CosActivity.ActivityNotProcessed;
import org.omg.CosActivity.ActivityPending;
import org.omg.CosActivity.ChildContextPending;
import org.omg.CosActivity.CompletionStatus;
import org.omg.CosActivity.SignalSetUnknown;

public class CosActivityCoordinatorProxy
implements CoordinatorProxy {
    private static final TraceComponent tc = Tr.register(CosActivityCoordinatorProxy.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    private ActivityCoordinator _cosActivityCoord;
    private static final long serialVersionUID = -339119627360163070L;

    public CosActivityCoordinatorProxy(ActivityCoordinator activityCoordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CosActivityCoordinatorProxy", activityCoordinator);
        }
        this._cosActivityCoord = activityCoordinator;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CosActivityCoordinatorProxy", this);
        }
    }

    public Outcome processSignalSet(String string, int n) throws ActivityNotProcessedException, SignalSetUnknownException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSignalSet", new Object[]{string, new Integer(n), this});
        }
        Outcome outcome = null;
        ClientSideProcessor.setInternalRequest(Boolean.TRUE);
        try {
            final String string2 = string;
            final CompletionStatus completionStatus = CosActivityUtils.getCosCompletionStatus(n);
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws ActivityNotProcessed, SignalSetUnknown {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "run", this);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                    return CosActivityCoordinatorProxy.this._cosActivityCoord.process_signal_set(string2, completionStatus);
                }
            };
            org.omg.CosActivity.Outcome outcome2 = (org.omg.CosActivity.Outcome)ActivityServiceComponentImpl.runAsSystem(privilegedExceptionAction);
            outcome = CosActivityUtils.getJOutFromCosOut(outcome2);
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.activity.remote.cos.CosActivityCoordinatorProxy.processSignalSet", "87", this);
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof SignalSetUnknown) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Convert CosAct.SignalSetUnknown to SignalSetUnknownException - root cordinator was not able to create signal set");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processSignalSet", "SignalSetUnknownException");
                }
                throw new SignalSetUnknownException();
            }
            if (throwable instanceof ActivityNotProcessed) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Convert CosAct.ActivityNotProcessed to javax Exception - ActivityNotProcessed thrown by remote coordinator");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processSignalSet", "ActivityNotProcessedException");
                }
                throw new ActivityNotProcessedException();
            }
            if (throwable instanceof TRANSIENT) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "TRANSIENT - communication with superior failed. Throwing ActivityNotProcessedException");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processSignalSet", "ActivityNotProcessedException");
                }
                throw new ActivityNotProcessedException();
            }
            if (throwable instanceof COMM_FAILURE) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "COMM_FAILURE - communication with superior failed. Throwing ActivityNotProcessedException");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processSignalSet", "ActivityNotProcessedException");
                }
                throw new ActivityNotProcessedException();
            }
            if (throwable instanceof OBJECT_NOT_EXIST) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "OBJECT_NOT_EXIST - communication with superior failed. Throwing ActivityNotProcessedException");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processSignalSet", "ActivityNotProcessedException");
                }
                throw new ActivityNotProcessedException();
            }
            if (throwable instanceof BAD_PARAM) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Convert org.omg.CORBA.BAD_PARAM to SystemException - completion status is unrecognised");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processSignalSet", "SystemException");
                }
                throw new SystemException();
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Convert Exception to SystemException - unexpected error occured whilst driving local CosCoord.process_signal_set");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processSignalSet", "SystemException");
            }
            Tr.error(tc, "ERR_UNEXP_EXCPN", new Object[]{"processSignalSet", this.getClass().getName(), throwable});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processSignalSet", "SystemException");
            }
            throw new SystemException();
        }
        finally {
            ClientSideProcessor.setInternalRequest(Boolean.FALSE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSignalSet", outcome);
        }
        return outcome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outcome completeActivity(String string, int n) throws ActivityPendingException, ContextPendingException, SystemException, NoActivityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeActivity", new Object[]{string, new Integer(n), this});
        }
        org.omg.CosActivity.Outcome outcome = null;
        Outcome outcome2 = null;
        ClientSideProcessor.setInternalRequest(Boolean.TRUE);
        try {
            if (!ActivityService.instance().isServerProcess()) {
                outcome = this._cosActivityCoord.complete_activity(string, CosActivityUtils.getCosCompletionStatus(n));
            } else {
                final String string2 = string;
                final CompletionStatus completionStatus = CosActivityUtils.getCosCompletionStatus(n);
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() throws ActivityNotProcessed, ActivityPending, ChildContextPending, SignalSetUnknown {
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "run", this);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "run");
                        }
                        return CosActivityCoordinatorProxy.this._cosActivityCoord.complete_activity(string2, completionStatus);
                    }
                };
                outcome = (org.omg.CosActivity.Outcome)ActivityServiceComponentImpl.runAsSystem(privilegedExceptionAction);
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            this.processExceptionFromCompleteActivity(throwable);
        }
        catch (Throwable throwable) {
            this.processExceptionFromCompleteActivity(throwable);
        }
        finally {
            ClientSideProcessor.setInternalRequest(Boolean.FALSE);
        }
        outcome2 = CosActivityUtils.getJOutFromCosOut(outcome);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeActivity", outcome2);
        }
        return outcome2;
    }

    public Action registerSubordinateAction(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSubordinateAction", new Object[]{byArray, this});
        }
        org.omg.CosActivity.Action action = ActionHelper.narrow(ActivityService.bytes_to_object(byArray));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSubordinateAction");
        }
        return ((CosActivityCoordImpl)this._cosActivityCoord).addActionToMap(action);
    }

    public byte[] toBytes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toBytes", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toBytes");
        }
        return ActivityService.object_to_bytes(this._cosActivityCoord);
    }

    private void processExceptionFromCompleteActivity(Throwable throwable) throws SystemException, ActivityPendingException, ContextPendingException, NoActivityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processExceptionFromCompleteActivity", new Object[]{throwable, this});
        }
        FFDCFilter.processException(throwable, "com.ibm.ws.activity.remote.cos.CosActivityCoordinatorProxy.processExceptionFromCompleteActivity", "334", this);
        if (throwable instanceof ActivityPending) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "!!!Exception: Convert CosAct.ActivityPending to ActivityPendingException - exception caught from remote coord");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processExceptionFromCompleteActivity", "ActivityPendingException");
            }
            throw new ActivityPendingException();
        }
        if (throwable instanceof ChildContextPending) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "!!!Exception: Convert CosAct.ChildContextPending to ContextPendingException - exception caught from remote coord");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processExceptionFromCompleteActivity", "ContextPendingException");
            }
            throw new ContextPendingException();
        }
        if (throwable instanceof SignalSetUnknown || throwable instanceof ActivityNotProcessed) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "!!!Exception: Convert CosAct.SignalSetUnknown or CosAct.ActivityNotProcessed to SystemException - exception caught from remote coord");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processExceptionFromCompleteActivity", "SystemException");
            }
            throw new SystemException();
        }
        if (throwable instanceof OBJECT_NOT_EXIST) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "!!!Exception: Convert org.omg.CORBA.OBJECT_NOT_EXIST to NoActivityException - exception caught from remote coord");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processExceptionFromCompleteActivity", "NoActivityException");
            }
            throw new NoActivityException();
        }
        Object[] objectArray = new Object[]{"complete", "com.ibm.ws.activity.remote.cos.CosActivityCoordWrapper", throwable};
        Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unexpected exception caught", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processExceptionFromCompleteActivity", "SystemException");
        }
        throw new SystemException();
    }

    public RemoteAction registerSubordinate(ActivityCoordinatorImpl activityCoordinatorImpl, HLSInformation hLSInformation) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSubordinate", new Object[]{activityCoordinatorImpl, hLSInformation, this});
        }
        CosActivityRemoteAction cosActivityRemoteAction = new CosActivityRemoteAction(activityCoordinatorImpl, hLSInformation);
        cosActivityRemoteAction.connect();
        final CosActivityActionImpl cosActivityActionImpl = cosActivityRemoteAction.getAction();
        ClientSideProcessor.setInternalRequest(Boolean.TRUE);
        try {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws SystemException {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "run", this);
                    }
                    CosActivityCoordinatorProxy.this._cosActivityCoord.add_global_action(cosActivityActionImpl, 0);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "run", null);
                    }
                    return null;
                }
            };
            ActivityServiceComponentImpl.runAsSystem(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.activity.remote.cos.CosActivityCoordinatorProxy.registerSubordinate", "310", this);
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof ACTIVITY_COMPLETED) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Attempt made to recreate an activity which has timed out");
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Rethrowing org.omg.CORBA.ACTIVITY_COMPLETED exception");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerSubordinate");
                }
                throw (ACTIVITY_COMPLETED)throwable;
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught from add_global_action on superior" + privilegedActionException);
            }
            cosActivityRemoteAction.cleanup();
            Object[] objectArray = new Object[]{"addGlobalAction", this.getClass().getName(), privilegedActionException};
            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "registerSubordinate", "SystemException");
            }
            throw new SystemException();
        }
        finally {
            ClientSideProcessor.setInternalRequest(Boolean.FALSE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSubordinate", cosActivityRemoteAction);
        }
        return cosActivityRemoteAction;
    }

    public RemoteAction createActionForSubordinate(ActivityCoordinatorImpl activityCoordinatorImpl, HLSInformation hLSInformation) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createActionForSubordinate", new Object[]{activityCoordinatorImpl, hLSInformation, this});
        }
        CosActivityRemoteAction cosActivityRemoteAction = new CosActivityRemoteAction(activityCoordinatorImpl, hLSInformation);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createActionForSubordinate", cosActivityRemoteAction);
        }
        return cosActivityRemoteAction;
    }

    public boolean readyToBePersisted() {
        return true;
    }

    public ActivityCoordinator getCosActivityCoordinator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCosActivityCoordinator", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCosActivityCoordinator", this._cosActivityCoord);
        }
        return this._cosActivityCoord;
    }

    public int getType() {
        return 1;
    }

    public void destroy() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject", new Object[]{objectOutputStream, this});
        }
        byte[] byArray = ActivityService.object_to_bytes(this._cosActivityCoord);
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", new Object[]{objectInputStream, this});
        }
        byte[] byArray = new byte[objectInputStream.readInt()];
        objectInputStream.readFully(byArray);
        this._cosActivityCoord = ActivityCoordinatorHelper.narrow(ActivityService.bytes_to_object(byArray));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject");
        }
    }
}

