/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote.cos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.activity.ActivityServiceComponentImpl;
import com.ibm.ws.activity.SubordinateAction;
import com.ibm.ws.activity.SubordinateContextPendingException;
import com.ibm.ws.activity.remote.cos.CosActivityUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActionErrorException;
import com.ibm.ws.javax.activity.Outcome;
import com.ibm.ws.javax.activity.Signal;
import com.ibm.ws.javax.activity.SystemException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.transaction.Transaction;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosActivity.Action;
import org.omg.CosActivity.ActionError;
import org.omg.CosActivity.ActionHelper;

public final class RemoteActionWrapper
implements SubordinateAction {
    private static final long serialVersionUID = 8491735135964944787L;
    private static final TraceComponent tc = Tr.register(RemoteActionWrapper.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    private transient Action _remAction = null;
    private long _retryInterval;
    private int _maxRetries;
    private int _id;

    public RemoteActionWrapper(Action action, int n, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RemoteActionWrapper", new Object[]{action, new Integer(n), new Long(l)});
        }
        this._remAction = action;
        this._maxRetries = n;
        this._retryInterval = l;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RemoteActionWrapper");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Outcome processSignal(Signal signal) throws ActionErrorException {
        Object object;
        org.omg.CosActivity.Signal signal2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSignal", new Object[]{signal, this});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, signal.getName());
        }
        try {
            signal2 = CosActivityUtils.getCosSigFromJSig(signal);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.remote.cos.RemoteActionWrapper.processSignal", "126", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "SystemException thrown by CosActivityUtils.getCosSigFromJSig");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processSignal");
            }
            ActionErrorException actionErrorException = new ActionErrorException();
            actionErrorException.initCause(systemException);
            throw actionErrorException;
        }
        int n = 0;
        boolean bl = false;
        if (this._maxRetries < 0) {
            bl = true;
        } else {
            n = this._maxRetries + 1;
        }
        Transaction transaction = null;
        try {
            transaction = TransactionManagerFactory.getTransactionManager().suspend();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.remote.cos.RemoteActionWrapper.processSignal", "166", this);
        }
        Outcome outcome = null;
        try {
            while ((bl || n > 0) && outcome == null) {
                try {
                    PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                        public Object run() throws ActionError {
                            if (tc.isEntryEnabled()) {
                                Tr.entry(tc, "run", this);
                            }
                            org.omg.CosActivity.Outcome outcome = RemoteActionWrapper.this._remAction.process_signal(signal2);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "run", outcome);
                            }
                            return outcome;
                        }
                    };
                    object = (org.omg.CosActivity.Outcome)ActivityServiceComponentImpl.runAsSystem(privilegedExceptionAction);
                    outcome = CosActivityUtils.getJOutFromCosOut((org.omg.CosActivity.Outcome)object);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable;
                    FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.activity.remote.cos.RemoteActionWrapper.processSignal", "203", this);
                    object = privilegedActionException.getCause();
                    if (object instanceof ActionError) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "ActionError caught from process_signal on remote action");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "processSignal");
                        }
                        throw new ActionErrorException();
                    }
                    if (object instanceof COMM_FAILURE) {
                        FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.activity.remote.cos.RemoteActionWrapper.processSignal", "218", this);
                        if (!bl) {
                            --n;
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "COMM_FAILURE caught from process_signal on remote action; attempts left = " + n);
                            }
                        } else if (tc.isEventEnabled()) {
                            Tr.event(tc, "COMM_FAILURE caught from process_signal on remote action");
                        }
                        if (bl || n > 0) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Sleeping for " + this._retryInterval + " milliseconds before retrying operation");
                            }
                            try {
                                Thread.sleep(this._retryInterval);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.activity.remote.cos.RemoteActionWrapper.processSignal", "244", this);
                                continue;
                            }
                        }
                        outcome = new Outcome("org.omg.CosActivity.ActionSystemException", privilegedActionException);
                        continue;
                    }
                    if (object instanceof TRANSIENT) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "TRANSIENT caught from process_signal on remote action");
                        }
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Sleeping for " + this._retryInterval + " milliseconds before retrying operation");
                        }
                        try {
                            Thread.sleep(this._retryInterval);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.activity.remote.cos.RemoteActionWrapper.processSignal", "272", this);
                            continue;
                        }
                    }
                    if (object instanceof OBJECT_NOT_EXIST) {
                        throwable = (OBJECT_NOT_EXIST)((Object)object);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "OBJECT_NOT_EXIST caught from process_signal on remote action. Minor code was " + ((OBJECT_NOT_EXIST)throwable).minor);
                        }
                        if (((OBJECT_NOT_EXIST)throwable).minor == 1229126674 || ((OBJECT_NOT_EXIST)throwable).minor == 1229126676) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Remote service not yet ready to process requests. Treat this like TRANSIENT and retry operation.");
                            }
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Sleeping for " + this._retryInterval + " milliseconds before retrying operation");
                            }
                            try {
                                Thread.sleep(this._retryInterval);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.activity.remote.cos.RemoteActionWrapper.processSignal", "308", this);
                                continue;
                            }
                        }
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Object does not exist on remote server");
                        }
                        outcome = new Outcome("org.omg.CosActivity.ActionSystemException", (Serializable)((Object)throwable));
                        continue;
                    }
                    if (object instanceof BAD_OPERATION) {
                        if (((BAD_OPERATION)((Object)object)).minor == 22) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "BAD_OPERATION caught from process_signal on remote action; convert to SubordinateContextPendingException");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "processSignal");
                            }
                            throw new SubordinateContextPendingException();
                        }
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "BAD_OPERATION caught from process_signal on remote action; convert to ActionErrorException");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "processSignal");
                        }
                        throw new ActionErrorException();
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unexpected exception caught from process_signal on remote action", object);
                    }
                    throwable = new ActionErrorException();
                    throwable.initCause((Throwable)object);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "processSignal", throwable);
                    }
                    throw throwable;
                }
            }
        }
        finally {
            try {
                TransactionManagerFactory.getTransactionManager().resume(transaction);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.remote.cos.RemoteActionWrapper.processSignal", "362", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception caught resuming suspended tx", exception);
                }
                object = new ActionErrorException();
                ((Throwable)object).initCause(exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processSignal", object);
                }
                throw object;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSignal", outcome);
        }
        return outcome;
    }

    public void destroy() {
    }

    public int getId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getId", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getId", new Integer(this._id));
        }
        return this._id;
    }

    public void setId(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setId", new Object[]{new Integer(n), this});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setId");
        }
        this._id = n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject", new Object[]{objectOutputStream, this});
        }
        objectOutputStream.defaultWriteObject();
        byte[] byArray = ActivityService.object_to_bytes(this._remAction);
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", new Object[]{objectInputStream, this});
        }
        objectInputStream.defaultReadObject();
        byte[] byArray = new byte[objectInputStream.readInt()];
        objectInputStream.readFully(byArray);
        this._remAction = ActionHelper.narrow(ActivityService.bytes_to_object(byArray));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject");
        }
    }

    public String getContextId() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getContextId");
        }
        return null;
    }
}

