/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ws.activity.remote.ActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.ClientSideProcessor;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.activity.remote.ServerSideProcessor;
import com.ibm.ws.activity.remote.soap.SIBActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.soap.SIBActivityContextDescriptorRenderer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws390.activity.ServantLocatorImpl;
import com.ibm.wsspi.exitpoint.systemcontext.SystemContext;
import com.ibm.wsspi.exitpoint.systemcontext.SystemContextHandler;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class ActivityServiceSystemContextHandler
implements SystemContextHandler {
    private static final TraceComponent tc = Tr.register(ActivityServiceSystemContextHandler.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    public static final String AGGREGATOR_KEY = "WLM_AGGREGATOR_STOKEN";
    protected final boolean IS_ZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    protected static ActivityContextDescriptorFactory _factory = new SIBActivityContextDescriptorFactory();
    private static final ThreadLocal _outboundSIBWSRequest = new ThreadLocal();

    public abstract boolean extractContext(SystemContext var1, Map var2);

    public abstract boolean insertResponseContext(SystemContext var1);

    public boolean insertRequestContext(SystemContext systemContext) {
        boolean bl;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "insertRequestContext", new Object[]{systemContext, this});
            }
            bl = false;
            SIBActivityContextDescriptorRenderer sIBActivityContextDescriptorRenderer = new SIBActivityContextDescriptorRenderer(systemContext);
            try {
                ClientSideProcessor.processRequest(_factory, sIBActivityContextDescriptorRenderer, true);
                bl = true;
            }
            catch (SystemException systemException) {
                FFDCFilter.processException(systemException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.insertRequestContext", "73");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught a SystemException in insertRequestContext(), returning false from SystemContextHandler.");
                }
            }
            catch (PropertyGroupTooLargeException propertyGroupTooLargeException) {
                FFDCFilter.processException(propertyGroupTooLargeException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.insertRequestContext", "78");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught a PropertyGroupTooLargeException in insertRequestContext(), returning false from SystemContextHandler.");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.insertRequestContext", "86");
                if (!tc.isEventEnabled()) break block8;
                Tr.event(tc, "Caught a Throwable in extractContext(), returning false from SystemContextHandler.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertRequestContext", bl);
        }
        return bl;
    }

    public boolean establishContext(Map map) {
        boolean bl;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "establishContext", new Object[]{map, this});
            }
            bl = false;
            try {
                ServerSideProcessor.processRequest(_factory, map);
                bl = true;
                ActivityServiceSystemContextHandler.setOutboundSIBWSRequestFlagOnThread();
            }
            catch (PropertyGroupTooLargeException propertyGroupTooLargeException) {
                FFDCFilter.processException(propertyGroupTooLargeException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.establishContext", "157");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught a PropertyGroupTooLargeException in establishContext(), returning false from SystemContextHandler.");
                }
            }
            catch (SystemException systemException) {
                FFDCFilter.processException(systemException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.establishContext", "162");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught a SystemException in establishContext(), returning false from SystemContextHandler.");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.establishContext", "167");
                if (!tc.isEventEnabled()) break block8;
                Tr.event(tc, "Caught a Throwable in establishContext(), returning false from SystemContextHandler.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "establishContext", bl);
        }
        return bl;
    }

    public void insertRequestContextFailed() {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "insertRequestContextFailed", this);
            }
            try {
                ClientSideProcessor.processReply(_factory, null, true);
            }
            catch (InvalidActivityException invalidActivityException) {
                FFDCFilter.processException(invalidActivityException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.insertRequestContextFailed", "244");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught an InvalidActivityException in insertRequestContextFailed()");
                }
            }
            catch (SystemException systemException) {
                FFDCFilter.processException(systemException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.insertRequestContextFailed", "249");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught a SystemException in insertRequestContextFailed()");
                }
            }
            catch (PropertyGroupTooLargeException propertyGroupTooLargeException) {
                FFDCFilter.processException(propertyGroupTooLargeException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.insertRequestContextFailed", "254");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught a PropertyGroupTooLargeException in insertRequestContextFailed()");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.insertRequestContextFailed", "258");
                if (!tc.isEventEnabled()) break block10;
                Tr.event(tc, "Caught a Throwable in insertRequestContextFailed()");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertRequestContextFailed");
        }
    }

    public void removeEstablishedContext() {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "removeEstablishedContext", this);
            }
            try {
                ActivityServiceSystemContextHandler.removeOutboundSIBWSRequestFlagFromThread();
                ServerSideProcessor.suspendAllContexts();
            }
            catch (SystemException systemException) {
                FFDCFilter.processException(systemException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.removeEstablishedContext", "281");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught a SystemException in removeEstablishedContext()");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.removeEstablishedContext", "275");
                if (!tc.isEventEnabled()) break block6;
                Tr.event(tc, "Caught a Throwable in removeEstablishedContext()");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEstablishedContext");
        }
    }

    public void extractContextFailed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractContextFailed", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractContextFailed");
        }
    }

    public void establishContextFailed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "establishContextFailed", this);
        }
        this.removeEstablishedContext();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "establishContextFailed");
        }
    }

    public void insertResponseContextFailed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertResponseContextFailed", this);
        }
        this.removeEstablishedContext();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertResponseContextFailed");
        }
    }

    public void requestFailed() {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "requestFailed", this);
            }
            try {
                ClientSideProcessor.processReply(_factory, null, true);
            }
            catch (InvalidActivityException invalidActivityException) {
                FFDCFilter.processException(invalidActivityException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.requestFailed", "340");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught an InvalidActivityException in requestFailed()");
                }
            }
            catch (SystemException systemException) {
                FFDCFilter.processException(systemException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.requestFailed", "345");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught a SystemException in requestFailed()");
                }
            }
            catch (PropertyGroupTooLargeException propertyGroupTooLargeException) {
                FFDCFilter.processException(propertyGroupTooLargeException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.requestFailed", "350");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught a PropertyGroupTooLargeException in requestFailed()");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.requestFailed", "355");
                if (!tc.isEventEnabled()) break block10;
                Tr.event(tc, "Caught a Throwable in requestFailed()");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestFailed");
        }
    }

    public void requestSucceeded() {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "requestSucceeded", this);
            }
            try {
                ClientSideProcessor.processReply(_factory, null, true);
            }
            catch (InvalidActivityException invalidActivityException) {
                FFDCFilter.processException(invalidActivityException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.requestSucceeded", "377");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught an InvalidActivityException in requestSucceeded()");
                }
            }
            catch (SystemException systemException) {
                FFDCFilter.processException(systemException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.requestSucceeded", "382");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught a SystemException in requestSucceeded()");
                }
            }
            catch (PropertyGroupTooLargeException propertyGroupTooLargeException) {
                FFDCFilter.processException(propertyGroupTooLargeException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.requestSucceeded", "387");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught a PropertyGroupTooLargeException in requestSucceeded()");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.requestSucceeded", "492");
                if (!tc.isEventEnabled()) break block10;
                Tr.event(tc, "Caught a Throwable in requestSucceeded()");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestSucceeded");
        }
    }

    public void requestSucceeded(SystemContext systemContext) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "requestSucceeded", new Object[]{systemContext, this});
            }
            try {
                ClientSideProcessor.processReply(_factory, this.systemContextToMap(systemContext), true);
            }
            catch (InvalidActivityException invalidActivityException) {
                FFDCFilter.processException(invalidActivityException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.requestSucceeded", "415");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught an InvalidActivityException in requestSucceeded()");
                }
            }
            catch (SystemException systemException) {
                FFDCFilter.processException(systemException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.requestSucceeded", "420");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught a SystemException in requestSucceeded()");
                }
            }
            catch (PropertyGroupTooLargeException propertyGroupTooLargeException) {
                FFDCFilter.processException(propertyGroupTooLargeException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.requestSucceeded", "425");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught a PropertyGroupTooLargeException in requestSucceeded()");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.requestSucceeded", "430");
                if (!tc.isEventEnabled()) break block10;
                Tr.event(tc, "Caught a Throwable in requestSucceeded()");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestSucceeded");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean peekContext(Map map) {
        boolean bl;
        block8: {
            ByteArray byteArray;
            block9: {
                byte[] byArray;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "peekContext", new Object[]{map, this});
                }
                bl = false;
                ArrayList arrayList = (ArrayList)map.get("com.ibm.ws.wscoor.context");
                if (arrayList == null || arrayList.isEmpty()) break block8;
                CoordinationContext coordinationContext = (CoordinationContext)arrayList.get(0);
                String string = coordinationContext.getIdentifier().getURI().toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "peekContext Coord context id", string);
                }
                if ((byArray = new ServantLocatorImpl().getSRToken(string)) == null) break block8;
                byteArray = map.put(AGGREGATOR_KEY, new ByteArray(byArray));
                bl = true;
                if (byteArray == null) break block8;
                if (!(byteArray instanceof ByteArray)) break block9;
                ByteArray byteArray2 = byteArray;
                if (Arrays.equals(byArray, byteArray2.getBytes())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Aggregator stoken key in Sib Map matches currrent stoken");
                    }
                    break block8;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Aggregator stoken key in Sib Map fails to match current stoken", byteArray);
                    }
                    throw new IllegalStateException("Aggregator stokens fail to match");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Aggregator stoken key in Sib Map is non-ByteArray", byteArray);
            }
            throw new ClassCastException("Aggregator stoken is in an invalid class");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "peekContext", bl);
        }
        return bl;
    }

    public Map systemContextToMap(SystemContext systemContext) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "systemContextToMap", new Object[]{systemContext, this});
        }
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        try {
            Serializable serializable;
            Serializable serializable2 = systemContext.getSystemContextItem("com.ibm.ws.activity.context");
            if (serializable2 != null) {
                hashMap.put("com.ibm.ws.activity.context", serializable2);
            }
            if ((serializable = systemContext.getSystemContextItem("com.ibm.ws.wscoor.context")) != null) {
                hashMap.put("com.ibm.ws.wscoor.context", serializable);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.systemContextToMap", "374");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught an IOException in systemContextToMap(), rethrowing as a SystemException.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "systemContextToMap", "SystemException");
            }
            throw new SystemException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.activity.remote.soap.ActivityServiceSystemContextHandler.systemContextToMap", "379");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught a ClassNotFoundException in systemContextToMap(), rethrowing as a SystemException.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "systemContextToMap", "SystemException");
            }
            throw new SystemException(classNotFoundException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "systemContextToMap", hashMap);
        }
        return hashMap;
    }

    public static void setOutboundSIBWSRequestFlagOnThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setOutboundSIBWSRequestFlagOnThread");
        }
        _outboundSIBWSRequest.set(new Object());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setOutboundSIBWSRequestFlagOnThread");
        }
    }

    public static void removeOutboundSIBWSRequestFlagFromThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeOutboundSIBWSRequestFlagFromThread");
        }
        _outboundSIBWSRequest.remove();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeOutboundSIBWSRequestFlagFromThread");
        }
    }

    public static boolean isOutboundSIBWSRequest() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isOutboundSIBWSRequest");
        }
        boolean bl = false;
        if (_outboundSIBWSRequest.get() != null) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isOutboundSIBWSRequest", bl);
        }
        return bl;
    }
}

