/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityContext;
import com.ibm.ws.activity.ContextExtractor;
import com.ibm.ws.activity.HLSInformation;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.remote.ActivityContextDescriptor;
import com.ibm.ws.activity.remote.ActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.activity.remote.soap.SOAPActivityContextDescriptor;
import com.ibm.ws.activity.remote.soap.WSActivityContextDescriptorFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.webservices.engine.MessageContext;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;

public class SOAPActivityContextDescriptorFactory
extends WSActivityContextDescriptorFactory
implements ActivityContextDescriptorFactory {
    private static final TraceComponent tc = Tr.register(SOAPActivityContextDescriptorFactory.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");

    public ActivityContextDescriptor createDescriptor(LocalActivityContext localActivityContext, boolean bl) {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createDescriptor", new Object[]{localActivityContext, bl, this});
        }
        SOAPActivityContextDescriptor sOAPActivityContextDescriptor = null;
        HLSInformation hLSInformation = localActivityContext.getHLSInformation();
        if (hLSInformation != null && ((n = hLSInformation.getWebServicePropagationEnabled()) == 1 || n == 2)) {
            boolean bl2 = n == 2;
            sOAPActivityContextDescriptor = new SOAPActivityContextDescriptor(localActivityContext, bl2, bl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createDescriptor", sOAPActivityContextDescriptor);
        }
        return sOAPActivityContextDescriptor;
    }

    public List extractDescriptors(Object object) throws SystemException, PropertyGroupTooLargeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractDescriptors", new Object[]{object, this});
        }
        MessageContext messageContext = (MessageContext)object;
        SOAPMessage sOAPMessage = messageContext.getMessage();
        SOAPHeader sOAPHeader = null;
        try {
            sOAPHeader = sOAPMessage.getSOAPHeader();
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.activity.remote.soap.SOAPActivityContextDescriptorFactory.extractDescriptors", "48", this);
        }
        List list = null;
        if (sOAPHeader != null) {
            list = SOAPActivityContextDescriptor.extractContextsFromSOAPHeader(sOAPHeader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                ActivityContextDescriptor.outputDescriptorHierarchy(list);
            }
            Iterator iterator = HLSInformation.getContextExtractors().iterator();
            while (iterator.hasNext()) {
                ContextExtractor contextExtractor = (ContextExtractor)iterator.next();
                ActivityContext activityContext = contextExtractor.extractContext(messageContext);
                if (activityContext != null) {
                    this.mapForeignIds(activityContext);
                    list.add(new SOAPActivityContextDescriptor(activityContext));
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Extracted context", activityContext);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "extractDescriptors", list);
        }
        return list;
    }
}

