/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.HLSInformation;
import com.ibm.ws.activity.ServerUserActivityImpl;
import com.ibm.ws.activity.coordination.ActivityHandlerCollaborator;
import com.ibm.ws.activity.remote.ActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.activity.remote.ServerSideProcessor;
import com.ibm.ws.activity.remote.soap.SOAPActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.soap.SOAPActivityContextDescriptorRenderer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.wsspi.webservices.rpc.handler.GenericHandler;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;

public class ServerHandler
extends GenericHandler {
    private static final TraceComponent tc = Tr.register(ServerHandler.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    private static ActivityContextDescriptorFactory _factory = new SOAPActivityContextDescriptorFactory();
    private static final boolean DISABLED = Boolean.valueOf(System.getProperty("com.ibm.ws.wsaddressingAndDependentsDisabled"));

    public boolean handleRequest(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest", new Object[]{messageContext, this});
        }
        if (!DISABLED && HLSInformation.isWebServiceEnabledHLSRegistered()) {
            ActivityHandlerCollaborator activityHandlerCollaborator = ServerUserActivityImpl.getActivityHandlerCollaborator();
            if (activityHandlerCollaborator != null) {
                activityHandlerCollaborator.inboundRequest(messageContext);
            }
            try {
                ServerSideProcessor.processRequest(_factory, messageContext);
            }
            catch (PropertyGroupTooLargeException propertyGroupTooLargeException) {
                FFDCFilter.processException((Throwable)propertyGroupTooLargeException, "com.ibm.ws.activity.remote.soap.ServerHandler.handleRequest", "42", this);
                JAXRPCException jAXRPCException = new JAXRPCException((Throwable)propertyGroupTooLargeException);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleRequest", (Object)jAXRPCException);
                }
                throw jAXRPCException;
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.remote.soap.ServerHandler.handleRequest", "50", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleRequest", "JAXRPCException");
                }
                throw new JAXRPCException((Throwable)systemException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest", Boolean.TRUE);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleResponse", new Object[]{messageContext, this});
        }
        if (!DISABLED && HLSInformation.isWebServiceEnabledHLSRegistered()) {
            ActivityHandlerCollaborator activityHandlerCollaborator = ServerUserActivityImpl.getActivityHandlerCollaborator();
            if (activityHandlerCollaborator != null) {
                activityHandlerCollaborator.outboundResponse(messageContext);
            }
            try {
                com.ibm.ws.webservices.engine.MessageContext messageContext2 = (com.ibm.ws.webservices.engine.MessageContext)messageContext;
                SOAPActivityContextDescriptorRenderer sOAPActivityContextDescriptorRenderer = new SOAPActivityContextDescriptorRenderer(messageContext2);
                ServerSideProcessor.processReply(sOAPActivityContextDescriptorRenderer);
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.activity.remote.soap.ServerHandler.handleResponse", "165", this);
                JAXRPCException jAXRPCException = new JAXRPCException((Throwable)systemException);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleResponse", (Object)jAXRPCException);
                }
                throw jAXRPCException;
            }
            catch (PropertyGroupTooLargeException propertyGroupTooLargeException) {
                FFDCFilter.processException((Throwable)propertyGroupTooLargeException, "com.ibm.ws.activity.remote.soap.ServerHandler.handleResponse", "70", this);
                JAXRPCException jAXRPCException = new JAXRPCException((Throwable)propertyGroupTooLargeException);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleResponse", (Object)jAXRPCException);
                }
                throw jAXRPCException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResponse", Boolean.TRUE);
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault", new Object[]{messageContext, this});
        }
        this.handleResponse(messageContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleFault", Boolean.TRUE);
        }
        return true;
    }

    public void handleClosure(MessageContext messageContext) {
    }
}

