/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityCoordinatorImpl;
import com.ibm.ws.activity.HLSInformation;
import com.ibm.ws.activity.coordination.WSCoorCoordinatorProxy;
import com.ibm.ws.activity.remote.CoordinatorProxy;
import com.ibm.ws.activity.remote.RemoteAction;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityNotProcessedException;
import com.ibm.ws.javax.activity.ActivityPendingException;
import com.ibm.ws.javax.activity.ContextPendingException;
import com.ibm.ws.javax.activity.NoActivityException;
import com.ibm.ws.javax.activity.Outcome;
import com.ibm.ws.javax.activity.SignalSetUnknownException;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.wscoor.RegisterResponseOperationHandler;
import com.ibm.ws.wscoor.RegisterType;
import com.ibm.ws.wscoor.WSCoorHelper;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URI;

public class WSCoorCoordinatorProxyWrapper
implements CoordinatorProxy {
    private static final TraceComponent tc = Tr.register(WSCoorCoordinatorProxyWrapper.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    private EndpointReference _registrationService;
    private WSCoorCoordinatorProxy _coordinatorProxy;
    private String _contextId;
    private RegisterResponseOperationHandler _registerResponseHandler;
    private static final long serialVersionUID = 6618583072901555651L;

    public WSCoorCoordinatorProxyWrapper(WSCoorCoordinatorProxy wSCoorCoordinatorProxy, String string, EndpointReference endpointReference, RegisterResponseOperationHandler registerResponseOperationHandler) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCoorCoordinatorProxyWrapper", new Object[]{wSCoorCoordinatorProxy, string, endpointReference, registerResponseOperationHandler});
        }
        this._coordinatorProxy = wSCoorCoordinatorProxy;
        this._contextId = string;
        this._registrationService = endpointReference;
        this._registerResponseHandler = registerResponseOperationHandler;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCoorCoordinatorProxyWrapper", this);
        }
    }

    public Outcome processSignalSet(String string, int n) throws ActivityNotProcessedException, SignalSetUnknownException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSignalSet", new Object[]{string, new Integer(n), this});
        }
        AttributedURI attributedURI = WSAddressingFactory.createAttributedURI(URI.create(string));
        this._coordinatorProxy.sendProtocolMessageToCoordinator(attributedURI);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSignalSet", null);
        }
        return null;
    }

    public Outcome completeActivity(String string, int n) throws ActivityPendingException, ContextPendingException, NoActivityException, SystemException {
        return null;
    }

    public byte[] toBytes() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toBytes", this);
        }
        if (this._registerResponseHandler.waitForRegisterResponse(this._coordinatorProxy.getAsyncTimeout())) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = null;
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this._coordinatorProxy);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.activity.remote.soap.WSCoorCoordinatorProxyWrapper.toBytes", "86", this);
                SystemException systemException = new SystemException();
                systemException.initCause(iOException);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "toBytes", systemException);
                }
                throw systemException;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "toBytes", byArray);
            }
            return byArray;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toBytes", "SystemException");
        }
        throw new SystemException();
    }

    public RemoteAction registerSubordinate(ActivityCoordinatorImpl activityCoordinatorImpl, HLSInformation hLSInformation) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSubordinate", new Object[]{activityCoordinatorImpl, hLSInformation, this});
        }
        RegisterType registerType = this._coordinatorProxy.getRegisterType(this._contextId);
        try {
            if (this._coordinatorProxy.supportsTwoWay()) {
                WSCoorHelper.doSyncRegister(registerType, this._registrationService, this._contextId, this._registerResponseHandler, this._coordinatorProxy.getFaultServiceAddress().getURI());
            } else {
                WSCoorHelper.doAsyncRegister(registerType, this._registrationService, this._contextId, this._registerResponseHandler, this._coordinatorProxy.getFaultServiceAddress().getURI());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.activity.remote.soap.WSCoorCoordinatorProxyWrapper.registerSubordinate", "144", this);
            SystemException systemException = new SystemException(exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "registerSubordinate", systemException);
            }
            throw systemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSubordinate", null);
        }
        return null;
    }

    public RemoteAction createActionForSubordinate(ActivityCoordinatorImpl activityCoordinatorImpl, HLSInformation hLSInformation) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createActionForSubordinate", new Object[]{activityCoordinatorImpl, hLSInformation, this});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createActionForSubordinate", null);
        }
        return null;
    }

    public boolean readyToBePersisted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readyToBePersisted", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readyToBePersisted");
        }
        return this._registerResponseHandler.waitForRegisterResponse(this._coordinatorProxy.getAsyncTimeout());
    }

    public int getType() {
        return 2;
    }

    public void destroy() {
    }
}

