/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.coordination.WSCoorParticipantProxy;
import com.ibm.ws.activity.remote.AsynchronousAction;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActionErrorException;
import com.ibm.ws.javax.activity.Outcome;
import com.ibm.ws.javax.activity.Signal;

public final class WSCoorParticipantProxyWrapper
extends AsynchronousAction {
    private static final TraceComponent tc = Tr.register(WSCoorParticipantProxyWrapper.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    WSCoorParticipantProxy _participantProxy;
    private long _retryInterval;
    private int _maxRetries;
    private static final long serialVersionUID = -1935988685684413303L;

    public WSCoorParticipantProxyWrapper(WSCoorParticipantProxy wSCoorParticipantProxy, int n, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCoorParticipantProxyWrapper", new Object[]{wSCoorParticipantProxy, new Integer(n), new Long(l)});
        }
        this._participantProxy = wSCoorParticipantProxy;
        this._maxRetries = n;
        this._retryInterval = l;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCoorParticipantProxyWrapper", this);
        }
    }

    public void processAsyncSignal(Signal signal) throws ActionErrorException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processAsyncSignal", new Object[]{signal, this});
        }
        if (!(bl = this._participantProxy.sendProtocolMessageToParticipant(signal, this._semaphore, this._parentCoordinator))) {
            boolean bl2;
            int n = this._maxRetries;
            boolean bl3 = bl2 = n < 0;
            while ((bl2 || n-- > 0) && !bl) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Sleeping for " + this._retryInterval + " prior to retrying call to " + this._participantProxy);
                    }
                    Thread.sleep(this._retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.activity.remote.soap.WSCoorParticipantProxyWrapper.processAsyncSignal", "83", this);
                }
                bl = this._participantProxy.sendProtocolMessageToParticipant(signal, this._semaphore, this._parentCoordinator);
            }
        }
        if (!bl) {
            ActionErrorException actionErrorException = new ActionErrorException();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processAsyncSignal");
            }
            throw actionErrorException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processAsyncSignal");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy", this);
        }
        this._participantProxy.destroy();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public Outcome getOutcome() {
        return this._participantProxy.getOutcome();
    }

    public String getContextId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextId");
        }
        String string = this._participantProxy.getContextId();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextId", string);
        }
        return string;
    }
}

