/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.splitprocess;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityServiceComponentImpl;
import com.ibm.ws.activity.splitprocess.CosActivityFactoryImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosActivity.Action;
import org.omg.CosActivity.ActionError;
import org.omg.CosActivity.AlreadyDestroyed;
import org.omg.CosActivity.Outcome;
import org.omg.CosActivity.Signal;
import org.omg.CosActivity._ActionImplBase;

final class CosControllerActivityActionImpl
extends _ActionImplBase {
    private static final TraceComponent tc = Tr.register(CosControllerActivityActionImpl.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    private Action _srAction = null;
    private boolean _isRecovering = false;
    private boolean _isRecoverable = false;
    private byte[] _srStoken = null;
    private static final long serialVersionUID = -3419724623273595403L;

    public CosControllerActivityActionImpl(Action action, byte[] byArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CosControllerActivityActionImpl", new Object[]{action, byArray, bl});
        }
        this._srAction = action;
        this._isRecoverable = bl;
        this._srStoken = byArray;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CosControllerActivityActionImpl", this);
        }
    }

    public Outcome process_signal(Signal signal) throws ActionError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "process_signal", new Object[]{signal, this});
        }
        if (this._isRecovering) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Servant is recovering. Throw TRANSIENT");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "process_signal", "TRANSIENT");
            }
            throw new TRANSIENT("Servant is recovering");
        }
        final Signal signal2 = signal;
        Outcome outcome = null;
        try {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws ActionError {
                    return CosControllerActivityActionImpl.this._srAction.process_signal(signal2);
                }
            };
            outcome = (Outcome)ActivityServiceComponentImpl.runAsSystem(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.activity.splitprocess.CosControllerActivityActionImpl.process_signal", "159", this);
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof ActionError) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "ActionError Exception caught during signal processing. Throwing", privilegedActionException.getCause());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "process_signal");
                }
                throw (ActionError)((Object)privilegedActionException.getCause());
            }
            if (throwable instanceof BAD_OPERATION) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "BAD_OPERATION caught", privilegedActionException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "process_signal");
                }
                throw (BAD_OPERATION)throwable;
            }
            if (throwable instanceof INTERNAL) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CORBA INTERNAL Exception caught during signal processing.", privilegedActionException);
                }
                this.processInternalException((INTERNAL)throwable);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "process_signal");
                }
                throw (INTERNAL)throwable;
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught. Throwing ActionError", privilegedActionException);
            }
            Object[] objectArray = new Object[]{"process_signal", this.getClass().getName(), privilegedActionException};
            Tr.error(tc, "ERR_UNEXP_EXCPN", objectArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "process_signal", "ActionError");
            }
            throw new ActionError();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "process_signal", outcome);
        }
        return outcome;
    }

    public void destroy() throws AlreadyDestroyed {
    }

    public void setIsRecovering(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIsRecovering", new Object[]{bl, this});
        }
        this._isRecovering = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setIsRecovering");
        }
    }

    public void refreshServantInfo(Action action, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshServantInfo", new Object[]{action, byArray, this});
        }
        this._srAction = action;
        this._srStoken = byArray;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshServantInfo");
        }
    }

    private void processInternalException(INTERNAL iNTERNAL) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processInternalException", new Object[]{iNTERNAL, this});
        }
        if (CosActivityFactoryImpl.isServantFailure(iNTERNAL)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The Servant that contained the SR action is dead. Servant Stoken: ", this._srStoken);
            }
            if (this._isRecoverable) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Servant is recovering. Throw TRANSIENT");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processInternalException", "TRANSIENT");
                }
                throw new TRANSIENT("Servant is recovering");
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Servant is dead. No recovery. Throw OBJECT_NOT_EXIST");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processInternalException", "OBJECT_NOT_EXIST");
            }
            throw new OBJECT_NOT_EXIST("Servant died");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processInternalException");
        }
    }
}

