/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ant.utils;

import com.ibm.ws.ant.utils.WebSphereStreamPumper;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.condition.Os;

public class WebSpherePumpStreamHandler
extends PumpStreamHandler {
    String encoding = null;
    OutputStreamWriter outs = null;
    BufferedWriter bufferWriter = null;

    public WebSpherePumpStreamHandler(OutputStream outputStream, OutputStream outputStream2, String string) throws UnsupportedEncodingException {
        super(outputStream, outputStream2);
        this.outs = new OutputStreamWriter(outputStream, string);
        this.bufferWriter = new BufferedWriter(this.outs);
        this.encoding = string;
    }

    public WebSpherePumpStreamHandler(OutputStream outputStream, OutputStream outputStream2) throws UnsupportedEncodingException {
        super(outputStream, outputStream2);
        this.outs = new OutputStreamWriter(outputStream);
        this.bufferWriter = new BufferedWriter(this.outs);
    }

    public WebSpherePumpStreamHandler(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(outputStream, outputStream, string);
    }

    public WebSpherePumpStreamHandler(String string) throws UnsupportedEncodingException {
        this(System.out, System.err, string);
    }

    public static String getEncoding() {
        String string = System.getProperty("file.encoding");
        if (Os.isFamily((String)"z/os")) {
            String string2 = System.getProperty("ibm.system.encoding");
            if (string2 != null || string2 != "") {
                // empty if block
            }
            string = string2;
        }
        return string;
    }

    protected Thread createPump(InputStream inputStream, OutputStream outputStream) {
        Thread thread = new Thread((Runnable)((Object)new WebSphereStreamPumper(inputStream, outputStream, this.bufferWriter, WebSpherePumpStreamHandler.getEncoding())));
        thread.setDaemon(true);
        return thread;
    }

    public void stop() {
        super.stop();
        try {
            if (this.bufferWriter != null) {
                this.bufferWriter.flush();
                this.bufferWriter.close();
            }
            if (this.outs != null) {
                this.outs.close();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            throw new BuildException((Throwable)exception);
        }
    }
}

