/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.appprofile;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.appprofile.accessintent.resources.AccessIntentMessages;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class AppProfileApplicationData {
    private static final TraceComponent _tc = Tr.register(AppProfileApplicationData.class, "AppProfile", "com.ibm.ws.appprofile.accessintent.resources.accessintent");
    private String applicationName;
    private int J2EEVersionID;
    private HashMap allTasks = new HashMap();
    private HashMap allProfiles = new HashMap();

    public AppProfileApplicationData(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AppProfileApplicationData", new Object[]{string});
        }
        this.applicationName = string;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "AppProfileApplicationData");
        }
    }

    public String getName() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getName", new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getName", this.applicationName);
        }
        return this.applicationName;
    }

    public void addTask(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addTask", new Object[]{string, string2});
        }
        if (string == null) {
            AccessIntentMessages.outputMessage(_tc, "ACIN_ERRO_NULL_ATTRIBUTE", new Object[]{"TASK_NAME"});
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateApplicationProfile", "A task without a name cannot be processed");
            }
        } else if (string2 == null) {
            AccessIntentMessages.outputMessage(_tc, "ACIN_ERRO_NULL_ATTRIBUTE", new Object[]{"APPLICATION_PROFILE_NAME"});
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "addTask", "A profile without a name cannot be processed");
            }
        } else {
            HashSet hashSet;
            String string3 = (String)this.allTasks.get(string);
            if (string3 != null && !string3.equals(string2)) {
                AccessIntentMessages.outputMessage(_tc, "ACIN_WARN_DUPLICATE_TASK_PROFILE", new Object[]{string, string3, string2});
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "addTask", "The same task appears in two profiles; we'll use the last one we're asked to");
                }
                if ((hashSet = (HashSet)this.allProfiles.get(string3)) != null) {
                    hashSet.remove(string);
                }
            }
            this.allTasks.put(string, string3);
            hashSet = (HashSet)this.allProfiles.get(string2);
            if (hashSet == null) {
                hashSet = new HashSet();
                this.allProfiles.put(string2, hashSet);
            }
            hashSet.add(string);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addTask");
        }
    }

    public HashMap getAllTasks() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getAllTasks", new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getAllTasks", this.allTasks);
        }
        return this.allTasks;
    }

    public HashMap getAllProfiles() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getAllProfiles", new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getAllProfiles", this.allProfiles);
        }
        return this.allProfiles;
    }

    public void setJ2EEVersionID(int n) {
        this.J2EEVersionID = n;
    }

    public int getJ2EEVersionID() {
        return this.J2EEVersionID;
    }

    public void printAppProfileApplicationData() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "printAppProfileApplicationData");
        }
        if (_tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Application name: " + this.applicationName + "    ");
            stringBuffer.append("J2EE Version: " + this.J2EEVersionID + "\n");
            Iterator iterator = this.allProfiles.keySet().iterator();
            int n = 1;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = "" + n++ + " " + string + ": {";
                HashSet hashSet = (HashSet)this.allProfiles.get(string);
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    string2 = string2 + iterator2.next() + ", ";
                }
                string2 = string2 + "}";
                stringBuffer.append("    " + string2 + "\n");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, "\n************* AppProfile Application Data *************\n");
                stringBuffer.append("************************* End **************************\n");
            }
            Tr.debug(_tc, stringBuffer.toString());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "printAppProfileApplicationData");
        }
    }
}

