/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.appprofile;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.appprofile.accessintent.resources.AccessIntentMessages;

public class AppProfileAttribute {
    private String name;
    private boolean entity;
    private String taskName;
    private int taskNameLevel = -1;
    private AccessIntent accessIntent;
    private int accessIntentLevel = -1;
    private static final TraceComponent _tc = Tr.register(AppProfileAttribute.class, "AppProfile", "com.ibm.ws.appprofile.accessintent.resources.accessintent");

    public AppProfileAttribute(EJBMethodInfo eJBMethodInfo, EJBComponentMetaData eJBComponentMetaData) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AppProfileAttribute", new Object[]{eJBMethodInfo, eJBComponentMetaData.getJ2EEName()});
        }
        J2EEName j2EEName = eJBComponentMetaData.getJ2EEName();
        String string = j2EEName.getComponent();
        String string2 = eJBMethodInfo.getMethodSignature();
        boolean bl = false;
        if (eJBMethodInfo.isHome()) {
            bl = true;
        }
        boolean bl2 = false;
        if (eJBMethodInfo.isLocalInterface()) {
            bl2 = true;
        }
        this.entity = eJBComponentMetaData.isEntityBean();
        int n = string2.indexOf(58);
        this.name = string + "." + string2.substring(0, n) + "(" + string2.substring(n + 1, string2.length()) + ")";
        if (bl2) {
            this.name = this.name + " : local";
        }
        if (bl) {
            this.name = this.name + " : home";
        }
        if (this.entity) {
            this.name = this.name + " : entity ";
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "AppProfileAttribute", "AppProfileAttribute created for " + this.name);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "AppProfileAttribute");
        }
    }

    public void replaceAccessIntent(AccessIntent accessIntent) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "replaceAccessIntent", accessIntent);
        }
        this.accessIntent = accessIntent;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "replaceAccessIntent");
        }
    }

    public void setAccessIntent(AccessIntent accessIntent, Integer n) {
        int n2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setAccessIntent", new Object[]{accessIntent, n});
        }
        if ((n2 = n.intValue()) == this.accessIntentLevel && !accessIntent.equals(this.accessIntent)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "setAccessIntent", "Duplicate access intent; will use the second and issue warning");
            }
            AccessIntentMessages.outputMessage(_tc, "ACIN_WARN_DUPLICATE_ACCESS_INTENT_CONFIG", new Object[]{this.name, this.accessIntent, accessIntent});
        }
        if (n2 >= this.accessIntentLevel) {
            this.accessIntent = accessIntent;
            this.accessIntentLevel = n2;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setAccessIntent");
        }
    }

    public void setTask(String string, Integer n) {
        int n2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setTask", new Object[]{string, n});
        }
        if ((n2 = n.intValue()) == this.accessIntentLevel && !string.equals(this.taskName)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "setAccessIntent", "Duplicate access intent; will use the second and issue warning");
            }
            AccessIntentMessages.outputMessage(_tc, "ACIN_WARN_DUPLICATE_TASK", new String[]{this.name, this.taskName, string});
        }
        if (n2 >= this.taskNameLevel) {
            this.taskName = string;
            this.taskNameLevel = n2;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setTask");
        }
    }

    public String getName() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getName", new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getName");
        }
        return this.name;
    }

    public String getTaskName() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getTaskName", new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getTaskName", this.taskName);
        }
        return this.taskName;
    }

    public AccessIntent getAccessIntent() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getAccessIntent", new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getAccessIntent", this.accessIntent);
        }
        return this.accessIntent;
    }

    public String getConfigurationPresentation() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getConfigurationPresentation", new Object[0]);
        }
        String string = null;
        String string2 = this.getTaskName();
        AccessIntent accessIntent = this.getAccessIntent();
        if (string2 != null || accessIntent != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getName() + "\n");
            if (string2 != null) {
                stringBuffer.append("  run as: " + string2 + "\n");
            }
            if (accessIntent != null) {
                stringBuffer.append("  access intent: " + accessIntent + "\n");
            }
            string = stringBuffer.toString();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getConfigurationPresentation", string);
        }
        return string;
    }

    public String toString() {
        AccessIntent accessIntent;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "toString", new Object[0]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName() + " ");
        String string = this.getTaskName();
        if (string != null) {
            stringBuffer.append("runAs: " + string + " ");
        }
        if ((accessIntent = this.getAccessIntent()) != null) {
            stringBuffer.append("intent:  ");
        }
        String string2 = stringBuffer.toString();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "toString", string2);
        }
        return string2;
    }
}

