/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.appprofile;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.appprofile.accessintent.resources.AccessIntentMessages;
import java.util.HashMap;
import java.util.Iterator;

public class AppProfileComponentData {
    protected String name;
    protected String taskName;
    protected HashMap taskNameRefMap = new HashMap();
    protected String applicationName;
    private static final TraceComponent _tc = Tr.register(AppProfileComponentData.class, "AppProfile", "com.ibm.ws.appprofile.accessintent.resources.accessintent");

    public AppProfileComponentData(J2EEName j2EEName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AppProfileComponentData", new Object[]{j2EEName});
        }
        this.name = j2EEName.getComponent();
        this.applicationName = j2EEName.getApplication();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "AppProfileComponentData");
        }
    }

    public void setTaskName(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setTaskName", new Object[]{string});
        }
        if (string == null) {
            AccessIntentMessages.outputMessage(_tc, "ACIN_ERRO_NULL_ATTRIBUTE", new Object[]{"TASK_NAME"});
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateApplicationProfile", "A task without a name cannot be processed");
            }
        } else {
            if (this.taskName != null && !this.taskName.equals(string)) {
                AccessIntentMessages.outputMessage(_tc, "ACIN_WARN_DUPLICATE_TASK", new Object[]{this.name, this.taskName, string});
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "setTaskName", "Duplicate task assignment; will override");
                }
            }
            this.taskName = string;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setTaskName");
        }
    }

    public void addTaskNameRef(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addTaskNameRef", new Object[]{string, string2});
        }
        String string3 = (String)this.taskNameRefMap.get(string);
        if (string == null) {
            AccessIntentMessages.outputMessage(_tc, "ACIN_ERRO_NULL_ATTRIBUTE", new Object[]{"TASK_REFERENCE_NAME"});
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateApplicationProfile", "A task reference without a name cannot be processed");
            }
        } else if (string2 == null) {
            AccessIntentMessages.outputMessage(_tc, "ACIN_ERRO_NULL_ATTRIBUTE", new Object[]{"TASK_NAME"});
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateApplicationProfile", "A task without a name cannot be processed");
            }
        } else {
            if (string3 != null && !string3.equals(string2)) {
                AccessIntentMessages.outputMessage(_tc, "ACIN_WARN_DUPLICATE_TASK_REFERENCE", new Object[]{this.name, string, string2, string3});
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "addTaskNameRef", string + "/" + string2 + " mapping will override " + string + "/" + string3 + " mapping");
                }
            }
            this.taskNameRefMap.put(string, string2);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addTaskNameRef");
        }
    }

    public String getName() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getName", new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getName", this.name);
        }
        return this.name;
    }

    public String getTaskName() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getTaskName", new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getTaskName", this.taskName);
        }
        return this.taskName;
    }

    public String getTaskName(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getTaskName", new Object[]{string});
        }
        String string2 = (String)this.taskNameRefMap.get(string);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getTaskName", string2);
        }
        return string2;
    }

    public HashMap getTaskNameRefMap() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getTaskNameRefMap", new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getTaskNameRefMap", this.taskNameRefMap);
        }
        return this.taskNameRefMap;
    }

    public String getConfigurationPresentation() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getConfigurationPresentation", new Object[0]);
        }
        String string = null;
        String string2 = this.getTaskName();
        if (string2 != null || this.taskNameRefMap.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getName() + "\n");
            if (string2 != null) {
                stringBuffer.append(" Own task: " + string2 + "\n");
            }
            Iterator iterator = this.taskNameRefMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = (String)this.taskNameRefMap.get(string3);
                stringBuffer.append("    Logical name: " + string3 + " -> task: " + string4 + "\n");
            }
            string = stringBuffer.toString();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getConfigurationPresentation", string);
        }
        return string;
    }

    public void printAppProfileComponentData() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "printAppProfileComponentData");
        }
        if (_tc.isDebugEnabled()) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Entity name : " + this.name + "\n");
            stringBuffer.append("Application name : " + this.applicationName + "\n");
            if (this.taskName != null) {
                stringBuffer.append("  Own task: " + this.getTaskName() + "\n");
            }
            if (this.taskNameRefMap.size() > 0) {
                stringBuffer.append("  Task references: \n");
                object = this.taskNameRefMap.keySet().iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    String string2 = (String)this.taskNameRefMap.get(string);
                    stringBuffer.append("    Logical name: " + string + " -> task: " + string2 + "\n");
                }
            }
            object = stringBuffer.toString();
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, "\n************* AppProfile ComponentData *************\n");
                stringBuffer.append("************************* End **************************\n");
            }
            Tr.debug(_tc, stringBuffer.toString());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "printAppProfileComponentData");
        }
    }

    public void postProcess() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "postProcess", new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "postProcess");
        }
    }
}

