/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.appprofile;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.appprofile.AppProfileComponentData;
import com.ibm.ws.appprofile.accessintent.AccessIntentFactory;
import com.ibm.ws.appprofile.accessintent.resources.AccessIntentMessages;
import java.util.HashMap;
import java.util.Iterator;

public class AppProfileEntityComponentData
extends AppProfileComponentData {
    private HashMap taskNameAccessIntentMap = new HashMap();
    private AccessIntent defaultAccessIntent;
    private boolean lifetimeInCache;
    private static final TraceComponent _tc = Tr.register(AppProfileEntityComponentData.class, "AppProfile", "com.ibm.ws.appprofile.accessintent.resources.accessintent");
    private boolean isMappedToOracle = false;
    private boolean isBeanManaged;
    private boolean mayLoadByMethodLevelConfiguration = true;

    public AppProfileEntityComponentData(J2EEName j2EEName, boolean bl, boolean bl2) {
        super(j2EEName);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AppProfileEntityComponentData", new Object[]{j2EEName, new Boolean(bl), new Boolean(bl2)});
        }
        this.lifetimeInCache = bl;
        this.isBeanManaged = bl2;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "AppProfileEntityComponentData");
        }
    }

    public boolean hasMethodLevelConfiguration() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "hasMethodLevelConfiguration");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "hasMethodLevelConfiguration", new Boolean(this.mayLoadByMethodLevelConfiguration));
        }
        return this.mayLoadByMethodLevelConfiguration;
    }

    public void hasMethodLevelConfiguration(boolean bl) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "hasMethodLevelConfiguration", new Boolean(bl));
        }
        this.mayLoadByMethodLevelConfiguration = bl;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "hasMethodLevelConfiguration");
        }
    }

    public boolean isBeanManaged() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "isBeanManaged");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "isBeanManaged", new Boolean(this.isBeanManaged));
        }
        return this.isBeanManaged;
    }

    public void setIsMappedToOracle(boolean bl) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setIsMappedToOraclet", new Object[]{new Boolean(bl)});
        }
        this.isMappedToOracle = bl;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setIsMappedToOracle");
        }
    }

    public boolean getIsMappedToOracle() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getIsMappedToOracle");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getIsMappedToOracle", new Boolean(this.isMappedToOracle));
        }
        return this.isMappedToOracle;
    }

    public void replaceDefaultAccessIntent(AccessIntent accessIntent) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "replaceDefaultAccessIntent", new Object[]{accessIntent});
        }
        this.defaultAccessIntent = accessIntent;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "replaceDefaultAccessIntent");
        }
    }

    public void setDefaultAccessIntent(AccessIntent accessIntent) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setDefaultAccessIntent", new Object[]{accessIntent});
        }
        if (this.defaultAccessIntent != null && !this.defaultAccessIntent.equals(accessIntent)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "setAccessIntent", "Duplicate access intent; will use the second and issue warning");
            }
            AccessIntentMessages.outputMessage(_tc, "ACIN_WARN_DUPLICATE_ACCESS_INTENT_CONFIG", new Object[]{this.name, this.defaultAccessIntent, accessIntent});
        }
        this.defaultAccessIntent = accessIntent;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setDefaultAccessIntent");
        }
    }

    public AccessIntent getDefaultAccessIntent() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getDefaultAccessIntent");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getDefaultAccessIntent");
        }
        return this.defaultAccessIntent;
    }

    public void postProcess() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "postProcess", new Object[0]);
        }
        if (this.defaultAccessIntent == null) {
            this.defaultAccessIntent = this.lifetimeInCache ? AccessIntentFactory.DEFAULT_ACCESSINTENT_FOR_LIFETIME_IN_CACHE : AccessIntentFactory.DEFAULT_ACCESSINTENT;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "postProcess");
        }
    }

    public void fillDefaultAccessIntents(HashMap hashMap) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "fillDefaultAccessIntents", hashMap);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.taskNameAccessIntentMap.get(string) != null) continue;
            this.taskNameAccessIntentMap.put(string, this.defaultAccessIntent);
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "fillDefaultAccessIntents", "Mapped task: " + string + " with default intent of: " + this.defaultAccessIntent);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "fillDefaultAccessIntents");
        }
    }

    public void addAccessIntentTaskMapping(String string, AccessIntent accessIntent) {
        AccessIntent accessIntent2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addAccessIntentTaskMapping", new Object[]{string, accessIntent});
        }
        if ((accessIntent2 = (AccessIntent)this.taskNameAccessIntentMap.get(string)) != null && !accessIntent2.equals(accessIntent)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "setAccessIntent", "Duplicate access intent for task; will use the second and issue warning");
            }
            AccessIntentMessages.outputMessage(_tc, "ACIN_WARN_DUPLICATE_TASK_ACCESS_INTENT_CONFIG", new Object[]{this.name, string, accessIntent2, accessIntent});
        }
        this.taskNameAccessIntentMap.put(string, accessIntent);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addAccessIntentTaskMapping");
        }
    }

    public AccessIntent getAccessIntent(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getAccessIntent", string);
        }
        AccessIntent accessIntent = null;
        if (string != null) {
            accessIntent = (AccessIntent)this.taskNameAccessIntentMap.get(string);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getAccessIntent", accessIntent);
        }
        return accessIntent;
    }

    public AccessIntent getAccessIntent(String string, boolean bl) {
        AccessIntent accessIntent;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getAccessIntent", new Object[]{string, new Boolean(bl)});
        }
        if ((accessIntent = this.getAccessIntent(string)) == null && bl) {
            accessIntent = this.defaultAccessIntent;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getAccessIntent", accessIntent);
        }
        return accessIntent;
    }

    public String getConfigurationPresentation() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getConfigurationPresentation", new Object[0]);
        }
        String string = super.getConfigurationPresentation();
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            stringBuffer.append(this.getName());
        }
        stringBuffer.append("  default access intent: " + this.defaultAccessIntent);
        string = stringBuffer.toString();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getConfigurationPresentation", string);
        }
        return string;
    }

    public void printAppProfileEntityComponentData() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "printAppProfileEntityComponentData");
        }
        if (_tc.isDebugEnabled()) {
            Object object;
            String string = super.toString();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string + "\n");
            stringBuffer.append("Entity name : " + this.name + "\n");
            stringBuffer.append("Application name : " + this.applicationName + "\n");
            stringBuffer.append("Default access intent for transactions not configured via application profiling : " + this.defaultAccessIntent + "\n");
            if (this.taskNameAccessIntentMap.size() > 0) {
                object = this.taskNameAccessIntentMap.keySet().iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    AccessIntent accessIntent = (AccessIntent)this.taskNameAccessIntentMap.get(string2);
                    stringBuffer.append("task: ");
                    stringBuffer.append(string2);
                    stringBuffer.append(" will use intent: ");
                    stringBuffer.append(accessIntent);
                    stringBuffer.append("\n");
                }
            }
            object = stringBuffer.toString();
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, "\n************* AppProfile EntityComponentData *************\n");
                stringBuffer.append("************************* End **************************\n");
            }
            Tr.debug(_tc, stringBuffer.toString());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "printAppProfileEntityComponentData");
        }
    }
}

