/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.appprofile;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.websphere.models.extensions.appprofileapplicationext.ApplicationProfile;
import com.ibm.websphere.models.extensions.appprofileapplicationext.ApplicationProfileExtension;
import com.ibm.websphere.models.extensions.appprofileapplicationext.AppprofileapplicationextPackage;
import com.ibm.websphere.models.extensions.appprofilecommonext.AppProfileComponentExtension;
import com.ibm.websphere.models.extensions.appprofilecommonext.AppprofilecommonextPackage;
import com.ibm.websphere.models.extensions.appprofilecommonext.Task;
import com.ibm.websphere.models.extensions.appprofileejbext.AppProfileEJBJarExtension;
import com.ibm.websphere.models.extensions.appprofileejbext.EJBModuleProfile;
import com.ibm.websphere.models.extensions.helpers.PMEApplicationExtensionHelper;
import com.ibm.websphere.models.extensions.helpers.impl.PMEApplicationExtensionHelperImpl;
import com.ibm.websphere.models.extensions.helpers.impl.PMEEJBJarExtensionHelperImpl;
import com.ibm.websphere.models.extensions.helpers.impl.PMEWebAppExtensionHelperImpl;
import com.ibm.ws.appprofile.AppProfileApplicationData;
import com.ibm.ws.appprofile.BaseServiceRegistration;
import com.ibm.ws.appprofile.MetaDataHelper;
import com.ibm.ws.appprofile.accessintent.resources.AccessIntentMessages;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedApplication;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;

public class ApplicationMetaDataHelper
extends MetaDataHelper
implements MetaDataListener {
    private static final TraceComponent _tc = Tr.register(ApplicationMetaDataHelper.class, "AppProfile", "com.ibm.ws.appprofile.accessintent.resources.accessintent");
    protected static final Map appProfileConfigMap = Collections.synchronizedMap(new HashMap());
    private static final boolean UpdateApplicationXMI = System.getProperty("com.ibm.websphere.appprofile.updateApplicationXMI", "false").equalsIgnoreCase("true");

    public ApplicationMetaDataHelper() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ApplicationMetaDataHelper", new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ApplicationMetaDataListener");
        }
    }

    public void metaDataCreated(MetaDataEvent metaDataEvent) throws RuntimeWarning {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "metaDataCreated", new Object[]{metaDataEvent});
        }
        try {
            MetaData metaData = metaDataEvent.getMetaData();
            if (metaData instanceof ApplicationMetaData) {
                DeployedApplication deployedApplication = (DeployedApplication)metaDataEvent.getDeployedObject();
                EARFile eARFile = (EARFile)deployedApplication.getModuleFile();
                String string = eARFile.getSpecVersion();
                boolean bl = ApplicationMetaDataHelper.containsAppProfileConfiguration(eARFile);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "metaDataCreated", "Application name: " + metaData.getName() + " , spec: " + string + " , containsAppProfileConfiguration: " + bl);
                }
                if (bl) {
                    if (!BaseServiceRegistration.instance().isAppProfileServiceEnabled()) {
                        AccessIntentMessages.outputMessage(_tc, "ACIN_ERRO_DISABLED_BUT_REQUIRED", new Object[]{metaData.getName()});
                        throw new RuntimeWarning("The " + metaData.getName() + " application is configured for application profiling, but the Application Profiling service is disabled", null);
                    }
                    if (string.equals("1.3") && BaseServiceRegistration.instance().getCompatibility()) {
                        if (!BaseServiceRegistration.instance().has5xSupport()) {
                            AccessIntentMessages.outputMessage(_tc, "ACIN_ERRO_RESTART_SERVER_REQUIRED", new Object[]{metaData.getName()});
                            throw new RuntimeWarning("The " + metaData.getName() + " application is configured to require the Application Profiling service, but it is installed and starting on a running server that enables Application Profiling 5.x Compatibility Mode.", null);
                        }
                        AccessIntentMessages.outputMessage(_tc, "ACIN_WARN_COMPATIBILITY_MODE", new Object[]{metaData.getName()});
                    } else if (!BaseServiceRegistration.instance().has6xSupport()) {
                        BaseServiceRegistration.instance().enable6xSupport();
                    }
                }
                PMEApplicationExtensionHelperImpl pMEApplicationExtensionHelperImpl = new PMEApplicationExtensionHelperImpl(eARFile);
                if (this.isSupportedVersion("1.3", string)) {
                    this.processMetaData(eARFile, (PMEApplicationExtensionHelper)pMEApplicationExtensionHelperImpl, (ApplicationMetaData)metaData);
                }
            }
        }
        catch (RuntimeWarning runtimeWarning) {
            throw runtimeWarning;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.appprofile.ApplicationMetaDataHelper.metaDataCreated", "140", this);
            AccessIntentMessages.handleException(_tc, throwable, "metaDataCreated", "Exception merging module profiles into app", "ACIN_ERRO_UNEXPECTED_EXCEPTION", new String[]{"PROCESSING_CONFIGURATION"}, true);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "metaDataCreated");
        }
    }

    public static boolean containsAppProfileConfiguration(EARFile eARFile) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "containsAppProfileConfiguration", new Object[]{eARFile});
        }
        boolean bl = true;
        try {
            Boolean bl2 = (Boolean)appProfileConfigMap.get(eARFile.getAbsolutePath());
            bl = bl2 != null ? bl2 : ApplicationMetaDataHelper.isEARFileContainsAppProfileConfiguration(eARFile);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "containsAppProfileConfiguration", "Caught exception: " + throwable);
            }
            bl = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "containsAppProfileConfiguration", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isEARFileContainsAppProfileConfiguration(EARFile eARFile) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "isEARFileContainsAppProfileConfiguration", new Object[]{eARFile});
        }
        try {
            Iterator iterator;
            Object object;
            boolean bl = false;
            PMEApplicationExtensionHelperImpl pMEApplicationExtensionHelperImpl = new PMEApplicationExtensionHelperImpl(eARFile, false);
            ApplicationProfileExtension applicationProfileExtension = pMEApplicationExtensionHelperImpl.getApplicationProfileExtension();
            if (applicationProfileExtension != null) {
                bl = true;
                object = applicationProfileExtension.getApplicationProfile().iterator();
                while (object.hasNext()) {
                    iterator = (ApplicationProfile)object.next();
                    if (iterator.getTasks().size() <= 0) continue;
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "isEARFileContainsAppProfileConfiguration", new Boolean(true));
                    }
                    return true;
                }
            }
            object = eARFile.getDeploymentDescriptor();
            iterator = object.getModules().iterator();
            while (iterator.hasNext()) {
                Object object2;
                Iterator iterator2;
                AppProfileEJBJarExtension appProfileEJBJarExtension;
                PMEEJBJarExtensionHelperImpl pMEEJBJarExtensionHelperImpl;
                EJBJarFile eJBJarFile;
                Module module = (Module)iterator.next();
                ModuleRef moduleRef = eARFile.getModuleRef(module);
                moduleRef.getDeploymentDescriptor();
                ModuleFile moduleFile = moduleRef.getModuleFile();
                if (moduleFile.isEJBJarFile()) {
                    eJBJarFile = (EJBJarFile)moduleFile;
                    pMEEJBJarExtensionHelperImpl = new PMEEJBJarExtensionHelperImpl(eJBJarFile, false);
                    appProfileEJBJarExtension = pMEEJBJarExtensionHelperImpl.getAppProfileEJBJarExtension();
                    if (appProfileEJBJarExtension == null) continue;
                    if (appProfileEJBJarExtension.getRunAsTasks().size() > 0) {
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "isEARFileContainsAppProfileConfiguration", new Boolean(true));
                        }
                        return true;
                    }
                    iterator2 = appProfileEJBJarExtension.getAppProfileComponentExtensions().iterator();
                    while (iterator2.hasNext()) {
                        object2 = (AppProfileComponentExtension)iterator2.next();
                        if (object2.getTaskRefs().size() <= 0) continue;
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "isEARFileContainsAppProfileConfiguration", new Boolean(true));
                        }
                        return true;
                    }
                    if (bl) continue;
                    object2 = appProfileEJBJarExtension.getApplicationProfiles().iterator();
                    while (object2.hasNext()) {
                        EJBModuleProfile eJBModuleProfile = (EJBModuleProfile)object2.next();
                        if (eJBModuleProfile.getTasks().size() <= 0) continue;
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "isEARFileContainsAppProfileConfiguration", new Boolean(true));
                        }
                        return true;
                    }
                    continue;
                }
                if (!moduleFile.isWARFile() || (appProfileEJBJarExtension = (pMEEJBJarExtensionHelperImpl = new PMEWebAppExtensionHelperImpl((WARFile)(eJBJarFile = (WARFile)moduleFile), false)).getAppProfileWebAppExtension()) == null) continue;
                iterator2 = appProfileEJBJarExtension.getAppProfileComponentExtensions().iterator();
                while (iterator2.hasNext()) {
                    object2 = (AppProfileComponentExtension)iterator2.next();
                    if (object2.getTask() != null) {
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "isEARFileContainsAppProfileConfiguration", new Boolean(true));
                        }
                        return true;
                    }
                    if (object2.getTaskRefs().size() <= 0) continue;
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "isEARFileContainsAppProfileConfiguration", new Boolean(true));
                    }
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.appprofile.ApplicationMetaDataHelper.isEARFileContainsAppProfileConfiguration", "256");
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "isEARFileContainsAppProfileConfiguration", throwable);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "isEARFileContainsAppProfileConfiguration", new Boolean(true));
            }
            return true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "isEARFileContainsAppProfileConfiguration", new Boolean(false));
        }
        return false;
    }

    public void processMetaData(EARFile eARFile, PMEApplicationExtensionHelper pMEApplicationExtensionHelper, ApplicationMetaData applicationMetaData) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processMetaData");
        }
        try {
            RuntimeWarning runtimeWarning;
            Object object;
            String string;
            Task task;
            Object object2;
            String string2;
            Object object3;
            List list;
            EList eList;
            EList eList2;
            pMEApplicationExtensionHelper = new PMEApplicationExtensionHelperImpl(eARFile, false);
            ApplicationProfileExtension applicationProfileExtension = pMEApplicationExtensionHelper.getApplicationProfileExtension();
            if (applicationProfileExtension == null || UpdateApplicationXMI) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "processMetaData", "Will create app-scoped profile configuration");
                }
                pMEApplicationExtensionHelper = new PMEApplicationExtensionHelperImpl(eARFile);
                applicationProfileExtension = pMEApplicationExtensionHelper.getApplicationProfileExtension();
                boolean bl = false;
                eList2 = new PMEApplicationExtensionHelperImpl(eARFile);
                applicationProfileExtension = eList2.getApplicationProfileExtension();
                eList = applicationProfileExtension.getApplicationProfile();
                list = eARFile.getEJBJarFiles();
                object3 = list.iterator();
                while (object3.hasNext()) {
                    string2 = (EJBJarFile)object3.next();
                    object2 = new PMEEJBJarExtensionHelperImpl((EJBJarFile)string2, false);
                    task = object2.getAppProfileEJBJarExtension();
                    if (task == null) continue;
                    string = task.getApplicationProfiles();
                    if (string.size() > 0) {
                        bl = true;
                    }
                    object = string.iterator();
                    runtimeWarning = (XMLResource)eARFile.getMofResource("META-INF/ibm-application-ext-pme.xmi");
                    while (object.hasNext()) {
                        EJBModuleProfile eJBModuleProfile = (EJBModuleProfile)object.next();
                        ApplicationMetaDataHelper.updateApplicationProfile(eJBModuleProfile, applicationMetaData, applicationProfileExtension, (XMLResource)runtimeWarning);
                    }
                }
                if (bl) {
                    try {
                        string2 = URI.createURI((String)"META-INF/ibm-application-ext-pme.xmi");
                        object2 = eARFile.getResourceSet();
                        task = object2.getResource((URI)string2, false);
                        if (task == null) {
                            task = object2.createResource((URI)string2);
                        }
                        string = task;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "processMetaData", "Saving resource: " + string);
                        }
                        AccessController.doPrivileged(new PrivilegedExceptionAction((Resource)string){
                            private final /* synthetic */ Resource val$resource;
                            {
                                this.val$resource = resource;
                            }

                            public Object run() throws Exception {
                                this.val$resource.save(null);
                                return new Boolean(true);
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.appprofile.ApplicationMetaDataHelper.processMetaData", "348", this);
                        AccessIntentMessages.handleException(_tc, throwable, "processMetaData", "Exception saving profiles into ear-scoped xmi", "ACIN_ERRO_UNEXPECTED_EXCEPTION", new String[]{"PROCESSING_CONFIGURATION"}, true);
                        AccessIntentMessages.outputMessage(_tc, "ACIN_WARN_CANNOT_ADMINISTER_FROM_CONSOLE", null);
                        throwable.printStackTrace();
                    }
                }
            }
            AppProfileApplicationData appProfileApplicationData = new AppProfileApplicationData(applicationMetaData.getName());
            appProfileApplicationData.setJ2EEVersionID(eARFile.getSpecVersionID());
            eList2 = applicationProfileExtension.getApplicationProfile();
            if (eList2.size() > 0) {
                eList = eList2.iterator();
                while (eList.hasNext()) {
                    list = (ApplicationProfile)eList.next();
                    object3 = list.getName();
                    if (object3 == null) {
                        string2 = "An application profile cannot be null; this profile cannot be processed";
                        object2 = new RuntimeWarning(string2);
                        FFDCFilter.processException((Throwable)object2, "com.ibm.ws.appprofile.ApplicationMetaDataHelper.processMetaData", "378", this);
                        continue;
                    }
                    string2 = list.getTasks();
                    object2 = string2.iterator();
                    while (object2.hasNext()) {
                        task = (Task)object2.next();
                        string = task.getName();
                        if (string == null) {
                            object = "A task without a name cannot be processed";
                            runtimeWarning = new RuntimeWarning((String)object);
                            FFDCFilter.processException((Throwable)runtimeWarning, "com.ibm.ws.appprofile.ApplicationMetaDataHelper.processMetaData", "389", this);
                            continue;
                        }
                        appProfileApplicationData.addTask(string, (String)object3);
                    }
                }
            }
            applicationMetaData.setMetaData(BaseServiceRegistration.instance().getAppMetaDataSlot(), appProfileApplicationData);
            if (_tc.isDebugEnabled()) {
                appProfileApplicationData.printAppProfileApplicationData();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.appprofile.ApplicationMetaDataHelper.processMetaData", "403", this);
            AccessIntentMessages.handleException(_tc, throwable, "processMetaData", "Unexpectedly failed processing meta data; may run with incomplete app-profile configuration", "ACIN_ERRO_UNEXPECTED_EXCEPTION", null, true);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processMetaData");
        }
    }

    public static String ensureUniqueID(XMLResource xMLResource, String string) {
        string = string + "_";
        long l = System.currentTimeMillis();
        String string2 = string + l;
        Map map = xMLResource.getIDToEObjectMap();
        while (map.get(string2) != null) {
            string2 = string + ++l;
        }
        return string2;
    }

    public static void assignID(EObject eObject, XMLResource xMLResource) {
        String string = eObject.eClass().getName();
        String string2 = ApplicationMetaDataHelper.ensureUniqueID(xMLResource, string);
        xMLResource.setID(eObject, string2);
    }

    public static ApplicationProfile updateApplicationProfile(EJBModuleProfile eJBModuleProfile, ApplicationMetaData applicationMetaData, ApplicationProfileExtension applicationProfileExtension, XMLResource xMLResource) {
        Task task;
        Iterator iterator;
        EList eList;
        Iterator iterator2;
        EList eList2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateApplicationProfile", new Object[]{eJBModuleProfile, applicationMetaData, applicationProfileExtension});
        }
        ApplicationProfile applicationProfile = null;
        String string = eJBModuleProfile.getName();
        String string2 = eJBModuleProfile.getDescription();
        if (string == null) {
            AccessIntentMessages.outputMessage(_tc, "ACIN_ERRO_NULL_ATTRIBUTE", new Object[]{"APPLICATION_PROFILE_NAME"});
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateApplicationProfile", "An application profile without a name cannot be processed");
            }
        } else {
            eList2 = applicationProfileExtension.getApplicationProfile();
            iterator2 = eList2.iterator();
            while (iterator2.hasNext() && applicationProfile == null) {
                applicationProfile = (ApplicationProfile)iterator2.next();
                if (string.equals(applicationProfile.getName())) continue;
                applicationProfile = null;
            }
            if (applicationProfile == null) {
                applicationProfile = AppprofileapplicationextPackage.eINSTANCE.getAppprofileapplicationextFactory().createApplicationProfile();
                applicationProfile.setName(string);
                applicationProfile.setDescription(string2);
                eList2.add(applicationProfile);
                ApplicationMetaDataHelper.assignID((EObject)applicationProfile, xMLResource);
            }
            eList = eJBModuleProfile.getTasks();
            iterator = eList.iterator();
            while (iterator.hasNext()) {
                task = (Task)iterator.next();
                ApplicationMetaDataHelper.updateTasks((List)applicationProfile.getTasks(), task, xMLResource);
            }
        }
        eList2 = applicationProfileExtension.getApplicationProfile();
        iterator2 = eList2.iterator();
        while (iterator2.hasNext() && applicationProfile == null) {
            applicationProfile = (ApplicationProfile)iterator2.next();
            if (applicationProfile.getName().equals(string)) continue;
            applicationProfile = null;
        }
        if (applicationProfile == null) {
            applicationProfile = AppprofileapplicationextPackage.eINSTANCE.getAppprofileapplicationextFactory().createApplicationProfile();
            applicationProfile.setName(string);
            applicationProfile.setDescription(string2);
            eList2.add(applicationProfile);
            ApplicationMetaDataHelper.assignID((EObject)applicationProfile, xMLResource);
        }
        eList = eJBModuleProfile.getTasks();
        iterator = eList.iterator();
        while (iterator.hasNext()) {
            task = (Task)iterator.next();
            ApplicationMetaDataHelper.updateTasks((List)applicationProfile.getTasks(), task, xMLResource);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateApplicationProfile", applicationProfile);
        }
        return applicationProfile;
    }

    public static Task updateTasks(List list, Task task, XMLResource xMLResource) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateTasks", new Object[]{list, task});
        }
        Task task2 = null;
        String string = task.getName();
        String string2 = task.getDescription();
        if (string == null) {
            AccessIntentMessages.outputMessage(_tc, "ACIN_ERRO_NULL_ATTRIBUTE", new Object[]{"TASK_NAME"});
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateApplicationProfile", "A task without a name cannot be processed");
            }
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && task2 == null) {
                task2 = (Task)iterator.next();
                if (ApplicationMetaDataHelper.stringsEqual(task2.getName(), string) && ApplicationMetaDataHelper.stringsEqual(task2.getDescription(), string2)) continue;
                task2 = null;
            }
            if (task2 == null) {
                task2 = AppprofilecommonextPackage.eINSTANCE.getAppprofilecommonextFactory().createTask();
                task2.setName(string);
                task2.setDescription(string2);
                list.add(task2);
                ApplicationMetaDataHelper.assignID((EObject)task2, xMLResource);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateTasks", task2);
        }
        return task2;
    }

    public static boolean stringsEqual(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stringsEqual", new Object[]{string, string2});
        }
        boolean bl = false;
        if (string == null) {
            if (string2 == null) {
                bl = true;
            }
        } else {
            bl = string.equals(string2);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stringsEqual", new Boolean(bl));
        }
        return bl;
    }

    public void metaDataDestroyed(MetaDataEvent metaDataEvent) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "metaDataDestroyed", new Object[]{metaDataEvent});
        }
        try {
            MetaData metaData = metaDataEvent.getMetaData();
            if (metaData instanceof ApplicationMetaData) {
                DeployedApplication deployedApplication = (DeployedApplication)metaDataEvent.getDeployedObject();
                EARFile eARFile = (EARFile)deployedApplication.getModuleFile();
                String string = eARFile.getAbsolutePath();
                appProfileConfigMap.remove(string);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "metaDataDestroyed", "Removed the following path from the config map: " + string);
                }
            }
        }
        catch (Throwable throwable) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "metaDataDestroyed", "The following exception was caused: " + throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.appprofile.ApplicationMetaDataHelper.metaDataDestroyed", "573", this);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "metaDataDestroyed");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Property: UpdateApplicationXMI = " + UpdateApplicationXMI);
        }
    }
}

