/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.asynchbeans.Alarm;
import com.ibm.websphere.asynchbeans.AlarmListener;
import com.ibm.websphere.asynchbeans.AlarmManagerEvents;
import com.ibm.ws.asynchbeans.AlarmManagerImpl;
import com.ibm.ws.asynchbeans.AsynchBeanManager;
import com.ibm.ws.asynchbeans.WLMWorkManagerImpl;
import com.ibm.ws.asynchbeans.services.wlm.ClassificationService;
import com.ibm.ws.asynchbeans.timer.GenericTimer;
import com.ibm.ws.ffdc.FFDCFilter;
import commonj.work.WorkException;

public final class AlarmImpl
extends GenericTimer
implements Alarm {
    static final TraceComponent tc = Tr.register(AlarmImpl.class, "AsynchBeans_Alarms", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    private AlarmManagerImpl alarmManager;
    private Object context;
    private AlarmListener userListener;
    private static final ClassificationService classSvc = ClassificationService.instance();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append("AlarmImpl(").append(this.userListener).append(",").append(Util.identity(this.context)).append(",AlarmManager:").append(this.genericTimerManager).append(")");
        return stringBuffer.toString();
    }

    public AlarmImpl(AlarmManagerImpl alarmManagerImpl, AlarmListener alarmListener, Object object, long l) {
        this.alarmManager = alarmManagerImpl;
        this.context = object;
        this.userListener = alarmListener;
        this.setAlarm(true);
        l = (l += System.currentTimeMillis()) < 0L ? Long.MAX_VALUE : l;
        this.init(alarmManagerImpl, l, 0L, false, alarmListener, true, 0);
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getContext() {
        Object object = this.timerLock;
        synchronized (object) {
            this.checkDestroyed();
            return this.context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runListenerAsCJWork() {
        WorkException workException;
        boolean bl;
        block16: {
            bl = tc.isEntryEnabled();
            if (bl) {
                Tr.entry(tc, "runListenerAsCJWork", this);
            }
            if (this.setWASAlarmAndCheckCancelled(null)) {
                if (bl) {
                    Tr.exit(tc, "runListenerAsCJWork", "Alarm cancelled");
                }
                return;
            }
            workException = null;
            try {
                if (this.callerContext != null) {
                    AsynchBeanManager asynchBeanManager = this.alarmManager.getAsynchBeanManager();
                    boolean bl2 = ClassificationService.isEnabled();
                    if (bl2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Classification Service is enabled");
                        }
                        classSvc.setExecutingWorkManager((WLMWorkManagerImpl)asynchBeanManager);
                    }
                    try {
                        workException = this.callerContext.run(this.asynchBeanManager, this.asynchBeanManager.getContextDescriptor(), this, null, this.callerContext, null, null, null, 32, 1);
                        break block16;
                    }
                    finally {
                        if (bl2) {
                            classSvc.setExecutingWorkManager(null);
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "runListenerAsCJWork", "callerContext is null");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.asynchbeans.AlarmImpl.runListenerAsCJWork", "160", this);
                Tr.error(tc, "MSG_KEY_38", new Object[]{throwable});
                this.sendAlarmThrewExceptionEvent(throwable);
                if (!bl) break block16;
                Tr.exit(tc, "runListenerAsCJWork", "Throwable");
            }
        }
        if (workException != null) {
            FFDCFilter.processException(workException, "com.ibm.ws.asynchbeans.AlarmImpl.runListenerAsCJWork", "268", this);
            Tr.error(tc, "MSG_KEY_38", new Object[]{workException});
            this.sendAlarmThrewExceptionEvent(workException);
            if (bl) {
                Tr.exit(tc, "runListenerAsCJWork", "commonj.work.WorkException");
            }
        }
        if (bl) {
            Tr.exit(tc, "runListenerAsCJWork");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(int n) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "reset", new Object[]{new Integer(n), this});
        }
        try {
            Object object = this.timerLock;
            synchronized (object) {
                this.checkDestroyed();
                if (this.wasAlarm != null) {
                    this.wasAlarm.cancel();
                }
                this.wasAlarm = this.asynchBeanManager.getRawAlarmManager().create(this, this, (long)n + System.currentTimeMillis(), 0L, false, true);
            }
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, this.getClass().getName() + ".reset", "261", this);
            Tr.info(tc, "MSG_KEY_39", illegalStateException);
            throw illegalStateException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.asynchbeans.AlarmImpl.reset", "194", this);
            Tr.error(tc, "MSG_KEY_39", new Object[]{throwable});
        }
    }

    public void destroy() {
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "cancel", new Object[]{this});
        }
        try {
            Object object = this.timerLock;
            synchronized (object) {
                this.cancelled = true;
                if (this.wasAlarm != null) {
                    this.wasAlarm.cancel();
                }
                this.genericTimerManager.destroyAlarm(this);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.asynchbeans.AlarmImpl.cancel", "226", this);
            Tr.error(tc, "MSG_KEY_40", new Object[]{throwable});
            if (bl) {
                Tr.exit(tc, "cancel", "Throwable");
            }
            return;
        }
        if (bl) {
            Tr.exit(tc, "cancel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AlarmListener getAlarmListener() {
        Object object = this.timerLock;
        synchronized (object) {
            this.checkDestroyed();
            return this.userListener;
        }
    }

    protected void callListenerMethod() {
        this.userListener.fired(this);
    }

    protected void sendAlarmThrewExceptionEvent(Throwable throwable) {
        AlarmManagerImpl alarmManagerImpl = (AlarmManagerImpl)this.genericTimerManager;
        AlarmManagerEvents alarmManagerEvents = (AlarmManagerEvents)alarmManagerImpl.getEventTrigger(AlarmManagerEvents.class);
        alarmManagerEvents.alarmThrewException(alarmManagerImpl, this, throwable);
    }
}

