/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.Alarm;
import com.ibm.websphere.asynchbeans.AlarmListener;
import com.ibm.websphere.asynchbeans.AlarmManager;
import com.ibm.websphere.asynchbeans.AlarmManagerEvents;
import com.ibm.ws.asynchbeans.AlarmImpl;
import com.ibm.ws.asynchbeans.AsynchBeanManager;
import com.ibm.ws.asynchbeans.AsynchScopeImpl;
import com.ibm.ws.asynchbeans.J2EEServiceManager;
import com.ibm.ws.asynchbeans.Messages;
import com.ibm.ws.asynchbeans.timer.GenericTimerManager;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.HashSet;
import javax.management.MBeanNotificationInfo;

public final class AlarmManagerImpl
extends GenericTimerManager
implements AlarmManager {
    static final TraceComponent tc = Tr.register(AlarmManagerImpl.class, "AsynchBeans_Alarms", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    AsynchScopeImpl asynchScopeOwner;
    private boolean destroyed;

    public MBeanNotificationInfo[] getNotificationInfo() {
        return null;
    }

    public AlarmManagerImpl(AsynchBeanManager asynchBeanManager, AsynchScopeImpl asynchScopeImpl) {
        super(asynchBeanManager);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AlarmManagerImpl.<init>", new Object[]{this, asynchBeanManager, asynchScopeImpl});
        }
        this.timers = new HashSet(asynchBeanManager.initialAlarmCapacity);
        this.setDestroyed(false);
        this.asynchScopeOwner = asynchScopeImpl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AlarmManagerImpl.<init>", this);
        }
    }

    protected synchronized void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    protected synchronized boolean getDestroyed() {
        return this.destroyed;
    }

    public synchronized Alarm create(AlarmListener alarmListener, Object object, int n) {
        if (alarmListener == null) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE_2", new Object[]{null, "com.ibm.websphere.asynchbeans.AlarmListener"}));
        }
        J2EEServiceManager.checkValidAsyncBean(alarmListener);
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "create(AlarmListener, Object, int)", new Object[]{this, alarmListener, object, new Integer(n)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "create(AlarmListener, Object, int)", "Owner AsynchScope=" + this.asynchScopeOwner);
        }
        try {
            if (this.getDestroyed()) {
                if (bl) {
                    Tr.exit(tc, "create(AlarmListener, Object, int)", "Exception");
                }
                throw new IllegalStateException(Messages.getMsg("INVALID_TIMERMANAGER_STATE", new Object[]{"AlarmManager", "destroyed"}));
            }
            AlarmImpl alarmImpl = new AlarmImpl(this, alarmListener, object, n);
            this.timers.add(alarmImpl);
            if (bl) {
                Tr.exit(tc, "create(AlarmListener, Object, int)", alarmImpl);
            }
            return alarmImpl;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            FFDCFilter.processException((Throwable)outOfMemoryError, "com.ibm.ws.asynchbeans.AlarmManagerImpl.create", "111", this);
            Tr.error(tc, "MSG_KEY_43", new Object[]{outOfMemoryError});
            throw outOfMemoryError;
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.asynchbeans.AlarmManagerImpl.create", "113", this);
            Tr.error(tc, "MSG_KEY_43", new Object[]{illegalStateException});
            throw illegalStateException;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.asynchbeans.AlarmManagerImpl.create", "117", this);
            Tr.error(tc, "MSG_KEY_43", new Object[]{runtimeException});
            throw runtimeException;
        }
    }

    protected void sendDestroyedEvent() {
        AlarmManagerEvents alarmManagerEvents = (AlarmManagerEvents)this.getEventTrigger(AlarmManagerEvents.class);
        alarmManagerEvents.destroyed(this);
    }

    public String toString() {
        return "AlarmManagerImpl:" + this.asynchScopeOwner;
    }
}

