/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.pool.ObjectPool;
import com.ibm.websphere.asynchbeans.pool.ObjectPoolManager;
import com.ibm.ws.asynchbeans.AsynchContextDescriptor;
import com.ibm.ws.asynchbeans.AsynchContextDescriptorImpl2;
import com.ibm.ws.asynchbeans.AsynchScopeManagerImpl;
import com.ibm.ws.asynchbeans.J2EEServiceManager;
import com.ibm.ws.asynchbeans.Messages;
import com.ibm.ws.asynchbeans.am.AlarmManager;
import com.ibm.ws.asynchbeans.timer.CancelTimerListenerRunnable;
import com.ibm.ws.asynchbeans.timer.StopTimerListenerRunnable;
import com.ibm.ws.asynchbeans.timer.TimerManagerImpl;
import com.ibm.ws.asynchbeans.util.AsynchBeanUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.asynchbeans.CommonJWorkManagerConfiguration;
import com.ibm.wsspi.asynchbeans.TimerManagerConfiguration;
import com.ibm.wsspi.asynchbeans.WorkManagerConfiguration;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;

public class AsynchBeanManager
extends AsynchScopeManagerImpl {
    static TraceComponent tc = Tr.register(AsynchBeanManager.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    protected AlarmManager rawAlarmMgr;
    protected int maxAlarmThreads;
    protected int threadPriority;
    public int initialAlarmCapacity;
    protected String name = null;
    static ObjectPoolManager poolManager = null;
    static ObjectPool arrayListPool = null;
    static ObjectPool stopTimerListenerRunnablePool = null;
    static ObjectPool cancelTimerListenerRunnablePool = null;
    String _defaultTransactionClass = "ASYNCBN";
    String _daemonTransactionClass = "ASYNCDMN";
    private HashMap timerManagers;
    protected ComponentMetaDataAccessorImpl cmda;
    private static char[] INVALID_MBEAN_CHARS = new char[]{':', '\"', ',', '=', '*', '?'};

    public AsynchBeanManager() {
        this.setAsynchBeanManager(this);
    }

    public AsynchBeanManager(String string, String[] stringArray, boolean bl) {
        this.setAsynchBeanManager(this);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AsynchBeanManager(name, String[]), isExcluded", AsynchBeanUtil.populateArrayForTrace(new Object[]{string, stringArray, new Boolean(bl)}));
        }
        this.name = string;
        String[] stringArray2 = stringArray;
        this.contextDescriptor = new AsynchContextDescriptorImpl2(bl, stringArray2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AsynchBeanManager(TimerManagerConfiguration)", this);
        }
    }

    public AsynchBeanManager(TimerManagerConfiguration timerManagerConfiguration) {
        this(timerManagerConfiguration.getName(), timerManagerConfiguration.getEnabledServices(), timerManagerConfiguration.isExcluded());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AsynchBeanManager(TimerManagerConfiguration)", timerManagerConfiguration);
        }
        this.threadPriority = 5;
        this.maxAlarmThreads = timerManagerConfiguration.getNumAlarmThreads();
        this.initialAlarmCapacity = timerManagerConfiguration.getInitialAlarmCapacity();
        String string = timerManagerConfiguration.getDefTranClass();
        if (string != null && string.trim().length() > 0) {
            this._defaultTransactionClass = string;
        }
        this.rawAlarmMgr = new AlarmManager(this);
    }

    public AsynchBeanManager(CommonJWorkManagerConfiguration commonJWorkManagerConfiguration) {
        this(commonJWorkManagerConfiguration.getName(), commonJWorkManagerConfiguration.getEnabledServices(), commonJWorkManagerConfiguration.isExcluded());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AsynchBeanManager(CommonJWorkManagerConfiguration)", commonJWorkManagerConfiguration);
        }
        this.maxAlarmThreads = 0;
    }

    public AsynchBeanManager(WorkManagerConfiguration workManagerConfiguration) {
        this((CommonJWorkManagerConfiguration)workManagerConfiguration);
        this.maxAlarmThreads = workManagerConfiguration.getNumAlarmThreads();
        this.initialAlarmCapacity = workManagerConfiguration.getInitialAlarmCapacity();
        this.threadPriority = workManagerConfiguration.getThreadPriority();
        if (this.threadPriority > 10 || this.threadPriority < 1) {
            this.threadPriority = 5;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The tread priority value is not valid, the thread priority  value will be set to Thread.NORM_PRIORITY !");
            }
        }
        this.rawAlarmMgr = new AlarmManager(this);
    }

    public String getDefaultTransactionClass() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultTransactionClass");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultTransactionClass", this._defaultTransactionClass);
        }
        return this._defaultTransactionClass;
    }

    public String getDaemonTransactionClass() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDaemonTransactionClass");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDaemonTransactionClass", this._daemonTransactionClass);
        }
        return this._daemonTransactionClass;
    }

    public AlarmManager getRawAlarmManager() {
        return this.rawAlarmMgr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getMaxAlarmThreads() {
        return this.maxAlarmThreads;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public static synchronized void initObjectPool() {
        if (poolManager == null) {
            poolManager = J2EEServiceManager.getSelf().getSystemObjectPoolManager();
            try {
                arrayListPool = poolManager.getPool(ArrayList.class);
                stopTimerListenerRunnablePool = poolManager.getPool(StopTimerListenerRunnable.class);
                cancelTimerListenerRunnablePool = poolManager.getPool(CancelTimerListenerRunnable.class);
            }
            catch (InstantiationException instantiationException) {
                FFDCFilter.processException((Throwable)instantiationException, "com.ibm.ws.asynchbeans.AsynchBeanManager.initObjectPool", "138", "");
                Tr.fatal(tc, "MSG_KEY_46");
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.asynchbeans.AsynchBeanManager.initObjectPool", "145", "");
                Tr.fatal(tc, "MSG_KEY_46");
            }
        }
    }

    public static ArrayList getPooledArrayList() {
        AsynchBeanManager.initObjectPool();
        ArrayList arrayList = null;
        arrayList = (ArrayList)arrayListPool.getObject();
        arrayList.clear();
        return arrayList;
    }

    public static void returnPooledArrayList(ArrayList arrayList) {
        AsynchBeanManager.initObjectPool();
        arrayListPool.returnObject(arrayList);
    }

    public static StopTimerListenerRunnable getPooledStopTimerListenerRunnable() {
        AsynchBeanManager.initObjectPool();
        StopTimerListenerRunnable stopTimerListenerRunnable = (StopTimerListenerRunnable)stopTimerListenerRunnablePool.getObject();
        return stopTimerListenerRunnable;
    }

    public static void returnPooledStopTimerListenerRunnable(StopTimerListenerRunnable stopTimerListenerRunnable) {
        AsynchBeanManager.initObjectPool();
        stopTimerListenerRunnablePool.returnObject(stopTimerListenerRunnable);
    }

    public static CancelTimerListenerRunnable getPooledCancelTimerListenerRunnable() {
        AsynchBeanManager.initObjectPool();
        CancelTimerListenerRunnable cancelTimerListenerRunnable = (CancelTimerListenerRunnable)cancelTimerListenerRunnablePool.getObject();
        return cancelTimerListenerRunnable;
    }

    public static void returnPooledCancelTimerListenerRunnable(CancelTimerListenerRunnable cancelTimerListenerRunnable) {
        AsynchBeanManager.initObjectPool();
        cancelTimerListenerRunnablePool.returnObject(cancelTimerListenerRunnable);
    }

    public static ObjectPoolManager getObjectPoolManager() {
        AsynchBeanManager.initObjectPool();
        return poolManager;
    }

    public TimerManagerImpl createTimerManager(String string) {
        TimerManagerImpl timerManagerImpl = new TimerManagerImpl(this, string);
        this.addTimerManagerToMap(timerManagerImpl);
        return timerManagerImpl;
    }

    private void addTimerManagerToMap(TimerManagerImpl timerManagerImpl) {
        String string = timerManagerImpl.getAppName();
        ArrayList<TimerManagerImpl> arrayList = null;
        if (this.timerManagers == null) {
            this.timerManagers = new HashMap(5);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addTimerManagerToMap", "Create TimerManager map and add the TimerManager to a new entry: " + timerManagerImpl);
            }
            arrayList = new ArrayList<TimerManagerImpl>(5);
            arrayList.add(timerManagerImpl);
            this.timerManagers.put(string, arrayList);
        } else {
            arrayList = (ArrayList<TimerManagerImpl>)this.timerManagers.get(string);
            if (arrayList == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addTimerManagerToMap", "Add the TimerManager to a new entry: " + timerManagerImpl);
                }
                arrayList = new ArrayList<TimerManagerImpl>(5);
                arrayList.add(timerManagerImpl);
                this.timerManagers.put(string, arrayList);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addTimerManagerToMap", "Add the TimerManager to an existing entry: " + timerManagerImpl);
                }
                arrayList.add(timerManagerImpl);
            }
        }
    }

    public void stopTimerManagersForApp(String string) {
        ArrayList arrayList = null;
        RuntimeException runtimeException = null;
        if (this.timerManagers == null || (arrayList = (ArrayList)this.timerManagers.get(string)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stopTimerManagersForApp", "No timer managers for application " + string + ", exit.");
            }
        } else {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                try {
                    TimerManagerImpl timerManagerImpl = (TimerManagerImpl)arrayList.remove(i);
                    timerManagerImpl.stop();
                    continue;
                }
                catch (RuntimeException runtimeException2) {
                    if (runtimeException != null) continue;
                    FFDCFilter.processException((Throwable)runtimeException2, "com.ibm.ws.asynchbeans.AsynchBeanManager.stopTimerManagersForApp", "304", "");
                    runtimeException = runtimeException2;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stopTimerManagersForApp", "all timer managers for application " + string + " are stopped.");
            }
        }
        this.timerManagers.remove(arrayList);
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimerManager(TimerManagerImpl timerManagerImpl) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "removeTimerManager", new Object[]{this, timerManagerImpl});
        }
        String string = timerManagerImpl.getAppName();
        ArrayList arrayList = null;
        try {
            HashMap hashMap = this.timerManagers;
            synchronized (hashMap) {
                arrayList = (ArrayList)this.timerManagers.get(string);
                arrayList.remove(timerManagerImpl);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.asynchbeans.AsynchBeanManager.stopTimerManagersForApp", "399", "");
            Tr.error(tc, Messages.getMsg("MSG_KEY_UNEX_EXCEPT", new Object[]{throwable}));
        }
    }

    public AsynchContextDescriptor getContextDescriptor() {
        return this.contextDescriptor;
    }

    public static String getMBeanValue(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        block0: for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            for (int j = 0; j < INVALID_MBEAN_CHARS.length; ++j) {
                if (INVALID_MBEAN_CHARS[j] != c) continue;
                stringBuffer.setCharAt(i, '.');
                continue block0;
            }
        }
        return stringBuffer.toString();
    }

    class GetThreadPool
    implements PrivilegedAction {
        private String name;

        GetThreadPool(String string) {
            this.name = string;
        }

        public Object run() {
            return J2EEServiceManager.getSelf().getThreadPool(this.name);
        }
    }
}

