/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.asynchbeans.AsynchContextDescriptor;
import com.ibm.ws.asynchbeans.J2EEServiceManager;
import com.ibm.ws.asynchbeans.ServiceWithContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AsynchContextDescriptorImpl
implements AsynchContextDescriptor {
    private static final long serialVersionUID = -1164652367919794925L;
    static final TraceComponent tc = Tr.register(AsynchContextDescriptorImpl.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    transient Set enabledServices;
    boolean securityEnabled;
    ArrayList enabledServiceNames;
    static Set overriddenServiceNames = new HashSet(3);

    public AsynchContextDescriptorImpl(boolean bl, String[] stringArray) {
        this.inflateContext(bl, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init() {
        boolean bl = tc.isDebugEnabled();
        boolean bl2 = tc.isEntryEnabled();
        if (bl2) {
            Tr.entry(tc, "init");
        }
        try {
            if (this.enabledServices == null) {
                String[] stringArray;
                if (this.enabledServiceNames == null) {
                    if (bl) {
                        Tr.debug(tc, "Creating empty list of service");
                    }
                    this.enabledServiceNames = new ArrayList();
                    stringArray = new String[]{""};
                } else {
                    if (bl) {
                        Tr.debug(tc, "Retrieving " + this.enabledServiceNames.size() + " service names.", new Object[]{this.enabledServiceNames});
                    }
                    stringArray = new String[this.enabledServiceNames.size()];
                    this.enabledServiceNames.toArray(stringArray);
                }
                this.inflateContext(false, stringArray);
            }
        }
        finally {
            if (bl2) {
                Tr.exit(tc, "init");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void inflateContext(boolean bl, String[] stringArray) {
        boolean bl2 = tc.isDebugEnabled();
        boolean bl3 = tc.isEntryEnabled();
        if (bl3) {
            Tr.entry(tc, "inflateContext");
        }
        try {
            Object v;
            String string;
            this.enabledServiceNames = new ArrayList();
            this.enabledServices = new HashSet();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray == null) {
                throw new IllegalArgumentException("serviceNames must not be null");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            Map map = J2EEServiceManager.getSelf().getServices();
            Iterator<Object> iterator = overriddenServiceNames.iterator();
            while (iterator.hasNext()) {
                this.enabledServices.add(map.get((String)iterator.next()));
            }
            if (bl) {
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (arrayList.contains(string) || overriddenServiceNames.contains(string) || (v = map.get(string)) == null) continue;
                    this.enabledServices.add(v);
                    this.enabledServiceNames.add(string);
                }
                boolean bl4 = this.securityEnabled = !arrayList.contains("security");
                if (this.securityEnabled) {
                    this.enabledServiceNames.add("security");
                }
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    string = (String)arrayList.get(i);
                    if (overriddenServiceNames.contains(string) || (v = map.get(string)) == null) continue;
                    this.enabledServices.add(v);
                    this.enabledServiceNames.add(string);
                }
                this.securityEnabled = arrayList.contains("security");
                if (this.securityEnabled) {
                    this.enabledServiceNames.add("security");
                }
            }
            if (bl2) {
                Iterator iterator2 = this.enabledServiceNames.iterator();
                while (iterator2.hasNext()) {
                    string = (String)iterator2.next();
                    Tr.debug(tc, " Service: " + string + " enabled");
                }
            }
        }
        finally {
            if (bl3) {
                Tr.exit(tc, "inflateContext");
            }
        }
    }

    public boolean isServiceEnabled(ServiceWithContext serviceWithContext) {
        this.init();
        return this.enabledServices.contains(serviceWithContext);
    }

    public boolean isServiceEnabled(String string) {
        this.init();
        return this.enabledServiceNames.contains(string);
    }

    public boolean isSecurityServiceEnabled() {
        this.init();
        return this.securityEnabled;
    }

    static {
        overriddenServiceNames.add("JavaCompContextMgr");
        overriddenServiceNames.add("JTA");
        overriddenServiceNames.add("servletruntime");
    }
}

