/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.SerialDeserialException;
import com.ibm.ws.asynchbeans.AsynchContextDescriptor;
import com.ibm.ws.asynchbeans.J2EEServiceManager;
import com.ibm.ws.asynchbeans.ServiceWithContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AsynchContextDescriptorImpl2
implements AsynchContextDescriptor {
    private static final long serialVersionUID = 327681L;
    static final TraceComponent tc = Tr.register(AsynchContextDescriptorImpl2.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    private static final int VER_5_0_1 = 327681;
    private static final short FLDID_QUANTITY = 13216;
    private static final short FLDID_SVCNAMES = 13217;
    private static final short FLDID_SECENABLED = 13218;
    transient Set enabledServices;
    boolean securityEnabled;
    ArrayList enabledServiceNames;

    public AsynchContextDescriptorImpl2(boolean bl, String[] stringArray) {
        this.inflateContext(bl, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init() {
        boolean bl = tc.isDebugEnabled();
        boolean bl2 = tc.isEntryEnabled();
        if (bl2) {
            Tr.entry(tc, "init");
        }
        try {
            if (this.enabledServices == null) {
                String[] stringArray;
                if (this.enabledServiceNames == null) {
                    if (bl) {
                        Tr.debug(tc, "Creating empty list of service");
                    }
                    this.enabledServiceNames = new ArrayList();
                    stringArray = new String[]{""};
                } else {
                    if (bl) {
                        Tr.debug(tc, "Retrieving " + this.enabledServiceNames.size() + " service names.", new Object[]{this.enabledServiceNames});
                    }
                    stringArray = new String[this.enabledServiceNames.size()];
                    this.enabledServiceNames.toArray(stringArray);
                }
                this.inflateContext(false, stringArray);
            }
        }
        finally {
            if (bl2) {
                Tr.exit(tc, "init");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void inflateContext(boolean bl, String[] stringArray) {
        boolean bl2 = tc.isDebugEnabled();
        boolean bl3 = tc.isEntryEnabled();
        if (bl3) {
            Tr.entry(tc, "inflateContext");
        }
        try {
            Object v;
            String string;
            this.enabledServiceNames = new ArrayList();
            this.enabledServices = new HashSet();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray == null) {
                throw new IllegalArgumentException("serviceNames must not be null");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            J2EEServiceManager j2EEServiceManager = J2EEServiceManager.getSelf();
            Map map = j2EEServiceManager.getServices();
            Set set = j2EEServiceManager.getEnabledServiceNames();
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                this.enabledServices.add(map.get((String)iterator.next()));
            }
            if (bl) {
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (arrayList.contains(string) || set.contains(string) || (v = map.get(string)) == null) continue;
                    this.enabledServices.add(v);
                    this.enabledServiceNames.add(string);
                }
                boolean bl4 = this.securityEnabled = !arrayList.contains("security");
                if (this.securityEnabled) {
                    this.enabledServiceNames.add("security");
                }
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    string = (String)arrayList.get(i);
                    if (set.contains(string) || (v = map.get(string)) == null) continue;
                    this.enabledServices.add(v);
                    this.enabledServiceNames.add(string);
                }
                this.securityEnabled = arrayList.contains("security");
                if (this.securityEnabled) {
                    this.enabledServiceNames.add("security");
                }
            }
            if (bl2) {
                Iterator iterator2 = this.enabledServiceNames.iterator();
                while (iterator2.hasNext()) {
                    string = (String)iterator2.next();
                    Tr.debug(tc, " Service: " + string + " enabled");
                }
            }
        }
        finally {
            if (bl3) {
                Tr.exit(tc, "inflateContext");
            }
        }
    }

    public boolean isServiceEnabled(ServiceWithContext serviceWithContext) {
        this.init();
        return this.enabledServices.contains(serviceWithContext);
    }

    public boolean isServiceEnabled(String string) {
        this.init();
        return this.enabledServiceNames.contains(string);
    }

    public boolean isSecurityServiceEnabled() {
        this.init();
        return this.securityEnabled;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws SerialDeserialException {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "writeObject");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream2.writeShort(13216);
            objectOutputStream2.writeShort(2);
            objectOutputStream2.writeShort(13217);
            objectOutputStream2.writeObject(this.enabledServiceNames);
            objectOutputStream2.writeShort(13218);
            objectOutputStream2.writeBoolean(this.securityEnabled);
            objectOutputStream2.flush();
            objectOutputStream.writeInt(327681);
            objectOutputStream.writeObject(byteArrayOutputStream.toByteArray());
            objectOutputStream.flush();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.asynchbeans.AsynchContextDescriptorImpl.writeObject", "120", this);
            Tr.error(tc, "MSG_KEY_UNEX_EXCEPT", throwable);
            if (bl2) {
                Tr.debug(tc, "Exception detected while serializing AsynchContextDescriptorImpl data: " + throwable.getMessage(), throwable);
            }
            if (throwable instanceof SerialDeserialException) {
                throw (SerialDeserialException)throwable;
            }
            throw new SerialDeserialException(throwable);
        }
        finally {
            if (bl) {
                Tr.exit(tc, "writeObject");
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws SerialDeserialException {
        block21: {
            boolean bl = tc.isEntryEnabled();
            boolean bl2 = tc.isDebugEnabled();
            if (bl) {
                Tr.entry(tc, "readObject");
            }
            try {
                int n = objectInputStream.readInt();
                if (bl2) {
                    Tr.debug(tc, "AsynchContextDescriptorImpl Version=" + Integer.toHexString(n));
                }
                if (n == 327681) {
                    byte[] byArray = (byte[])objectInputStream.readObject();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
                    short s = wsObjectInputStream.readShort();
                    if (s != 13216) {
                        throw new SerialDeserialException("Incorrect field detected in byte data.  Expected: 13216, got:" + s);
                    }
                    short s2 = wsObjectInputStream.readShort();
                    if (bl2) {
                        Tr.debug(tc, "Attempting to deserialize " + s2 + " objects");
                    }
                    block9: for (short s3 = 0; s3 < s2; s3 = (short)(s3 + 1)) {
                        s = wsObjectInputStream.readShort();
                        switch (s) {
                            case 13217: {
                                if (bl2) {
                                    Tr.debug(tc, "Reading Enabled Service Names");
                                }
                                this.enabledServiceNames = (ArrayList)wsObjectInputStream.readObject();
                                if (!bl2) continue block9;
                                Tr.debug(tc, "ServiceNames=" + this.enabledServiceNames);
                                continue block9;
                            }
                            case 13218: {
                                if (bl2) {
                                    Tr.debug(tc, "Reading Security Enabled Flag");
                                }
                                this.securityEnabled = wsObjectInputStream.readBoolean();
                                if (!bl2) continue block9;
                                Tr.debug(tc, "SecurityEnabled=" + this.securityEnabled);
                                continue block9;
                            }
                            default: {
                                if (bl2) {
                                    Tr.debug(tc, "Unknown AsynchContextDescriptorImpl field id detected: " + Integer.toHexString(s));
                                }
                                byte[] byArray2 = (byte[])wsObjectInputStream.readObject();
                                if (!bl2) continue block9;
                                Tr.debug(tc, "Discarded " + (byArray2 == null ? 0 : byArray2.length) + " bytes.");
                            }
                        }
                    }
                    break block21;
                }
                throw new SerialDeserialException("Unsupported AsynchContextDescriptorImpl Version: 0x" + Integer.toHexString(n));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.asynchbeans.AsynchContextDescriptorImpl.readObject", "390", this);
                Tr.error(tc, "MSG_KEY_UNEX_EXCEPT", throwable);
                if (bl2) {
                    Tr.debug(tc, "Exception detected while deserializing AsynchContextDescriptorImpl data: " + throwable.getMessage(), throwable);
                }
                if (throwable instanceof SerialDeserialException) {
                    throw (SerialDeserialException)throwable;
                }
                throw new SerialDeserialException(throwable);
            }
            finally {
                if (bl) {
                    Tr.exit(tc, "readObject");
                }
            }
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof AsynchContextDescriptorImpl2) {
            AsynchContextDescriptorImpl2 asynchContextDescriptorImpl2 = (AsynchContextDescriptorImpl2)object;
            return (this.enabledServiceNames == null ? asynchContextDescriptorImpl2.enabledServiceNames == null : this.enabledServiceNames.equals(asynchContextDescriptorImpl2.enabledServiceNames)) && this.securityEnabled == asynchContextDescriptorImpl2.securityEnabled;
        }
        return false;
    }
}

