/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans;

import com.ibm.ws.asynchbeans.CallInfo;

public class CallInfoImpl
implements CallInfo {
    private static final long serialVersionUID = 7498682990624867122L;
    private int ci = 0;
    private static final int MASK_PROGMODEL = 61440;
    private static final int MASK_PEEKCALLTYPE = 3840;
    private static final int MASK_CALLTYPE = 240;
    private static final int MASK_CALLSUBTYPE = 15;
    private static final int CLEAR_MASK_PROGMODEL = 4095;
    private static final int CLEAR_MASK_PEEKCALLTYPE = 61695;
    private static final int CLEAR_MASK_CALLTYPE = 65295;
    private static final int CLEAR_MASK_CALLSUBTYPE = 65520;
    private static final String STR_PROGMODEL_ABEANS = "PROGMODEL_ABEANS";
    private static final String STR_PROGMODEL_COMMONJ = "PROGMODEL_COMMONJ";
    private static final String STR_PEEK_CALLTYPE_WORK_DEFERRED = "PEEK_CALLTYPE_WORK_DEFERRED";
    private static final String STR_PEEK_CALLTYPE_WORK_POOLED = "PEEK_CALLTYPE_WORK_POOLED";
    private static final String STR_PEEK_CALLTYPE_WORK_DAEMON = "PEEK_CALLTYPE_WORK_DAEMON";
    private static final String STR_PEEK_CALLTYPE_ALARM = "PEEK_CALLTYPE_ALARM";
    private static final String STR_PEEK_CALLTYPE_EVENTLISTENER_REGISTER = "PEEK_CALLTYPE_EVENTLISTENER_REGISTER";
    private static final String STR_CALLTYPE_UNKNOWN = "CALLTYPE_UNKNOWN";
    private static final String STR_CALLTYPE_WORK = "CALLTYPE_WORK";
    private static final String STR_CALLTYPE_ALARM = "CALLTYPE_ALARM";
    private static final String STR_CALLTYPE_EVENTLISTENER = "CALLTYPE_EVENTLISTENER";
    private static final String STR_CALLTYPE_WORKLISTENER = "CALLTYPE_WORKLISTENER";
    private static final String STR_CALLSUBTYPE_NONE = "CALLSUBTYPE_NONE";
    private static final String STR_CALLSUBTYPE_ALARM_ALARMLISTENER = "CALLSUBTYPE_ALARM_ALARMLISTENER";
    private static final String STR_CALLSUBTYPE_ALARM_STOPLISTENER = "CALLSUBTYPE_ALARM_STOPLISTENER";
    private static final String STR_CALLSUBTYPE_ALARM_CANCELLISTENER = "CALLSUBTYPE_ALARM_CANCELLISTENER";

    protected CallInfoImpl() {
    }

    public CallInfoImpl(int n, int n2) {
        this.ci = n | n2;
    }

    public int getCallType() {
        return this.ci & 0xF0;
    }

    public int getPeekCallType() {
        return this.ci & 0xF00;
    }

    public int getCallSubType() {
        return this.ci & 0xF;
    }

    public int getProgrammingModel() {
        return this.ci & 0xF000;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("PM=").append(CallInfoImpl.getProgrammingModelString(this.getProgrammingModel()));
        stringBuffer.append(",PCT=").append(CallInfoImpl.getPeekCallTypeString(this.getPeekCallType()));
        stringBuffer.append(",CT=").append(CallInfoImpl.getCallTypeString(this.getCallType()));
        stringBuffer.append(",CST=").append(CallInfoImpl.getCallSubTypeString(this.getCallType(), this.getCallSubType()));
        return stringBuffer.toString();
    }

    public void setCallType(int n) {
        this.ci = this.ci & 0xFF0F | n;
    }

    public void setPeekCallType(int n) {
        this.ci = this.ci & 0xF0FF | n;
    }

    public void setCallSubType(int n) {
        this.ci = this.ci & 0xFFF0 | n;
    }

    public static String getCallTypeString(int n) {
        switch (n) {
            case 0: {
                return STR_CALLTYPE_UNKNOWN;
            }
            case 32: {
                return STR_CALLTYPE_ALARM;
            }
            case 48: {
                return STR_CALLTYPE_EVENTLISTENER;
            }
            case 16: {
                return STR_CALLTYPE_WORK;
            }
            case 64: {
                return STR_CALLTYPE_WORKLISTENER;
            }
        }
        return "INVALID_TYPE";
    }

    public static String getPeekCallTypeString(int n) {
        switch (n) {
            case 1024: {
                return STR_PEEK_CALLTYPE_ALARM;
            }
            case 1280: {
                return STR_PEEK_CALLTYPE_EVENTLISTENER_REGISTER;
            }
            case 768: {
                return STR_PEEK_CALLTYPE_WORK_DAEMON;
            }
            case 256: {
                return STR_PEEK_CALLTYPE_WORK_DEFERRED;
            }
            case 512: {
                return STR_PEEK_CALLTYPE_WORK_POOLED;
            }
        }
        return "INVALID_TYPE";
    }

    public static String getProgrammingModelString(int n) {
        switch (n) {
            case 0: {
                return STR_PROGMODEL_ABEANS;
            }
            case 4096: {
                return STR_PROGMODEL_COMMONJ;
            }
        }
        return "INVALID_PROGMODEL";
    }

    public static String getCallSubTypeString(int n, int n2) {
        if (n2 == 0) {
            return STR_CALLSUBTYPE_NONE;
        }
        switch (n) {
            case 32: {
                switch (n2) {
                    case 1: {
                        return STR_CALLSUBTYPE_ALARM_ALARMLISTENER;
                    }
                    case 3: {
                        return STR_CALLSUBTYPE_ALARM_CANCELLISTENER;
                    }
                    case 2: {
                        return STR_CALLSUBTYPE_ALARM_STOPLISTENER;
                    }
                }
                return "INVALID_SUBTYPE";
            }
        }
        return "INVALID_SUBTYPE";
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[4];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(this.ci >> i * 8 & 0xFF);
        }
        return byArray;
    }

    public void setBytes(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        n |= byArray[1] << 8 & 0xFF00;
        n |= byArray[2] << 16 & 0xFF0000;
        this.ci = n |= byArray[3] << 24;
    }
}

