/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.workmanager.WorkManagerInfo;
import com.ibm.ws.asynchbeans.Messages;
import com.ibm.ws.asynchbeans.util.AsynchBeanUtil;
import com.ibm.wsspi.asynchbeans.CommonJWorkManagerConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CommonJWorkManagerProperties
implements CommonJWorkManagerConfiguration {
    static final TraceComponent tc = Tr.register(CommonJWorkManagerProperties.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    private static final long serialVersionUID = 7947670603889813547L;
    public String name;
    public ArrayList enabledServices;
    public boolean isExcluded;
    protected String defTranClass;
    public int minThreads;
    public int maxThreads;
    public boolean isGrowable;
    public int threadPriority;
    public Map customProperties;
    protected int workRequestQueueSize;
    protected int workRequestQueueFullAction;
    protected String daemonTranClass;
    protected int workTimeout;
    protected String jNDIName;

    public CommonJWorkManagerProperties() {
        this.minThreads = 1;
        this.maxThreads = 5;
        this.isGrowable = false;
        this.threadPriority = 5;
        this.workTimeout = 0;
        this.initWorkRequestProperties();
    }

    public CommonJWorkManagerProperties(String string, String string2, int n, int n2, int n3, boolean bl, int n4, int n5, int n6, String[] stringArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CommonJWorkManagerProperties(WorkManagerInfo)", new Object[]{string, string2, new Integer(n), new Integer(n2), new Integer(n3), new Boolean(bl), new Integer(n4), new Integer(n5), new Integer(n6), stringArray});
        }
        this.name = string;
        this.jNDIName = string2;
        this.minThreads = n;
        this.maxThreads = n2;
        this.threadPriority = n3;
        this.isGrowable = bl;
        this.workTimeout = n4;
        this.workRequestQueueFullAction = n6;
        this.workRequestQueueSize = n5;
        this.validate();
        this.customProperties = new HashMap();
        this.enabledServices = stringArray == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(stringArray));
    }

    public CommonJWorkManagerProperties(WorkManagerInfo workManagerInfo) {
        this(workManagerInfo.getName(), workManagerInfo.getJndiName(), workManagerInfo.getMinThreads(), workManagerInfo.getMaxThreads(), workManagerInfo.getThreadPriority(), workManagerInfo.isSetIsGrowable() ? workManagerInfo.isIsGrowable() : false, workManagerInfo.getWorkTimeout(), workManagerInfo.getWorkReqQSize(), workManagerInfo.isSetWorkReqQFullAction() ? workManagerInfo.getWorkReqQFullAction() : 0, null);
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "WorkManagerProperties(WorkManagerInfo)", workManagerInfo);
        }
        Iterator iterator = workManagerInfo.getServiceNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.enabledServices.add(string);
        }
        this.daemonTranClass = workManagerInfo.getDaemonTranClass();
        this.defTranClass = workManagerInfo.getDefTranClass();
    }

    private void initWorkRequestProperties() {
        this.workRequestQueueSize = 0;
        this.workRequestQueueFullAction = 0;
    }

    public boolean isGrowable() {
        return this.isGrowable;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setGrowable(boolean bl) {
        this.isGrowable = bl;
    }

    public void setMaxThreads(int n) {
        this.maxThreads = n;
    }

    public void setMinThreads(int n) {
        this.minThreads = n;
    }

    public void setThreadPriority(int n) {
        this.threadPriority = n;
    }

    protected StringBuffer internalToString() {
        StringBuffer stringBuffer = new StringBuffer(255).append("name=").append(this.getName()).append(", isExcluded=").append(this.isExcluded()).append(", minimumThread=").append(this.minThreads).append(", maximumThread=").append(this.maxThreads).append(", isGrowable=").append(this.isGrowable).append(", threadPriority=").append(this.threadPriority).append(", workRequestQueueFullAction=").append(AsynchBeanUtil.getWorkRequestQueueFullActionAsString(this.workRequestQueueFullAction)).append(", workRequestQueueSize=").append(this.workRequestQueueSize).append(", enabledServices=").append(this.servicesToString()).append(", defaultTransactionClass=").append(this.defTranClass).append(", daemonTransactionClass=").append(this.daemonTranClass).append(", workTimeout=").append(this.workTimeout).append(", Custom Properties=").append(this.propsToString());
        return stringBuffer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(255).append("CommonJWorkManagerProperties[").append(this.internalToString()).append("]");
        return stringBuffer.toString();
    }

    protected String propsToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.customProperties != null) {
            Iterator iterator = this.customProperties.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append("[");
                stringBuffer.append(string);
                stringBuffer.append(",");
                stringBuffer.append(this.customProperties.get(string));
                stringBuffer.append("]");
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    protected String servicesToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.enabledServices != null) {
            stringBuffer.append("[");
            Iterator iterator = this.enabledServices.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public int getWorkRequestQueueSize() {
        return this.workRequestQueueSize;
    }

    public void setWorkRequestQueueSize(int n) {
        if (n < 1 || n > Integer.MAX_VALUE) {
            Tr.error(tc, Messages.getMsg("INVALID_VALUE", new Object[]{"WorkRequestQueueSize", "1-2147483647"}));
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{"WorkRequestQueueSize", "1-2147483647"}));
        }
        this.workRequestQueueSize = n;
    }

    public Map getCustomProperties() {
        return this.customProperties;
    }

    public int getWorkRequestQueueFullAction() {
        return this.workRequestQueueFullAction;
    }

    public void setCustomProperties(Map map) {
        this.customProperties = map;
    }

    public void setWorkRequestQueueFullAction(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid WorkRequestQueueFullAction value: " + n);
        }
        this.workRequestQueueFullAction = n;
    }

    public String getDaemonTranClass() {
        return this.daemonTranClass;
    }

    public void setDaemonTranClass(String string) {
        this.daemonTranClass = string;
    }

    public int getWorkTimeout() {
        return this.workTimeout;
    }

    public void setWorkTimeout(int n) {
        this.workTimeout = n;
    }

    public String getDefTranClass() {
        return this.defTranClass;
    }

    public String[] getEnabledServices() {
        if (this.enabledServices == null || this.enabledServices.size() == 0) {
            return new String[0];
        }
        String[] stringArray = new String[this.enabledServices.size()];
        return this.enabledServices.toArray(stringArray);
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public String getName() {
        return this.name;
    }

    public void setDefTranClass(String string) {
        this.defTranClass = string;
    }

    public void setEnabledServices(String[] stringArray) {
        this.enabledServices = stringArray == null || stringArray.length == 0 ? new ArrayList() : new ArrayList<String>(Arrays.asList(stringArray));
    }

    public void setExcluded(boolean bl) {
        this.isExcluded = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getJNDIName() {
        return this.jNDIName;
    }

    public void setJNDIName(String string) {
        this.jNDIName = string;
    }

    public void validate() {
        if (this.name == null || this.name.trim().length() == 0) {
            Tr.error(tc, "INVALID_VALUE_2", new Object[]{this.name, "name"});
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE_2", new Object[]{this.name, "name"}));
        }
        if (this.jNDIName == null || this.jNDIName.trim().length() == 0) {
            Tr.error(tc, "INVALID_VALUE_2", new Object[]{this.jNDIName, "JNDIName"});
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE_2", new Object[]{this.jNDIName, "JNDIName"}));
        }
        if (this.minThreads < 0) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(this.minThreads), "minThreads", "0..Integer.MAX_VALUE"}));
        }
        if (this.maxThreads <= 0) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(this.maxThreads), "maxThreads", "1..Integer.MAX_VALUE"}));
        }
        if (this.maxThreads < this.minThreads) {
            throw new IllegalArgumentException(Messages.getMsg("MIN_MAX_ERROR", new Object[]{new Integer(this.minThreads), new Integer(this.maxThreads)}));
        }
        if (this.threadPriority < 1 || this.threadPriority > 10) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(this.threadPriority), "threadPriority", " Thread.MIN_PRIORITY .. Thread.MAX_PRIORITY"}));
        }
        if (this.workTimeout < 0) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(this.workTimeout), "workTimeout", " 0..Integer.MAX_VALUE"}));
        }
        if (this.workRequestQueueSize < 0 || this.workRequestQueueSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(this.workRequestQueueSize), "workRequestQueueSize", "1..2147483647"}));
        }
        if (this.workRequestQueueFullAction != 0 && this.workRequestQueueFullAction != 1) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(this.workRequestQueueFullAction), "workRequestQueueFullAction", "0..1"}));
        }
    }
}

