/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.Alarm;
import com.ibm.websphere.asynchbeans.AlarmListener;
import com.ibm.websphere.asynchbeans.AlarmManager;
import com.ibm.websphere.asynchbeans.SubsystemMonitor;
import com.ibm.websphere.asynchbeans.SubsystemMonitorEvents;
import com.ibm.ws.asynchbeans.JMXBroadcasterHelper;
import com.ibm.ws.asynchbeans.SubsystemMonitorManagerImpl;
import java.util.Hashtable;
import java.util.Map;

public class SubsystemMonitorImpl
extends JMXBroadcasterHelper
implements SubsystemMonitor,
AlarmListener {
    static final TraceComponent tc = Tr.register(SubsystemMonitorImpl.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    SubsystemMonitorManagerImpl myManager;
    int currentState;
    int heartBeatInterval;
    int numBeatsForStale;
    int numBeatsForDead;
    String name;
    Alarm myAlarm;
    Object eventMonitor;
    boolean destroyed;
    Map properties;
    final int RESOURCE_DESTROYED = -2;
    final int RESOURCE_NOT_STARTED = -1;
    final int MISS_WOULD_BE_STALE = 0;
    final int MISS_WOULD_BE_DEAD = 1;
    final int AM_DEAD = 2;
    int status;

    public void init() {
    }

    public void init(SubsystemMonitorManagerImpl subsystemMonitorManagerImpl, String string, int n, int n2, int n3) {
        this.name = string;
        this.myManager = subsystemMonitorManagerImpl;
        this.setAsynchBeanManager(subsystemMonitorManagerImpl.getAsynchBeanManager());
        this.numBeatsForStale = n2;
        this.numBeatsForDead = n3;
        this.heartBeatInterval = n;
        this.properties = new Hashtable();
        this.status = -1;
        this.setCurrentState(0);
        this.eventMonitor = new Object();
        this.setDestroyed(false);
    }

    public Map getPropertyMap() {
        return this.properties;
    }

    public String getName() {
        return this.name;
    }

    public int getMissedBeatsForStale() {
        return this.numBeatsForStale;
    }

    public int getMissedBeatsForDead() {
        return this.numBeatsForDead;
    }

    public int getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() {
        boolean bl = tc.isDebugEnabled();
        boolean bl2 = tc.isEntryEnabled();
        if (bl2) {
            Tr.entry(tc, "ping", this.getName());
        }
        try {
            if (this.getDestroyed()) {
                throw new IllegalStateException("SubSystemMonitor has been destroyed");
            }
            boolean bl3 = false;
            boolean bl4 = false;
            SubsystemMonitorImpl subsystemMonitorImpl = this;
            synchronized (subsystemMonitorImpl) {
                if (this.status != -1) {
                    if (bl) {
                        switch (this.status) {
                            case 1: {
                                Tr.debug(tc, "State was MISS_WOULD_BE_DEAD");
                                break;
                            }
                            case 0: {
                                Tr.debug(tc, "State was MISS_WOULD_BE_STALE");
                            }
                        }
                    }
                    if (this.status == 1 || this.status == 2) {
                        bl4 = true;
                    }
                    this.status = this.numBeatsForDead > this.numBeatsForStale ? 0 : 1;
                    if (bl) {
                        switch (this.status) {
                            case 1: {
                                Tr.debug(tc, "State is now MISS_WOULD_BE_DEAD");
                                break;
                            }
                            case 0: {
                                Tr.debug(tc, "State is now MISS_WOULD_BE_STALE");
                            }
                        }
                    }
                    bl3 = true;
                }
            }
            if (bl4) {
                this.fireFresh();
            }
            if (bl3) {
                if (this.myAlarm != null) {
                    this.myAlarm.reset(this.heartBeatInterval * this.numBeatsForStale);
                } else {
                    this.myAlarm = this.myManager.getAlarmManager().create(this, this, this.heartBeatInterval * this.numBeatsForStale);
                }
            }
        }
        finally {
            if (bl2) {
                Tr.exit(tc, "ping", this.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "start", this.getName());
        }
        if (this.getDestroyed()) {
            throw new IllegalStateException("SubSystemMonitor has been destroyed");
        }
        boolean bl2 = false;
        SubsystemMonitorImpl subsystemMonitorImpl = this;
        synchronized (subsystemMonitorImpl) {
            this.currentState = 0;
            if (this.status == -1) {
                AlarmManager alarmManager = this.myManager.getAlarmManager();
                this.status = this.numBeatsForDead <= this.numBeatsForStale ? 1 : 0;
                this.myAlarm = alarmManager.create(this, this, this.heartBeatInterval * this.numBeatsForStale);
                bl2 = true;
            } else {
                Tr.debug(tc, "Resource already started", this.name);
            }
        }
        if (bl2) {
            this.fireFresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        boolean bl = tc.isDebugEnabled();
        if (this.getDestroyed()) {
            throw new IllegalStateException("SubSystemMonitor has already been destroyed");
        }
        boolean bl2 = false;
        SubsystemMonitorImpl subsystemMonitorImpl = this;
        synchronized (subsystemMonitorImpl) {
            if (this.status != -2) {
                if (bl) {
                    Tr.debug(tc, "destroy", this.getName());
                }
                if (this.myAlarm != null) {
                    this.myAlarm.cancel();
                    this.myAlarm = null;
                }
                bl2 = true;
                this.myManager.resourceDestroyed(this);
                this.status = -2;
            } else {
                Tr.debug(tc, "Resource already destroyed");
            }
            super.destroy();
            this.setDestroyed(true);
        }
        if (bl2) {
            this.fireDestroyed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fired(Alarm alarm) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "fired");
        }
        if (this.getDestroyed()) {
            throw new IllegalStateException("SubSystemMonitor has been destroyed");
        }
        int n = 0;
        SubsystemMonitorImpl subsystemMonitorImpl = this;
        synchronized (subsystemMonitorImpl) {
            if (this.status == 0) {
                if (bl2) {
                    Tr.debug(tc, "Subsystem is stale", this.getName());
                }
                alarm.reset(this.heartBeatInterval * (this.numBeatsForDead - this.numBeatsForStale));
                n = 1;
                this.status = 1;
            } else {
                if (bl2) {
                    Tr.debug(tc, "Subsystem is dead", this.getName());
                }
                this.status = 2;
                alarm.cancel();
                this.myAlarm = null;
                n = 2;
            }
            switch (n) {
                case 1: {
                    this.fireStale();
                    break;
                }
                case 2: {
                    this.fireDead();
                }
            }
        }
        if (bl) {
            Tr.exit(tc, "fired");
        }
    }

    void fireStale() {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "fireStale", this.getName());
        }
        SubsystemMonitorEvents subsystemMonitorEvents = (SubsystemMonitorEvents)this.getEventTrigger(SubsystemMonitorEvents.class);
        subsystemMonitorEvents.subsystemIsStale(this);
        this.setCurrentState(2);
    }

    void fireDead() {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "fireDead", this.getName());
        }
        SubsystemMonitorEvents subsystemMonitorEvents = (SubsystemMonitorEvents)this.getEventTrigger(SubsystemMonitorEvents.class);
        subsystemMonitorEvents.subsystemIsDead(this);
        this.setCurrentState(0);
    }

    void fireDestroyed() {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "fireDestroyed", this.getName());
        }
        SubsystemMonitorEvents subsystemMonitorEvents = (SubsystemMonitorEvents)this.getEventTrigger(SubsystemMonitorEvents.class);
        subsystemMonitorEvents.destroyed(this);
        this.setCurrentState(3);
    }

    void fireFresh() {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "fireFresh", this.getName());
        }
        SubsystemMonitorEvents subsystemMonitorEvents = (SubsystemMonitorEvents)this.getEventTrigger(SubsystemMonitorEvents.class);
        subsystemMonitorEvents.subsystemIsFresh(this);
        this.setCurrentState(1);
    }

    private synchronized void setCurrentState(int n) {
        this.currentState = n;
    }

    public synchronized int getCurrentState() {
        return this.currentState;
    }

    private synchronized void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    private synchronized boolean getDestroyed() {
        return this.destroyed;
    }

    public String toString() {
        return "SubsystemMonitor: " + super.toString() + ", Name " + this.getName();
    }
}

