/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.EventSource;
import com.ibm.websphere.asynchbeans.WorkRejectedException;
import com.ibm.ws.asynchbeans.J2EEContext;
import com.ibm.ws.asynchbeans.WorkEventStatusListener;
import com.ibm.ws.asynchbeans.WorkManagerImpl;
import com.ibm.ws.asynchbeans.WorkTimeoutListener;
import com.ibm.ws.asynchbeans.WorkWithExecutionContextImpl;
import com.ibm.ws.util.ThreadPool;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;

public abstract class WorkItemImpl
implements Runnable,
WorkEventStatusListener {
    static TraceComponent tc = Tr.register(WorkItemImpl.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    protected J2EEContext creatorContext;
    protected WorkManagerImpl workManager;
    protected int status;
    protected WorkWithExecutionContextImpl target;
    protected long startByTime;
    protected ArrayList waiters;
    protected EventSource workEventSource;
    protected PoolExecuteProxy poolExecuteProxy;
    protected WorkTimeoutListener timeoutListener;

    public WorkItemImpl(WorkManagerImpl workManagerImpl, WorkWithExecutionContextImpl workWithExecutionContextImpl, long l) {
        this.workManager = workManagerImpl;
        this.status = 1;
        this.target = workWithExecutionContextImpl;
        this.waiters = new ArrayList(10);
        if (l != Long.MAX_VALUE) {
            this.startByTime = System.currentTimeMillis() + l;
            this.startByTime = this.startByTime < 0L ? -1L : this.startByTime;
        } else {
            this.startByTime = -1L;
        }
        this.setStatus(1);
        this.poolExecuteProxy = new PoolExecuteProxy(this.workManager.getThreadPool(), this.workManager.getRequestQueueFullBehavior());
    }

    public synchronized void addWaiter(Object object) {
        this.waiters.add(object);
    }

    public synchronized boolean workHasCompleted() {
        return this.status == 4 || this.status == 2;
    }

    public synchronized void removeWaiter(Object object) {
        if (!this.waiters.remove(object)) {
            Tr.error(tc, "MSG_KEY_08");
        }
    }

    public abstract void run();

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized void setStatus(int n) {
        this.status = n;
    }

    public Object getEventTrigger(Class clazz) {
        return this.workEventSource.getEventTrigger(clazz);
    }

    public WorkWithExecutionContextImpl getTarget() {
        return this.target;
    }

    public void executeOnPool() throws WorkRejectedException {
        try {
            this.poolExecuteProxy.run();
        }
        catch (ThreadPool.ThreadPoolQueueIsFullException threadPoolQueueIsFullException) {
            WorkRejectedException workRejectedException = new WorkRejectedException(threadPoolQueueIsFullException);
            workRejectedException.setErrorCode(3);
            throw workRejectedException;
        }
        catch (Exception exception) {
            WorkRejectedException workRejectedException = new WorkRejectedException(exception);
            throw workRejectedException;
        }
    }

    public WorkTimeoutListener getTimeoutListener() {
        return this.timeoutListener;
    }

    public void setTimeoutListener(WorkTimeoutListener workTimeoutListener) {
        this.timeoutListener = workTimeoutListener;
    }

    class PoolExecuteProxy
    implements PrivilegedExceptionAction {
        private ThreadPool pool;
        private int requestQueueFullBehavior;

        PoolExecuteProxy(ThreadPool threadPool, int n) {
            this.pool = threadPool;
            this.requestQueueFullBehavior = n;
        }

        public Object run() throws Exception {
            this.pool.execute((Runnable)WorkItemImpl.this, this.requestQueueFullBehavior);
            return null;
        }
    }
}

