/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.asynchbeans.EventSource;
import com.ibm.websphere.asynchbeans.Work;
import com.ibm.websphere.asynchbeans.WorkException;
import com.ibm.websphere.asynchbeans.WorkItem;
import com.ibm.websphere.asynchbeans.WorkManagerEvents;
import com.ibm.websphere.asynchbeans.WorkRejectedException;
import com.ibm.websphere.asynchbeans.WorkWithExecutionContext;
import com.ibm.websphere.asynchbeans.pool.ObjectPool;
import com.ibm.websphere.asynchbeans.pool.ObjectPoolManager;
import com.ibm.ws.asynchbeans.ABAsynchItemWaiter;
import com.ibm.ws.asynchbeans.ABWorkItemImpl;
import com.ibm.ws.asynchbeans.ABWorkListenerRunnable;
import com.ibm.ws.asynchbeans.AsynchBeanManager;
import com.ibm.ws.asynchbeans.AsynchContextDescriptor;
import com.ibm.ws.asynchbeans.AsynchItemWaiter;
import com.ibm.ws.asynchbeans.CJAsynchItemWaiter;
import com.ibm.ws.asynchbeans.CJRemoteWorkItemImpl;
import com.ibm.ws.asynchbeans.CJWorkItemImpl;
import com.ibm.ws.asynchbeans.CJWorkListenerRunnable;
import com.ibm.ws.asynchbeans.CallInfoImpl;
import com.ibm.ws.asynchbeans.EventSourceImpl;
import com.ibm.ws.asynchbeans.J2EEContext;
import com.ibm.ws.asynchbeans.J2EEServiceManager;
import com.ibm.ws.asynchbeans.Messages;
import com.ibm.ws.asynchbeans.WorkItemImpl;
import com.ibm.ws.asynchbeans.WorkManagerDaemonThread;
import com.ibm.ws.asynchbeans.WorkManagerProperties;
import com.ibm.ws.asynchbeans.WorkTimeoutListener;
import com.ibm.ws.asynchbeans.WorkWithExecutionContextImpl;
import com.ibm.ws.asynchbeans.util.AsynchBeanUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.asynchbeans.CommonJWorkManagerConfiguration;
import com.ibm.wsspi.asynchbeans.WorkManagerConfiguration;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WorkManagerImpl
extends AsynchBeanManager
implements com.ibm.websphere.asynchbeans.WorkManager,
WorkManager {
    static TraceComponent tc = Tr.register(WorkManagerImpl.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    static ObjectPool cjAsynchWaiterPool;
    static ObjectPool abAsynchWaiterPool;
    static ObjectPool abWorkListenerRunnablePool;
    static ObjectPool cjWorkListenerRunnablePool;
    static ObjectPool workTimeoutListenerPool;
    ThreadGroup workManagerDemonThreads;
    Map appThreadGroups;
    protected int requestQueueFullBehavior;
    ThreadPool myPool;
    protected int workTimeout;

    public WorkManagerImpl() {
    }

    public WorkManagerImpl(CommonJWorkManagerConfiguration commonJWorkManagerConfiguration) {
        super(commonJWorkManagerConfiguration);
        this.init(commonJWorkManagerConfiguration);
    }

    public WorkManagerImpl(WorkManagerConfiguration workManagerConfiguration) {
        super(workManagerConfiguration);
        this.init(workManagerConfiguration);
    }

    private void init(CommonJWorkManagerConfiguration commonJWorkManagerConfiguration) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "WorkManagerImpl.<init>");
        }
        this.myPool = (ThreadPool)AccessController.doPrivileged(new AsynchBeanManager.GetThreadPool("WorkManager." + WorkManagerImpl.getMBeanValue(this.name)));
        this.myPool.setMinimumPoolSize(commonJWorkManagerConfiguration.getMinThreads());
        this.myPool.setMaximumPoolSize(commonJWorkManagerConfiguration.getMaxThreads());
        this.myPool.setGrowAsNeeded(commonJWorkManagerConfiguration.isGrowable());
        this.myPool.setThreadPriority(commonJWorkManagerConfiguration.getThreadPriority());
        this.myPool.setKeepAliveTime(60000L);
        int n = commonJWorkManagerConfiguration.getWorkRequestQueueSize();
        if (n != 0) {
            this.myPool.setRequestBufferSize(n);
        } else {
            n = (commonJWorkManagerConfiguration.getMinThreads() + commonJWorkManagerConfiguration.getMaxThreads()) / 2;
            if (n < 1) {
                n = 1;
            }
            this.myPool.setRequestBufferSize(n);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Work request queue size was not set, using defualt  work request queue size of: " + n);
            }
        }
        int n2 = commonJWorkManagerConfiguration.getWorkRequestQueueFullAction();
        this.requestQueueFullBehavior = n2 == 1 ? 1 : 0;
        this.workTimeout = commonJWorkManagerConfiguration.getWorkTimeout();
        WorkManagerImpl.initObjectPool();
        this.initializeThreadGroups();
        if (bl) {
            Tr.exit(tc, "WorkManagerImpl.<init>", this);
        }
    }

    public WorkManagerImpl(WorkManagerProperties workManagerProperties) {
        this((WorkManagerConfiguration)workManagerProperties);
    }

    private void initializeThreadGroups() {
        this.cmda = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        this.appThreadGroups = new HashMap();
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                return new ThreadGroup("WM Demon Group:" + WorkManagerImpl.this.name);
            }
        };
        this.workManagerDemonThreads = (ThreadGroup)AccessController.doPrivileged(privilegedAction);
    }

    public static synchronized void initObjectPool() {
        if (poolManager == null) {
            AsynchBeanManager.initObjectPool();
            try {
                abAsynchWaiterPool = poolManager.getPool(ABAsynchItemWaiter.class);
                cjAsynchWaiterPool = poolManager.getPool(CJAsynchItemWaiter.class);
                abWorkListenerRunnablePool = poolManager.getPool(ABWorkListenerRunnable.class);
                cjWorkListenerRunnablePool = poolManager.getPool(CJWorkListenerRunnable.class);
                workTimeoutListenerPool = poolManager.getPool(WorkTimeoutListener.class);
            }
            catch (InstantiationException instantiationException) {
                FFDCFilter.processException((Throwable)instantiationException, "com.ibm.ws.asynchbeans.WorkManagerImpl.initObjectPool", "138", "");
                Tr.fatal(tc, "MSG_KEY_46");
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.asynchbeans.WorkManagerImpl.initObjectPool", "145", "");
                Tr.fatal(tc, "MSG_KEY_46");
            }
        }
    }

    public WorkItem startWork(WorkWithExecutionContext workWithExecutionContext) throws WorkException {
        return this.startWork(workWithExecutionContext, Long.MAX_VALUE, null, false, false);
    }

    public WorkItem startWork(WorkWithExecutionContext workWithExecutionContext, boolean bl) throws WorkException {
        ((WorkWithExecutionContextImpl)workWithExecutionContext).setIsDemon(bl);
        return this.startWork(workWithExecutionContext, Long.MAX_VALUE, null, bl, true);
    }

    public WorkItem startWork(WorkWithExecutionContext workWithExecutionContext, long l, com.ibm.websphere.asynchbeans.WorkListener workListener, boolean bl) throws WorkException {
        ((WorkWithExecutionContextImpl)workWithExecutionContext).setIsDemon(bl);
        return this.startWork(workWithExecutionContext, l, workListener, bl, true);
    }

    public WorkItem startWork(WorkWithExecutionContext workWithExecutionContext, long l, com.ibm.websphere.asynchbeans.WorkListener workListener) throws WorkException {
        return this.startWork(workWithExecutionContext, l, workListener, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WorkItem startWork(WorkWithExecutionContext workWithExecutionContext, long l, com.ibm.websphere.asynchbeans.WorkListener workListener, boolean bl, boolean bl2) throws WorkException {
        J2EEServiceManager.checkValidAsyncBean(workListener);
        boolean bl3 = tc.isEntryEnabled();
        if (bl3) {
            Tr.entry(tc, "startWork");
        }
        ABWorkItemImpl aBWorkItemImpl = null;
        try {
            WorkWithExecutionContextImpl workWithExecutionContextImpl = (WorkWithExecutionContextImpl)workWithExecutionContext;
            CallInfoImpl callInfoImpl = workWithExecutionContextImpl.getJ2EEContext().getCallInfo();
            if (bl2) {
                callInfoImpl.setPeekCallType(256);
            } else if (bl) {
                callInfoImpl.setPeekCallType(768);
            } else {
                callInfoImpl.setPeekCallType(512);
            }
            aBWorkItemImpl = this.createABWorkItem(workWithExecutionContextImpl, l, workListener);
            if (bl) {
                this.startDemonThread(aBWorkItemImpl);
            } else {
                WorkTimeoutListener workTimeoutListener = null;
                if (this.workTimeout > 0) {
                    workTimeoutListener = WorkManagerImpl.getPooledWorkTimeoutListener();
                    workTimeoutListener.init(((WorkWithExecutionContextImpl)workWithExecutionContext).abTarget, (long)this.workTimeout);
                    aBWorkItemImpl.setTimeoutListener(workTimeoutListener);
                }
                this.queueWorkItemForDispatch(aBWorkItemImpl);
            }
            if (!bl3) return aBWorkItemImpl;
        }
        catch (Throwable throwable) {
            if (!bl3) throw throwable;
            Tr.exit(tc, "startWork", aBWorkItemImpl);
            throw throwable;
        }
        Tr.exit(tc, "startWork", aBWorkItemImpl);
        return aBWorkItemImpl;
    }

    protected ABWorkItemImpl createABWorkItem(WorkWithExecutionContextImpl workWithExecutionContextImpl, long l, com.ibm.websphere.asynchbeans.WorkListener workListener) {
        return new ABWorkItemImpl(this, workWithExecutionContextImpl, l, workListener);
    }

    protected CJRemoteWorkItemImpl createCJRemoteWorkItem(WorkWithExecutionContextImpl workWithExecutionContextImpl, long l, WorkListener workListener) {
        return new CJRemoteWorkItemImpl(this, workWithExecutionContextImpl, l, workListener, workWithExecutionContextImpl.isDemon);
    }

    protected CJWorkItemImpl createCJWorkItem(WorkWithExecutionContextImpl workWithExecutionContextImpl, long l, WorkListener workListener, boolean bl) {
        return new CJWorkItemImpl(this, workWithExecutionContextImpl, l, workListener, bl);
    }

    protected void queueWorkItemForDispatch(WorkItemImpl workItemImpl) throws WorkRejectedException {
        workItemImpl.executeOnPool();
    }

    protected synchronized void startDemonThread(WorkItemImpl workItemImpl) {
        final boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "startDemonThread", workItemImpl);
        }
        final WorkItemImpl workItemImpl2 = workItemImpl;
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                Object object;
                ComponentMetaData componentMetaData = WorkManagerImpl.this.cmda.getComponentMetaData();
                String string = "WM Service Group";
                if (componentMetaData != null && (object = componentMetaData.getJ2EEName()) != null) {
                    string = object.getApplication();
                }
                object = null;
                if (WorkManagerImpl.this.appThreadGroups.containsKey(string)) {
                    object = (ThreadGroup)WorkManagerImpl.this.appThreadGroups.get(string);
                } else {
                    if (bl) {
                        Tr.debug(tc, "New ThreadGroup for " + string + " created.");
                    }
                    object = new ThreadGroup(WorkManagerImpl.this.workManagerDemonThreads, WorkManagerImpl.this.name + ": " + string);
                    WorkManagerImpl.this.appThreadGroups.put(string, object);
                }
                WorkManagerDaemonThread workManagerDaemonThread = new WorkManagerDaemonThread((ThreadGroup)object, workItemImpl2, ((ThreadGroup)object).toString());
                workManagerDaemonThread.setDaemon(true);
                workManagerDaemonThread.start();
                if (bl) {
                    Tr.debug(tc, "Started new Daemon thread for " + string);
                }
                return workManagerDaemonThread;
            }
        };
        AccessController.doPrivileged(privilegedAction);
    }

    public synchronized void stopDaemonsForApp(String string) {
        final boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "stopDaemonsForApp", new Object[]{this, string});
        }
        if (this.appThreadGroups.containsKey(string)) {
            final ThreadGroup threadGroup = (ThreadGroup)this.appThreadGroups.get(string);
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    Thread[] threadArray = new Thread[threadGroup.activeCount()];
                    threadGroup.enumerate(threadArray);
                    for (int i = 0; i < threadArray.length; ++i) {
                        if (bl) {
                            Tr.debug(tc, "Thread Info [" + i + "] (name, group, class, string)", new Object[]{threadArray[i].getName(), threadArray[i].getThreadGroup(), threadArray[i].getClass(), threadArray[i].toString()});
                        }
                        if (threadArray[i] instanceof WorkManagerDaemonThread) {
                            if (bl) {
                                Tr.debug(tc, "Releasing...");
                            }
                            WorkManagerDaemonThread workManagerDaemonThread = (WorkManagerDaemonThread)threadArray[i];
                            workManagerDaemonThread.release();
                            if (!bl) continue;
                            Tr.debug(tc, "Released.");
                            continue;
                        }
                        if (!bl) continue;
                        Tr.debug(tc, "ERROR!  Invalid thread in our Thread Group!");
                    }
                    return null;
                }
            };
            AccessController.doPrivileged(privilegedAction);
        }
    }

    public WorkItem startWork(Work work, boolean bl) throws WorkException {
        WorkWithExecutionContextImpl workWithExecutionContextImpl = this.create(work, this.contextDescriptor, false);
        workWithExecutionContextImpl.setIsDemon(bl);
        return this.startWork(workWithExecutionContextImpl, Long.MAX_VALUE, null, bl, false);
    }

    public WorkItem startWork(Work work, long l, com.ibm.websphere.asynchbeans.WorkListener workListener, boolean bl) throws WorkException {
        WorkWithExecutionContextImpl workWithExecutionContextImpl = this.create(work, this.contextDescriptor, false);
        workWithExecutionContextImpl.setIsDemon(bl);
        return this.startWork(workWithExecutionContextImpl, l, workListener, bl, false);
    }

    public WorkItem startWork(Work work) throws WorkException {
        return this.startWork(work, false);
    }

    public WorkItem startWork(Work work, long l, com.ibm.websphere.asynchbeans.WorkListener workListener) throws WorkException {
        return this.startWork(work, l, workListener, false);
    }

    public void doWork(WorkWithExecutionContext workWithExecutionContext) throws WorkException {
        this.doWork(workWithExecutionContext, null);
    }

    public void doWork(WorkWithExecutionContext workWithExecutionContext, com.ibm.websphere.asynchbeans.WorkListener workListener) throws WorkException {
        J2EEServiceManager.checkValidAsyncBean(workListener);
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "doWork");
        }
        try {
            WorkTimeoutListener workTimeoutListener = null;
            WorkWithExecutionContextImpl workWithExecutionContextImpl = (WorkWithExecutionContextImpl)workWithExecutionContext;
            if (this.workTimeout > 0) {
                workTimeoutListener = WorkManagerImpl.getPooledWorkTimeoutListener();
                workTimeoutListener.init(workWithExecutionContextImpl.abTarget, (long)this.workTimeout);
            }
            workWithExecutionContextImpl.go(this, this.contextDescriptor, workListener, null, null, workTimeoutListener, 16);
        }
        catch (WorkException workException) {
            FFDCFilter.processException((Throwable)workException, "com.ibm.ws.asynchbeans.WorkManagerImpl.doWork", "231", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WorkException from doWork", workException);
            }
            throw workException;
        }
        finally {
            if (bl) {
                Tr.exit(tc, "doWork");
            }
        }
    }

    public void doWork(Work work) throws WorkException {
        WorkWithExecutionContextImpl workWithExecutionContextImpl = this.create(work, this.contextDescriptor, false);
        this.doWork(workWithExecutionContextImpl, null);
    }

    public void doWork(Work work, com.ibm.websphere.asynchbeans.WorkListener workListener) throws WorkException {
        WorkWithExecutionContextImpl workWithExecutionContextImpl = this.create(work, this.contextDescriptor, false);
        this.doWork(workWithExecutionContextImpl, workListener);
    }

    public boolean join(ArrayList arrayList, boolean bl, int n) {
        ABWorkItemImpl[] aBWorkItemImplArray = this.convertToABWorkItemArray(arrayList);
        if (aBWorkItemImplArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "join", "There is no valid WorkItems in the collection, exit");
            }
            return false;
        }
        try {
            return this.joinWorks(aBWorkItemImplArray, bl, (long)n);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public WorkWithExecutionContext create(Work work) {
        return this.create(work, this.contextDescriptor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkWithExecutionContextImpl create(Work work, AsynchContextDescriptor asynchContextDescriptor, boolean bl) {
        J2EEServiceManager.checkValidAsyncBean(work);
        boolean bl2 = tc.isEntryEnabled();
        if (bl2) {
            Tr.entry(tc, "create", work);
        }
        try {
            WorkWithExecutionContextImpl workWithExecutionContextImpl;
            int n = 512;
            if (bl) {
                n = 256;
            }
            J2EEContext j2EEContext = J2EEServiceManager.getSelf().peek(asynchContextDescriptor, null, AsynchBeanUtil.isAsynchBeanEJB(work), n, 0);
            WorkWithExecutionContextImpl workWithExecutionContextImpl2 = workWithExecutionContextImpl = new WorkWithExecutionContextImpl(j2EEContext, work);
            return workWithExecutionContextImpl2;
        }
        finally {
            if (bl2) {
                Tr.exit(tc, "create");
            }
        }
    }

    public int getMinSize() {
        return this.myPool.getMinimumPoolSize();
    }

    public int getMaxSize() {
        return this.myPool.getMaximumPoolSize();
    }

    public int getThreadPriority() {
        return this.myPool.getThreadPriority();
    }

    public static ObjectPoolManager getObjectPoolManager() {
        WorkManagerImpl.initObjectPool();
        return poolManager;
    }

    public static ObjectPool getCJWorkListenerRunnablePool() {
        WorkManagerImpl.initObjectPool();
        return cjWorkListenerRunnablePool;
    }

    public static ObjectPool getABWorkListenerRunnablePool() {
        WorkManagerImpl.initObjectPool();
        return abWorkListenerRunnablePool;
    }

    public static WorkTimeoutListener getPooledWorkTimeoutListener() {
        WorkManagerImpl.initObjectPool();
        return (WorkTimeoutListener)workTimeoutListenerPool.getObject();
    }

    public static void returnPooledWorkTimeoutListener(WorkTimeoutListener workTimeoutListener) {
        WorkManagerImpl.initObjectPool();
        workTimeoutListenerPool.returnObject(workTimeoutListener);
    }

    public void quiesce() {
        WorkManagerEvents workManagerEvents = (WorkManagerEvents)this.getEventTrigger(WorkManagerEvents.class);
        workManagerEvents.destroyed(this);
        this._destroy();
    }

    public EventSource createEventSource() {
        EventSourceImpl eventSourceImpl = new EventSourceImpl(this.contextDescriptor);
        return eventSourceImpl;
    }

    public String toString() {
        return "WorkManagerImpl:" + this.name;
    }

    public ThreadPool getThreadPool() {
        return this.myPool;
    }

    public int getRequestQueueFullBehavior() {
        return this.requestQueueFullBehavior;
    }

    private WorkWithExecutionContextImpl create(commonj.work.Work work) {
        return this.create(work, this.contextDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkWithExecutionContextImpl create(commonj.work.Work work, AsynchContextDescriptor asynchContextDescriptor) {
        WorkWithExecutionContextImpl workWithExecutionContextImpl;
        block4: {
            J2EEServiceManager.checkValidAsyncBean(work);
            boolean bl = tc.isEntryEnabled();
            if (bl) {
                Tr.entry(tc, "create(commonj.work.Work, AsynchContextDescriptor)", new Object[]{this, work, asynchContextDescriptor});
            }
            WorkWithExecutionContextImpl workWithExecutionContextImpl2 = null;
            try {
                J2EEContext j2EEContext = J2EEServiceManager.getSelf().peek(asynchContextDescriptor, null, AsynchBeanUtil.isAsynchBeanEJB(work), work.isDaemon() ? 768 : 512, 4096);
                workWithExecutionContextImpl = workWithExecutionContextImpl2 = new WorkWithExecutionContextImpl(j2EEContext, work);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    Tr.exit(tc, "create(commonj.work.Work, AsynchContextDescriptor)", workWithExecutionContextImpl2);
                }
                throw throwable;
            }
            Tr.exit(tc, "create(commonj.work.Work, AsynchContextDescriptor)", workWithExecutionContextImpl2);
        }
        return workWithExecutionContextImpl;
    }

    public commonj.work.WorkItem schedule(commonj.work.Work work) throws commonj.work.WorkException, IllegalArgumentException {
        if (work == null) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE_2", new Object[]{null, "commonj.work.Work"}));
        }
        J2EEServiceManager.checkValidAsyncBean(work);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "schedule(Work)", new Object[]{this, work});
        }
        WorkWithExecutionContextImpl workWithExecutionContextImpl = this.create(work);
        return this.schedule(workWithExecutionContextImpl, Long.MAX_VALUE, null);
    }

    public commonj.work.WorkItem schedule(commonj.work.Work work, WorkListener workListener) throws commonj.work.WorkException, IllegalArgumentException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "schedule(Work, WorkListener)", new Object[]{this, work, workListener});
        }
        if (work == null) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE_2", new Object[]{null, "commonj.work.Work"}));
        }
        WorkWithExecutionContextImpl workWithExecutionContextImpl = this.create(work, this.contextDescriptor);
        return this.schedule(workWithExecutionContextImpl, Long.MAX_VALUE, workListener);
    }

    public boolean waitForAll(Collection collection, long l) throws InterruptedException {
        if (collection == null) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE_2", new Object[]{null, "java.util.Collection"}));
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForAll", new Object[]{this, collection, new Long(l)});
        }
        if (l < 0L) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForAll", "IllegalArgumentException");
            }
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Long(l), "timeout_ms", "0..Long.MAX_VALUE"}));
        }
        CJWorkItemImpl[] cJWorkItemImplArray = this.convertToCJWorkItemArray(collection);
        if (cJWorkItemImplArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForAll", "There is no valid WorkItem in the collection, exit");
            }
            return true;
        }
        boolean bl = this.joinWorks(cJWorkItemImplArray, false, l);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForAll", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    public Collection waitForAny(Collection collection, long l) throws InterruptedException, IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE_2", new Object[]{null, "java.util.Collection"}));
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForAny", new Object[]{this, collection, new Long(l)});
        }
        if (l < 0L) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForAny", "IllegalArgumentException");
            }
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Long(l), "timeout_ms", "0..Long.MAX_VALUE"}));
        }
        CJWorkItemImpl[] cJWorkItemImplArray = this.convertToCJWorkItemArray(collection);
        if (cJWorkItemImplArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForAny", "There is no valid WorkItem in the collection, exit");
            }
            return Collections.EMPTY_LIST;
        }
        ArrayList<CJWorkItemImpl> arrayList = new ArrayList<CJWorkItemImpl>(1);
        if (this.joinWorks(cJWorkItemImplArray, true, l)) {
            for (int i = 0; i < cJWorkItemImplArray.length; ++i) {
                if (!cJWorkItemImplArray[i].workHasCompleted()) continue;
                arrayList.add(cJWorkItemImplArray[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForAny", arrayList);
        }
        return arrayList;
    }

    protected commonj.work.WorkItem schedule(WorkWithExecutionContextImpl workWithExecutionContextImpl, long l, WorkListener workListener) throws commonj.work.WorkException {
        J2EEServiceManager.checkValidAsyncBean(workListener);
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "schedule(WorkWithExecutionContextImpl, long, WorkListener)", new Object[]{this, workWithExecutionContextImpl, new Long(l), workListener});
        }
        CJWorkItemImpl cJWorkItemImpl = null;
        try {
            if (workWithExecutionContextImpl.cjTarget instanceof Serializable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "creating a CJ remote work item.");
                }
                cJWorkItemImpl = this.createCJRemoteWorkItem(workWithExecutionContextImpl, l, workListener);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "creating a CJ work item.");
                }
                cJWorkItemImpl = this.createCJWorkItem(workWithExecutionContextImpl, l, workListener, workWithExecutionContextImpl.isDemon());
            }
            if (workWithExecutionContextImpl.isDemon()) {
                this.startDemonThread(cJWorkItemImpl);
            } else {
                WorkTimeoutListener workTimeoutListener = null;
                if (this.workTimeout > 0) {
                    workTimeoutListener = WorkManagerImpl.getPooledWorkTimeoutListener();
                    workTimeoutListener.init(workWithExecutionContextImpl.cjTarget, (long)this.workTimeout);
                    cJWorkItemImpl.setTimeoutListener(workTimeoutListener);
                }
                this.queueWorkItemForDispatch(cJWorkItemImpl);
            }
        }
        catch (WorkRejectedException workRejectedException) {
            if (bl) {
                Tr.exit(tc, "schedule(WorkWithExecutionContextImpl, long, WorkListener)", "exception");
            }
            throw AsynchBeanUtil.convertABWorkRejectedException(workRejectedException);
        }
        if (bl) {
            Tr.exit(tc, "schedule(WorkWithExecutionContextImpl, long, WorkListener)", cJWorkItemImpl);
        }
        return cJWorkItemImpl;
    }

    private CJWorkItemImpl[] convertToCJWorkItemArray(Collection collection) throws IllegalArgumentException {
        CJWorkItemImpl[] cJWorkItemImplArray = null;
        int n = 0;
        int n2 = collection.size();
        if (n2 == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "convertToCJWorkItemArray", "Collection of WorkItems is empty. Return immediately");
            }
            return null;
        }
        cJWorkItemImplArray = new CJWorkItemImpl[collection.size()];
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 == null) continue;
            try {
                cJWorkItemImplArray[n] = (CJWorkItemImpl)e2;
                ++n;
            }
            catch (ClassCastException classCastException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(Messages.getMsg("INVALID_ITEM_IN_COLLECTION", new Object[]{e2.getClass(), commonj.work.WorkItem.class}));
                illegalArgumentException.initCause(classCastException);
                throw illegalArgumentException;
            }
        }
        return cJWorkItemImplArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ABWorkItemImpl[] convertToABWorkItemArray(Collection aBWorkItemImplArray) {
        ABWorkItemImpl[] aBWorkItemImplArray2 = null;
        int n = 0;
        ABWorkItemImpl[] aBWorkItemImplArray3 = aBWorkItemImplArray;
        synchronized (aBWorkItemImplArray) {
            int n2 = aBWorkItemImplArray.size();
            if (n2 == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "convertToABWorkItemArray", "Collection workItems is emptry. Return immediately");
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return null;
            }
            aBWorkItemImplArray2 = new ABWorkItemImpl[aBWorkItemImplArray.size()];
            Iterator iterator = aBWorkItemImplArray.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (e2 == null) continue;
                try {
                    aBWorkItemImplArray2[n] = (ABWorkItemImpl)e2;
                    ++n;
                }
                catch (ClassCastException classCastException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "convertToABWorkItemArray", "An Object in the collection is not a WorkItem. It is of type " + e2.getClass());
                    }
                    throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE_2", new Object[]{e2, "com.ibm.websphere.asynchbeans.WorkItem"}));
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (n == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "convertToABWorkItemArray", "There are no valid WorkItems in the collection.");
                }
                return null;
            }
            if (n != aBWorkItemImplArray2.length) {
                aBWorkItemImplArray3 = aBWorkItemImplArray2;
                aBWorkItemImplArray2 = new ABWorkItemImpl[n];
                System.arraycopy(aBWorkItemImplArray3, 0, aBWorkItemImplArray2, 0, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "convertToABWorkItemArray", "There are invalid WorkItems in the collection. The number of valid workItems is " + n);
                }
            }
            return aBWorkItemImplArray2;
        }
    }

    private boolean joinWorks(CJWorkItemImpl[] cJWorkItemImplArray, boolean bl, long l) throws InterruptedException {
        CJAsynchItemWaiter cJAsynchItemWaiter = (CJAsynchItemWaiter)cjAsynchWaiterPool.getObject();
        cJAsynchItemWaiter.init(cJWorkItemImplArray, bl);
        return this.joinWorks(cJAsynchItemWaiter, l);
    }

    private boolean joinWorks(ABWorkItemImpl[] aBWorkItemImplArray, boolean bl, long l) throws InterruptedException {
        ABAsynchItemWaiter aBAsynchItemWaiter = (ABAsynchItemWaiter)abAsynchWaiterPool.getObject();
        aBAsynchItemWaiter.init(aBWorkItemImplArray, bl);
        return this.joinWorks(aBAsynchItemWaiter, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean joinWorks(AsynchItemWaiter asynchItemWaiter, long l) throws InterruptedException {
        boolean bl;
        boolean bl2;
        block20: {
            bl2 = tc.isEntryEnabled();
            boolean bl3 = tc.isDebugEnabled();
            if (bl2) {
                Tr.entry(tc, "joinWorks", new Object[]{this, asynchItemWaiter, new Long(l)});
            }
            bl = false;
            Alarm alarm = null;
            bl = false;
            if (l == 0L) {
                bl = asynchItemWaiter.isFinished();
            } else {
                asynchItemWaiter.addWaiterToItems();
                if (l > 0L) {
                    if (bl3) {
                        Tr.debug(tc, "joinWorks", "Creating an alarm with the timeout value " + l);
                    }
                    alarm = AlarmManager.createNonDeferrable(l, asynchItemWaiter, null);
                } else if (bl3) {
                    Tr.debug(tc, "joinWorks", "No timeout specified");
                }
                try {
                    do {
                        if (bl3) {
                            Tr.debug(tc, "joinWorks", "Blocking for join event");
                        }
                        asynchItemWaiter.waitForEvents();
                        if (bl3) {
                            Tr.debug(tc, "joinWorks", "Woke up, join event received");
                        }
                        if (!asynchItemWaiter.isFinished()) continue;
                        if (bl3) {
                            Tr.debug(tc, "joinWorks", "Join attempt ");
                        }
                        bl = true;
                        break block20;
                    } while (!asynchItemWaiter.timedOut());
                    if (bl3) {
                        Tr.debug(tc, "joinWorks", "Join timeout occurred");
                    }
                    bl = false;
                }
                finally {
                    asynchItemWaiter.removeWaiterFromItems();
                    if (asynchItemWaiter instanceof ABAsynchItemWaiter) {
                        abAsynchWaiterPool.returnObject((ABAsynchItemWaiter)asynchItemWaiter);
                    } else {
                        cjAsynchWaiterPool.returnObject((CJAsynchItemWaiter)asynchItemWaiter);
                    }
                    if (alarm != null) {
                        if (bl3) {
                            Tr.debug(tc, "joinWorks", "Destroying alarm");
                        }
                        alarm.cancel();
                    }
                }
            }
        }
        if (bl2) {
            Tr.exit(tc, "joinWorks", new Boolean(bl));
        }
        return bl;
    }
}

