/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans;

import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.workmanager.WorkManagerInfo;
import com.ibm.ws.asynchbeans.CommonJWorkManagerProperties;
import com.ibm.ws.asynchbeans.Messages;
import com.ibm.wsspi.asynchbeans.WorkManagerConfiguration;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public class WorkManagerProperties
extends CommonJWorkManagerProperties
implements WorkManagerConfiguration {
    static final TraceComponent tc = Tr.register(WorkManagerProperties.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    private static final long serialVersionUID = 7947670603889813547L;
    public int numAlarmThreads;
    private int initialAlarmCapacity;

    public WorkManagerProperties() {
        this.numAlarmThreads = 0;
        this.initialAlarmCapacity = 20;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>", this);
        }
    }

    public WorkManagerProperties(String string, String string2, int n, int n2, int n3, boolean bl, int n4, int n5, int n6, String[] stringArray, int n7, int n8) {
        super(string, string2, n, n2, n3, bl, n4, n5, n6, stringArray);
        if (n7 < 0) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(n7), "numAlarmThreads", "0..Integer.MAX_VALUE"}));
        }
        this.numAlarmThreads = n7;
        if (n8 < 0) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(n8), "INITIAL_ALARM_CAPACITY", "0..Integer.MAX_VALUE"}));
        }
        this.initialAlarmCapacity = n8;
    }

    public WorkManagerProperties(WorkManagerInfo workManagerInfo) {
        super(workManagerInfo);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init> Apply WorkManagerInfo", workManagerInfo);
        }
        if (workManagerInfo.getNumAlarmThreads() < 0) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(this.numAlarmThreads), "numAlarmThreads", "0..Integer.MAX_VALUE"}));
        }
        this.numAlarmThreads = workManagerInfo.getNumAlarmThreads();
        Iterator iterator = null;
        this.customProperties = new HashMap();
        boolean bl = tc.isDebugEnabled();
        J2EEResourcePropertySet j2EEResourcePropertySet = workManagerInfo.getPropertySet();
        if (j2EEResourcePropertySet != null) {
            EList eList = j2EEResourcePropertySet.getResourceProperties();
            iterator = eList.iterator();
            while (iterator.hasNext()) {
                int n;
                J2EEResourceProperty j2EEResourceProperty = (J2EEResourceProperty)iterator.next();
                String string = j2EEResourceProperty.getName().trim();
                String string2 = j2EEResourceProperty.getValue();
                this.customProperties.put(string, string2);
                if (bl) {
                    Tr.debug(tc, "WorkManagerProperties(WorkManagerInfo)", string + "=" + string2);
                }
                if (string.equals("WORKREQUEST_QUEUE_FULL_ACTION")) {
                    Tr.warning(tc, Messages.getMsg("CUSTOM_PROPERTY_WARNING", new Object[]{"WORKREQUEST_QUEUE_FULL_ACTION"}));
                    if (workManagerInfo.isSetWorkReqQFullAction()) continue;
                    try {
                        n = Integer.parseInt(string2);
                        if (n != 0 && n != 1) {
                            Tr.error(tc, "INVALID_VALUE", new Object[]{string2, "WORKREQUEST_QUEUE_FULL_ACTION", "0,1"});
                            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{string2, "WORKREQUEST_QUEUE_FULL_ACTION", "0,1"}));
                        }
                        this.workRequestQueueFullAction = n;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Tr.error(tc, "INVALID_VALUE", new Object[]{string2, "WORKREQUEST_QUEUE_FULL_ACTION", "0,1"});
                        throw numberFormatException;
                    }
                }
                if (string.equals("WORKREQUEST_QUEUE_SIZE")) {
                    Tr.warning(tc, Messages.getMsg("CUSTOM_PROPERTY_WARNING", new Object[]{"WORKREQUEST_QUEUE_SIZE"}));
                    if (this.workRequestQueueSize >= 1 && this.workRequestQueueSize <= Integer.MAX_VALUE) continue;
                    try {
                        n = Integer.parseInt(string2);
                        if (n < 1 || n > Integer.MAX_VALUE) {
                            Tr.error(tc, "INVALID_VALUE", new Object[]{string2, "WORKREQUEST_QUEUE_SIZE", "1-2147483647"});
                            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{string2, "WORKREQUEST_QUEUE_SIZE", "1-2147483647"}));
                        }
                        this.workRequestQueueSize = n;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Tr.error(tc, "INVALID_VALUE", new Object[]{string2, "WORKREQUEST_QUEUE_SIZE", "1-2147483647"});
                        throw numberFormatException;
                    }
                }
                if (string.equals("INITIAL_ALARM_CAPACITY")) {
                    n = Integer.parseInt(string2);
                    if (n < 0) {
                        throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(n), "INITIAL_ALARM_CAPACITY", "0..Integer.MAX_VALUE"}));
                    }
                    this.initialAlarmCapacity = n;
                    continue;
                }
                if (string.equals("com.ibm.ws.asynchbeans.zos.wlm.default.transaction.class")) {
                    Tr.warning(tc, Messages.getMsg("CUSTOM_PROPERTY_WARNING", new Object[]{"com.ibm.ws.asynchbeans.zos.wlm.default.transaction.class"}));
                    if (this.defTranClass != null && this.defTranClass.trim().length() != 0) continue;
                    this.defTranClass = string2;
                    continue;
                }
                if (!string.equals("com.ibm.ws.asynchbeans.zos.wlm.daemon.transaction.class")) continue;
                Tr.warning(tc, Messages.getMsg("CUSTOM_PROPERTY_WARNING", new Object[]{"com.ibm.ws.asynchbeans.zos.wlm.daemon.transaction.class"}));
                if (this.daemonTranClass != null && this.daemonTranClass.trim().length() != 0) continue;
                this.daemonTranClass = string2;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>", this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("WorkManagerProperties:[").append("numofAlarmThreads=").append(this.getNumAlarmThreads()).append(",initialAlarmCapacity=").append(this.initialAlarmCapacity).append(',').append(this.internalToString()).append("]");
        return stringBuffer.toString();
    }

    public int getInitialAlarmCapacity() {
        return this.initialAlarmCapacity;
    }

    public int getNumAlarmThreads() {
        return this.numAlarmThreads;
    }

    public void setInitialAlarmCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(n), "INITIAL_ALARM_CAPACITY", "0..Integer.MAX_VALUE"}));
        }
        this.initialAlarmCapacity = n;
    }

    public void setNumAlarmThreads(int n) {
        this.numAlarmThreads = n;
    }
}

